	page 56,132
	title "Fast Integer Log  Version 1.2   as of 3-8-89 -med"
;
;***********************************************************;
; ILog - assembly routine to generate fast log values
; returns a word result of the longint value passed.
; The value returned is significant to three decimal places.
; The log value is returned as Ilog(value)*1000.
; Example: Value = 100 will return a log2 value of 6644
; the real log2 value of 100 is 6.644. Accuracy is +-.6%
; over the entire range of input. Values passed must be >0. 
; Values less than one return zero. No other error info given.
;***********************************************************;
;Upon entry stack looks like this
; SP + 6        [ value msb ]  ;msb of value to convert
; SP + 4	[ value lsb ]  ;lsb of value to convert
; SP + 2	[ CS	    ]  ;return address segment
; SP + 0	[ IP	    ]  ;return address offset
;This is for Pascal, so we have to clean up the stack on return
;-------------------------------------------------

CODE	SEGMENT	BYTE	PUBLIC

	ASSUME	CS:CODE
	PUBLIC  ILOG	;natural log
	PUBLIC	ILOG2	;base 2 log
	PUBLIC  ILOG10	;base 10 log

;*******************************************************
;function ILOG(Value:longint):word;
;*******************************************************

ILOG 	proc	far
	mov di,sp	;point at value on stack
	call Lcalc	;compute the log2 value
	mov bx,45426	;convert log2 to natural log
	mul bx		;0.69315*65536=45426
	or ax,ax
	jns nrln	;round it to nearest value
	inc dx
nrln:
	mov ax,dx	;scale it back to a word value
	xor dx,dx	;clear dx
	ret 4		;clean up the stack and go home
ILOG	endp

;******************************************************
;function ILOG2(Value:longint):word;
;******************************************************

ILOG2 	proc	far
	mov di,sp	;point at value on stack
	call Lcalc	;compute the log2 value
	ret 4		;clean up the stack and go home
ILog2 	endp

;******************************************************
;function ILOG10(Value:longint):word;
;******************************************************

ILOG10 	proc	far
	mov di,sp	;point at value on stack
	call Lcalc	;compute the log2 value
	mov bx,19728	;convert log2 to log10
	mul bx		;0.30103*65536=19728
	or ax,ax
	jns nrln10	;round it to nearest value
	inc dx
nrln10:
	mov ax,dx	;scale it back to a word value
	xor dx,dx	;clear dx
	ret 4		;clean up the stack and go home
ILOG10	endp


;-------------------------------------------------------
;Compute log of value in bx:dx return log in dx:ax

Lcalc	proc near
	mov dx,ss:[di+4];read value lsb off stack
	mov bx,ss:[di+6];read value msb off stack
	xor ax,ax	;clear return value
	mov cx,32	;a longint is 32 bits long
	or bx,bx	;check if really longint passed
	js done		;return zero if negative number
	jnz sloop	;it is a longint so process it
	mov bx,dx	;a word, so switch to word format
	xor dx,dx	;for faster processing
	shr cx,1	;cx=16
sloop:
	dec cx		;loop til done
	jz done
	rcl dx,1	;carry is clear from the dec cx
	rcl bx,1	;look for high bit
	jnc sloop	;loop til we find it
	mov ax,1000	;mult bit position x1000
	mul cx		;and put it in ax

	lea di,Ftable	;di points at frac table
	mov bl,bh	;adjust bx for table lookup
	xor bh,bh
	test bl,1	;round up?
	jz nornd	;no
	and bl,0FEh	;truncate to 7 bits resolution
	mov cx,cs:[di+bx]   ;get this value
	mov dx,cs:[di+bx+2] ;and next value
	sub dx,cx	;calc diff
	shr dx,1	;take half that
	add ax,dx	;add it to log
nornd:
	add ax,cs:[di+bx] ;add in fractional part
done:			;log is returned in ax
	xor dx,dx	;this allows use as a longint ret
	ret
Lcalc	endp

;-----------------------------------------------------
;log fraction table lookup

Ftable: ;fraction part table
        dw 0    ;index:0   log fraction:0.0000000000
        dw 11   ;index:1   log fraction:0.0112272554
        dw 22   ;index:2   log fraction:0.0223678130
        dw 33   ;index:3   log fraction:0.0334230015
        dw 44   ;index:4   log fraction:0.0443941193
        dw 55   ;index:5   log fraction:0.0552824355
        dw 66   ;index:6   log fraction:0.0660891904
        dw 77   ;index:7   log fraction:0.0768155970
        dw 87   ;index:8   log fraction:0.0874628412
        dw 98   ;index:9   log fraction:0.0980320829
        dw 109  ;index:10  log fraction:0.1085244568
        dw 119  ;index:11  log fraction:0.1189410727
        dw 129  ;index:12  log fraction:0.1292830169
        dw 140  ;index:13  log fraction:0.1395513524
        dw 150  ;index:14  log fraction:0.1497471195
        dw 160  ;index:15  log fraction:0.1598713367
        dw 170  ;index:16  log fraction:0.1699250014
        dw 180  ;index:17  log fraction:0.1799090900
        dw 190  ;index:18  log fraction:0.1898245589
        dw 200  ;index:19  log fraction:0.1996723448
        dw 209  ;index:20  log fraction:0.2094533656
        dw 219  ;index:21  log fraction:0.2191685204
        dw 229  ;index:22  log fraction:0.2288186905
        dw 238  ;index:23  log fraction:0.2384047393
        dw 248  ;index:24  log fraction:0.2479275134
        dw 257  ;index:25  log fraction:0.2573878427
        dw 267  ;index:26  log fraction:0.2667865407
        dw 276  ;index:27  log fraction:0.2761244053
        dw 285  ;index:28  log fraction:0.2854022188
        dw 295  ;index:29  log fraction:0.2946207489
        dw 304  ;index:30  log fraction:0.3037807482
        dw 313  ;index:31  log fraction:0.3128829553
        dw 322  ;index:32  log fraction:0.3219280949
        dw 331  ;index:33  log fraction:0.3309168781
        dw 340  ;index:34  log fraction:0.3398500029
        dw 349  ;index:35  log fraction:0.3487281542
        dw 358  ;index:36  log fraction:0.3575520046
        dw 366  ;index:37  log fraction:0.3663222142
        dw 375  ;index:38  log fraction:0.3750394313
        dw 384  ;index:39  log fraction:0.3837042924
        dw 392  ;index:40  log fraction:0.3923174227
        dw 401  ;index:41  log fraction:0.4008794363
        dw 409  ;index:42  log fraction:0.4093909361
        dw 418  ;index:43  log fraction:0.4178525149
        dw 426  ;index:44  log fraction:0.4262647547
        dw 435  ;index:45  log fraction:0.4346282276
        dw 443  ;index:46  log fraction:0.4429434958
        dw 451  ;index:47  log fraction:0.4512111118
        dw 459  ;index:48  log fraction:0.4594316186
        dw 468  ;index:49  log fraction:0.4676055501
        dw 476  ;index:50  log fraction:0.4757334309
        dw 484  ;index:51  log fraction:0.4838157772
        dw 492  ;index:52  log fraction:0.4918530963
        dw 500  ;index:53  log fraction:0.4998458871
        dw 508  ;index:54  log fraction:0.5077946402
        dw 516  ;index:55  log fraction:0.5156998383
        dw 524  ;index:56  log fraction:0.5235619560
        dw 531  ;index:57  log fraction:0.5313814605
        dw 539  ;index:58  log fraction:0.5391588111
        dw 547  ;index:59  log fraction:0.5468944599
        dw 555  ;index:60  log fraction:0.5545888516
        dw 562  ;index:61  log fraction:0.5622424242
        dw 570  ;index:62  log fraction:0.5698556083
        dw 577  ;index:63  log fraction:0.5774288280
        dw 585  ;index:64  log fraction:0.5849625007
        dw 592  ;index:65  log fraction:0.5924570372
        dw 600  ;index:66  log fraction:0.5999128422
        dw 607  ;index:67  log fraction:0.6073303137
        dw 615  ;index:68  log fraction:0.6147098441
        dw 622  ;index:69  log fraction:0.6220518194
        dw 629  ;index:70  log fraction:0.6293566201
        dw 637  ;index:71  log fraction:0.6366246205
        dw 644  ;index:72  log fraction:0.6438561898
        dw 651  ;index:73  log fraction:0.6510516912
        dw 658  ;index:74  log fraction:0.6582114827
        dw 665  ;index:75  log fraction:0.6653359172
        dw 672  ;index:76  log fraction:0.6724253420
        dw 679  ;index:77  log fraction:0.6794800995
        dw 687  ;index:78  log fraction:0.6865005272
        dw 693  ;index:79  log fraction:0.6934869575
        dw 700  ;index:80  log fraction:0.7004397181
        dw 707  ;index:81  log fraction:0.7073591321
        dw 714  ;index:82  log fraction:0.7142455176
        dw 721  ;index:83  log fraction:0.7210991887
        dw 728  ;index:84  log fraction:0.7279204545
        dw 735  ;index:85  log fraction:0.7347096202
        dw 741  ;index:86  log fraction:0.7414669864
        dw 748  ;index:87  log fraction:0.7481928496
        dw 755  ;index:88  log fraction:0.7548875021
        dw 762  ;index:89  log fraction:0.7615512324
        dw 768  ;index:90  log fraction:0.7681843247
        dw 775  ;index:91  log fraction:0.7747870596
        dw 781  ;index:92  log fraction:0.7813597135
        dw 788  ;index:93  log fraction:0.7879025594
        dw 794  ;index:94  log fraction:0.7944158663
        dw 801  ;index:95  log fraction:0.8008998999
        dw 807  ;index:96  log fraction:0.8073549220
        dw 814  ;index:97  log fraction:0.8137811912
        dw 820  ;index:98  log fraction:0.8201789624
        dw 827  ;index:99  log fraction:0.8265484873
        dw 833  ;index:100  log fraction:0.8328900141
        dw 839  ;index:101  log fraction:0.8392037881
        dw 845  ;index:102  log fraction:0.8454900509
        dw 852  ;index:103  log fraction:0.8517490414
        dw 858  ;index:104  log fraction:0.8579809951
        dw 864  ;index:105  log fraction:0.8641861446
        dw 870  ;index:106  log fraction:0.8703647196
        dw 877  ;index:107  log fraction:0.8765169465
        dw 883  ;index:108  log fraction:0.8826430493
        dw 889  ;index:109  log fraction:0.8887432489
        dw 895  ;index:110  log fraction:0.8948177633
        dw 901  ;index:111  log fraction:0.9008668080
        dw 907  ;index:112  log fraction:0.9068905956
        dw 913  ;index:113  log fraction:0.9128893362
        dw 919  ;index:114  log fraction:0.9188632372
        dw 925  ;index:115  log fraction:0.9248125036
        dw 931  ;index:116  log fraction:0.9307373375
        dw 937  ;index:117  log fraction:0.9366379390
        dw 943  ;index:118  log fraction:0.9425145053
        dw 948  ;index:119  log fraction:0.9483672316
        dw 954  ;index:120  log fraction:0.9541963104
        dw 960  ;index:121  log fraction:0.9600019320
        dw 966  ;index:122  log fraction:0.9657842846
        dw 972  ;index:123  log fraction:0.9715435539
        dw 977  ;index:124  log fraction:0.9772799235
        dw 983  ;index:125  log fraction:0.9829935747
        dw 989  ;index:126  log fraction:0.9886846868
        dw 994  ;index:127  log fraction:0.9943534368
        dw 1000 ;index:128  log fraction:1.0000000000


;-------------------------------------------------

CODE	ENDS

	END



