	page 56,132
	title "Rounding Integer Division  Version 1.1  as of 3-8-89 -med"
;
;***********************************************************;
; INTDIV - assembly routine to perform 
; integer division with rounding.
;***********************************************************;
;Upon entry stack looks like this
; SP + 8        [ Dividend msb ]  ;msb of value to divide
; SP + 6	[ Dividend lsb ]  ;lsb of value to divide
; SP + 4        [ Divisor      ]  ;divisor to use
; SP + 2	[ CS	       ]  ;return address segment
; SP + 0	[ IP	       ]  ;return address offset
;This is for Pascal, so we have to clean up the stack on return
;-------------------------------------------------

CODE	SEGMENT	BYTE	PUBLIC

	ASSUME	CS:CODE
	PUBLIC  RWDIV	;unsigned rounding divide
	PUBLIC	RIDIV	;signed rounding divide

;*******************************************************
;function RWDIV(Dividend:longint; Divisor:word):word;
;*******************************************************

RWDIV 	proc	far
	mov di,sp	;point at value on stack
	mov bx,ss:[di+4]
	mov ax,ss:[di+6] ;get values from stack
	mov dx,ss:[di+8]
	div bx		;do the divide
	add dx,dx
	cmp bx,dx	;round it if needed
	jnc nornd
	inc ax
nornd:
	xor dx,dx	;clear dx
	ret 6		;clean up the stack and go home
RWDIV	endp

;************************************************************
;function RIDIV(Dividend:longint; Divisor:integer):integer;
;************************************************************

RIDIV 	proc	far
	mov di,sp	;point at value on stack
	mov bx,ss:[di+4]
	mov ax,ss:[di+6] ;get values from stack
	mov dx,ss:[di+8]
	idiv bx		;do the divide
	add dx,dx
	jns posok	;adjust remainder to absolute
	neg dx
posok:
	or bx,bx
	jns sngok	;adjust divisor to absolute
	neg bx
sngok:
	or ax,ax	;negative quotient?
	js negrnd
	cmp dx,bx	;nope, check for positive rounding
	jl noirnd
	inc ax
	jmp short noirnd
negrnd:
	cmp dx,bx	;check for negative rounding
	jl noirnd
	dec ax
noirnd:
	xor dx,dx	;clear dx
	ret 6		;clean up the stack and go home
RIDIV 	endp


;-------------------------------------------------

CODE	ENDS

	END


