
program InsertRedrawDemo;
{demonstrates reading an input line in a dialog box, }
{placing an output in another input line in the      }
{same box while box stays open.                      }
{Author: Stewart Midwinter, with thanks to           }
{Blake Watson [70303,373] for his assistance.        }

uses Objects,Drivers,Views,Menus,Dialogs,App,Crt;

const
  cmNewDialog = 101;
  cmConvert   = 55555;

type
  PDataRec = ^DataRec;
  DataRec  = RECORD
   Field1: string [ 15 ] ; 
   Field2: string [ 15 ] ; 
  END ;

const
  DemoDialogData: DataRec = (Field1: '123.45'; Field2: '');

type
  TMyApp = object(TApplication)
    procedure HandleEvent(var Event: TEvent); virtual;
    procedure InitStatusLine; virtual;
    procedure NewDialog;
  end;

  PDemoDialog = ^TDemoDialog;
  TDemoDialog = object(TDialog)
         POutput: PInputLine;
          PInput: PInputLine;
  procedure HandleEvent(var Event:TEvent); virtual;
  end;
{ pointers to the inputlines (which could be descendant types for
  validation) are needed here so that HandleEvent can work with the data}
{ Box needs its own HandleEvent since we are defining additional behaviour}

procedure TMyApp.HandleEvent(var Event: TEvent);
begin
      TApplication.HandleEvent(Event);
      if Event.What = evCommand then
      begin
        case Event.Command of
        cmNewDialog: NewDialog;
        else Exit;
      end;
      ClearEvent(Event);
      end;
end;

procedure TMyApp.InitStatusLine;
var R: TRect;
begin
      GetExtent(R);
      R.A.Y := R.B.Y - 1;
      StatusLine := New(PStatusLine, Init(R,
      NewStatusDef(0,$FFFF,NewStatusKey('~Alt-X~ Exit',kbAltX,cmQuit,
      NewStatusKey('~F2~ Dialog',kbF2,cmNewDialog,nil)),nil)));
end;
  {you don't need a menubar to create a dialog box}
  
procedure TMyApp.NewDialog;
var Dlg: PDemoDialog;
    R: TRect; C: word;
    IControl: PInputline; {could be PTimeInputLine or whatever}
    OControl: PInputline;
    
begin
   R.Assign(3,1,44,13);
   Dlg:=New(PDemoDialog,Init(R,'Input/Output'));
with Dlg^ do begin
   R.Assign ( 12 , 2 , 37 , 3 ) ;
   IControl:= New ( PInputline , Init ( R , 15 ));
   Dlg^.Insert ( IControl ) ;
   Dlg^.PInput := IControl;
   R.Assign ( 5 , 2 , 12 , 3 ) ;
   Dlg^.Insert (New(PLabel,Init(R,'~I~nput',IControl))) ;
   R.Assign ( 12 , 4 , 37 , 5 ) ;
   OControl:= New(PInputline,Init(R,15));
   Dlg^.Insert (OCOntrol);
   Dlg^.POutput := OCOntrol;
   R.Assign ( 4 , 4 , 12 , 5 ) ;
   Dlg^.Insert (New(PLabel,Init(R,'~O~utput',OControl ))) ;
   R.Assign ( 7 , 6 , 18 , 8 ) ;
   Dlg^.Insert(New(PButton,Init (R,'Convert~',cmConvert,bfDefault))) ;
   R.Assign ( 20 , 6 , 30 , 8 ) ;
   Dlg^.Insert(New(PButton,Init(R,'Done',cmOk,0)));
                             {note OK button has no bf flag}
   Dlg^.SelectNext(False);
   Dlg^.SetData(DemodialogData);
         {omit if you don't need initial data shown upon opening the box}
end;
  C := DeskTop^.ExecView(Dlg);
         {don't need to Insert box to have it remain open while we
          undertake conversions.}
end;

procedure TDemoDialog.HandleEvent;
var S: string;
begin TDialog.HandleEvent(Event);
      if Event.What = evCommand then begin
      Case Event.Command of
      cmConvert: begin
                 sound(2000); delay(10); nosound;
                 S:= PInput^.Data^;    {string contains contents of input-
                                        line pointed to by PInput }
                 PInput^.GetData(S);   {GetData is only necessary here if
                                        you are overriding the default, eg.
                                        converting km to miles, etc.}

                 POutput^.SetData(S);
                 end;
      end;
      end;
end;

var   MyApp: TMyApp;

begin
    MyApp.Init;
    MyApp.Run;
    MyApp.Done;
end.
