Unit Testunit;

Interface

Uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, Menus, HugeBffr, StdCtrls;

Type
  TForm1 = class(TForm)
    PopupMenu1: TPopupMenu;
    LoadFile1: TMenuItem;
    dlgOpen: TOpenDialog;
    Memo1: TMemo;
    RandomBytes: TMenuItem;
    Last100Chars1: TMenuItem;
    First100Chars1: TMenuItem;
    SubBuffer: TMenuItem;
    LeftString: TMenuItem;
    SpaceFill: TMenuItem;
    Partition: TMenuItem;
    LineCount: TMenuItem;
    procedure LoadFile1Click(Sender: TObject);
    procedure RandomBytesClick(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure Last100Chars1Click(Sender: TObject);
    procedure First100Chars1Click(Sender: TObject);
    procedure SubBufferClick(Sender: TObject);
    procedure LeftStringClick(Sender: TObject);
    procedure SpaceFillClick(Sender: TObject);
    procedure PartitionClick(Sender: TObject);
    procedure LineCountClick(Sender: TObject);
  private
    { Private declarations }
		Procedure CheckBfr;
  public
	{ Public declarations }
   Bfr: TBuffer;
  end;

Var
  Form1: TForm1;

Implementation

{$R *.DFM}

{ ************************************************************************* }
procedure TForm1.CheckBfr;
Begin
	If NOT Assigned(Bfr)
		Then raise Exception.Create('No BUFFER has been created yet');
End;

{ ************************************************************************* }
procedure TForm1.LoadFile1Click(Sender: TObject);
begin
	Memo1.Lines.Clear;
	If Assigned(Bfr) then begin
		Bfr.Free;
		Bfr := NIL
      End;
	If dlgOpen.Execute then begin
		Bfr := TBuffer.CreateFromFile(dlgOpen.FileName);
		If (Bfr.GetSize > 0) then Bfr.BufferToMemo(Memo1)
      End
end;

{ ************************************************************************* }
Function MakeRandom(Sz: LongInt): LongInt;
Var	I1, I2, I3: LongInt;
Begin
	If Sz < 32767 then MakeRandom := random(Sz)
   Else begin
		I3 := Sz;
		While (I3 >= Sz) OR (I3 <= 0) do begin
			I1 := random(32767);
			I2 := random(32767);
			I3 := I1 * I2;
			End;
		MakeRandom := I1*I2
		End
End;

{ ************************************************************************* }
procedure TForm1.RandomBytesClick(Sender: TObject);
Var	IX: LongInt;
		I: Integer;
		Txt: TStrings;
begin
	CheckBfr;
	Txt := Memo1.Lines;
	Txt.Clear;
	Randomize;
	For I := 1 to 100 do begin
		IX := MakeRandom(Bfr.GetSize);
		Txt.Add(IntToStr(IX)+': '+IntToStr(byte(Bfr.GetChar(IX))));
		End;
end;

{ ************************************************************************* }
procedure TForm1.FormDestroy(Sender: TObject);
begin
	If Assigned(Bfr) then Bfr.Free
end;

{ ************************************************************************* }
procedure TForm1.Last100Chars1Click(Sender: TObject);
Var	IX: LongInt;
		Txt: TStrings;
		S: String;
begin
	CheckBfr;
	Txt := Memo1.Lines;
	S := '';
	Txt.Clear;
	Randomize;
	If Bfr.GetSize >= 100 then begin
		IX := Bfr.GetSize-100;
		For IX := IX to Bfr.GetSize-1
			Do S := S+Bfr.GetChar(IX)
		End
	Else begin
		For IX := 0 to Bfr.GetSize-1
			Do S := S+Bfr.GetChar(IX)
		End;
	Txt.Add(S);
end;

{ ************************************************************************* }
procedure TForm1.First100Chars1Click(Sender: TObject);
Var	IX: LongInt;
		Txt: TStrings;
		S: String;
begin
	CheckBfr;
	Txt := Memo1.Lines;
	S := '';
	Txt.Clear;
	Randomize;
	If Bfr.GetSize < 100 then for IX := 0 to Bfr.GetSize-1
			Do S := S+Bfr.GetChar(IX)
	Else for IX := 0 to 99 do S := S+Bfr.GetChar(IX);
	Txt.Add(S);
end;

{ ************************************************************************* }
procedure TForm1.SubBufferClick(Sender: TObject);
Var	Tmp: TBuffer;
		Nmbr: string[32];
      IX, Lngth: LongInt;
begin
	CheckBfr;
	If InputQuery(EmptyStr, 'Starting Index:', Nmbr) then begin
   	IX := StrToInt(Nmbr);
   	If (IX < 0) or (IX >= Bfr.Size) then exit;
   	If InputQuery(EmptyStr, 'Length:', Nmbr) then begin
	      Lngth := StrToInt(Nmbr);
	      If (Lngth < 0) then exit;
			Tmp := Bfr.SubBuffer(IX, Lngth);
		   Memo1.Clear;
	      If Tmp.Size <= 32000 then Tmp.BufferToMemo(Memo1)
	      Else Memo1.Lines.Add('Sub-buffer '+IntToStr(Tmp.Size));
		   Tmp.SaveToFile('C:\TEMP.TMP');
		   Tmp.Free
         End
      End
end;

procedure TForm1.LeftStringClick(Sender: TObject);
Var	What: string;
begin
	CheckBfr;
	What := InputBox('Enter Search String','Object:','');
   If What = EmptyStr then exit;
   Memo1.Lines.Add(IntToStr(Bfr.Size));
   Memo1.Lines.Add(IntToStr(Bfr.LeftString(What,0,True)));
end;

procedure TForm1.SpaceFillClick(Sender: TObject);
begin
	If Assigned(Bfr) then Bfr.Free;
   Bfr := TBuffer.Create(65636);
	Bfr.Fill(32,0,200000);
   Bfr.SaveToFile('C:\TEMP.TMP');
   Bfr.Free;
   Bfr := NIL;
end;

procedure TForm1.PartitionClick(Sender: TObject);
Var	What: string;
		Tmp: TList;
begin
	CheckBfr;
	What := InputBox('Enter Partition String','Partition:','');
   If What = EmptyStr then exit;
   Tmp := Bfr.Partition(What, True);
   Memo1.Lines.Add('"'+What+'":'+IntToStr(Tmp.Count)+' occurrences');
   Tmp.Free
end;

procedure TForm1.LineCountClick(Sender: TObject);
begin
	CheckBfr;
   Memo1.Lines.Add(IntToStr(Bfr.CountCRLF)+' CR/LF pairs');
   Memo1.Lines.Add(IntToStr(Bfr.CountLF)+' Line Feeds')
end;

end.

