Program TestDemo;  {Generic Hash Table Demonstration Program}

Uses Crt,DemoTab;

Const
  Number     = 200;
  LoadFactor = 4;

Type
  KeyString = String[24];  {20 is the Maximum useable Key Length}
                           {longer keys are truncated to 20}

  SaveArray = Array[1..Number] of KeyString;

Var
  Table     : DemoTable;
  I,J       : Word;
  S         : KeyString;
  R         : Demo;
  Dupe      : Boolean;
  Save      : SaveArray;
  DupeCount : LongInt;

Function RandomKey : KeyString;
Var
  I : Byte;
  J : Byte;
  C : Char;
  S : KeyString;
Begin
  S := '';
  For I := 1 to SizeOf(KeyString)-1 do
    Begin
      C := ' ';
      While (Ord(C) < Ord('A')) or (Ord(C) > Ord ('Z')) do
        Begin
          J := Random (256);
          C := Chr(J)
        End;
      S := S + C
  End;
  RandomKey := S
End;

Procedure RandomRec (Var Rec : Demo);
Begin
  Rec.Data := Random (MaxInt);
End;

Begin
  ClrScr;

  Randomize;
{  RandSeed := 100; } {for testing Hashing Function Algorithms}

  DupeCount := 0;
  WriteLn ('Before Table Creation, Memory Available = ',MemAvail);
  Table.Create (Number,LoadFactor);
  WriteLn ('After Table Creation, Memory Available = ',MemAvail);
  For I := 1 to Number do
    Begin
      RandomRec (R);
      GoToXY (1,9);
      Save[I] := RandomKey;
      Write (I:4,' Entering Key ',Save[I],' with random value ',R.Data,'      ');
      Table.Enter (Save[I],R,Dupe);
      If Dupe Then
        DupeCount := DupeCount + 1
    End;
  GoToXY (1,3);
  WriteLn ('After Table Loading, Memory Available = ',MemAvail);
  WriteLn ('Table Contains ',Table.EntryCount:1,' Records');
  WriteLn ('Encountered ',DupeCount:1,' Duplicate Keys');
  WriteLn ('Table Allocated ',Table.StaticLength:1,' Buckets. Attempted Load Factor ',LoadFactor);
  GoToXY (1,11);
  Write ('Press <Return>/<Enter> to Continue...');
  ReadLn;
  For I := (Number Div 2) to Number do
    Begin

      {***** NOTE: In real world, check Table.Member(Save[I]) first!!!}

      R.Data := MaxInt - I;
      Table.UpDate (Save[I],R);
      GoToXY (1,11);
      Write (I:4,' UpDating Key ',Save[I],' with value ',R.Data,'      ')
    End;
  GoToXY (1,13);
  Write ('Press <Return>/<Enter> to Continue...');
  ReadLn;
  For I := 1 to Number do
    If Table.Member(Save[I]) Then
      Begin
        GoToXY (1,13);
        Table.Retrieve (Save[I],R,Dupe);
        Write (I:4,' Retrieving Key ',Save[I],'. Found value ',R.Data,'      ');
      End;
  WriteLn;
  WriteLn;
  Write ('Press <Return>/<Enter> to Continue...');
  ReadLn;
  Window (1,7,80,25);
  ClrScr;
  WriteLn ('Maximum Bucket Load          = ',Table.MaxLoad);
  WriteLn ('Total Number of Buckets Used = ',Table.Buckets_In_Use);
  WriteLn ('Index of Last Bucket Used    = ',Table.LastBucket);
  WriteLn ('Hash Table Load Factor       = ',Table.AverageLoad:4:8);
  Window (1,11,80,25);
  Table.Distribution_Report;
  WriteLn;
  WriteLn ('DESTROYING TABLE!  Please Wait...');
  Table.Destroy;
  Write ('After Table Destruction, Memory Available = ',MemAvail);
  ReadLn;
  Window (1,1,80,25)
End.