{------------------------------------------------------------------------------}
{		    Concepts from the TEGL Windows Toolkit		       }
{		   Copyright (C) 1990,1992 TEGL Systems Corporation 	       }
{			     All Rights Reserved.			       }
{------------------------------------------------------------------------------}
{$I switches.inc}

Unit visual;

Interface

Uses frames,msmouse,fgraph;

Procedure BevelBox(x,y,x1,y1,topcolor,botcolor,interior,thickness : Word);
Procedure DrawSquareButton(x1,y1,x2,y2:Word);
Procedure ifsDrawSquareButton(fs:ImageStkPtr; x,y,x1,y1:Word);
Procedure DefineSquareButton(fs:ImageStkPtr; x,y,x1,y1:Word; EntryCallProc:callproc);
Procedure DefineSquareButtonText(fs:ImageStkPtr; x,y,x1,y1,rx,ry:Word; msg:string; EntryCallProc:callproc);
Function  VisualSquareButtonPress(fs:ImageStkPtr; ms:MsClickPtr) : Boolean;
Procedure ReleaseSquareButton(fs:ImageStkPtr; ms:MsClickPtr);
Procedure PressSquareButton(fs:ImageStkPtr; ms:MsClickPtr);
Procedure ShiftText(x,y,c,s:Word; msg:String);

Procedure ReverseMSArea(fs:ImageStkPtr; ms : MsClickPtr);
Function  VisualReverseAreaPress(fs:ImageStkPtr; ms:MsClickPtr) : Boolean;

implementation

Procedure ReverseMSArea(fs:ImageStkPtr; ms : MsClickPtr);
   VAR pt : Pointer;
       sz : Word;
       x,y,x1,y1 :word;
   BEGIN
      IF ms<>NIL THEN
	 begin
	    x  := fs^.x+ms^.x;
	    y  := fs^.y+ms^.y;
	    x1 := fs^.x+ms^.x1;
	    y1 := fs^.y+ms^.y1;

	    sz := ImageSize(x,y,x1,y1);
	    GetMem(pt,sz);
	    hidemouse;
	    GetImage(x,y,x1,y1,pt^);
	    putimage(x,y,pt^,NotPut);
	    showmouse;
	    freeMem(pt,sz);
	 end;
   END;

Function VisualReverseAreaPress(fs:ImageStkPtr; ms:MsClickPtr) : Boolean;
   VAR selected    : Boolean;
       pressed	   : Boolean;
       mxpos,mypos : Word;
       stat	   : Word;
       ms1	   : MsClickPtr;
   BEGIN
      selected := TRUE;

      IF (fs<>NIL) and (ms<>NIL) THEN
	 BEGIN
	    pressed := FALSE;

	    repeat
	       stat := MousePosition(mxpos,mypos);
	       ms1  := findms(fs,mxpos,mypos);

	       IF (ms1<>ms) and pressed THEN
		  BEGIN
		     ReverseMSArea(fs,ms);
		     pressed := FALSE;
		     selected := FALSE;
		  END
	       ELSE
	       IF (ms1=ms) and not pressed THEN
		  BEGIN
		     ReverseMSArea(fs,ms);
		     pressed := TRUE;
		     selected := TRUE;
		  END;
	    until (ms1<>ms) or (stat=0);

	 END;

      VisualReverseAreaPress := selected;
   END;

Procedure PressSquareButton(fs:ImageStkPtr; ms:MsClickPtr);
   var x,y,x1,y1:word;
       im : pointer;
       is : word;
   BEGIN
      hidemouse;
      x  := fs^.x+ms^.x;
      y  := fs^.y+ms^.y;
      x1 := fs^.x+ms^.x1;
      y1 := fs^.y+ms^.y1;

      setcolor(lightgray);
      rectangle(x+1,y+1,x1-1,y1-1);
      rectangle(x+2,y+2,x1-2,y1-2);

      is := imagesize(x+1,y+1,x1-2,y1-2);
      getmem(im,is);
      getimage(x+1,y+1,x1-2,y1-2,im^);
      putimage(x+2,y+2,im^,normalput);
      freemem(im,is);

      setcolor(darkgray);
      line(x+1,y+1,x+1,y1-1);
      line(x+1,y+1,x1-1,y+1);
      showmouse;
   END;

Procedure ReleaseSquareButton(fs:ImageStkPtr; ms:MsClickPtr);
   var x,y,x1,y1:word;
       im : pointer;
       is : word;
   BEGIN
      hidemouse;
      x  := fs^.x+ms^.x;
      y  := fs^.y+ms^.y;
      x1 := fs^.x+ms^.x1;
      y1 := fs^.y+ms^.y1;

      is := imagesize(x+2,y+2,x1-1,y1-1);
      getmem(im,is);
      getimage(x+2,y+2,x1-1,y1-1,im^);
      putimage(x+1,y+1,im^,normalput);
      freemem(im,is);

      setcolor(white);
      line(x+1,y+1,x1-1,y+1);	   {top white reflection}
      line(x+1,y+1,x+1,y1-1);	   {left white reflection}

      setcolor(darkgray);
      line(x+1,y1-1,x1-1,y1-1); {bottom darkgray shadow}
      line(x+2,y1-2,x1-1,y1-2); {bottom darkgray shadow}

      line(x1-1,y+1,x1-1,y1-1); {right darkgray shadow}
      line(x1-2,y+2,x1-2,y1-1); {right darkgray shadow}
      showmouse;
   END;

Function VisualSquareButtonPress(fs:ImageStkPtr; ms:MsClickPtr) : Boolean;
   VAR selected    : Boolean;
       pressed	   : Boolean;
       mxpos,mypos : Word;
       stat	   : Word;
       ms1	   : MsClickPtr;
   BEGIN
      selected := TRUE;

      IF (fs<>NIL) and (ms<>NIL) THEN
	 BEGIN
	    pressed := FALSE;

	    repeat
	       stat := MousePosition(mxpos,mypos);
	       ms1  := findms(fs,mxpos,mypos);

	       IF (ms1<>ms) and pressed THEN
		  BEGIN
		     ReleaseSquareButton(fs,ms);
		     pressed := FALSE;
		     selected := FALSE;
		  END
	       ELSE
	       IF (ms1=ms) and not pressed THEN
		  BEGIN
		     PressSquareButton(fs,ms);
		     pressed := TRUE;
		     selected := TRUE;
		  END;
	    until (ms1<>ms) or (stat=0);

	 END;

      VisualSquareButtonPress := selected;
   END;

Procedure DrawSquareButton(x1,y1,x2,y2:Word);
   BEGIN
      setfillstyle(solidfill,lightgray);
      Bar(x1,y1,x2,y2);

      setcolor(black);
      rectangle(x1,y1,x2,y2);

      setcolor(white);
      line(x1+1,y1+1,x2-1,y1+1);    {top white reflection}
      line(x1+1,y1+1,x1+1,y2-1);    {left white reflection}

      setcolor(darkgray);
      line(x1+1,y2-1,x2-1,y2-1); {bottom darkgray shadow}
      line(x1+2,y2-2,x2-1,y2-2); {bottom darkgray shadow}

      line(x2-1,y1+1,x2-1,y2-1); {right darkgray shadow}
      line(x2-2,y1+2,x2-2,y2-1); {right darkgray shadow}
   END;

Procedure ShiftText(x,y,c,s:Word; msg:String);
   BEGIN
      SetColor(c);
      OutTextXY(x+1,y,msg);
      SetColor(s);
      OutTextXY(x,y,msg);
   END;

Procedure ifsDrawSquareButton(fs:ImageStkPtr; x,y,x1,y1:Word);
   VAR xc1,yc1,xc2,yc2 : Word;
   BEGIN
      xc1 := fs^.x+x;
      yc1 := fs^.y+y;
      xc2 := fs^.x+x1;
      yc2 := fs^.y+y1;

      DrawSquareButton(xc1,yc1,xc2,yc2);
   END;

Procedure DefineSquareButton(fs:ImageStkPtr; x,y,x1,y1:Word; EntryCallProc:callproc);
   BEGIN
      ifsDrawSquareButton(fs,x,y,x1,y1);
      DefineMouseClickArea(fs,x,y,x1,y1,EntryCallProc);
   END;

Procedure DefineSquareButtonText(fs:ImageStkPtr; x,y,x1,y1,rx,ry:Word; msg:string; EntryCallProc:callproc);
   BEGIN
      DefineSquareButton(fs,x,y,x1,y1,EntryCallProc);
      shifttext(fs^.x+x+rx,fs^.y+y+ry,white,black,msg);
   END;

Procedure BevelBox(x,y,x1,y1,topcolor,botcolor,interior,thickness : Word);
   var i : word;
   BEGIN
      setcolor(black);
      rectangle(x,y,x1,y1);
      rectangle(x+thickness,y+thickness,x1-thickness,y1-thickness);

      for i:=1 to thickness-1 do
	 begin
	    setcolor(topcolor);
	    Line(x+i,y+i,x1-i,y+i);   {top}
	    Line(x+i,y+i,x+i,y1-i);   {left}

	    setcolor(botcolor);
	    Line(x+i,y1-i,x1-i,y1-i);  {bottom}
	    Line(x1-i,y+i,x1-i,y1-i);  {right}
	 end;

      setcolor(black);
      Line(x,y,x+thickness,y+thickness);      {upper left}
      Line(x,y1,x+thickness,y1-thickness);    {lower left}
      Line(x1,y,x1-thickness,y+thickness);    {upper right}
      Line(x1,y1,x1-thickness,y1-thickness);  {lower right}

      setfillstyle(solidfill,interior);
      Bar(x+thickness+1,y+thickness+1,x1-thickness-1,y1-thickness-1);
   END;

end.
