{------------------------------------------------------------------------------}
{		    Concepts from the TEGL Windows Toolkit		       }
{		   Copyright (C) 1990,1992 TEGL Systems Corporation 	       }
{			     All Rights Reserved.			       }
{------------------------------------------------------------------------------}
{$I switches.inc}
{$F+}

uses frames,fgraph,visual,msmouse,movewin,menus,intrpts,stredits,tablinks;

var gd,gm : integer;
    TEGLMain_ExitSave : Pointer;
    mfs   : imagestkptr;

const
    om1        : optionMptr = nil;
    om2        : optionMptr = nil;
    namestr    : string[50] = 'Richard Tom';
    companystr : string[40] = 'TEGL Systems Corporation';
    addressstr : string[40] = 'P.O. Box 680, Stn. A';
    citystr    : string[20] = 'Vancouver';
    Statestr   : string[20] = 'British Columbia';
    countrystr : string[20] = 'Canada';
    postalstr  : string[12] = 'V6C 2N2';
    phonestr   : string[20] = '(604) 669-2577';
    faxstr     : string[20] = '(604) 688-9530';

    UpgradeSel : word = 2;

procedure pressme(ifs:ImageStkPtr; ms: MsClickPtr);
   begin
      if visualsquarebuttonpress(ifs,ms) then
	 begin
	   releasesquarebutton(ifs,ms);
	   halt(0);
	 end;
   end;

procedure closeme(ifs:ImageStkPtr; ms: MsClickPtr);
   begin
      if visualsquarebuttonpress(ifs,ms) then
	 closeframe(ifs);
   end;

procedure menuacknowledge(ifs:ImageStkPtr; ms: MsClickPtr);
   begin
      if visualreverseareapress(ifs,ms) then
	 closeframe(ifs);
   end;

procedure om1event(ifs:ImageStkPtr; ms: MsClickPtr);
   begin
      if visualreverseareapress(ifs,ms) then
	 openoptionmenu(ifs^.x+ms^.x,ifs^.y+ms^.y1,om1);
   end;

procedure om2event(ifs:ImageStkPtr; ms: MsClickPtr);
   begin
      if visualreverseareapress(ifs,ms) then
	 openoptionmenu(ifs^.x+ms^.x,ifs^.y+ms^.y1,om2);
   end;

Procedure TEGLMain_TerminateExit;
   BEGIN
     CloseGraph;
     RestoreCrtMode;

     ExitProc := TEGLMain_ExitSave;
   END;

type
   maxminwindptr = ^maxwindrec;
   maxwindrec = record
		   x,y,x1,y1 : word;
		end;

procedure Freemaxwindptr(fs:ImageStkPtr; Userkey:word; Var DataArea);
   var mw : maxminwindptr absolute DataArea;
   begin
      freemem(mw,sizeof(mw^));
   end;

procedure maxminwind(ifs:ImageStkPtr; ms: MsClickPtr);
   var mw : maxminwindptr;
   begin
      if visualsquarebuttonpress(ifs,ms) then
	 begin
	    GetUserDataArea(ifs,$6fff,mw);     {get maxminwindptr}
	    if mw=nil then
	       begin
		  getmem(mw,sizeof(mw^));
		  mw^.x  := ifs^.x;
		  mw^.y  := ifs^.y;
		  mw^.x1 := ifs^.x1;
		  mw^.y1 := ifs^.y1;
		  resizeframe(ifs,0,0,getmaxx,getmaxy);
		  setuserdataarea(ifs,$6fff,mw,freemaxwindptr);
	       end
	    else
	       resizeframe(ifs,mw^.x,mw^.y,mw^.x1,mw^.y1);
	 end;
   end;

procedure solidxorhighlight(ifs:ImageStkPtr; ms: MsClickPtr);
   var lastrmwb  : word;
   begin
      lastrmwb	:= rmwbits;
      rmwbits	:= xorput;

      hidemouse;
      setcolor(7);
      rectangle(ifs^.x+ms^.x-1,
		ifs^.y+ms^.y-1,
		ifs^.x+ms^.x1+1,
		ifs^.y+ms^.y1+1);
      showmouse;
      setcolor(black);

      rmwbits := lastrmwb;
   end;

{activated from stredit on entry}
procedure tabstr(ifs:ImageStkPtr; ms: MsClickPtr);
   begin
      settablink(ifs,(ms^.clicknumber-12) div 2);
   end;

{activated by tablinks when highlighting}
procedure clickstr(ifs:ImageStkPtr; ms: MsClickPtr);
   var se : septr;
   begin
{     solidxorhighlight(ifs,ms); }

      {getactivese() will return an active se ptr if tablink was
       activated from stredit. Otherwise, if no active se, we will
       activate it}
      se := getactivese(ifs);
      ms := getms(ifs,ms^.clicknumber+1);

      if (se=nil) or (se^.ms<>ms) then
	 setstredit(ifs,ms,255);
   end;

{actviated by mouse click area on label}
procedure clickedit(ifs:ImageStkPtr; ms: MsClickPtr);
   var x,y : word;
   begin
     { this will call clickstr to highlight and activate str edit }
      settablink(ifs,(ms^.clicknumber-11) div 2);
      while mouseposition(x,y)<>0 do;
   end;

procedure Nexttablink(ifs:ImageStkPtr; ms: MsClickPtr);
   var ct : word;
   begin
      ct := getactivetabnum(ifs);
      if (ct<9) then
	 settablink(ifs,ct+1)
      else
	 settablink(ifs,14);
   end;

procedure toggleX(ifs:imagestkptr; msnum:word; toggle:boolean);
   var ugms : msclickptr;
   begin
      ugms := getms(ifs,msnum);
      bar(ifs^.x+ugms^.x+4,ifs^.y+ugms^.y+2,ifs^.x+ugms^.x+4+8,ifs^.y+ugms^.y+2+12);
      rectangle(ifs^.x+ugms^.x+4,ifs^.y+ugms^.y+2,ifs^.x+ugms^.x+4+8,ifs^.y+ugms^.y+2+12);
      if toggle then
	 outtextxy(ifs^.x+ugms^.x+5,ifs^.y+ugms^.y+2,'X');
   end;

procedure UpgradeProc(ifs:ImageStkPtr; ms: MsClickPtr);
   var ugms : msclickptr;
       x,y  : word;
   begin
      settablink(ifs,ms^.clicknumber-21);

      setcolor(black);
      if upgradesel=(ms^.clicknumber-30) then
	 upgradesel:=0
      else
	 upgradesel:=(ms^.clicknumber-30);

      hidemouse;
      toggleX(ifs,31,upgradesel=1);
      toggleX(ifs,32,upgradesel=2);
      toggleX(ifs,33,upgradesel=3);
      showmouse;

      while mouseposition(x,y)<>0 do;
   end;


     { The following are the MouseClick numbers in []
      ͻ
      [04] [01]		A GUI Window			[05][06]
      ͹
       [02]File  [03]Options					     [10]
      ͹
       	    Ŀ	     [11]
      [13]Name     [14]				 	     ͹
       	    Ĵ	     	  
      [15]Company  [16]				 	     	  
       	    Ĵ	     	  
      [17]Address  [18]				 	     	  
       	    Ĵ	     	  
      [19]City     [20]	   [21]State [22]	 	     	  
       	    Ĵ	     	  
      [23]Country  [24]	   [25]Postal[26]	 	     	  
       	    Ĵ	     	  
      [27]Phone    [28]	   [29]Fax[30]	 	     	  
       	    	     	  
       Upgrade:						     	  
        [31] Release 1.1 to 3.0 ($149) 			     	  
        [32] Release 2.x to 3.0 ($89)				     	  
        [33] Release 2.x to Protected Mode 3.0 ($249)		     	  
       							     	  
       							     ͹
       							     [12]
      ͹
      [07][08]						[09]	  
      ͼ}

procedure ifsaddinputline(ifs:imagestkptr; x,y,x1,y1,maxlen,cn:word; title:string; var stringptr:string; firsttime:boolean);
   var wd : word;
   begin
      wd := length(title)*8;
      outtextxy(ifs^.x+x,ifs^.y+y+2,title);
      rectangle(ifs^.x+x+wd,ifs^.y+y,ifs^.x+x1,ifs^.y+y1);
      if firsttime then
	 begin
	    DefineMouseClickArea(ifs,x,y+2,x+wd,y+2+charheight,clickedit);
	    addtablinks(ifs,ifs^.msptr,clickstr,nilunitproc,nexttablink);
	    definestreditevent(ifs,x+wd+2,y+2,x1-2,y+2+charheight,maxlen,
				     black,stringptr,tabstr,nilunitproc);
	 end
      else
	 displaystredit(ifs,getms(ifs,cn));
   end;

procedure ifsaddradiobutton(ifs:imagestkptr; x,y,x1,y1:word; radiotext:string; firsttime:boolean; radioproc:callproc);
   var wd,tp : word;
   begin
{     rectangle(ifs^.x+x+4,ifs^.y+y+2,ifs^.x+x+4+8,ifs^.y+y+2+12); }
      wd := length(radiotext)*8;
      tp := ifs^.x+x+4+14+wd;
      if tp>ifs^.x1 then
	 begin
	    tp := ((tp-ifs^.x1) div 8)+4;
	    radiotext := copy(radiotext,1,length(radiotext)-tp);
	 end;

      outtextxy(ifs^.x+x+4+14,ifs^.y+y+2,radiotext);
      if firsttime then
	 begin
	    DefineMouseClickArea(ifs,x,y,x1,y1,radioproc);
	    addtablinks(ifs,ifs^.msptr,solidxorhighlight,solidxorhighlight,radioproc);
	 end;
   end;

procedure MsWindowredraw(ifs:ImageStkPtr; ms: MsClickPtr);
   var fx,fy,fx1,fy1  : word;
       wx,wy,wx1,wy1  : word;
       h,w,c,tx,ty,mx : word;
       firsttime      : boolean;
       fullsize       : boolean;
       ct	      : word;
   begin
      firsttime := ifs^.firsttime;

      fx  := ifs^.x;		{absolute frame coordinates}
      fy  := ifs^.y;
      fx1 := ifs^.x1;
      fy1 := ifs^.y1;

      fullsize := false;
      if (fx=0) and (fy=0) and (fx1=getmaxx) and (fy1=getmaxy) then
	 fullsize := true;

      if fullsize then
	 begin
	    setfillstyle(solidfill,white);
	    bar(fx,fy,fx1,fy1);
	 end
      else
	 bevelbox(fx,fy,fx1,fy1,lightgray,darkgray,white,5);

      h  := textheight('A')+1;  {header bar height}
      w  := h;			{buttons width}

      if fullsize then
	 begin
	    wx	:= 0;		      {working coordinates for full size win}
	    wy	:= 0;
	    wx1 := fx1-fx;
	    wy1 := fy1-fy;
	 end
      else
	 begin
	    wx	:= 5;		      {working coordinates after bevel edges}
	    wy	:= 5;
	    wx1 := fx1-fx-5;
	    wy1 := fy1-fy-5;
	 end;

      setfillstyle(solidfill,darkgray);
      bar(fx+wx+1,fy+wy+1,fx+wx1-1,fy+wy+2*h);

      setcolor(black);
      line(fx+wx,fy+wy+h,fx+wx1,fy+wy+h);
      line(fx+wx,fy+wy+2*h,fx+wx1,fy+wy+2*h);

      if firsttime then
	 definemouseclickarea(ifs,wx,wy,wx1,wy+h,framemove);

      setcolor(white);
      tx := wx+(((wx1-w-wx) div 2) - (textwidth('TEGL Release 3.0') div 2));
      outtextxy(fx+tx,fy+wy+2,'TEGL Release 3.0');
      setcolor(lightgray);
      outtextxy(fx+wx+5,fy+wy+h+2,' File  Options');
      if firsttime then
	 begin
	    definemouseclickarea(ifs,wx+5,wy+h+2,wx+5+6*8,wy+2*h,om1event);
	    definemouseclickarea(ifs,wx+5+6*8,wy+h+2,wx+5+15*8,wy+2*h,om2event);
	 end;

      ifsDrawSquareButton(ifs,wx,wy,wx+w,wy+h);
      ifsDrawSquareButton(ifs,wx1-2*w,wy,wx1-w,wy+h);
      ifsDrawSquareButton(ifs,wx1-w,wy,wx1,wy+h);

      if firsttime then
	 begin
	    DefineMouseClickArea(ifs,wx,wy,wx+w,wy+h,pressme);
	    DefineMouseClickArea(ifs,wx1-2*w,wy,wx1-w,wy+h,closeme);
	    DefineMouseClickArea(ifs,wx1-w,wy,wx1,wy+h,maxminwind);
	 end;

      wy  := wy+2*h;	      {working coordinates after header}
      setcolor(black);
      setfillstyle(solidfill,lightgray);
      bar(fx+wx1-w,fy+wy,fx+wx1,fy+wy1-h);
      bar(fx+wx,fy+wy1-h,fx+wx1,fy+wy1);

      rectangle(fx+wx1-w,fy+wy,fx+wx1,fy+wy1-h);
      rectangle(fx+wx,fy+wy1-h,fx+wx1-w,fy+wy1);

      ifsDrawSquareButton(ifs,wx,wy1-h,wx+w,wy1);
      ifsDrawSquareButton(ifs,wx+w,wy1-h,wx+2*w,wy1);
      ifsDrawSquareButton(ifs,wx1-2*w,wy1-h,wx1-w,wy1);

      ifsDrawSquareButton(ifs,wx1-w,wy,wx1,wy+h);
      ifsDrawSquareButton(ifs,wx1-w,wy+h,wx1,wy+2*h);
      ifsDrawSquareButton(ifs,wx1-w,wy1-2*h,wx1,wy1-h);

      if firsttime then
	 begin
	    DefineMouseClickArea(ifs,wx,wy1-h,wx+w,wy1,closeme);
	    DefineMouseClickArea(ifs,wx+w,wy1-h,wx+2*w,wy1,closeme);
	    DefineMouseClickArea(ifs,wx1-2*w,wy1-h,wx1-w,wy1,closeme);

	    DefineMouseClickArea(ifs,wx1-w,wy,wx1,wy+h,closeme);
	    DefineMouseClickArea(ifs,wx1-w,wy+h,wx1,wy+2*h,closeme);
	    DefineMouseClickArea(ifs,wx1-w,wy1-2*h,wx1,wy1-h,closeme);
	 end;

      wx  := 15;
      wy  := 50;
      wx1 := wx+48+324;
      wy1 := (fy1-fy)-(h+4+charheight+4);
      if wx1>(fx1-fx-30) then
	 wx1 := fx1-fx-30;


      setcolor(black);
      ifsaddinputline(ifs,wx,wy,wx1,wy+4+charheight,50,14,'Name    ',namestr,firsttime);

      wy  := wy+4+charheight+2;
      ifsaddinputline(ifs,wx,wy,wx1,wy+4+charheight,40,16,'Company ',Companystr,firsttime);

      wy  := wy+4+charheight+2;
      ifsaddinputline(ifs,wx,wy,wx1,wy+4+charheight,40,18,'Address ',Addressstr,firsttime);

      wy  := wy+4+charheight+2;
      tx  := wx+(wx1-wx) div 2;
      if wy<wy1 then
	 begin
	    ifsaddinputline(ifs,wx,wy,tx-2,wy+4+charheight,20,20,'City    ',citystr,firsttime);
	    ifsaddinputline(ifs,tx+2,wy,wx1,wy+4+charheight,20,22,'State ',statestr,firsttime);
	 end;

      wy  := wy+4+charheight+2;
      if wy<wy1 then
	 begin
	    ifsaddinputline(ifs,wx,wy,tx-2,wy+4+charheight,20,24,'Country ',countrystr,firsttime);
	    ifsaddinputline(ifs,tx+2,wy,wx1,wy+4+charheight,12,26,'Postal ',postalstr,firsttime);
	 end;

      wy  := wy+4+charheight+2;
      if wy<wy1 then
	 begin
	    ifsaddinputline(ifs,wx,wy,tx-2,wy+4+charheight,20,28,'Phone#  ',phonestr,firsttime);
	    ifsaddinputline(ifs,tx+2,wy,wx1,wy+4+charheight,20,30,'Fax# ',faxstr,firsttime);
	 end;

      wy  := wy+4+charheight+6;
      if wy<wy1 then
	 begin
	    outtextxy(fx+wx,fy+wy+2,'Upgrade:');

	    wy	:= wy+4+charheight;
	    if wy<wy1 then
	       begin
		  ifsaddradiobutton(ifs,wx+10,wy,wx1,wy+charheight,'Release 1.1 to 3.0 ($149)',
							  firsttime,upgradeproc);
		  toggleX(ifs,31,upgradesel=1);
	       end;

	    wy	:= wy+4+charheight;
	    if wy<wy1 then
	       begin
		  ifsaddradiobutton(ifs,wx+10,wy,wx1,wy+charheight,'Release 2.x to 3.0 ($89)',
							  firsttime,upgradeproc);
		  toggleX(ifs,32,upgradesel=2);
	       end;

	    wy	:= wy+4+charheight;
	    if wy<wy1 then
	       begin
		  ifsaddradiobutton(ifs,wx+10,wy,wx1,wy+charheight,'Release 2.x to Protected Mode 3.0 ($249)',
							  firsttime,upgradeproc);
		  toggleX(ifs,33,upgradesel=3);
	       end;
	 end;

      wy  := wy+4+charheight+6;
      if wy<wy1 then
	 begin
	    ifsDrawSquareButton(ifs,wx1-50,wy,wx1,wy+h);
	    shifttext(fx+wx1-50+6,fy+wy+2,white,black,'ORDER');

	    ifsDrawSquareButton(ifs,wx1-118,wy,wx1-60,wy+h);
	    shifttext(fx+wx1-118+6,fy+wy+2,white,black,'CANCEL');

	    if firsttime then
	       begin
		  DefineMouseClickArea(ifs,wx1-118,wy,wx1-60,wy+h,closeme);
		  addtablinks(ifs,ifs^.msptr,solidxorhighlight,solidxorhighlight,closeme);
		  DefineMouseClickArea(ifs,wx1-50,wy,wx1,wy+h,closeme);
		  addtablinks(ifs,ifs^.msptr,solidxorhighlight,solidxorhighlight,closeme);
	       end;
	 end;

      if firsttime then
	 activatetablinks(ifs,1)
      else
	 begin
	    ct := getactivetabnum(ifs);
	    settablink(ifs,ct);
	 end;
   end;

procedure RandomWindows(ifs:ImageStkPtr; ms: MsClickPtr);
   var x,y,x1,y1 : word;
   begin
      if visualsquarebuttonpress(ifs,ms) then
	 begin
	   releasesquarebutton(ifs,ms);

	   x  := random(getmaxx-200);
	   y  := random(getmaxy-140);
	   x1 := x+random(getmaxx-x-198)+196;
	   y1 := y+random(getmaxy-y-138)+136;

	   ifs := OpenFrame(x,y,x1,y1,MSWindowRedraw);
	 end;
   end;

procedure buttonredraw(ifs:ImageStkPtr; ms: MsClickPtr);
   var x,y,x1,y1,c,h : word;
   begin
      ResetMouseClicks(ifs);
      bevelbox(ifs^.x,ifs^.y,ifs^.x1,ifs^.y1,white,darkgray,lightgray,5);

      x1 := ifs^.x1-ifs^.x;
      y1 := ifs^.y1-ifs^.y;

      h := textheight('A')+4;
      c := ord('A');
      x  := 10;
      while x+30+5+5<x1 do
	 begin
	    y := 10;
	    while y+h+5+5<y1 do
	       begin
		  DefineSquareButtonText(ifs,x,y,x+30,y+h,5,3,chr(c)+':',randomwindows);
		  inc(y,h+2);
		  inc(c);
		  if c>ord('Z') then
		     c := ord('a');
	       end;
	    inc(x,32);
	 end;
   end;

begin
   gd := VGA;
   gm := VGAhi;

   InitGraph(Gd, Gm, '');
   if graphresult<>0 then
      halt(1);

   InitIntrpts;

   TEGLMain_ExitSave := ExitProc;
   ExitProc := @TEGLMain_TerminateExit;


   om1 := createoptionmenu;
   defineoptions(om1,' Open  ',true,menuacknowledge);
   defineoptions(om1,' Close ',true,menuacknowledge);
   defineoptions(om1,'-',false,menuacknowledge);
   defineoptions(om1,' Folder ',false,menuacknowledge);
   defineoptions(om1,' File ',true,menuacknowledge);

   om2 := createoptionmenu;
   defineoptions(om2,' Sound ',true,menuacknowledge);
   defineoptions(om2,' Mouse Sense ',true,menuacknowledge);
   defineoptions(om2,'-',false,menuacknowledge);
   defineoptions(om2,' Font Select ',true,menuacknowledge);


   mfs := OpenFrame(100,100,345,188,buttonredraw);

   TEGLSupervisor;
END.
