{------------------------------------------------------------------------------}
{		    Concepts from the TEGL Windows Toolkit		       }
{		   Copyright (C) 1992, TEGL Systems Corporation 	       }
{			     All Rights Reserved.			       }
{------------------------------------------------------------------------------}
{$I switches.inc}

Unit frames;

Interface

Uses crt, fgraph, msmouse, intrpts;

type
   MsClickPtr  = ^MSClickStk;
   ImageStkPtr = ^ImageStack;
   KeyClickPtr = ^KeyClickStk;

   Callproc    = procedure(FS:ImageStkPtr; MS: MsClickPtr);
   Dataproc    = procedure(FS:ImageStkPtr; Userkey:word; Var DataArea);

   UserRecPtr = ^UserRecord;
   UserRecord = Record
	NxtUserPtr     : UserRecPtr;	{user data area chains}
	UserKey        : word;		{user assigned key for retrieving data}
	UserDataArea   : pointer;	{pointer to userdata}
	UserTerminate  : dataproc;	{terminating call event}
		end;

   KeyClickStk = RECORD
	nextkeyclick   : Keyclickptr;	{chain of keyboard click areas}
	keycode        : Word;		{scancode for capturing}
	entrycallproc  : callproc;	{event for scancode activation}
	fs	       : ImageStkPtr;	{related fs/ms for event}
	ms	       : MsClickPtr;
		 END;

   MSClickStk = RECORD
	nextmsclick    : MsClickPtr;	{mouse click chains}
	x,y,x1,y1      : integer;	{mouse x,y,x1,y1 region}
	entrycallproc  : callproc;	{normal mouse click call event}
	ClickNumber    : Word;		{assignable key for mouse click}
		END;

   ImageStack = RECORD
	nxtptr	       : ImageStkPtr;	{forward chain of Frames}
	lstptr	       : ImageStkPtr;	{backward chain of Frames}
	x,y,x1,y1      : Word;		{frame coordinates}
	redrawcallproc : callproc;
	firsttime      : boolean;
	MsPtr	       : MsClickPtr;	{ms chain for mouse click areas}
	keyPtr	       : KeyClickPtr;	{key chain for local keyclicks}
	UserDataPtr    : UserRecPtr;	{user data chain}
	MsClickCount   : Word;		{ms clicks counts}
		END;

const
   StackPtr	   : ImageStkPtr = NIL;
   pendactive	   : ImageStkPtr = NIL;
   FunctionKeyCode : Word = 0;			{last TEGLKeypress}

var
   pendcallproc    : callproc;

function  OpenFrame(x,y,x1,y1 : Word;  RedrawCallProc:callproc) : imagestkptr;
Procedure CloseFrame(ifs:imagestkptr);
Procedure DefineMouseClickArea(fs:ImageStkPtr; x,y,x1,y1:Word; EntryCallProc:callproc);
Procedure ResetMouseClicks(ifs:ImageStkPtr);
Procedure ResetLocalKeyClicks(ifs:ImageStkPtr);
Function  findms(fs:ImageStkPtr; mxpos,mypos:Word):MsClickPtr;
Function  Findfs(mxpos,mypos : Word) : ImageStkPtr;
function  FramesOverlapped(fs1:imagestkptr; ax,ay,ax1,ay1:word) : boolean;
procedure RotateTop(ifs:imagestkptr);
procedure restorebackimage(ifs:imagestkptr);
function  coveredabove(ifs:imagestkptr) : boolean;

procedure CallUserDataTerminate(fs:imagestkptr);
Procedure SetUserDataArea(fs:ImageStkPtr; Userkey:word; Var Userdata; TerminateDataProc:dataproc);
Procedure GetUserDataArea(fs:imagestkptr; Userkey:word; Var Userdata);

Procedure DefineLocalKeyClickArea(fs:ImageStkPtr; ms:MsClickPtr; Keycode:Word; EntryCallProc:callproc);
Function  FindlocalKeyClickPtr(fs:ImageStkPtr; Keycode:Word) : KeyClickPtr;
Procedure DropKeyClick(fs:ImageStkPtr; Keycode:Word; EntryCallProc:callproc);

procedure setpendingevent(fs:imagestkptr; entrycallproc:callproc);
procedure setpendingoff;

Function FrameExist(fs:ImageStkPtr) : Boolean;

procedure nildataproc(ifs:ImageStkPtr; Userkey:word; Var DataArea);
procedure nilunitproc(ifs:ImageStkPtr; ms: MsClickPtr);
Procedure ReSizeFrame(ifs:ImageStkPtr; x,y,x1,y1:Word);

Function getms(fs:ImageStkPtr; Clicknumber:Word) : MsClickPtr;

procedure TEGLSupervisor;

implementation

const
   BIOS_Data	 = $40;

var
   keybuffer	 : word absolute BIOS_Data : $001a;

procedure nildataproc(ifs:ImageStkPtr; Userkey:word; Var DataArea);
   begin
   end;

procedure nilunitproc(ifs:ImageStkPtr; ms: MsClickPtr);
   begin
   end;

Function FrameExist(fs:ImageStkPtr) : Boolean;
   VAR lfs    : ImageStkPtr;
   BEGIN
      lfs := StackPtr;
      WHILE (lfs<>NIL) and (lfs<>fs) DO
	 lfs := lfs^.lstptr;

      FrameExist := (lfs=fs) and (fs<>nil);
   END;

Procedure DefineLocalKeyClickArea(fs:ImageStkPtr; ms:MsClickPtr; Keycode:Word; EntryCallProc:callproc);
   VAR nkeyptr,lstkey,nxtkey : KeyClickPtr;
   BEGIN
      lstkey := NIL;
      nxtkey := fs^.keyptr;
      WHILE (nxtkey<>NIL) and (nxtkey^.keycode>keycode) DO
	 BEGIN
	    lstkey := nxtkey;
	    nxtkey := nxtkey^.nextkeyclick;
	 END;

      getmem(nkeyptr,sizeof(keyclickstk));

      nkeyptr^.nextkeyclick   := nxtkey;
      nkeyptr^.keycode	      := Keycode;
      nkeyptr^.entrycallproc  := entrycallproc;
      nkeyptr^.fs	      := fs;
      nkeyptr^.ms	      := ms;

      IF lstkey=NIL THEN
	 fs^.KeyPtr  := nkeyptr
      ELSE
	 lstkey^.NextKeyClick := nkeyptr;
   END;

Function FindlocalKeyClickPtr(fs:ImageStkPtr; Keycode:Word) : KeyClickPtr;
   VAR nextkeyclick : KeyClickPtr;
   BEGIN
      nextkeyclick := NIL;

      {search through the Local keyclick stack}
      IF fs<>NIL THEN
	 BEGIN
	    nextkeyclick := fs^.KeyPtr;
	    WHILE (nextkeyclick<>NIL) and (NextKeyclick^.Keycode<>Keycode) DO
	       nextKeyclick := nextKeyclick^.nextKeyclick;
	 END;

      FindlocalKeyClickPtr := nextKeyclick;
   END;

Procedure DropKeyClick(fs:ImageStkPtr; Keycode:Word; EntryCallProc:callproc);
   VAR NextKeyClick,LastKeyClick : KeyClickPtr;
   BEGIN
      lastkeyclick := NIL;
      NextKeyClick := fs^.KeyPtr;
      WHILE (NextKeyClick<>NIL) and
	    (NextKeyClick^.Keycode<>Keycode) and
	    (@NextKeyClick^.EntryCallProc<>@EntryCallProc) DO
	 BEGIN
	    LastKeyClick := NextKeyClick;
	    NextKeyClick := NextKeyClick^.NextKeyClick;
	 END;

      IF NextKeyClick<>NIL THEN
	 BEGIN
	     IF lastkeyclick=NIL THEN
		fs^.KeyPtr := NextKeyClick^.NextKeyClick
	     ELSE
		LastKeyClick^.NextKeyClick := NextKeyClick^.NextKeyClick;

	     freemem(NextKeyClick,sizeof(KeyClickStk));
	 END;
   END;

Procedure ResetLocalKeyClicks(ifs:ImageStkPtr);
   VAR NextKeyClick : KeyClickPtr;
   begin
      WHILE ifs^.KeyPtr<>NIL DO
	  BEGIN
	     NextKeyClick := ifs^.KeyPtr;
	     ifs^.KeyPtr   := NextKeyClick^.NextKeyClick;
	     freemem(NextKeyClick,sizeof(KeyClickStk));
	  END;
   end;

procedure CallUserDataTerminate(fs:imagestkptr);
   var UD,LUD : UserRecPtr;
   begin
      UD := fs^.userdataptr;
      fs^.UserDataPtr := nil;	{just in case we get recursive}

      while (UD<>nil) do
	 begin
	    UD^.UserTerminate(fs,UD^.userkey,UD^.UserDataArea);
	    LUD := UD;
	    UD := UD^.nxtuserptr;
	    freemem(LUD,sizeof(LUD^));
	 end;
   end;

Procedure SetUserDataArea(fs:ImageStkPtr; Userkey:word; Var Userdata; TerminateDataProc:dataproc);
   var UD : UserRecPtr;
       DT : pointer absolute Userdata;
   BEGIN
      getmem(UD,sizeof(UD^));

      UD^.nxtuserptr := fs^.userdataptr;
      fs^.userdataptr	 := UD;
      UD^.UserKey	 := Userkey;
      UD^.UserDataArea	 := DT;
      UD^.UserTerminate  := TerminateDataProc;
   END;

Procedure GetUserDataArea(fs:imagestkptr; Userkey:word; Var Userdata);
   var pt  : pointer absolute Userdata;
       UD  : UserRecPtr;
   BEGIN
      UD  := fs^.userdataptr;

      while (UD<>nil) and (UD^.userkey<>userkey) do
	 UD := UD^.nxtuserptr;

      if UD=nil then
	 pt := UD
      else
	 pt := UD^.UserDataArea;
   END;

Procedure iLinkFS(nfs,cfs:ImageStkPtr);
   BEGIN
      nfs^.lstptr := cfs;

      IF cfs<>NIL THEN
	 BEGIN
	    nfs^.nxtptr := cfs^.nxtptr;
	    cfs^.nxtptr := nfs;
	 END
      ELSE
	 nfs^.nxtptr := NIL;

      IF nfs^.nxtptr<>NIL THEN
	 nfs^.nxtptr^.lstptr := nfs;

      If StackPtr=cfs then {we are linking at stackptr}
	 StackPtr:=nfs;
   END;

Procedure iUnLinkFS(fs:ImageStkPtr);
   BEGIN
      IF StackPtr=fs THEN
	 StackPtr:=fs^.lstptr;

      {disconnect Frame}
      IF fs^.lstptr <> NIL THEN
	  fs^.lstptr^.nxtptr := fs^.nxtptr;

      IF fs^.nxtptr <> NIL THEN
	  fs^.nxtptr^.lstptr := fs^.lstptr;
   END;

Function OverLapArea(ax,ay,ax1,ay1,bx,by,bx1,by1 : Word; VAR cx,cy,cx1,cy1 : Word) : Boolean;
   Function Overlap(ax1,ax2,bx1,bx2 : Word;VAR nx1,nx2 : Word) : Boolean;
      Procedure switch(VAR i,j : Word);
	 VAR k : Integer;
	 BEGIN
	    k := i;
	    i := j;
	    j := k;
	 END;
      BEGIN
	 IF bx1<ax1 THEN
	    BEGIN
	       switch(ax1,bx1);
	       switch(ax2,bx2);
	    END;

	 nx1 := bx1;
	 nx2 := ax2;
	 IF ax2>bx2 THEN
	    nx2 := bx2;

	 IF ax2<bx1 THEN
	    Overlap := FALSE
	 ELSE
	    Overlap := TRUE;
      END;
   BEGIN
      OverLapArea := Overlap(ax,ax1,bx,bx1,cx,cx1) and Overlap(ay,ay1,by,by1,cy,cy1);
   END;

function FramesOverlapped(fs1:imagestkptr; ax,ay,ax1,ay1:word) : boolean;
   var x,y,x1,y1 : word;
   begin
      FramesOverlapped := OverlapArea(fs1^.x,fs1^.y,fs1^.x1,fs1^.y1,
				      ax,ay,ax1,ay1,x,y,x1,y1);
   end;

{ checks if fs1 completely covers the ax,ay,ax1,ay1 coordinates }
function FramesCovered(fs1:imagestkptr; ax,ay,ax1,ay1:word) : boolean;
   var x,y,x1,y1 : word;
       covered	 : boolean;
   begin
      covered := false;

      if OverlapArea(fs1^.x,fs1^.y,fs1^.x1,fs1^.y1,
		     ax,ay,ax1,ay1,x,y,x1,y1) then
	 if ((ax=x) and (ay=y) and (ax1=x1) and (ay1=y1)) then
	    covered := true;

      framescovered := covered;
   end;

Function findms(fs:ImageStkPtr; mxpos,mypos:Word):MsClickPtr;
   VAR i : MsClickPtr;
   BEGIN
      i := fs^.MSPtr;
      WHILE (i<>NIL) and
	     ((mxpos < fs^.x+i^.x) or
	     (mxpos > fs^.x+i^.x1) or
	     (mypos < fs^.y+i^.y) or
	     (mypos > fs^.y+i^.y1)) DO
	     i := i^.NextMSClick;

      findms := i;
   END;

function OpenFrame(x,y,x1,y1 : Word;  RedrawCallProc:callproc) : imagestkptr;
   VAR IFS : ImageStkPtr;
   BEGIN
      GetMem(IFS,sizeof(imagestack));
      ifs^.x		  := x;
      ifs^.y		  := y;
      ifs^.x1		  := x1;
      ifs^.y1		  := y1;
      ifs^.redrawcallproc := redrawcallproc;
      ifs^.msptr	  := nil;
      ifs^.userdataptr	  := nil;
      ifs^.firsttime	  := true;
      ifs^.keyptr	  := nil;
      ifs^.msclickcount   := 0;

      ilinkfs(ifs,stackptr);
      hidemouse;
      redrawcallproc(ifs,nil);
      ifs^.firsttime	  := false;
      showmouse;

      OpenFrame := ifs;
   END;

Procedure DefineMouseClickArea(fs:ImageStkPtr; x,y,x1,y1:Word; EntryCallProc:callproc);
   VAR nmsptr : MsClickPtr;
   BEGIN
      inc(fs^.MSClickCount);

      getmem(nmsptr,sizeof(MSClickStk));
      nmsptr^.nextmsclick   := fs^.msptr;
      nmsptr^.x 	    := x;
      nmsptr^.y 	    := y;
      nmsptr^.x1	    := x1;
      nmsptr^.y1	    := y1;
      nmsptr^.ClickNumber   := fs^.MSClickCount;

      nmsptr^.EntryCallProc := EntryCallProc;
      fs^.msptr 	    := nmsptr;
   END;

Function getms(fs:ImageStkPtr; Clicknumber:Word) : MsClickPtr;
   VAR nxtms : MsClickPtr;
   BEGIN
      nxtms := fs^.msPtr;
      WHILE (nxtms<>NIL) and (nxtms^.Clicknumber<>ClickNumber) DO
	  nxtms := nxtms^.nextmsclick;
      getms := nxtms;
   END;

Function Findfs(mxpos,mypos : Word) : ImageStkPtr;
   VAR i : ImageStkPtr;
   BEGIN
      i := StackPtr;
      WHILE (i<>NIL) and
	    not ((mxpos >= i^.x) and (mxpos <= i^.x1) and
		 (mypos >= i^.y) and (mypos <= i^.y1)) do
	    i := i^.lstptr;

      Findfs := i
   END;

function GetFSMS(var fs:imagestkptr; var ms:msclickptr) : word;
   var Mouse_Xcoord, Mouse_Ycoord, Mouse_buttons : word;
   begin
      Mouse_buttons := MousePosition(Mouse_Xcoord,Mouse_Ycoord);

      fs := Findfs(Mouse_Xcoord,Mouse_Ycoord);
      ms := NIL;
      IF (fs<>NIL) then
	 ms := findms(fs,Mouse_Xcoord,Mouse_Ycoord);

      GetFSMS := Mouse_buttons;
   end;

Procedure ResetMouseClicks(ifs:ImageStkPtr);
   VAR ms,lms : MsClickPtr;
   begin
      ms := ifs^.MSPtr;
      WHILE (ms<>NIL) do
	 begin
	     lms := ms;
	     ms := ms^.NextMSClick;
	     freemem(lms,sizeof(MSClickStk));
	 end;
      ifs^.msptr := nil;
      ifs^.MsClickCount := 0;
   end;


{ checks if any frames above ifs completely covers ifs }
function coveredabove(ifs:imagestkptr) : boolean;
   var nfs     : imagestkptr;
       covered : boolean;
   begin
      nfs := ifs^.nxtptr;
      covered := false;
      while (nfs<>nil) and not covered do
	 begin
	    if (nfs<>ifs) and framescovered(nfs,ifs^.x,ifs^.y,ifs^.x1,ifs^.y1) then
	       covered := true;
	    nfs := nfs^.nxtptr;
	 end;
      coveredabove := covered;
   end;

procedure restorebackimage(ifs:imagestkptr);
   var nfs     : imagestkptr;
       covered : boolean;
   begin
      nfs := stackptr;
      while (nfs<>nil) and (nfs^.lstptr<>nil) do
	 nfs := nfs^.lstptr;

      covered := false;
      while (nfs<>nil) and not covered do
	 begin
	    if (nfs<>ifs) and framescovered(nfs,ifs^.x,ifs^.y,ifs^.x1,ifs^.y1) then
	       covered := true;
	    nfs := nfs^.nxtptr;
	 end;

      setfillstyle(solidfill,black);
      if not covered then
	 bar(ifs^.x,ifs^.y,ifs^.x1,ifs^.y1);
   end;

Procedure CloseFrame(ifs:imagestkptr);
   var nfs     : imagestkptr;
       covered : boolean;
   BEGIN
      (* call background draw with coordinates *)
      (* putimage(ifs^.x,ifs^.y,ifs^.imagesave^,NormalPut); *)

      hidemouse;

      if (pendactive<>nil) and (ifs=pendactive) then
	 pendactive := nil;

      restorebackimage(ifs);

      iunlinkfs(ifs);

      nfs := stackptr;
      covered := false;
      while (nfs<>nil) and (nfs^.lstptr<>nil) and not covered do
	 begin
	    if (nfs<>ifs) and framescovered(nfs,ifs^.x,ifs^.y,ifs^.x1,ifs^.y1) then
	       covered := true
	    else
	       nfs := nfs^.lstptr;
	 end;

      while (nfs<>nil) do
	 begin
	    if framesoverlapped(nfs,ifs^.x,ifs^.y,ifs^.x1,ifs^.y1) and
	       not coveredabove(nfs) then
	       nfs^.Redrawcallproc(nfs,nil);

	    nfs := nfs^.nxtptr;
	 end;
      showmouse;

      Resetmouseclicks(ifs);
      ResetLocalKeyClicks(ifs);
      CallUserDataTerminate(ifs);
      freeMem(IFS,sizeof(imagestack));
   END;

Procedure ReSizeFrame(ifs:ImageStkPtr; x,y,x1,y1:Word);
   var nfs     : imagestkptr;
       covered : boolean;
       ax,ay,ax1,ay1 : word;
   BEGIN
      rotatetop(ifs);

      ax  := ifs^.x;
      ay  := ifs^.y;
      ax1 := ifs^.x1;
      ay1 := ifs^.y1;

      if (x<>0) or (y<>0) or (x1<>getmaxx) or (y1<>getmaxy) then
	 begin
	    hidemouse;
	    restorebackimage(ifs);

	    ifs^.x  := x;
	    ifs^.y  := y;
	    ifs^.x1 := x1;
	    ifs^.y1 := y1;

	    nfs := stackptr;
	    while (nfs<>nil) and (nfs^.lstptr<>nil) do
	       nfs := nfs^.lstptr;

	    while (nfs<>nil) do
	       begin
		  if (nfs<>ifs) and
		     framesoverlapped(nfs,ax,ay,ax1,ay1) and
		     not coveredabove(nfs) then
		     nfs^.Redrawcallproc(nfs,nil);

		  nfs := nfs^.nxtptr;
	       end;
	    showmouse;
	 end;

      ifs^.x  := x;
      ifs^.y  := y;
      ifs^.x1 := x1;
      ifs^.y1 := y1;


      ResetMouseClicks(ifs);
      ResetLocalKeyClicks(ifs);
      CallUserDataTerminate(ifs);

      hidemouse;
      ifs^.firsttime	   := true;
      ifs^.redrawcallproc(ifs,nil);
      ifs^.firsttime	   := false;
      showmouse;
   END;


procedure RotateTop(ifs:imagestkptr);
   begin
      if ifs<>stackptr then
	 begin
	    iunlinkfs(ifs);
	    ilinkfs(ifs,stackptr);
	    hidemouse;
	    ifs^.Redrawcallproc(ifs,nil);
	    showmouse;
	 end;
   end;

function peekatkeys : word;
   var keyboardptr : pointer;
       keyword	   : word;
   begin
      keyboardptr := ptr(BIOS_DATA,keybuffer);
      keyword := byte(keyboardptr^);
      if keyword=0 then
	 begin
	    keyboardptr := ptr(BIOS_DATA,keybuffer+1);
	    keyword := byte(keyboardptr^);
	    keyword := keyword shl 8;
	 end;

      peekatkeys := keyword;
   end;

function fetchkeys : word;
   var keyword	   : word;
   begin
      keyword := ord(readkey);
      if keyword=0 then
	 begin
	    keyword := ord(readkey);
	    keyword := keyword shl 8;
	 end;

      fetchkeys := keyword;
   end;

Procedure ClearKeyBoardBuf;
   VAR ch : Char;
   BEGIN
      WHILE keypressed DO ch := readkey;
   END;

procedure setpendingevent(fs:imagestkptr; entrycallproc:callproc);
   begin
      pendactive := fs;
      pendcallproc := entrycallproc;
   end;

procedure setpendingoff;
   begin
      pendactive := nil;
   end;

procedure TEGLSupervisor;
   VAR stat : Word;
       fs   : imagestkptr;
       ms   : msclickptr;
       EventKeyPressed	: boolean;
       KeyClickPos  : KeyClickPtr;
   BEGIN
      ShowMouse;
      repeat
	 stat := GetFSMS(fs,ms);

	 checkblink;  {use flag to blink text cursor}

	 EventKeypressed := Keypressed;

	 IF EventKeyPressed THEN
	    BEGIN
	       FunctionKeyCode := Peekatkeys;
	       KeyClickPos := FindLocalKeyClickPtr(Stackptr,functionkeycode);
	       if (keyclickpos<>nil) then
		  FunctionKeyCode := Fetchkeys
	       else
		  KeyClickPos := FindLocalKeyClickPtr(Stackptr,0);

	       IF (KeyClickPos<>NIL) then
		  begin
		     fs := keyclickpos^.fs;
		     ms := keyclickpos^.ms;
		  end
	       else
		  begin
		     clearKeyboardbuf;
		     Eventkeypressed := false;
		     FunctionKeyCode := 0;
		  end
	    end;

	 {simplified version of pending active. Pending events are
	  usually events like closing the menu frame whenever the user
	  clicks on an empty screen area}
	 if ((stat<>0) or (EventKeyPressed)) and (pendactive<>nil) then
	    pendcallproc(fs,ms);

	 IF EventKeyPressed THEN
	    BEGIN
	       IF KeyClickPos<>NIL THEN
		  KeyClickpos^.entrycallproc(fs,ms);
	       clearkeyboardbuf;
	       FunctionKeyCode := 0;
	    END
	 else
	 IF (fs<>NIL) and (stat<>0) then
	    begin
	       rotatetop(fs);
	       if (ms<>NIL) then
		  ms^.entrycallproc(fs,ms);
	    end;


      until false;
   END;

end.
