{------------------------------------------------------------------------------}
{		    Concepts from the TEGL Windows Toolkit		       }
{		   Copyright (C) 1990,1992 TEGL Systems Corporation 	       }
{			     All Rights Reserved.			       }
{------------------------------------------------------------------------------}
{$I switches.inc}

Unit Movewin;

Interface

Uses frames,msmouse,fgraph;

Procedure MoveFrame(VAR fx,fy,fx1,fy1 : Integer; rx,ry,rx1,ry1: Integer);
Procedure MoveStackImage(ifs:ImageStkPtr; x,y : Word);
procedure FrameMove(ifs:ImageStkPtr; ms: MsClickPtr);

implementation

Procedure MoveStackImage(ifs:ImageStkPtr; x,y : Word);
   var cx,cy : word;
       nfs   : imagestkptr;
       ox,oy : word;
   begin
      IF (ifs^.x<>x) or
	 (ifs^.y<>y) THEN
	 BEGIN
	    hidemouse;
	    restorebackimage(ifs);
{	    setfillstyle(solidfill,black);
	    bar(ifs^.x,ifs^.y,ifs^.x1,ifs^.y1); }

	    ox := ifs^.x;
	    oy := ifs^.y;
	    cx := ifs^.x1-ifs^.x;
	    cy := ifs^.y1-ifs^.y;

	    ifs^.x  := x;
	    ifs^.y  := y;
	    ifs^.x1 := x+cx;
	    ifs^.y1 := y+cy;

	    nfs := stackptr;
	    while (nfs<>nil) and (nfs^.lstptr<>nil) do
	       nfs := nfs^.lstptr;

	    while (nfs<>nil) do
	       begin
		  if (nfs=ifs) or ((nfs<>ifs) and
		      framesoverlapped(nfs,ox,oy,ox+cx,oy+cy) and
		      not coveredabove(nfs)) then
		     nfs^.Redrawcallproc(nfs,nil);

		  nfs := nfs^.nxtptr;
	       end;
	    showmouse;
	 end;
   end;

Procedure MoveFrame(VAR fx,fy,fx1,fy1 : Integer; rx,ry,rx1,ry1: Integer);
   VAR mx,my	     : Integer;
       fxs,fys	     : Integer;
       stat	     : Word;
       mxpos,mypos   : Word;
       nx,ny,nx1,ny1 : Word;
       lastcolor     : Word;
   BEGIN
      lastcolor := getcolor;
      setwritemode(xorput);
      setcolor(7);

      fxs := fx1-fx;
      fys := fy1-fy;

      Stat := MousePosition(mxpos,mypos);

      nx := fx;
      ny := fy;
      nx1 := fx+fxs;
      ny1 := fy+fys;

      hidemouse;
      rectangle(nx,ny,nx1,ny1); 	{box image is on}
      showmouse;

      mx := mxpos-fx;
      my := mypos-fy;

      repeat
	 Stat := MousePosition(mxpos,mypos);
	 fx := mxpos-mx;
	 fy := mypos-my;

	 IF fy<ry THEN
	    fy := ry
	 ELSE
	 IF fy+fys>ry1 THEN
	    fy := ry1-fys;

	 IF fx<rx THEN
	    fx := rx
	 ELSE
	 IF fx+fxs>rx1 THEN
	    fx := rx1-fxs;

	IF (nx<>fx) or (ny<>fy) THEN
	   BEGIN
	      hidemouse;
	      rectangle(nx,ny,nx1,ny1); 	{box image is off}

	      nx := fx;
	      ny := fy;
	      nx1 := fx+fxs;
	      ny1 := fy+fys;
	      rectangle(nx,ny,nx1,ny1); 	{box image is on}
	      showmouse;
	   END;

      until stat=0;

      hidemouse;
      rectangle(nx,ny,nx1,ny1); 	{box image is off}
      showmouse;

      setwritemode(copyput);
      setcolor(lastcolor);

      fx1 := fx+fxs;
      fy1 := fy+fys;
 END;

procedure FrameMove(ifs:ImageStkPtr; ms: MsClickPtr);
   VAR x,y,x1,y1 : Integer;
   BEGIN
      rotatetop(ifs);

      x  := ifs^.x;
      y  := ifs^.y;
      x1 := ifs^.x1;
      y1 := ifs^.y1;

      moveframe(x,y,x1,y1,0,0,getmaxx,getmaxy);
      MoveStackImage(ifs,x,y);
   END;

end.
