{ == RECOL3.PAS ===============================================================

  Utility program to convert color exception files from GR_COL2G.PAS into a
  set of Turbo source statements to build the XorColConv exception table.

  This was a "bootstrap" process in that an initial exception table was built
  and "adjusted" visually by examining the output colors to determine which
  "standard" VGA colors went with which XOR "exception" colors.

  See the documentation of XorColConv in GR_CON2G.PAS for an explanation of
  the techniques used.

  Written by Jerry Rivers. Last modified: 04/16/93

  ============================================================================= }

program ReCol;
  uses
    Crt;

  var
    BkCol : integer;
    Col : integer;
    I, J: integer;
    New : text;
    New2: text;
    S   : string;
    RGB : longint;
    Txt : text;
    Txt2: text;

  begin
    assign( Txt, 'coltxt.txt' );
    reset( Txt );
    assign( New, 'coltxt.new' );
    rewrite( New );

    assign( Txt2, 'col.txt' );
    reset ( Txt2 );
    assign( New2, 'col.new' );
    rewrite( New2 );
    {
      Read from one of the color diagnostic files, convert to TP statements
      for the color exception table
    }
    I := 1; J := 1;
    while not eof( Txt2 ) do
      begin
        readln( Txt,  S );
        readln( Txt2, BkCol, RGB, Col );
        {
          Only create an exception entry for colors which do not have a
          standard VGA XOR output. These are identified in the 'coltxt.txt'
          file with FALSE at the beginning of each line
        }
        if pos( 'FALSE', S ) <> 0 then
          begin
            writeln( New,  S );

            writeln( New2, 'RGB[', J:2, '] := ', RGB:7, ';  ',
                           'Col[', J:2, '] := ', Col:2, ';'    );
            writeln( I, ': ', S );
            inc( J );
          end;
        inc( I );
      end;

    close( Txt );
    close( New );
    close( Txt2 );
    close( New2 );

    writeln;
    write( 'Press RETURN to quit ');
    readln;

  end.