{ == GR_DEMO1.PAS =============================================================

  Demo program to illustrate some of the uses of the XorColConv procedure.
  XorColConv is fully documented in the file GR_COL2G.PAS. Comments are removed
  here to save space.

  Written by Jerry Rivers. Last modified: 04/16/93

  ============================================================================= }

PROGRAM Gr_Demonstration;

  uses Graph, Crt;
  const
    ColNam : array[0..15] of string[12] = (
              'Black',    'Blue',         'Green',      'Cyan',
              'Red',      'Magenta',      'Brown',      'LtGray',
              'DarkGray', 'LtBlue',       'LtGreen',    'LtCyan',
              'LtRed',    'LtMagenta',    'Yellow',     'White' );

  var
    Ch              : char;
    ColorBack,
    ColorIn,
    ColorOut        : integer;
    ColorTest       : longint;
    Driver          : integer;
    Escape          : boolean;
    GRreturn        : integer;
    I               : integer;
    Mode            : integer;
    Str             : string;

{ == XorColConv ===============================================================

  Calculates color resulting from background XOR foreground in graphics

  Written by Jerry Rivers. Last modified: 04/16/93

  ============================================================================= }

PROCEDURE XorColConv( ColBkGnd, ColSet : integer; var ColResult : integer );
  const
    ColVal : array[0..15] of longint = (
                    0,         42,          10752,        10794,
              2752512,    2752554,        2757888,      2763306,
              1381653,    1381695,        1392405,      1392447,
              4134168,    4134207,        4144917,      4144959 );
  var
    Color1, Color2, Color3 : longint;
    I                      : byte;
    OK                     : boolean;
    RGB                    : array[1..30] of longint;        { RGB exceptions }
    Col                    : array[1..30] of integer;  { corresponding colors }
  begin
    {
      Initialize the Color exception tables
    }
    RGB[ 1] := 2757930;  Col[ 1] :=  7;
    RGB[ 2] := 2763264;  Col[ 2] :=  6;
    RGB[ 3] := 4134194;  Col[ 3] := 13;
    RGB[ 4] := 4134165;  Col[ 4] := 12;
    RGB[ 5] := 2768640;  Col[ 5] :=  4;
    RGB[ 6] := 4144920;  Col[ 6] := 14;
    RGB[ 7] := 2768682;  Col[ 7] :=  5;
    RGB[ 8] := 4144946;  Col[ 8] := 15;
    RGB[ 9] :=    5376;  Col[ 9] :=  2;
    RGB[10] := 1381656;  Col[10] :=  8;
    RGB[11] :=    5418;  Col[11] :=  3;
    RGB[12] := 1381682;  Col[12] :=  9;
    RGB[13] :=   16170;  Col[13] :=  1;
    RGB[14] := 4128789;  Col[14] := 14;
    RGB[15] := 4128831;  Col[15] := 15;
    RGB[16] := 4139541;  Col[16] := 12;
    RGB[17] := 4139583;  Col[17] := 13;
    RGB[18] := 1376280;  Col[18] := 10;
    RGB[19] := 1376319;  Col[19] := 11;
    RGB[20] := 1387029;  Col[20] :=  8;
    RGB[21] := 1387071;  Col[21] :=  9;
    RGB[22] := 1392434;  Col[22] := 11;
    RGB[23] := 2752525;  Col[23] :=  4;
    RGB[24] := 2752551;  Col[24] :=  5;
    RGB[25] := 2763277;  Col[25] :=  6;
    RGB[26] := 2763303;  Col[26] :=  7;
    RGB[27] :=      39;  Col[27] :=  1;
    RGB[28] :=   10765;  Col[28] :=  2;
    RGB[29] :=   10791;  Col[29] :=  3;
    {
      Get long integer RGB color numbers for background and "desired" color
    }
    Color1 := ColVal[ ColBkGnd ];
    Color2 := ColVal[ ColSet ];
    Color3 := Color1 XOR Color2;
    {
      If the XOR color matches a "standard" VGA color, you're done!
    }
    I := 0; OK := false;
    repeat
      if Color3 = ColVal[ I ] then
        begin
          ColResult := I;                 { return corresponding color number }
          OK := true;                                     { signal OK to quit }
        end;
        inc( I );
    until ( I > White );
    {
      If the XOR color isn't "standard", look at the "exception" list

      This list was built by checking all the Color3's that aren't
      "standard" and visually identifying the matching color

      A 29-long look-up table may not be the most efficient, but it works!
    }
    if not OK then begin
        I := 1;
        repeat
          if Color3 = RGB[ I ] then
            begin
              ColResult := Col[ I ];      { return corresponding color number }
              OK := true;                                 { signal OK to quit }
            end;
          inc( I ) ;
        until OK or ( I > 29 );
      end;
    {
      If the bell rings, a color slipped thru the exception table;
      This should never happen
    }
    if not OK then writeln( chr(7) );

  end; { XorColConv }

  BEGIN  { --- Main Program --- }
    {
      This program assumes you are running standard VGA 16-color graphics
      If you're not, an error will result and the program will stop
    }
    Driver := VGA;
    Mode   := VGAhi;

    InitGraph(Driver, Mode, '');

    GRreturn := GraphResult;
    if GRreturn <> 0 then begin
        writeln( 'Couldn''t start Scene-may be graphics or video problem' );
        writeln( GraphErrorMsg( GRreturn ) );
        halt;
      end;
    {
      Turn direct video off so standard writeln works in graphics
    }
    DirectVideo := false;

    ColorBack := Magenta;
    {
      Set background to arbitray color
    }
    SetFillStyle( SolidFill, ColorBack );
    Bar( 0, 0, 639, 479 );

    Str := 'This string will be written then erased one character at a time';
    {
      Set "desired" foreground color as "color in"
    }
    XorColConv( ColorBack, Yellow, ColorOut );
    {
      "color out" is the XOR inverse of the "desired" color, so setting
      TextColor to ColorOut will XOR back onto the graphics screen in
      the original "desired" color (ColorIn)

      Confusing, but it works!
    }
    TextColor( ColorOut + 128 );

    gotoXY( 5, 15);
    writeln( Str );
    delay(1500);
    {
      Erase by re-writing text, one character at a time. Since this is an
      XOR write, the string will be erased
    }
    gotoXY( 5, 15 );
    for I := 1 to length( Str ) do
      begin
        write( Str[I] );
        delay( 100 );
      end;
    {
      Now, write the string again, this time in LightRed color
    }
    delay(300);
    XorColConv( ColorBack, LightRed, ColorOut );
    TextColor( ColorOut + 128 );
    {
      Write one character at a time, backwards
    }
    for I := length( Str ) downto 1 do
      begin
        gotoXY( 5 + I, 15 );
        write( Str[I] );
        delay( 100 );
      end;

    {
      Now, simulate blinking text, this time with LightCyan background and
      Black foreground text
    }
    ColorBack := LightCyan;
    SetFillStyle( SolidFill, ColorBack );
    Bar( 50, 30, 600, 200 );

    XorColConv( ColorBack, LightRed, ColorOut );
    TextColor( ColorOut + 128 );
    gotoXY( 15, 10 );
    write( 'PRESS ANY KEY TO QUIT ' );

    XorColConv( ColorBack, Black, ColorOut );
    TextColor( ColorOut + 128 );
    {
      blink text until user presses a key
    }
    repeat
        gotoXY( 10, 5 );
        writeln( Str );
        delay(70);
    until KeyPressed
  END.
