function fArctan( ang : single ) : single; assembler;
{ ST(1) <- atan( ST(1) / ST); pop( );
  FPATAN computes the artangent in radians of ST(1)/ST.  The mnemonic
  "partial arctangent" is inherited from earlier NDPs, which placed
  restrictions on the values of ST and ST(1).  These values are not
  restricted on the 80387 and 80486. }
asm
   fld ang    { load angle }
   fld1       { load "one" }
   fpatan     { compute "partial" arctangent, actually "full" in 387/486 }
end;


function fSin( ang : single ) : single; Assembler;
{ ST <- sin(ST);             Only 80387 and 80486
  FSIN computes the sine of the top of the stack and stores the result
  in ST.  The value in ST is assumed to be in radians.  The input operand
  to FSIN must be a value such that |ST|<2^63, or no operation takes place
  and the C2 condition code bit is set to 1.  If the operand is a legal
  value, C2 is cleared to 0.  }
asm
   fld ang         { load angle }
   db 0D9h, 0FEh   { FSIN }
end;


function fCos( ang : single ) : single; Assembler;
{ ST <- cos(ST);             Only 80387 and 80486
  FCOS computes the cosine of the value in radians at the top of the stack
  and replaces ST with cosine.  The input operand to FCOS must be a value
  such that |ST|<2^63, or no operation takes place and the C2 condition code
  bit is set to 1.  If the operand is a legal value, C2 is cleared to 0.  }
asm
   fld ang         { load angle }
   db 0D9h, 0FFh   { FCOS }
end;


function fTan( ang : single ) : single; Assembler;
{ ST <- tan(ST); push(1.0);
  FPTAN computes the tangent of the top of the stack and arranges the
  NDP stack such that: ST(1) / ST = tan( original ST ).  The denominator
  is always 1.0 after the FPTAN instruction.  The operand value must be a
  positive number expressed in radians less than PIx2^62, or no operation
  takes place and the C2 condition code bit is set to 1.  If the input
  operand is legal, C2 is cleared to 0. }
var trash : single;
asm
   fld ang         { load angle }
   fptan           { compute tangent }
   fstp trash      { pop denominator, because it's always one }
end;
