{******************************************************}
{*                    GAME.PAS 2.01                   *}
{*      Copyright (c) TurboPower Software 1994.       *}
{*                All rights reserved.                *}
{******************************************************}

{$I APDEFINE.INC}

{$IFNDEF UseUart}
  !! Error!  The settings in APDEFINE.INC are incompatible with this unit
{$ENDIF}

{$IFNDEF UseOOP}
  !! Error - You must use the object-oriented interface for this program
{$ENDIF}

{$S-,R-,V-,I-,B-,F+,O+,A-}

unit Game;
  {-Tic-Tac-Toe engine }

interface

uses
  OoCom,
  {$IFDEF UseOpro}
  OpCrt,
  {$ENDIF}
  {$IFDEF UseTpro}
  TpCrt,
  {$ENDIF}
  {$IFDEF Standalone}
  Crt,
  {$ENDIF}
  DoorIO;

procedure InitTTT(Color : Boolean);
  {-Initialize all TTT variables }

procedure PlayGame;
  {-Play the Tic-Tac-Toe game }

implementation

type
  CoordPair =
    record
      X, Y : Byte;
    end;

const
  NumSquares = 9;
  SquareCoords : array[1..NumSquares] of CoordPair =
    ( (X:23; Y:03),
      (X:36; Y:03),
      (X:49; Y:03),
      (X:23; Y:10),
      (X:36; Y:10),
      (X:49; Y:10),
      (X:23; Y:17),
      (X:36; Y:17),
      (X:49; Y:17) );

  XLines : array[1..4] of String[9] =
    ('       ',
     '      ',
     '      ',
     '       ' );

  OLines : array[1..4] of String[9] =
    ('      ',
     '       ',
     '       ',
     '      ');

const
  MonoTopCap     = 'Ŀ';
  MonoVirtPiece  = '۳';
  MonoBotCap     = '';
  MonoDownTee    = 'Ŀ';
  MonoHorizTee   = '۳';
  MonoUpTee      = 'ĿĿ';

  ColorTopCap    = #27'[34mĿ';
  ColorVirtPiece = #27'[34m'#27'[32m'#27'[34m';
  ColorBotCap    = #27'[34m';
  ColorDownTee   = #27'[34m'#27'[32m'#27'[34m'#27'[32m'#27'[34mĿ';
  ColorHorizTee  = #27'[34m'#27'[32m'#27'[34m';
  ColorUpTee     = #27'[34mĿ'#27'[32m'#27'[34mĿ'#27'[32m'#27'[34m';

  Help1Mono      = ' 123';
  Help2Mono      = '';
  Help3Mono      = ' 456';
  Help4Mono      = '';
  Help5Mono      = ' 789';

  Help1Color     = #27'[33m 1'#27'[34m'#27'[33m2'#27'[34m'#27'[33m3';
  Help2Color     = #27'[34m';
  Help3Color     = #27'[33m 4'#27'[34m'#27'[33m5'#27'[34m'#27'[33m6';
  Help4Color     = #27'[34m';
  Help5Color     = #27'[33m 7'#27'[34m'#27'[33m8'#27'[34m'#27'[33m9';

  Prompt         = 'Select a square or press ''Q'' to quit: ';

  YouHave        = 'You already occupy that square...';
  IHave          = 'I own that square thankyouverymuch.  Not trying to cheat, are you?';

  ReturnMessage  = #27'[2J'#27'[33mReturning you to the BBS...'#13#10#13#10;

  SquareColorMono  = 0;
  SquareColorColor = 33;

  MsgColorMono     = 0;
  MsgColorColor    = 41;

  PromptColorMono  = 0;
  PromptColorColor = 32;

  BoardX    = 21;
  LeftBarX  = 32;
  RightBarX = 45;

  { Play algorithm constants }
  XV   = 1;
  X2   = 2 * XV;
  OV   = 4;
  O2   = 2 * OV;
  Draw = 255;

var
  TopCap      : String[80];
  VirtPiece   : String[80];
  BotCap      : String[80];
  DownTee     : String[80];
  HorizTee    : String[80];
  UpTee       : String[80];
  Help1       : String[40];
  Help2       : String[40];
  Help3       : String[40];
  Help4       : String[40];
  Help5       : String[40];
  ColorSquare : Byte;
  ColorPrompt : Byte;
  UserHasQuit : Boolean;
  UserHasWon  : Boolean;
  CompHasWon  : Boolean;
  GameTied    : Boolean;
  IsX         : Boolean;
  Plays       : array[0..9] of Byte;
  Moves       : Word;

  procedure InitTTT(Color : Boolean);
    {-Initialize all TTT variables }
  begin
    if Color then begin
      TopCap      := ColorTopCap;
      VirtPiece   := ColorVirtPiece;
      BotCap      := ColorBotCap;
      DownTee     := ColorDownTee;
      HorizTee    := ColorHorizTee;
      UpTee       := ColorUpTee;
      Help1       := Help1Color;
      Help2       := Help2Color;
      Help3       := Help3Color;
      Help4       := Help4Color;
      Help5       := Help5Color;
      ColorSquare := SquareColorColor;
      ColorPrompt := PromptColorColor;
    end else begin
      TopCap      := MonoTopCap;
      VirtPiece   := MonoVirtPiece;
      BotCap      := MonoBotCap;
      DownTee     := MonoDownTee;
      HorizTee    := MonoHorizTee;
      UpTee       := MonoUpTee;
      Help1       := Help1Mono;
      Help2       := Help2Mono;
      Help3       := Help3Mono;
      Help4       := Help4Mono;
      Help5       := Help5Mono;
      ColorSquare := SquareColorMono;
      ColorPrompt := PromptColorMono;
    end;
  end;

  procedure DrawBoard;
    {-Draw the Tic-Tac-Toe board }

    procedure DrawVerticals(Starting, Ending : Byte);
    var
      I : Word;

    begin
      for I := Starting to Ending do begin
        DoorGotoXY(LeftBarX, I);
        Write(DoorOut, VirtPiece);
        DoorGotoXY(RightBarX, I);
        Write(DoorOut, VirtPiece);
      end;
    end;

    procedure DrawCrossPiece(StartAt : Byte);
    begin
      DoorGotoXY(BoardX, StartAt);
      Write(DoorOut, DownTee);
      DoorGotoXY(BoardX, StartAt + 1);
      Write(DoorOut, HorizTee);
      DoorGotoXY(BoardX, StartAt + 2);
      Write(DoorOut, UpTee);
    end;

    procedure DrawHelpLine(Line : Byte; St : String);
    begin
      DoorGotoXY(4, 1 + Line);
      Write(DoorOut, St);
    end;

  begin
    { display main board }
    DoorBoldVideo;
    DoorClrScr;
    DoorGotoXY(LeftBarX, 2);
    Write(DoorOut, TopCap);
    DoorGotoXY(RightBarX, 2);
    Write(DoorOut, TopCap);

    DrawVerticals(3, 6);
    DrawCrossPiece(7);
    DrawVerticals(10, 13);
    DrawCrossPiece(14);
    DrawVerticals(17, 20);

    DoorGotoXY(LeftBarX, 21);
    Write(DoorOut, BotCap);
    DoorGotoXY(RightBarX, 21);
    Write(DoorOut, BotCap);

    { display help board }
    DrawHelpLine(1, Help1);
    DrawHelpLine(2, Help2);
    DrawHelpLine(3, Help3);
    DrawHelpLine(4, Help4);
    DrawHelpLine(5, Help5);
  end;

  procedure DrawXMarker(X, Y : Byte);
  var
    I : Byte;

  begin
    DoorSetFG(ColorSquare);
    for I := 1 to 4 do begin
      DoorGotoXY(X, Y + I - 1);
      Write(DoorOut, XLines[I]);
    end;
  end;

  procedure DrawOMarker(X, Y : Byte);
  var
    I : Byte;

  begin
    DoorSetFG(ColorSquare);
    for I := 1 to 4 do begin
      DoorGotoXY(X, Y + I - 1);
      Write(DoorOut, OLines[I]);
    end;
  end;

  procedure PutMarkerInSquare(Square : Byte; Marker : Char);
    {-Put a position marker in a square }
  begin
    Marker := UpCase(Marker);
    if ((Marker <> 'X') and (Marker <> 'O')) or (Square < 1) or (Square > NumSquares) then
      Exit;

    if (Marker = 'X') then
      DrawXMarker(SquareCoords[Square].X, SquareCoords[Square].Y)
    else
      DrawOMarker(SquareCoords[Square].X, SquareCoords[Square].Y);
  end;

  procedure InitPlayArea;
    {-Initialize the TTT scorecard }
  begin
    FillChar(Plays, SizeOf(Plays), 0);
    Plays[9]    := 127;
    Moves       := 0;
    UserHasQuit := False;
    UserHasWon  := False;
    CompHasWon  := False;
    GameTied    := False;
    DrawBoard;
  end;

  function YesNo(YNPrompt : String) : Boolean;
    {-Get an answer to a yes/no question }
  var
    Ch : Char;

  begin
    DoorGotoXY(10, 23);
    DoorEraseEOL;
    DoorSetFG(ColorPrompt);
    Write(DoorOut, YNPrompt, ' (Y/N)? ');

    repeat
      Ch := UpCase(DoorGetChar);
      if (Ch >= #33) then
        Write(DoorOut, Ch, #8);

    until (Ch in ['Y', 'N']);

    YesNo := (Ch = 'Y');
  end;

  procedure WriteMsg(St : String);
    {-Write a message to the display }
  begin
    DoorGotoXY(10, 23);
    DoorEraseEOL;
    Write(DoorOut, St, #7);
    Delay(1000);
  end;

  procedure ComputerMove; forward;
  procedure PlayandCheck(NewSpot : Word); forward;

  function GetSquareFromUser : Byte;
  var
    Ch : Char;

  begin
    DoorGotoXY(10, 23);
    DoorEraseEOL;
    DoorSetFG(ColorPrompt);
    Write(DoorOut, Prompt);

    repeat
      Ch := UpCase(DoorGetChar);
      if (Ch >= #33) then
        Write(DoorOut, Ch, #8);

    until (Ch in ['Q', '1'..'9']);
    if (Ch = 'Q') then
      GetSquareFromUser := 0
    else
      GetSquareFromUser := Ord(Ch) - Ord('0');
  end;

  procedure GetUserMove;
    {-Get, validate, and display the user's move }
  var
    Sq : Byte;

  begin
    repeat
      Sq := GetSquareFromUser;
      if (Sq <> 0) then begin
        if (Plays[SQ-1] = XV) then
          WriteMsg(YouHave)
        else if (Plays[Sq-1] = OV) then
          WriteMsg(IHave);
      end else
        if YesNo('Are you really giving up?  Am I too much for you') then begin
          UserHasQuit := True;
          Exit;
        end else
          Sq := 0;

    until (Sq <> 0) and (Plays[Sq-1] = 0);

    if (Sq <> 0) then
      PlayAndCheck(Sq - 1);
  end;

  procedure PlayandCheck(NewSpot : Word);

    function Won : Byte;
    var
      N : Word;

    begin
      for N := 0 to 2 do
        case Plays[N * 3 + 0] + Plays[N * 3 + 1] + Plays[N * 3 + 2] of
          3*XV:
            begin
              Won := XV;
              Exit;
            end;
          3*OV:
            begin
              Won := OV;
              Exit;
            end;
        end;

      for N := 0 to 2 do
        case Plays[N + 0] + Plays[N + 3] + Plays[N + 6] of
          3*XV:
            begin
              Won := XV;
              Exit;
            end;
          3*OV:
            begin
              Won := OV;
              Exit;
            end;
        end;

      case Plays[0] + Plays[4] + Plays[8] of
        3*XV:
          begin
            Won := XV;
            Exit;
          end;
        3*OV:
          begin
            Won := OV;
            Exit;
          end;
      end;

      case Plays[2] + Plays[4] + Plays[6] of
        3*XV:
          begin
            Won := XV;
            Exit;
          end;
        3*OV:
          begin
            Won := OV;
            Exit;
          end;
      end;

      if (Moves = 9) then begin
        Won := Draw;
        Exit;
      End;

      Won := 0;
    end;

  begin
    if (Plays[NewSpot] <> 0) then
      Exit;

    if IsX then begin
      Plays[NewSpot] := XV;
      PutMarkerInSquare(NewSpot + 1, 'X');
    end else begin
      Plays[NewSpot] := OV;
      PutMarkerInSquare(NewSpot + 1, 'O');
    end;
    Inc(Moves);

    IsX := not IsX;

    case Won of
      XV  : UserHasWon := True;
      OV  : CompHasWon := True;
      Draw: GameTied   := True;
      else
        if not IsX then
          ComputerMove;
    end;
  end;

  procedure ComputerMove;
  var
    Spot : Word;

  const
    Corners : array[0..3] of Byte = (0, 2, 6, 8);

    function Block2Way(var S : Word) : Boolean;
      {-Only called when the computer has a 4th move }
    begin
      if ((Plays[0] = XV) and (Plays[8] = XV)) or
         ((Plays[2] = XV) and (Plays[6] = XV)) then begin
        Block2Way := True;
        S := Succ(2 * Random(4));
      end else
        Block2Way := False;
    end;

    function RateThem : Word;
      {-Never called 'til after middle square is used }
    var
      N        : Word;
      Best     : Word;
      BestRate : Word;
      A1       : Word;
      A2       : Word;
      D1       : Word;
      D2       : Word;
      G1       : Word;
      G2       : Word;
      AC       : Word;
      DN       : Word;
      DG       : Word;
      Ratings  : array[0..8] of Byte;

      procedure UpdateBest(Num, Value : Word);
      begin
        Ratings[Num] := Value;
        if (Value > BestRate) then begin
          BestRate := Value;
          Best     := Num;
        end;
      end;

    begin
      Best     := 0;
      BestRate := 0;
      for N := 0 to 8 do begin
        if (Plays[N] <> 0) then
          Ratings[N] := 0
        else begin
          { A1 and A2 are the other two across }
          A1 := (N div 3) * 3;
          A2 := Succ(A1);
          if (A1 = N) then
            Inc(A1, 2);
          if (A2 = N) then
            Inc(A2);

          { D1 and D2 are the other two down }
          D1 := N mod 3;
          D2 := D1 + 3;
          if (D1 = N) then
            Inc(D1, 6);
          if (D2 = N) then
            Inc(D2, 3);

          { G1 and G2 are the other two diagonally }
          G1 := 4;
          if Odd(N) then begin
            G1 := 9;
            G2 := 9;
          end else case N of
            0: G2 := 8;
            2: G2 := 6;
            6: G2 := 2;
            8: G2 := 0;
          end;

          AC := Plays[A1] + Plays[A2];
          DN := Plays[D1] + Plays[D2];
          DG := Plays[G1] + Plays[G2];

          if (AC = O2) or (DN = O2) or (DG = O2) then
            UpdateBest(N, 5)  { a win! }
          else if (AC = X2) or (DN = X2) or (DG = X2) then
            UpdateBest(N, 4)  { a block! }
          else if ((AC + DN) = O2) or ((AC + DG) = O2) or ((DN + DG) = O2) then
            UpdateBest(N, 3)  { a 2-way! }
          else if (AC = OV) or (DN = OV) or (DG = OV) then
            UpdateBest(N, 2)  { 2 in a row }
          else
            UpdateBest(N, 1);
        end;
      end;

      RateThem := Best;
    end;

  begin
    case Moves of
      0: Spot := 4;
      1:
        begin
          if (Plays[4] = 0) then
            Spot := 4
          else
            Spot := Corners[Random(4)];
        end;
      3:
        if not Block2Way(Spot) then
          Spot := RateThem;
      else
        Spot := RateThem;
    end;

    PlayAndCheck(Spot);
  end;

  procedure PlayGame;
    {-Play the Tic-Tac-Toe game }
  var
    LastX : Boolean;
    Msg   : String;

    procedure GetMsg;
    begin
      if UserHasWon then
        Msg := 'Beginner''s luck!  You win!'
      else if CompHasWon then
        Msg := 'Ha ha, human!  I win!'
      else
        Msg := 'We tied!  Imagine that!';
    end;

  begin
    Randomize;

    InitTTT(True);
    LastX := False;

    repeat
      LastX := not LastX;
      IsX   := LastX;

      InitPlayArea;

      if not IsX then
        ComputerMove;

      repeat
        GetUserMove;
      until UserHasQuit or UserHasWon or CompHasWon or GameTied;

      if not UserHasQuit then begin
        GetMsg;
        Msg := Msg + '  Do you want to play again';
        UserHasQuit := not YesNo(Msg);
      end;
    until UserHasQuit;

    Write(DoorOut, ReturnMessage);
  end;

end.
