{      program: DISAP0
       the skeleton of the program: no special features.
}
 
{$X+}
program DisappearingInputLineDemo;

uses
    Objects,Views,Dialogs,App;

type
    PDemo = ^TDemo;
    TDemo = object (TApplication)
       constructor Init;
    end;

constructor TDemo.Init;
var
    Dialog       : PDialog;
    InputLine    : PInputLine;
    Rectangle    : TRect;
    Button       : PButton;
    RadioButtons : PRadioButtons;
    Text         : PStaticText;
    LabelText    : PLabel;
    RetCode      : Word;
begin
    TApplication.Init;

    Rectangle.Assign(2,1,77,20);
    Dialog := New(PDialog,Init(Rectangle,'enter printer-data'));

    Rectangle.Assign(3,9,34,10);
    Text := New(PStaticText,Init(Rectangle,'printer connected via COMx:'));
    Dialog^.Insert(Text);

    Rectangle.Assign(3,2,27,5);
    RadioButtons := New(PRadioButtons,Init(Rectangle,
                        NewSItem('IBM-GraphicPrinter',
                        NewSItem('HP LaserJet II/III',
                        NewSItem('Epson FX80',nil)))));

    Rectangle.Assign(2,1,20,2);
    LabelText := New(PLabel,Init(Rectangle,'type of printer:',RadioButtons));
    Dialog^.Insert(LabelText);
    Dialog^.Insert(RadioButtons);

    Rectangle.Assign(33,2,45,9);
    RadioButtons := New(PRadioButtons,Init(Rectangle,
                        NewSItem('LPT 1',
                        NewSItem('LPT 2',
                        NewSItem('COM 1',
                        NewSItem('COM 2',
                        NewSItem('COM 3',
                        NewSItem('COM 4',
                        NewSItem('File:',nil)))))))));
    Rectangle.Assign(31,1,47,2);
    LabelText := New(PLabel,Init(Rectangle,'outputting via:',RadioButtons));
    Dialog^.Insert(LabelText);
    Dialog^.Insert(RadioButtons);

    Rectangle.Assign(45,8,72,9);
    InputLine := New(PInputLine,Init(Rectangle,64));
    Rectangle.Assign(45,7,69,8);
    LabelText := New(PLabel,Init(Rectangle,'if output in file:',InputLine));
    Dialog^.Insert(LabelText);
    Dialog^.Insert(InputLine);

    Rectangle.Assign(13,10,73,11);
    RadioButtons := New(PRadioButtons,Init(Rectangle,
                        NewSItem(' 300',
                        NewSItem(' 600',
                        NewSItem('1200',
                        NewSItem('2400',
                        NewSItem('4800',
                        NewSItem('9600',nil))))))));
    RadioButtons^.Value := 5;
    RadioButtons^.Sel := 5;
    Rectangle.Assign(2,10,13,11);
    LabelText := New(PLabel,Init(Rectangle,'baud:',RadioButtons));
    Dialog^.Insert(LabelText);
    Dialog^.Insert(RadioButtons);

    Rectangle.Assign(19,11,45,12);
    RadioButtons := New(PRadioButtons,Init(Rectangle,
                        NewSItem('8 bits  ',
                        NewSItem('7 bits',nil))));
    Rectangle.Assign(2,11,9,12);
    LabelText := New(PLabel,Init(Rectangle,'data:',RadioButtons));
    Dialog^.Insert(LabelText);
    Dialog^.Insert(RadioButtons);

    Rectangle.Assign(19,12,45,13);
    RadioButtons := New(PRadioButtons,Init(Rectangle,
                        NewSItem('1 bit   ',
                        NewSItem('2 bits',nil))));
    Rectangle.Assign(2,12,8,13);
    LabelText := New(PLabel,Init(Rectangle,'stop:',RadioButtons));
    Dialog^.Insert(LabelText);
    Dialog^.Insert(RadioButtons);

    Rectangle.Assign(19,13,43,14);
    RadioButtons := New(PRadioButtons,Init(Rectangle,
                        NewSItem('odd     ',
                        NewSItem('even',nil))));
    Rectangle.Assign(2,13,10,14);
    LabelText := New(PLabel,Init(Rectangle,'parity:',RadioButtons));
    Dialog^.Insert(LabelText);
    Dialog^.Insert(RadioButtons);

    Rectangle.Assign(19,14,42,15);
    RadioButtons := New(PRadioButtons,Init(Rectangle,
                        NewSItem('XON/XOFF',
                        NewSItem('DTR',nil))));
    Rectangle.Assign(2,14,16,15);
    LabelText := New(PLabel,Init(Rectangle,'flow control:',RadioButtons));
    Dialog^.Insert(LabelText);
    Dialog^.Insert(RadioButtons);

    Rectangle.Assign(13,16,21,18);
    Button := New(PButton,Init(Rectangle,'O~K~',cmOK,bfDefault));
    Button^.AmDefault := True;
    Dialog^.Insert(Button);

    Rectangle.Assign(48,16,60,18);
    Button := New(PButton,Init(Rectangle,'Cancel',cmCancel,bfNormal));
    Dialog^.Insert(Button);

    Dialog^.SelectNext(False);
    RetCode := DeskTop^.ExecView(Dialog);

    Dispose(Dialog,Done);
end;

var
    Demo: TDemo;

begin
    Demo.Init;
    Demo.Run;
    Demo.Done;
end.
