{ This program is basically a slimmed-down version of the TVDEMO program,
  with added stuff to handle the functions implemented in PHONELST.PAS and
  PHONEDLG.PAS. In order to save space, I have eliminated anything that
  wasn't absolutely required to demonstrate the techniques. If you want to
  add back anything that was contained in the original TVDEMO, such as the
  help system, you should be able to pretty much copy it verbatim.

  See PHONELST.PAS and PHONEDLG.PAS for additional documentation.            }

{$X+}
{$S-}
program PhoneDemo;

{ As it stands, this demo uses the PhoneLst unit, which displays the phone
  list in a list box. To use the PhoneDlg unit, simply replace 'PhoneLst'
  with 'PhoneDlg' in the USES statement below.                               }

uses
  Dos,Drivers,Objects,Views,Menus,Dialogs,StdDlg,MsgBox,App,PhoneLst;

{ Following are the commands defined for TPhoneApp.                          }

const
  cmNew   = 101;  { Initialize a new phone file }
  cmOpen  = 102;  { Open an existing phone file and read it into memory }

{ TPhoneApp is a simple descendant of TApplication. It owns a single
  TPhoneColl object, which is the current phone list. In this demo, I have
  arranged things so that only a single phone list can be loaded into memory
  at any time. However, it shouldn't be too hard to modify things to give
  you the ability to have more than one list in memory at once (so that you
  could compare them, for example). Instead of owning a single TPhoneColl
  object, TPhoneApp might own an array of them, or even a TCollection of
  them. The CurrentFile field keeps track of the filename of the currently
  loaded phone list, if any.                                                 }

type
  PPhoneApp = ^TPhoneApp;
  TPhoneApp = object (TApplication)
    PhoneList: PPhoneColl;
    CurrentFile: PathStr;
    constructor Init;
    procedure NewPhoneList;
    procedure OpenPhoneList;
    procedure SavePhoneList;
    procedure HandleEvent (var Event: TEvent); virtual;
    procedure InitMenuBar; virtual;
    procedure InitStatusLine; virtual;
    end;

{ The FileExists function checks to see if the filename passed to it refers
  to an existing file.                                                       }

function FileExists (FileName: PathStr): Boolean;

var
  F: File;

begin
Assign (F,FileName);
{$I-}
Reset (F);
{$I+}
if IOResult <> 0 then FileExists := False
else begin
  FileExists := True;
  Close (F);
  end;
end;

{ TPhoneApp methods }

constructor TPhoneApp.Init;

begin
TApplication.Init;
RegisterObjects;
RegisterViews;
RegisterMenus;
RegisterDialogs;
RegisterApp;
RegisterPhone;
CurrentFile := '';
end;

{ NewPhoneList instantiates a new TPhoneColl object (empty), and invokes a
  dialog box via PhoneList^.Show, so that the user can enter information
  into the TPhoneColl. At the time the dialog is closed, the value returned
  by Show is checked. If the dialog was not closed with a cmCancel, the
  TPhoneColl is saved to disk.                                               }

procedure TPhoneApp.NewPhoneList;

begin
PhoneList := New (PPhoneColl,Init (10,10));
CurrentFile := '';
if PhoneList^.Show <> cmCancel then SavePhoneList;
end;

{ OpenPhoneList is similar to NewPhoneList, except that the TPhoneColl is
  loaded from an existing disk file. Error handling is rudimentary.          }

procedure TPhoneApp.OpenPhoneList;

var
  D: PFileDialog;
  S: TBufStream;

begin
D := New (PFileDialog,Init ('*.PHN','Open phone file','~N~ame',
  fdOKButton + fdHelpButton,100));
if Desktop^.ExecView (D) <> cmCancel then
  begin
  D^.GetFileName (CurrentFile);
  if FileExists (CurrentFile) then
    begin
    S.Init (CurrentFile,stOpenRead,512);
    PhoneList := PPhoneColl (S.Get);
    S.Done;
    if PhoneList^.Show <> cmCancel then SavePhoneList;
    end
  else begin
    MessageBox ('Can''t find ' + CurrentFile + '.',nil,
      mfError + mfOkButton);
    CurrentFile := '';
    end;
  end;
Dispose (D,Done);
end;

{ In this demo, SavePhoneList is called only by NewPhoneList or
  OpenPhoneList when it's time to save the currently active TPhoneColl
  object. If CurrentFile is null, SavePhoneList opens a conventional file
  dialog; otherwise, the TPhoneColl is saved to CurrentFile.                 }

procedure TPhoneApp.SavePhoneList;

var
  D: PFileDialog;
  S: TBufStream;

begin
if CurrentFile = '' then
  begin
  D := New (PFileDialog,Init ('*.PHN','Save phone file','~N~ame',
    fdOKButton + fdHelpButton,100));
  if Desktop^.ExecView (D) <> cmCancel then D^.GetFileName (CurrentFile);
  Dispose (D,Done);
  end;
if FileExists (CurrentFile) then S.Init (CurrentFile,stOpenWrite,512)
else S.Init (CurrentFile,stCreate,512);
S.Put (PhoneList);
S.Done;
Dispose (PhoneList,Done);
end;

{ The remaining methods are lifted directly out of TVDEMO.PAS, with
  appropriate modifications.                                                 }

procedure TPhoneApp.HandleEvent (var Event: TEvent);

begin
TApplication.HandleEvent (Event);
if Event.What = evCommand then
  begin
  case Event.Command of
    cmNew: NewPhoneList;
    cmOpen: OpenPhoneList;
    else Exit;
    end;
  ClearEvent(Event);
  end;
end;

procedure TPhoneApp.InitMenuBar;

var
  R: TRect;

begin
GetExtent (R);
R.B.Y := R.A.Y + 1;
MenuBar := New (PMenuBar,Init (R,NewMenu (
  NewSubMenu ('~F~ile',hcNoContext,NewMenu (
    NewItem ('~N~ew list','F3',kbF3,cmNew,hcNoContext,
    NewItem ('~O~pen file...','F5',kbF5,cmOpen,hcNoContext,
    NewLine (
    NewItem ('E~x~it','Alt-X',kbAltX,cmQuit,hcNoContext,nil))))),nil))));
end;

procedure TPhoneApp.InitStatusLine;

var
  R: TRect;

begin
GetExtent (R);
R.A.Y := R.B.Y - 1;
StatusLine := New (PStatusLine,Init (R,
  NewStatusDef (0,$FFFF,
    NewStatusKey ('~F3~ New',kbF3,cmNew,
    NewStatusKey ('~F5~ Open',kbF5,cmOpen,
    NewStatusKey ('~Alt-X~ Exit',kbAltX,cmQuit,
    NewStatusKey ('',kbF10,cmMenu,nil)))),nil)));
end;

var
  PhoneApp: TPhoneApp;

begin
PhoneApp.Init;
PhoneApp.Run;
PhoneApp.Done;
end.
