{===========================================================================}
{                                                                           }
{ DEMODATE.PAS is a demonstration program that demonstrates the date and    }
{ calendar routines in the Dates and Calendar units.                        }
{                                                                           }
{===========================================================================}

Program DemoDate;

Uses

 DOS,
 App,
 Dates,
 Views,
 Menus,
 MsgBox,
 Drivers,
 Dialogs,
 Objects,
 Gadgets,
 HelpFile,
 DemoHelp,
 Rectangl,
 Calendar;

Const

 Version          = ^C'Date and Calendar Demonstrator 1.0.0';
 Programmer       = ^C'Major David L. Kutzler';

 { Command constants. }

 cmAge            = 100;
 cmDifference     = 101;
 cmEDC            = 102;
 cmGestation      = 103;
 cmCalendar       = 104;
 cmSetDate        = 105;
 cmHelp           = 106;
 cmUseHelp        = 107;
 cmTOC            = 108;
 cmDocument       = 109;
 cmAbout          = 110;

 fnHelpFile     = 'DEMOHELP.HLP';

Type

 Demonstrator  = Object(TApplication)
                   Clock:         PClockView;
                   Date:          PGenericDateView;
                   Constructor Init;
                   Procedure   Age_Calculator;
                   Procedure   Difference_Calculator;
                   Procedure   EDC_Calculator;
                   Procedure   Gestation_Calculator;
                   Procedure   About;
                   Procedure   GetEvent(Var  Event:  TEvent);    Virtual;
                   Function    GetPalette:  PPalette;            Virtual;
                   Procedure   Idle;                             Virtual;
                   Procedure   InitMenuBar;                      Virtual;
                   Procedure   InitStatusLine;                   Virtual;
                   Procedure   HandleEvent(Var  Event:  TEvent); Virtual;
                  end;

 DataType       = Record
                   LMP:          Date;
                   EDC:          Date;
                   Target_Date:  Date;
                  end;

Var

 DateDemonstrator:  Demonstrator;
 Julian_Today:      Scaliger;
 WhoAmI:            PDialog;

{============================================================================}
{                                                                            }
{ Find_File returns TRUE if it finds the file defined by file_name.          }
{                                                                            }
{============================================================================}

Function  Find_File(file_name:  string):  Boolean;

Var

 directory_information:  SearchRec;

Begin
 FindFirst(file_name,AnyFile,directory_information);
 Find_File := (DOSError = 0);
 DOSError  := 0;
end;

{============================================================================}
{                                                                            }
{ Define methods for Demonstrator.                                           }
{                                                                            }
{============================================================================}

Constructor Demonstrator.Init;

Begin
 Inherited Init;
 HelpCtx := hcDocument;
 RegisterHelpFile;
 GetExtent(Box);
 Box.A.X := Box.B.X - 9;
 Box.B.Y := Box.A.Y + 1;
 Clock := New(PClockView,Init(Box));
 Insert(Clock);
 GetExtent(Box);
 Box.A.X := Box.B.X - 19;
 Box.B.Y := Box.A.Y + 1;
 Box.Move(-11,0);
 Date := New(PGenericDateView,Init(Box));
 Date^.Update(Todays_Date);
 Insert(Date);
 Julian_Today := Julian(Todays_Date);
 Box.Assign(0,0,Length(Version) + 4,5);
 WhoAmI := New(PDialog,Init(Box,''));
 Set_Center_Option(WhoAmI);
 With WhoAmI^ do begin
  Box.Assign(0,0,Length(Version),1);
  Box.Move(2,2);
  Insert(New(PStaticText,Init(Box,Version)));
 end;
 DeskTop^.Insert(WhoAmI);
 If NOT(Find_File(fnHelpFile)) then begin
  MessageBox('ERROR:  The Help File is not in the current directory.',
             NIL,mfError + mfOkButton);
  Inherited Done;
  Halt;
 end;
 About;
end;

{============================================================================}
{                                                                            }
{ Age_Calculator is a dialog box that allows the user to calculate a         }
{ person's current age by entering their date of birth.                      }
{                                                                            }
{============================================================================}

Procedure   Demonstrator.Age_Calculator;

Var

 Age_Dialog:         PDialog;
 Birthdate:          PDateInputView;
 Current_Age:        PAgeDisplay;
 Today_Pointer,
 Birthdate_Pointer:  PDate;
 Done_Button,
 Help_Button,
 Cancel_Button:      PButton;

Begin

 { Create the dialog box. }

 Box.Assign(0,0,42,11);
 Age_Dialog := New(PDialog,Init(Box,'Age Calculator'));

 { Center the dialog box on the screen. This is from RECTANGL.PAS. }

 Set_Center_Option(Age_Dialog);

 { Build the dialog box. }

 With Age_Dialog^ do begin

  { Define the help context. }

  HelpCtx := hcAgeCalc;

  { "Box" is a predeclared "TRectangle." It is found in the RECTANGL.PAS }
  { unit. TRectangle is a descendent of TRect that has a few extensions. }
  { Box is used here to define a 1 x 22 rectangle for Birthdate and      }
  { Current_Age.                                                         }

  Box.Assign(0,0,22,1);
  Box.Move(17,2);

  { Create a view for entering a person's birthdate. }

  Birthdate := New(PDateInputView,Init(Box));

  { Default the help context of the DateInputView to the dialog box. }

  Birthdate^.HelpCtx := hcNoContext;

  { Create pointers to the birthdate and today's date. NOTE: Todays_Date }
  { is predeclared in the DATES.PAS unit and is pre-initialized to the   }
  { current system date.                                                 }

  Birthdate_Pointer := @Birthdate^.The_Date;
  Today_Pointer := @Todays_Date;

  { Create a view for calculating and displaying the age. }

  Box.Move(0,1);
  Current_Age := New(PAgeDisplay,Init(Box));

  { Point the Reference date to the Birthdate and the Target date to    }
  { today's date.                                                       }

  Current_Age^.Point_To_Reference(Birthdate_Pointer);
  Current_Age^.Point_To_Target(Today_Pointer);

  { Standard_Button, Center_Button and Move_Button_Right are TRectangle }
  { extensions that make it easier to position buttons in a dialog box. }

  Box.Standard_Button;
  Box.Center_Buttons(Size.X,Size.Y - 3);
  Done_Button := New(PButton,Init(Box,'~O~k',cmOK,bfDefault));
  Box.Move_Button_Right;
  Help_Button := New(PButton,Init(Box,'~H~elp',cmHelp,bfNormal));
  Box.Move_Button_Right;
  Cancel_Button := New(PButton,Init(Box,'Cancel',cmCancel,bfNormal));

  { Create labels. }

  Box.Assign(0,0,14,1);
  Box.Move(2,2);
  Insert(New(PLabel,Init(Box,'  ~B~irthdate:',Birthdate)));
  Box.Move(1,1);
  Insert(New(PStaticText,Init(Box,'Current Age:')));

  { Create static text. }

  Box.Assign(0,0,Size.X - 2,1);
  Box.Move(1,5);
  Insert(New(PStaticText,Init(Box,^C'Click the down arrow icon')));
  Box.Move(0,1);
  Insert(New(PStaticText,Init(Box,^C'to enter the birthdate.')));

  { Insert everything in the proper Z-order and select Birthdate. }

  Insert(Birthdate);
  Insert(Current_Age);
  Insert(Done_Button);
  Insert(Help_Button);
  Insert(Cancel_Button);
  Birthdate^.Select;
 end;

 { Show the folks back home what you've done. }

 DeskTop^.ExecView(Age_Dialog);

 { If needed, you could have passed a date to Birthdate using SetData and }
 { have recovered the value in Birthdate using GetData.                   }

 Dispose(Age_Dialog,Done);
end;

{============================================================================}
{                                                                            }
{ Difference_Calculator is a dialog box that allows the user to calculate    }
{ the number of days between two dates.                                      }
{                                                                            }
{============================================================================}

Procedure   Demonstrator.Difference_Calculator;

Var

 Difference_Dialog:  PDialog;
 First_Date:         PDateInputView;
 Second_Date:        PDateInputView;
 Difference:         PJulianDays;
 First_Pointer,
 Second_Pointer:     PDate;
 Done_Button,
 Help_Button,
 Cancel_Button:      PButton;

Begin

 { Create the dialog box. }

 Box.Assign(0,0,42,12);
 Difference_Dialog := New(PDialog,Init(Box,'Date Difference Calculator'));

 { Center the dialog box on the screen. This is from RECTANGL.PAS. }

 Set_Center_Option(Difference_Dialog);

 { Build the dialog box. }

 With Difference_Dialog^ do begin

  { Define the help context. }

  HelpCtx := hcDifferenceCalc;

  { "Box" is a predeclared "TRectangle." It is found in the RECTANGL.PAS }
  { unit. TRectangle is a descendent of TRect that has a few extensions. }
  { Box is used here to define a 1 x 22 rectangle for First_Date,        }
  { Second_Date and Difference.                                          }

  Box.Assign(0,0,22,1);
  Box.Move(17,2);

  { Create two views for entering two different dates. }

  First_Date  := New(PDateInputView,Init(Box));
  Box.Move(0,1);
  Second_Date := New(PDateInputView,Init(Box));

  { Default the help contexts of the DateInputViews to the dialog box. }

  First_Date^.HelpCtx  := hcNoContext;
  Second_Date^.HelpCtx := hcNoContext;

  { Create pointers to the two dates. }

  First_Pointer  := @First_Date^.The_Date;
  Second_Pointer := @Second_Date^.The_Date;

  { Create a view for calculating and displaying the difference. }

  Box.Move(0,1);
  Difference := New(PJulianDays,Init(Box));

  { Point the Reference date to the First_Date and the Target date to   }
  { the Second_Date.                                                    }

  Difference^.Point_To_Reference(First_Pointer);
  Difference^.Point_To_Target(Second_Pointer);

  { Standard_Button, Center_Button and Move_Button_Right are TRectangle }
  { extensions that make it easier to position buttons in a dialog box. }

  Box.Standard_Button;
  Box.Center_Buttons(Size.X,Size.Y - 3);
  Done_Button := New(PButton,Init(Box,'~O~k',cmOK,bfDefault));
  Box.Move_Button_Right;
  Help_Button := New(PButton,Init(Box,'~H~elp',cmHelp,bfNormal));
  Box.Move_Button_Right;
  Cancel_Button := New(PButton,Init(Box,'Cancel',cmCancel,bfNormal));

  { Create labels. }

  Box.Assign(0,0,14,1);
  Box.Move(2,2);
  Insert(New(PLabel,Init(Box,' ~F~irst Date:',First_Date)));
  Box.Move(0,1);
  Insert(New(PLabel,Init(Box,'~S~econd Date:',Second_Date)));
  Box.Move(0,1);
  Insert(New(PStaticText,Init(Box,'  Difference:')));

  { Create static text. }

  Box.Assign(0,0,Size.X - 2,1);
  Box.Move(1,6);
  Insert(New(PStaticText,Init(Box,^C'Click a down arrow icon')));
  Box.Move(0,1);
  Insert(New(PStaticText,Init(Box,^C'to enter a date.')));

  { Insert everything in the proper Z-order and select the First_Date. }

  Insert(First_Date);
  Insert(Second_Date);
  Insert(Difference);
  Insert(Done_Button);
  Insert(Help_Button);
  Insert(Cancel_Button);
  First_Date^.Select;
 end;

 { Show the folks back home what you've done. }

 DeskTop^.ExecView(Difference_Dialog);
 Dispose(Difference_Dialog,Done);
end;

{============================================================================}
{                                                                            }
{ EDC_Calculator is a dialog box that allows the user to calculate a         }
{ pregnant woman's "Due" date or EDC by entering her last menstrual period.  }
{                                                                            }
{============================================================================}

Procedure   Demonstrator.EDC_Calculator;

Var

 EDC_Dialog:         PDialog;
 LMP_Date:           PDateInputView;
 EDC:                PEDCDisplay;
 LMP_Pointer:        PDate;
 Done_Button,
 Help_Button,
 Cancel_Button:      PButton;

Begin

 { Create the dialog box. }

 Box.Assign(0,0,42,11);
 EDC_Dialog := New(PDialog,Init(Box,'EDC Calculator'));

 { Center the dialog box on the screen. This is from RECTANGL.PAS. }

 Set_Center_Option(EDC_Dialog);

 { Build the dialog box. }

 With EDC_Dialog^ do begin

  { Define the help context. }

  HelpCtx := hcEDCCalc;

  { "Box" is a predeclared "TRectangle." It is found in the RECTANGL.PAS }
  { unit. TRectangle is a descendent of TRect that has a few extensions. }
  { Box is used here to define a 1 x 22 rectangle for the LMP_Date and   }
  { EDC.                                                                 }

  Box.Assign(0,0,22,1);
  Box.Move(17,2);

  { Create a view for entering a woman's LMP. }

  LMP_Date := New(PDateInputView,Init(Box));

  { Default the help context of the DateInputView to the dialog box. }

  LMP_Date^.HelpCtx  := hcNoContext;

  { Create pointer to the woman's LMP. }

  LMP_Pointer := @LMP_Date^.The_Date;

  { Create a view for calculating and displaying the EDC. }

  Box.Move(0,1);
  EDC := New(PEDCDisplay,Init(Box));

  { Point the Reference date to the LMP. }

  EDC^.Point_To_Reference(LMP_Pointer);

  { Standard_Button, Center_Button and Move_Button_Right are TRectangle }
  { extensions that make it easier to position buttons in a dialog box. }

  Box.Standard_Button;
  Box.Center_Buttons(Size.X,Size.Y - 3);
  Done_Button := New(PButton,Init(Box,'~O~k',cmOK,bfDefault));
  Box.Move_Button_Right;
  Help_Button := New(PButton,Init(Box,'~H~elp',cmHelp,bfNormal));
  Box.Move_Button_Right;
  Cancel_Button := New(PButton,Init(Box,'Cancel',cmCancel,bfNormal));

  { Create labels. }

  Box.Assign(0,0,14,1);
  Box.Move(2,2);
  Insert(New(PLabel,Init(Box,'~L~ast Period:',LMP_Date)));
  Box.Move(1,1);
  Insert(New(PStaticText,Init(Box,'        EDC:')));

  { Create static text. }

  Box.Assign(0,0,Size.X - 2,1);
  Box.Move(1,5);
  Insert(New(PStaticText,Init(Box,^C'Click the down arrow icon')));
  Box.Move(0,1);
  Insert(New(PStaticText,Init(Box,^C'to enter the last period.')));

  { Insert everything in the proper Z-order and select LMP_Date. }

  Insert(LMP_Date);
  Insert(EDC);
  Insert(Done_Button);
  Insert(Help_Button);
  Insert(Cancel_Button);
  LMP_Date^.Select;
 end;

 { Show the folks back home what you've done. }

 DeskTop^.ExecView(EDC_Dialog);
 Dispose(EDC_Dialog,Done);
end;

{============================================================================}
{                                                                            }
{ Gestation_Calculator is a dialog box that allows the user to calculate     }
{ the gestation of a pregnancy via either the LMP or the EDC. May also be    }
{ used to calculate the difference between a due date based on an LMP versus }
{ a due date based on an ultrasound derived EDC.                             }
{                                                                            }
{============================================================================}

Procedure   Demonstrator.Gestation_Calculator;

Var

 Gestation_Dialog:   PDialog;
 LMP,
 EDC,
 Target_Date:        PDateInputView;
 LMP_Gestation,
 EDC_Gestation:      PGestDisplay;
 Difference:         PDiffDisplay;
 LMP_Pointer,
 EDC_Pointer,
 Target_Pointer:     PDate;
 Done_Button,
 Help_Button,
 Cancel_Button:      PButton;
 Data:               DataType;

Begin

 { Create the dialog box. }

 Box.Assign(0,0,44,15);
 Gestation_Dialog := New(PDialog,Init(Box,'Gestation Calculator'));

 { Center the dialog box on the screen. This is from RECTANGL.PAS. }

 Set_Center_Option(Gestation_Dialog);

 { Build the dialog box. }

 With Gestation_Dialog^ do begin

  { Define the help context. }

  HelpCtx := hcGestationCalc;

  { "Box" is a predeclared "TRectangle." It is found in the RECTANGL.PAS }
  { unit. TRectangle is a descendent of TRect that has a few extensions. }
  { Box is used here to define a 1 x 22 rectangle for the LMP and EDC.   }

  Box.Assign(0,0,22,1);
  Box.Move(19,2);

  { Create a view for entering the LMP and EDC. }

  LMP  := New(PDateInputView,Init(Box));
  Box.Move(0,1);
  EDC := New(PDateInputView,Init(Box));
  Box.Move(0,1);
  Target_Date := New(PDateInputView,Init(Box));

  { Default the help contexts of the DateInputViews to the dialog box. }

  LMP^.HelpCtx         := hcNoContext;
  EDC^.HelpCtx         := hcNoContext;
  Target_Date^.HelpCtx := hcNoContext;

  { Create pointers to the various dates. }

  LMP_Pointer    := @LMP^.The_Date;
  EDC_Pointer    := @EDC^.The_Date;
  Target_Pointer := @Target_Date^.The_Date;

  { Create a view for the LMP gestation, EDC gestation & Difference. }

  Box.Move(0,1);
  LMP_Gestation := New(PGestDisplay,Init(Box));
  Box.Move(0,1);
  EDC_Gestation := New(PGestDisplay,Init(Box));
  Box.Move(0,1);
  Difference    := New(PDiffDisplay,Init(Box));

  { Set EDC_Gestation to calculate Gestation from EDC. }

  EDC_Gestation^.Set_Use_EDC(TRUE);

  { Point the LMP_Gestation Reference_Date to the LMP date and the }
  { LMP_Gestation Target_Date to the Target_Date.                  }

  LMP_Gestation^.Point_To_Reference(LMP_Pointer);
  LMP_Gestation^.Point_To_Target(Target_Pointer);

  { Point the EDC_Gestation Reference_Date to the EDC date and the }
  { EDC_Gestation Target_Date to the Target_Date.                  }

  EDC_Gestation^.Point_To_Reference(EDC_Pointer);
  EDC_Gestation^.Point_To_Target(Target_Pointer);

  { Point the Difference Reference_Date to the EDC date and the }
  { Difference Target_Date to the Target_Date.                  }

  Difference^.Point_To_Reference(LMP_Pointer);
  Difference^.Point_To_Target(EDC_Pointer);

  { Standard_Button, Center_Button and Move_Button_Right are TRectangle }
  { extensions that make it easier to position buttons in a dialog box. }

  Box.Standard_Button;
  Box.Center_Buttons(Size.X,Size.Y - 3);
  Done_Button := New(PButton,Init(Box,'~O~k',cmOK,bfDefault));
  Box.Move_Button_Right;
  Help_Button := New(PButton,Init(Box,'~H~elp',cmHelp,bfNormal));
  Box.Move_Button_Right;
  Cancel_Button := New(PButton,Init(Box,'Cancel',cmCancel,bfNormal));

  { Create labels. }

  Box.Assign(0,0,16,1);
  Box.Move(2,2);
  Insert(New(PLabel,Init(Box,'          ~L~MP:',LMP)));
  Box.Move(0,1);
  Insert(New(PLabel,Init(Box,'          ~E~DC:',EDC)));
  Box.Move(0,1);
  Insert(New(PLabel,Init(Box,'  ~T~arget Date:',EDC)));
  Box.Move(0,1);
  Insert(New(PStaticText,Init(Box,' LMP Gestation:')));
  Box.Move(0,1);
  Insert(New(PStaticText,Init(Box,' EDC Gestation:')));
  Box.Move(0,1);
  Insert(New(PStaticText,Init(Box,'    Difference:')));

  { Create static text. }

  Box.Assign(0,0,Size.X - 2,1);
  Box.Move(1,9);
  Insert(New(PStaticText,Init(Box,^C'Click a down arrow icon')));
  Box.Move(0,1);
  Insert(New(PStaticText,Init(Box,^C'to enter a date.')));

  { Insert everything in the proper Z-order and select the First_Date. }

  Insert(LMP);
  Insert(EDC);
  Insert(Target_Date);
  Insert(LMP_Gestation);
  Insert(EDC_Gestation);
  Insert(Difference);
  Insert(Done_Button);
  Insert(Help_Button);
  Insert(Cancel_Button);
  LMP^.Select;
 end;

 { Pass data to the dialog box. }

 With Data do begin
  LMP         := Null_Date;
  EDC         := Null_Date;
  Target_Date := Todays_Date;
 end;
 Gestation_Dialog^.SetData(Data);

 { Show the folks back home what you've done. }

 DeskTop^.ExecView(Gestation_Dialog);
 Dispose(Gestation_Dialog,Done);
end;

{============================================================================}
{                                                                            }
{ About tells the user about me.                                             }
{                                                                            }
{============================================================================}

Procedure   Demonstrator.About;

Var

 About_Dialog:   PDialog;
 Done_Button,
 Help_Button,
 Cancel_Button:  PButton;

Begin
 Box.Assign(0,0,45,11);
 About_Dialog := New(PDialog,Init(Box,'Date and Calendar Demonstrator'));
 Set_Center_Option(About_Dialog);
 With About_Dialog^ do begin
  HelpCtx := hcDocument;
  Box.Assign(0,0,Size.X - 4,1);
  Box.Move(2,2);
  Insert(New(PStaticText,Init(Box,Version)));
  Box.Move(0,2);
  Insert(New(PStaticText,Init(Box,Programmer)));
  Box.Move(0,2);
  Insert(New(PStaticText,Init(Box,^C'Press "H" For Help')));
  Box.Standard_Button;
  Box.Center_Buttons(Size.X,Size.Y - 3);
  Done_Button := New(PButton,Init(Box,'~O~k',cmOK,bfDefault));
  Box.Move_Button_Right;
  Help_Button := New(PButton,Init(Box,'~H~elp',cmHelp,bfNormal));
  Box.Move_Button_Right;
  Cancel_Button := New(PButton,Init(Box,'Cancel',cmCancel,bfNormal));
  Insert(Done_Button);
  Insert(Help_Button);
  Insert(Cancel_Button);
  Done_Button^.Select;
 end;
 DeskTop^.ExecView(About_Dialog);
 Dispose(About_Dialog,Done);
end;

Procedure   Demonstrator.GetEvent(var Event: TEvent);

Type

 Commands = Set of Byte;

Const

 HelpInUse:     Boolean  = FALSE;
 HelpCommands:  Commands = [cmHelp,
                            cmUseHelp,
                            cmTOC,
                            cmDocument];

Var

 HelpWindow:  PWindow;
 HelpFile:    PHelpFile;
 HelpStream:  PDosStream;

Begin
 Inherited GetEvent(Event);
 If HelpInUse then Exit;
 HelpWIndow := NIL;
 If (Event.What = evKeyDown) AND (Event.KeyCode = kbShiftF1) then begin
  Event.What    := evCommand;
  Event.Command := cmTOC;
 end;
 If NOT(Event.What = evCommand) then Exit;
 If NOT(Event.Command IN HelpCommands) then Exit;
 HelpInUse  := TRUE;
 HelpStream := New(PDosStream, Init(fnHelpFile,stOpenRead));
 HelpFile   := New(PHelpFile, Init(HelpStream));
 If (HelpStream^.Status <> stOk)
  then begin
   MessageBox('Could not open help file.',NIL,mfError + mfOkButton);
   Dispose(HelpFile,Done);
  end
  else begin
   Case Event.Command of
    cmHelp:            HelpWindow := New(PHelpWindow,Init(HelpFile,GetHelpCtx));
    cmUseHelp:         HelpWindow := New(PHelpWindow,Init(HelpFile,hcHelp));
    cmTOC:             HelpWindow := New(PHelpWindow,Init(HelpFile,hcTOC));
    cmDocument:        HelpWindow := New(PHelpWindow,Init(HelpFile,hcDocument));
   end;
   If (ValidView(HelpWindow) <> NIL) then begin
    HelpWindow^.HelpCtx := hcHelpWindow;
    ExecView(HelpWindow);
    Dispose(HelpWindow, Done);
   end;
   ClearEvent(Event);
  end;
 HelpInUse := FALSE;
end;

Function    Demonstrator.GetPalette:  PPalette;

Const

 CNewColor      = CAppColor      + CHelpColor;
 CNewBlackWhite = CAppBlackWhite + CHelpBlackWhite;
 CNewMonochrome = CAppMonochrome + CHelpMonochrome;

 Palette:  Array[apColor..apMonochrome] of String[Length(CNewColor)] = (CNewColor,CNewBlackWhite,CNewMonochrome);

Begin
 GetPalette := @Palette[AppPalette];
end;

Procedure   Demonstrator.Idle;

Begin
 Inherited Idle;
 Clock^.Update;
 Julian_Today := Julian(Todays_Date);
 If NOT(Julian_Today = Julian(Date^.The_Date)) then Date^.Update(Todays_Date);
end;

Procedure   Demonstrator.InitMenuBar;

Var

 Bar:  TRect;

Function Date_Calculator_Menu(ANext:  PMenuItem):  PMenuItem;

Begin
 Date_Calculator_Menu :=
  NewSubMenu('~D~ate Calculators', hcDateCalcMenu,
   NewMenu(
    NewItem('~A~ge Calculator...',        '',      kbNoKey, cmAge,        hcAge,
    NewItem('~D~ate Difference...',       '',      kbNoKey, cmDifference, hcDifference,
    NewItem('~E~DC Calculator...',        '',      kbNoKey, cmEDC,        hcEDC,
    NewItem('~G~estation Calculator...',  '',      kbNoKey, cmGestation,  hcGestation,
    NewItem('E~x~it Program',             'Alt+X', kbAltX,  cmQuit,       hcQuit,
    NIL)))))), ANext);
 end;

Function Calendar_Menu(ANext:  PMenuItem):  PMenuItem;

Begin
 Calendar_Menu :=
  NewSubMenu('~C~alendar', hcCalendarMenu,
   NewMenu(
    NewItem('~L~ook at the Calendar...', '', kbNoKey, cmCalendar, hcLookAtCalendar,
    NewItem('~S~et Today''s Date...', '',    kbNoKey, cmSetDate,  hcSetDate,
    NIL))), ANext);
end;

Function Help_Menu(ANext:  PMenuItem):  PMenuItem;

Begin
 Help_Menu :=
  NewSubMenu('~H~elp', hcHelpMenu,
   NewMenu(
    NewItem('~H~ow to Use the Help System...',  '',         kbNoKey,   cmUseHelp,   hcHelpMenuHow,
    NewItem('~T~able of Contents...',           'Shift+F1', kbShiftF1, cmTOC,       hcHelpMenuTOC,
    NewItem('~D~ate and Calendar Documentation','',         kbNoKey,   cmDocument,  hcHelpMenuDocument,
    NewItem('~A~bout...',                       '',         kbNoKey,   cmAbout,     hcHelpMenuAbout,
    NIL))))), ANext);
end;

Begin
 GetExtent(Bar);
 Bar.B.Y := Bar.A.Y + 1;
 MenuBar := New(PMenuBar,Init(Bar,
                               NewMenu(
                                Date_Calculator_Menu(
                                Calendar_Menu(
                                Help_Menu(
                                NIL))))
                               )
                              );
end;

Procedure   Demonstrator.InitStatusLine;

Var

 Line:  TRect;

Function Main_Status(ANext:  PStatusDef):  PStatusDef;

Begin
 Main_Status := 
  NewStatusDef(hcDocument, hcDocument,
   NewStatusKey('~Alt+X~ Exit Program',         kbAltX,    cmQuit,
   NewStatusKey('~F1~ Help',                    kbF1,      cmHelp,
   NewStatusKey('~Shift-F1~ Table of Contents', kbShiftF1, cmTOC,
   NewStatusKey('~F10~ Menu',                   kbF10,     cmMenu,
   NewStatusKey('',                             kbF5,      cmZoom,
   NIL))))),
  ANext);
end;

Function Data_Status(ANext:  PStatusDef):  PStatusDef;

Begin
 Data_Status :=
  NewStatusDef(hcDateCalcMenu, hcDateCalcMenu,
   NewStatusKey('~F1~ Help  The Date Calculator Menu.',kbF1,cmHelp,
   NIL),
  NewStatusDef(hcAge, hcAge,
   NewStatusKey('~F1~ Help  Calculate current age from date of birth.', kbF1, cmHelp,
   NIL),
  NewStatusDef(hcAgeCalc, hcAgeCalc,
   NewStatusKey('~F1~ Help  Calculate current age from date of birth.', kbF1, cmHelp,
   NIL),
  NewStatusDef(hcDifference, hcDifference,
   NewStatusKey('~F1~ Help  Calculate the number of days between two dates.', kbF1, cmHelp,
   NIL),
  NewStatusDef(hcDifferenceCalc, hcDifferenceCalc,
   NewStatusKey('~F1~ Help  Calculate the number of days between two dates.', kbF1, cmHelp,
   NIL),
  NewStatusDef(hcEDC, hcEDC,
   NewStatusKey('~F1~ Help  Enter the last menstrual period and calculate the due date.', kbF1, cmHelp,
   NIL),
  NewStatusDef(hcEDCCalc, hcEDCCalc,
   NewStatusKey('~F1~ Help  Enter the last menstrual period and calculate the due date.', kbF1, cmHelp,
   NIL),
  NewStatusDef(hcGestation, hcGestation,
   NewStatusKey('~F1~ Help  Calculate how far along is a pregnancy.', kbF1, cmHelp,
   NIL),
  NewStatusDef(hcGestationCalc, hcGestationCalc,
   NewStatusKey('~F1~ Help  Calculate how far along is a pregnancy.', kbF1, cmHelp,
   NIL),
  NewStatusDef(hcQuit, hcQuit,
   NewStatusKey('~F1~ Help  Exit the program.', kbF1, cmHelp,
   NIL),
  ANext))))))))));
end;

Function Calendar_Status(ANext:  PStatusDef):  PStatusDef;

Begin
 Calendar_Status :=
  NewStatusDef(hcCalendarMenu, hcCalendarMenu,
   NewStatusKey('~F1~ Help  The Calendar Menu.', kbF1, cmHelp,
   NIL),
  NewStatusDef(hcLookAtCalendar, hcLookAtCalendar,
   NewStatusKey('~F1~ Help  Look at the Desk Calendar.', kbF1, cmHelp,
   NIL),
  NewStatusDef(hcSetDate, hcSetDate,
   NewStatusKey('~F1~ Help  Set the date that the program uses for today''s date.', kbF1, cmHelp,
   NIL),
  NewStatusDef(hcDeskCalendar, hcDeskCalendar,
   NewStatusKey('~F1~ Help  The Desk Calendar.', kbF1, cmHelp,
   NIL),
  NewStatusDef(hcSetDateCalendar, hcSetDateCalendar,
   NewStatusKey('~F1~ Help  The Set Date Calendar.', kbF1, cmHelp,
   NIL),
  NewStatusDef(hcDateInputView, hcDateInputView,
   NewStatusKey('~F1~ Help  The Date Input View.', kbF1, cmHelp,
   NIL),
  ANext))))));
end;

Function Help_Status(ANext:  PStatusDef):  PStatusDef;

Begin
 Help_Status :=
  NewStatusDef(hcHelpMenu, hcHelpMenu,
   NewStatusKey('~F1~ Help  The Help Menu.', kbF1, cmHelp,
   NIL),
  NewStatusDef(hcHelpMenuHow, hcHelpMenuHow,
   NewStatusKey('~F1~ Help  Help with the Help System.', kbF1, cmHelp,
   NIL),
  NewStatusDef(hcHelpMenuTOC, hcHelpMenuTOC,
   NewStatusKey('~F1~ Help  The Help System Table of Contents.', kbF1, cmHelp,
   NIL),
  NewStatusDef(hcHelpMenuDocument, hcHelpMenuDocument,
   NewStatusKey('~F1~ Help  Documentation for the Date and Calendar Routines.', kbF1, cmHelp,
   NIL),
  NewStatusDef(hcHelpMenuAbout, hcHelpMenuAbout,
   NewStatusKey('~F1~ Help  About the Author.', kbF1, cmHelp,
   NIL),
  NewStatusDef(hcHelpWindow, hcHelpWindow,
   NewStatusKey('~F5~ Zoom the help window', kbF5, cmZoom,
   NewStatusKey('~Alt+F3~ Close the help window', kbAltF3, cmClose,
   NewStatusKey('', kbCtrlF5, cmResize,
   NIL))),
  NewStatusDef(hcHelp, hcHelp,
   NewStatusKey('~F1~ Help  Help with the Help System.', kbF1, cmHelp,
   NIL),
  ANext)))))));
end;

Begin
 GetExtent(Line);
 Line.A.Y := Line.B.Y - 1;
 StatusLine := New(PStatusLine,
                    Init(Line,
                     Main_Status(
                     Data_Status(
                     Calendar_Status(
                     Help_Status(
                     NIL))))
                    )
                   );
end;

Procedure   Demonstrator.HandleEvent(Var  Event:  TEvent);

Begin
 TApplication.HandleEvent(Event);
 If (Event.What = evCommand) then begin
  Box.Calendar;
  Box.Move(20,0);
  Case Event.Command of
   cmAge:            Age_Calculator;
   cmDifference:     Difference_Calculator;
   cmEDC:            EDC_Calculator;
   cmGestation:      Gestation_Calculator;
   cmCalendar:       View_Calendar(Box,Todays_Date);
   cmSetDate:        Pick_Date(Box,Todays_Date);
   cmAbout:          About;
  Else Exit;
  end;
 Julian_Today := Julian(Todays_Date);
 Today_String := String_Date(Todays_Date,FALSE,FALSE,FALSE);
 ClearEvent(Event);
 end;
end;

Begin
 DateDemonstrator.Init;
 DateDemonstrator.Run;
 DateDemonstrator.Done;
end.