{============================================================================}
{                                                                            }
{ "Dates" is a unit of date manipulation functions and procedures.           }
{                                                                            }
{============================================================================}

                            { Optimize compiler. }

                       {$A+,B-,D-,F+,I-,L-,O+,R-,S-,V-}

Unit Dates;

Interface

Uses

 DOS;

{============================================================================}
{                                                                            }
{ Global type declarations.                                                  }
{                                                                            }
{============================================================================}

Type

 { User defined scalar types for "Days" and "Months." }

 Days   = (Mon, Tue, Wed, Thu, Fri, Sat, Sun);
 Months = (error, Jan, Feb, Mar, Apr, May, Jun,
                  Jul, Aug, Sep, Oct, Nov, Dec);

 { The "Date" type. }

 PDate = ^Date;
 Date  = Record
          day,
          year:   integer;
          month:  Months
         end;

 { A type for Julian dates. }

 PScaliger = ^Scaliger;
 Scaliger  = LongInt;

 { A type for representing dates as strings. }

 PDate_Strings = ^Date_Strings;
 Date_Strings  = string[30];

{============================================================================}
{                                                                            }
{ Global constant declarations.                                              }
{                                                                            }
{============================================================================}

Const

 { The null date constant. }

 Null_Date:  Date = (day:    0;
                     year:   0;
                     month:  error);

 { Structured, typed constants for the days of the week...}

 day_string:  Array[Days] of string[10] = ('Monday',    'Tuesday',
                                           'Wednesday', 'Thursday',
                                           'Friday',    'Saturday',
                                           'Sunday');

 { ...and the months of the year. }

 month_string:  Array[Months] of string[10] = ('ERROR',
                                               'January',   'February',
                                               'March',     'April',
                                               'May',       'June',
                                               'July',      'August',
                                               'September', 'October',
                                               'November',  'December');

{============================================================================}
{                                                                            }
{ Declare global variables.                                                  }
{                                                                            }
{============================================================================}

Var

 { Date and string variables for today's date.  }

 Todays_Date:   Date;
 Today_String:  date_strings;

{============================================================================}
{                                                                            }
{ Declare the public routines for the Dates unit.                            }
{                                                                            }
{============================================================================}


Function  Leap(year:  integer):  Boolean;
Function  Days_per_Month(month:  Months;
                          year:  integer):  integer;
Function  Valid_Date(the_date:  Date):  Boolean;
Function  Julian(the_date:  Date):  Scaliger;
Procedure Standard( Julian_date:  Scaliger;
                   Var the_date:  Date);
Function  Day_of_Week(the_date:  Date):  Days;
Procedure Get_Date(Var the_date:  Date);
Procedure Set_Date(the_date:  Date);
Function  String_Date(   the_date:  Date;
                         military,
                      abbreviated,
                            short:  Boolean):  date_strings;

Implementation

{============================================================================}
{                                                                            }
{ The following include files are the public routines for the unit.          }
{                                                                            }
{============================================================================}

{$I     LEAP.INC}     { Function  Leap.                    }
{$I DAYS-MON.INC}     { Function  Days_per_Month.          }
{$I    VALID.INC}     { Function  Valid_Date.              }
{$I   JULIAN.INC}     { Function  Julian.                  }
{$I STANDARD.INC}     { Procedure Standard.                }
{$I DAY-WEEK.INC}     { Function  Day_of_Week.             }
{$I SYS-DATE.INC}     { Procedure Get_Date & Set_Date.     }
{$I STR-DATE.INC}     { Function  String_Date.             }

{============================================================================}
{                                                                            }
{                           Initialization Code                              }
{                                                                            }
{============================================================================}

Begin

 { Set today's date to the system date and initialize Today_String. }

 Get_Date(Todays_Date);
 Today_String := String_Date(Todays_Date,FALSE,FALSE,FALSE);
end.
