{$N+,E+}
{definitions for contour plot routines
 copyright 1988, Optimal Systems Laboratory, Plainfield, NJ}
unit c_defs;

interface

const
  {maximum width of data array}
  max_x_size = 250;
  {maximum height of data array}
  max_y_size = 250;
  {maximum number of contours}
  max_contours = 100;

type
  {definition of floating type:  if coprocessor present, setting this to
   single, double or extended yields rapid operation, while setting it to real
   yields slow operation with a coprocessor.  If no coprocessor is present,
   most rapid operation is obtained by setting this equal to real}
  float = single;
  {definitions for data array type and contour array type}
  column_type = array[0..max_y_size-1] of longint;
  column_pointer_type = ^column_type;
  data_array_type = array[0..max_x_size-1] of column_pointer_type;
  data_array_pointer_type = ^data_array_type;
  contour_array_type = array[0..max_contours-1] of float;
  contour_array_pointer_type = ^contour_array_type;

var
  {pointers to data and contour levels}
  data_array_pointer : data_array_pointer_type;
  contours : contour_array_pointer_type;

procedure init_array;

implementation

procedure init_array ;
  var
    i : integer;

  begin
    new(contours);
    new(data_array_pointer);
    for  i:=0  to max_x_size-1 do
      new(data_array_pointer^[i]);
  end;

end.
