{$M 4096,0,0}
PROGRAM TestCDS;  {Version 0.90}

{$DEFINE COMMENTS}

   {This program generates a sample CDS activity log and calls on a program
named "Operator" to calculate the cost of a call currently in progress.  It
is designed as a limited tutorial for using the CommCDS unit in a program.

   This program, like the CommCDS unit, requires the TPRO5 toolkit from
TurboPower Software in order to be compiled.}


USES
   TpCRT,
   TpDate,
   CommCDS;


CONST
   MaxByte    = 255;
   NullString = '';

   OurName      = 'TESTCDS';         {the name of our test program}
   AnalyzerName = 'OPERATOR';        {the name of a CDS phone bill analyzer}
   ConnectARQ   = 'Modems established ARQ connection';

   Comment1 =
      'This first comment shows what is possible in the Call Data Standard.  '
    + 'Look above: you''ll see this comment has no "COM port" entry.  The '
    + 'CommCDS unit knows no call is in progress, so it assumes this must be '
    + 'a "generic", or global, comment.';

   Comment2 =
      'If you look closely at the code, you will see it is formatted '
    + 'differently compared to the final output in the CDS log file.  This '
    + 'is because the CommCDS unit uses word-wrapping to keep the comments '
    + 'within CDS log file syntax constraints.';

   Comment3 =
      'This comment was added to the CDS log while a call was in progress.  '
    + 'CommCDS added a "COM port" entry (above) which ties it to the call.';

VAR
   TheComPort   : BYTE;
   TheComSpeed  : LONGINT;
   TheComBits   : BYTE;
   TheComParity : CHAR;
   TheComStopB  : BYTE;
   NameOfBBS    : STRING;
   PhoneNumber  : STRING;

   FileName        : STRING;
   FileSize        : LONGINT;
   Protocol        : CDSProtocolType;
   TransferStarted : DateTimeRec;
   TransferEnded   : DateTimeRec;
   TotalXmitErrors : WORD;
   Efficiency      : REAL;
   AverageCPS      : WORD;

{============================================================================}
PROCEDURE WasteTime;

   {This procedure provides us with a time lapse between CDS log entries.  It
can be bypassed at any instant by pressing a key.}

VAR
   GarbageChar : CHAR;
   Index       : WORD;

BEGIN {WasteTime}
IF (MaxByte = 0)
 THEN EXIT; {no need to hang around here, eh?}

{Initialize.}
WHILE KEYPRESSED
 DO GarbageChar := READKEY;

{Waste some time to show a time lapse for the next log entry.}
WRITELN(OUTPUT,'This countdown generates ''elapsed time''');
WRITELN(OUTPUT,'between CDS log entries.  Press any key');
WRITELN(OUTPUT,'if you want to stop the countdown.');
FOR Index := MaxByte DOWNTO 1
 DO BEGIN
    WRITE(OUTPUT,^M'Countdown: ',Index,' seconds...    ');
    IF KEYPRESSED
     THEN {null}
     ELSE DELAY(1000)
    END;

WHILE KEYPRESSED
 DO GarbageChar := READKEY;

WRITELN(OUTPUT);
WRITELN(OUTPUT)
END; {WasteTime}
{============================================================================}

BEGIN {TestCDS}
{Initialize program.}
ProgramName := OurName;
HostName    := NullString;
InitCommCDS(NullString);

{$IFDEF COMMENTS}
    {Let's log a CDS free-format comment to show that it can be done.}
    LogFreeFormatComment(Comment1);
    LogFreeFormatComment(Comment2);
    LogFreeFormatComment(NullString);
    IF (CDSIORESULT = 0)
     THEN {everything went okay}
     ELSE HALT(CDSIORESULT);
{$ENDIF}

{We just connected to a call we placed.}
TheComPort   := 1;          {we're using COM1}
TheComSpeed  := 19200;      {we're running at 19.2k}
TheComBits   := 8;          {our # of data bits}
TheComParity := 'N';        {the parity (none)}
TheComStopB  := 1;          {the stop bits (1)}
NameOfBBS    := 'TheBBS';   {name of the BBS we dialed}
PhoneNumber  := '555-1212'; {phone number for BBS}

{Tell CDS we just placed a call!}
LogOutgoingCall(TheComPort,
                TheComSpeed,
                TheComBits,
                TheComParity,
                TheComStopB,
                NullString,    {we don't know who our user is}
                UnknownReason, {business or personal call status is unknown}
                NameOfBBS,
                PhoneNumber,
                FALSE,         {this is not a host callback}
                ConnectARQ);   {we know we connected with an ARQ}
IF (CDSIORESULT = 0)
 THEN {everything went okay}
 ELSE HALT(CDSIORESULT);

{$IFDEF COMMENTS}
    {This next CDS free-format comment will be "tied" to the call in progress.}
    LogFreeFormatComment(Comment3);
    LogFreeFormatComment(NullString);
    IF (CDSIORESULT = 0)
     THEN {everything went okay}
     ELSE HALT(CDSIORESULT);
{$ENDIF}

WasteTime;

{"Overhead" for logging into BBS is finished; we're in the Main conference.}
LogForumSwitch('MAIN',NullString);
IF (CDSIORESULT = 0)
 THEN {everything went okay}
 ELSE HALT(CDSIORESULT);

WasteTime;

{Pretend we moved to the download conference area.}
LogForumSwitch('Download',NullString);
IF (CDSIORESULT = 0)
 THEN {everything went okay}
 ELSE HALT(CDSIORESULT);

WasteTime;

{Now we're going to fake an uploaded file.}
FileName          := 'SOMEFILE.ZIP';
FileSize          := 18027;          {pretend this is the size of the file}
Protocol          := YmodemG;        {pretend this is the transfer protocol}
TransferStarted.D := Today;
TransferStarted.T := CurrentTime;

WasteTime; {generate some elapsed time for the file transfer}

WITH TransferEnded
 DO BEGIN
    D := Today;
    T := CurrentTime
    END;
TotalXmitErrors := 13;  {pretend we had lots of xmit errors}
Efficiency      := 0.0; {pretend the file aborted, therefore no efficiency}
AverageCPS      := 0;   {pretend the file aborted, therefore no avg CPS}

LogFileXfer(FileName,
            TRUE,             {we're uploading this file}
            FileSize,
            UnknownReason,    {we don't know if this is business or personal}
            Protocol,
            FALSE,            {let a CDS phone bill analyzer decide if it
                                should suspend host BBS charges}
            TransferStarted,
            TransferEnded,
            FALSE,            {pretend it wasn't aborted by sender}
            FALSE,            {pretend it wasn't aborted by receiver}
            TRUE,             {pretend it died when DTR went down}
            TotalXmitErrors,
            Efficiency,
            AverageCPS,
            NullString);


{Okay, now the call has ended.}
LogTerminatedCall(FALSE,       {no password on a regular outgoing call}
                  FALSE,       {DTR is down, not up}
                  TRUE,        {pretend we abruptly lost the carrier}
                  0,           {we don't calculate average CPS for a call}
                  NullString); {no comment for the CDS log}
IF (CDSIORESULT = 0)
 THEN {everything went okay}
 ELSE HALT(CDSIORESULT);

WrapupCommCDS
{And that's all he wrote!}
END. {TestCDS}
