program ColorApp;

{---------------------------------------------------------------------
Example application for the custom control Color (Colors.DLL) of
the SMWCC 2.0 Custom Control Pack

Copyright (C) by Sebastian Modersohn

Note: This code file isn't documented into detail. If you have
      questions to *THIS* code file or want to know some details
      please contact me via CompuServe, ID 100340,1474.
---------------------------------------------------------------------}

{$IFNDEF AUTOLOAD}

  You HAVE to compile this program with the global defined symbol "AUTOLOAD" !
  This demonstrates the autoloading feature of the import unit Color!
{$ENDIF}

{$R ColorApp}

uses WinTypes, WinProcs, OWindows, ODialogs, Strings, BWCC,
     {the import unit and the constant unit for the control}
     Color, ColorCo;

{some Id's}
const id_Color1      =101;
      id_Color2      =102;
      id_Check       =103;

type
  pColorWindow = ^tColorWindow;
  tColorWindow = object(tDlgWindow)
    Color1, Color2: pColor;
    Check: pCheckBox;
    constructor Init(AParent: PWindowsObject; AName: PChar);

    procedure WMColorChanged(var Msg: TMessage);
      virtual wm_first + wm_ColorChanged;

    procedure Ok(var Msg: TMessage);
      virtual id_First + id_OK;
    procedure Help(var Msg: TMessage);
      virtual id_First + idHelp;
  end;

{App initializes the main window}
  pColorApp = ^tColorApp;
  tColorApp = object(tApplication)
    procedure InitMainWindow; virtual;
  end;

{ tColorWindow }

constructor tColorWindow.Init(AParent: PWindowsObject; AName: PChar);
begin
  inherited Init(AParent, AName);
  {simple initializing with the Parent (@Self) and the ID}
  Color1:=New(pColor, InitResource(@Self, id_Color1));
  Color2:=New(pColor, InitResource(@Self, id_Color2));
  Check:=New(pCheckBox, InitResource(@Self, id_Check));
end;

{Notification message for monitoring the changes of the color-selection}
procedure TColorWindow.WMColorChanged(var Msg: TMessage);
begin
  {wParam=ID; see help for more info}
  if Msg.wParam=id_Color2 then
  begin
    if Check^.GetCheck=bf_Checked then
    begin
      Color1^.SetBKColor(Color2^.GetFGColor);
    end else
    begin
      Color1^.SetFGColor(Color2^.GetFGColor);
    end;
  end;
end;

procedure TColorWindow.Ok(var Msg: TMessage);
begin
  CloseWindow;
end;

procedure TColorWindow.Help(var Msg: TMessage);
begin
  WinHelp(HWindow, HelpFile, Help_Context, 100);
end;

{ TColorApp }

procedure TColorApp.InitMainWindow;
begin
  MainWindow := New(PColorWindow, Init(nil, MakeIntResource(100)));
end;

var
  App: TColorApp;

begin
  App.Init('Color Demo');
  App.Run;
  App.Done;
end.
