{ Pascal INCLUDE file to implement complex math - by Paul McGinnis }
{ Address information: 5151 McFadden Avenue                        }
{                      Huntington Beach, CA  92649-1236            }
{                      CompuServe: 76056, 201                      }
{                      GEnie: EXP.ENG-                             }
{                      Internet: TRADER@cup.portal.com             }
{                                                                  }
{ This file provides some basic complex math functions and defines }
{ a complex data type. A complex number is of the type (a + jb)    }
{ where j (or i if you are not an engineer) is the square root of  }
{ -1. This was designed as a generic Pascal INCLUDE file and has   }
{ been tested on Turbo Pascal(Mac) & VAX Pascal.                   }

TYPE
  cmplx = RECORD
            Re : REAL;    { x.Re = the real part of x }
            Im : REAL;    { x.Im = the imaginary part of x }
          END;


PROCEDURE CXADD(c1, c2 : cmplx; VAR c3 : cmplx);    { c3 = c1 + c2 }

BEGIN
  c3.Re := c1.Re + c2.Re;
  c3.Im := c1.Im + c2.Im;
END;  



PROCEDURE CXSUB(c1, c2 : cmplx; VAR c3 : cmplx);    { c3 = c1 - c2 }

BEGIN
  c3.Re := c1.Re - c2.Re;
  c3.Im := c1.Im - c2.Im;
END;  



PROCEDURE CXMUL(c1, c2 : cmplx; VAR c3 : cmplx);    { c3 = c1 * c2 }

BEGIN
  c3.Re := (c1.Re * c2.Re) - (c1.Im * c2.Im);
  c3.Im := (c1.Re * c2.Im) + (c1.Im * c2.Re);
END;



PROCEDURE CXDIV(c1, c2 : cmplx; VAR c3 : cmplx);    { c3 = c1 / c2 }

VAR
  denom : REAL;
  
BEGIN
  denom := (c2.Re * c2.Re) + (c2.Im * c2.Im);
  c3.Re := ((c1.Re * c2.Re) + (c1.Im * c2.Im)) / denom;
  c3.Im := ((c1.Im * c2.Re) - (c1.Re * c2.Im)) / denom;
END;



PROCEDURE CXINV(c1 : cmplx; VAR c2 : cmplx);        { c2 = 1 / c1 }

VAR
  denom : REAL;
  
BEGIN
  denom := (c1.Re * c1.Re) + (c1.Im * c1.Im);
  c2.Re := c1.Re / denom;
  c2.Im := (-1.0 * c1.Im) / denom;
END;
                                                                  