{->>>>VarDump<<<<----------------------------------------------}
{                                                              }
{ Filename : VARDUMP.SRC -- Last Modified 7/14/88              }
{                                                              }
{ This routine will display a hex dump of any variable or      }
{ typed constant passed in untyped VAR parameter Target.       }
{ VarDump calls WriteHex; be sure WriteHex is available.       }
{                                                              }
{     From: COMPLETE TURBO PASCAL 5.0  by Jeff Duntemann       }
{    Scott, Foresman & Co., Inc. 1988   ISBN 0-673-38355-5     }
{--------------------------------------------------------------}

PROCEDURE VarDump(VAR Device : Text; VAR Target; ItSize : Integer);

CONST
  Printables : SET OF Char = [' '..'}'];

VAR
  I,J       : Integer;
  Full,Left : Integer;
  DumpIt    : ARRAY[0..MAXINT] OF Byte ABSOLUTE Target;

PROCEDURE DumpLine(Offset,ByteCount : Integer);

VAR
  I : Integer;

BEGIN
  FOR I := 0 TO ByteCount-1 DO               { Hex dump the data }
    BEGIN
      WriteHex(Device,DumpIt[(Offset*16)+I]);
      Write(Device,' ')
    END;
  FOR I := 0 TO 56 - (ByteCount*3) DO Write(Device,' ');  { Space interval }
    Write(Device,'|');                       { Show first boundary bar }
  FOR I := 0 TO ByteCount-1 DO               { Show printable equivalents }
    IF Chr(DumpIt[(Offset*16)+I]) IN Printables THEN
      Write(Device,Chr(DumpIt[(Offset*16)+I]))
    ELSE Write(Device,'.');
  Writeln(Device,'|')                        { Final boundary bar }
END;


BEGIN
  Full := ItSize DIV 16;   { Number of 16-byte chunks in Target }
  Left := ItSize MOD 16;   { 'Leftover' bytes after last 16-byte chunk }
  FOR I := 0 TO Full-1 DO  { Not executed if less than 16 bytes in Target }
    DumpLine(I,16);
  IF Left > 0 THEN         { Not executed if size of Target divides by 16 }
    DumpLine(Full,Left);
  Writeln(Device)          { Space down one line after dump }
END;  { VARDUMP }
