{--------------------------------------------------------------}
{                         Polygons                             }
{                                                              }
{      Polygon draw/polygon fill demonstration program         }
{                                                              }
{                             by Jeff Duntemann                }
{                             Turbo Pascal V5.0                }
{                             Last update 9/3/88               }
{                                                              }
{     From: COMPLETE TURBO PASCAL 5.0  by Jeff Duntemann       }
{    Scott, Foresman & Co., Inc. 1988   ISBN 0-673-38355-5     }
{--------------------------------------------------------------}

PROGRAM Polygons;

USES Graph;

CONST
  Squiggles : FillPatternType =
              ($94,$84,$48,$30,$00,$c1,$22,$14);

  Pentagon  : ARRAY[0..5] OF PointType =
              ((X : 100; Y :  10),
               (X : 200; Y :  80),
               (X : 155; Y : 160),
               (X :  45; Y : 160),
               (X :   0; Y :  80),
               (X : 100; Y :  10));

  BigDipper : ARRAY[0..5] OF PointType =
              ((X : 350; Y :  20),
               (X : 420; Y :  35),
               (X : 475; Y : 100),
               (X : 450; Y : 160),
               (X : 530; Y : 195),
               (X : 600; Y : 150));


VAR
  I           : Integer;
  GraphDriver : Integer;
  GraphMode   : Integer;
  ErrorCode   : Integer;


BEGIN
  GraphDriver := Detect;  { Let the BGI determine what board we're using }
  DetectGraph(GraphDriver,GraphMode);
  InitGraph(GraphDriver,GraphMode,'');
  IF GraphResult <> 0 THEN
    BEGIN
      Writeln('>>Halted on graphics error: ',GraphErrorMsg(GraphResult));
      Halt(2)
    END;

  SetFillPattern(Squiggles,White);

  DrawPoly(6,Pentagon);
  FOR I := 0 TO 5 DO     { Translate the pentagon down 160 pixels }
    Pentagon[I].Y := Pentagon[I].Y + 160;
  FillPoly(6,Pentagon);

  DrawPoly(6,BigDipper);
  FOR I := 0 TO 5 DO     { Translate the Big Dipper down 140 pixels }
    BigDipper[I].Y := BigDipper[I].Y + 140;
  FillPoly(6,BigDipper);

  Readln;
  CloseGraph;
END.
