{--------------------------------------------------------------}
{                           KeyTest                            }
{                                                              }
{         Full keyboard access demonstration program           }
{                                                              }
{                             by Jeff Duntemann                }
{                             Turbo Pascal V4.0                }
{                             Last update 7/1/88               }
{                                                              }
{     From: COMPLETE TURBO PASCAL 5.0  by Jeff Duntemann       }
{    Scott, Foresman & Co., Inc. 1988   ISBN 0-673-38355-5     }
{--------------------------------------------------------------}

PROGRAM KeyTest;

USES Crt,DOS;

VAR Ch : Char;
    Extended : Boolean;
    Scan,Shifts : Byte;
    Ready : Boolean;

{$I FLUSHKEY.SRC }
{$I GETKEY.SRC }
{$I CURSOFF.SRC }

BEGIN
  Ch := ' ';
  Ready := False;
  ClrScr;
  CursorOff;  { Get the cursor out of the way; we don't need it. }
  GotoXY(20,1); Write('< COMPLETE TURBO PASCAL Keyboard Read Demo >');
  GotoXY(30,2); Write('(Press ESC to exit...)');

  { First we set up the labels for the shift keys: }
  GotoXY(12,17); Write('Ctrl: ');
  GotoXY(5,18);  Write('Left Shift: ');
  GotoXY(48,18); Write('Right Shift: ');
  GotoXY(13,19); Write('Alt: ');

  { Here we set up the labels for the toggle keys: }
  GotoXY(50,19); Write('Caps Lock: ');
  GotoXY(64,19); Write('Insert: ');
  GotoXY(52,13); Write('Num Lock: ');
  GotoXY(64,13); Write('Scroll Lock: ');

  GotoXY(31,7); Write('<Last key pressed: >');

  FlushKey; { Empty any waiting keystrokes from the typeahead buffer }
  REPEAT
    Ready := GetKey(Ch,Extended,Scan,Shifts);
    GotoXY(29,8);
    IF Ready THEN  { If a character key has been pressed... }
      IF Extended THEN Write('Extended; Scan code = ',Scan)
        ELSE Write('           ',Ch,'              ');
    GotoXY(17,18); IF (Shifts AND $02) <> 0 THEN   { Left Shift }
      Write(Chr(31)) ELSE Write(Chr(30));
    GotoXY(62,18); IF (Shifts AND $01) <> 0 THEN   { Right Shift }
      Write(Chr(31)) ELSE Write(Chr(30));
    GotoXY(18,17); IF (Shifts AND $04) <> 0 THEN   { Ctrl }
      Write(Chr(31)) ELSE Write(Chr(30));
    GotoXY(18,19); IF (Shifts AND $08) <> 0 THEN   { Alt }
      Write(Chr(31)) ELSE Write(Chr(30));

    GotoXY(61,19); IF (Shifts AND $40) <> 0 THEN   { Caps Lock }
      Write(Chr(15)) ELSE Write(' ');
    GotoXY(72,19); IF (Shifts AND $80) <> 0 THEN   { Insert }
      Write(Chr(15)) ELSE Write(' ');
    GotoXY(62,13); IF (Shifts AND $20) <> 0 THEN   { Num Lock }
      Write(Chr(15)) ELSE Write(' ');
    GotoXY(77,13); IF (Shifts AND $10) <> 0 THEN   { Scroll Lock }
      Write(Chr(15)) ELSE Write(' ');

  UNTIL Ch = Chr(27);      { Until you press ESC... }
  TextMode(3);             { ...then restore cursor and quit. }
END.
