{->>>>Square<<<<-----------------------------------------------}
{                                                              }
{ Filename : SQUARE.SRC -- Last Modified 7/23/88               }
{                                                              }
{ This routine draws a square at X,Y that is symmetrical       }
{ independent of the curren graphics device and mode.  The     }
{ Side parameter contains the measure in pixel of a side, and  }
{ the MeasureXAxis is a Boolean that indicates whether the     }
{ figure passed in Side is measured along the X Axis or the Y  }
{ axis.  MeasureXAxis=True assumes that Side measures along    }
{ X axis, and False assumes that Side measures along the Y     }
{ axis.                                                        }
{                                                              }
{ The system must be in BGI graphics mode.                     }
{                                                              }
{     From: COMPLETE TURBO PASCAL 5.0  by Jeff Duntemann       }
{    Scott, Foresman & Co., Inc. 1988   ISBN 0-673-38355-5     }
{--------------------------------------------------------------}

PROCEDURE Square(X,Y,Side : Word; MeasureXAxis : Boolean);

VAR
  XA,YA   : Word;
  XL,YL : Word;

BEGIN
  XL := Side; YL := Side;
  GetAspectRatio(XA,YA);
  IF MeasureXAxis THEN YL := Round((XA/YA)*Side)
    ELSE XL := Round((YA/XA)*Side);
  Rectangle(X,Y,X+XL,Y+YL);
END;
