{->>>>DisposeOfDirectory<<<<-----------------------------------}
{                                                              }
{ Filename : DISPDIR.SRC -- Last Modified 7/11/88              }
{                                                              }
{ This routine disposes of lists of DIRRec records as built by }
{ GetDirectory.  Type DIRRec and DIRPtr must be defined prior  }
{ to its inclusion.                                            }
{                                                              }
{     From: COMPLETE TURBO PASCAL 5.0  by Jeff Duntemann       }
{    Scott, Foresman & Co., Inc. 1988   ISBN 0-673-38355-5     }
{--------------------------------------------------------------}

PROCEDURE DisposeOfDirectory(RootPointer : DIRPtr);

VAR
  Holder : DIRPtr;

BEGIN
  IF RootPointer <> NIL THEN       { Can't dispose if no list! }
  REPEAT
    Holder := RootPointer^.Next;   { Grab the next record. }
    Dispose(RootPointer);          { Dispose of the first... }
    RootPointer := Holder          { ...and make the next the first... }
  UNTIL RootPointer = NIL          { ...until the list is all gone. }
END;
