{->>>>RoundedRectangle<<<<-------------------------------------}
{                                                              }
{ Filename : ROUNDRCT.SRC -- Last Modified 7/23/88             }
{                                                              }
{ This routine draws a rectangle at X,Y; Width pixels wide and }
{ Height pixels high; with rounded corners of radius R.        }
{                                                              }
{ The Graph unit must be USED for this procedure to compile.   }
{                                                              }
{     From: COMPLETE TURBO PASCAL 5.0  by Jeff Duntemann       }
{    Scott, Foresman & Co., Inc. 1988   ISBN 0-673-38355-5     }
{--------------------------------------------------------------}

PROCEDURE RoundedRectangle(X,Y,Width,Height,R : Word);

VAR
  ULData,LLData,LRData,URData : ArcCoordsType;

BEGIN
  { First we draw each corner arc and save its coordinates: }
  Arc(X+R,Y+R,90,180,R);
  GetArcCoords(ULData);
  Arc(X+R,Y+Height-R,180,270,R);
  GetArcCoords(LLData);
  Arc(X+Width-R,Y+Height-R,270,360,R);
  GetArcCoords(LRData);
  Arc(X+Width-R,Y+R,0,90,R);
  GetArcCoords(URData);
  { Next we draw the four connecting lines: }
  Line(ULData.XEnd,ULData.YEnd,LLData.XStart,LLData.YStart);
  Line(LLData.XEnd,LLData.YEnd,LRData.XStart,LRData.YStart);
  Line(LRData.XEnd,LRData.YEnd,URData.XStart,URData.YStart);
  Line(URData.XEnd,URData.YEnd,ULData.XStart,ULData.YStart);
END;
