PROGRAM Flops;

 {This program uses the Clocks UNIT to determine the number of
  floating-point operations per second (FLOPS) by arithmetic type
  with REAL "matrices" having a size greater than 65535 bytes.

  Earl F. Glynn, Overland Park, KS.  July 1989.}

  USES Clocks;  {Clock, hhmmss}

  CONST
    iMax     = 250;   {Treat x,y,z (below) as ARRAY[1..iMax,1..jMax] ...}
    jMax     = 100;   {6 bytes/REAL * 250 * 100 = 150000 bytes/matrix   }
    MaxTimes =   4;

  TYPE                 {REAL is 6-byte floating point}
    RealType  = REAL;  {or try SINGLE, DOUBLE, EXTENDED}
    RealArray = ARRAY[1..jMax] OF RealType;

  VAR
    clk1,clk2,clk3:  Clock;
    i,j           :  WORD;
    looptime      :  RealType;
    nflops        :  LONGINT;
    overhead      :  RealType;
    sec           :  ARRAY[1..4] OF RealType;
    setup         :  REAL;
    times         :  WORD;
    value         :  RealType;
    x,y,z         :  ARRAY[1..iMax] OF ^RealArray;
                     {Treat x[i]^[j] as matrix}

BEGIN
  Clk1.Start (CMOSClock);

  RandSeed := 17;
  FOR i := 1 TO iMax DO BEGIN
    NEW (x[i]);
    NEW (y[i]);
    NEW (z[i]);
    FOR j := 1 TO jMax DO BEGIN
      x[i]^[j] := Random;
      y[i]^[j] := i+j
    END
  END;
  value := -987.654;

  Clk2.Start (DOSClock);                     {Measure clock overhead}
  FOR times := 1 TO MaxTimes DO
    FOR i := 1 TO iMax DO BEGIN
      FOR j := 1 TO jMax DO BEGIN
      END
    END;
  looptime := Clk2.Elapsed;

  Clk2.Start (DOSClock);
  FOR times := 1 TO MaxTimes DO
    FOR i := 1 TO iMax DO BEGIN
      FOR j := 1 TO jMax DO BEGIN
        Clk3.Start (DOSClock);
        overhead := Clk3.Elapsed
      END
    END;
  overhead := Clk2.Elapsed;
  overhead := (overhead-looptime) / LONGINT(MaxTimes*iMax*jMax);
  setup := Clk1.Elapsed;

  Clk2.Start (DOSClock);                     {Addition}
  FOR times := 1 TO MaxTimes DO
    FOR i := 1 TO iMax DO
      FOR j := 1 TO jMax DO
        z[i]^[j] := x[i]^[j] + y[i]^[j] + value + 12345.67;
  sec[1] := Clk2.Elapsed;

  Clk2.Start (DOSClock);                     {Subtraction}
  FOR times := 1 TO MaxTimes DO
    FOR i := 1 TO iMax DO
      FOR j := 1 TO jMax DO
        z[i]^[j] := x[i]^[j] - y[i]^[j] - value - 12345.67;
  sec[2] := Clk2.Elapsed;

  Clk2.Start (DOSClock);                     {Multiplication}
  FOR times := 1 TO MaxTimes DO
    FOR i := 1 TO iMax DO
      FOR j := 1 TO jMax DO
        z[i]^[j] := x[i]^[j] * y[i]^[j] * value * 12345.67;
  sec[3] := Clk2.Elapsed;

  Clk2.Start (DOSClock);                     {Division}
  FOR times := 1 TO MaxTimes DO
    FOR i := 1 TO iMax DO
      FOR j := 1 TO jMax DO
        z[i]^[j] := x[i]^[j] / y[i]^[j] / value / 12345.67;
  sec[4] := Clk2.Elapsed;

  FOR i := 1 TO iMax DO BEGIN
    DISPOSE (z[i]);                    {Deallocate variables}
    DISPOSE (y[i]);
    DISPOSE (x[i]);
  END;
  nflops := LONGINT(MaxTimes*3*iMax*jMax);
  WRITELN ('Floating-Point Operations Per Second (Flops)');
  WRITELN;
  WRITELN ('  T y p e        Seconds    Flops  ');
  WRITELN ('--------------   -------   --------');
  WRITELN ('Addition         ',sec[1]:7:2,nflops/sec[1]:10:0);
  WRITELN ('Subtraction      ',sec[2]:7:2,nflops/sec[2]:10:0);
  WRITELN ('Multiplication   ',sec[3]:7:2,nflops/sec[3]:10:0);
  WRITELN ('Division         ',sec[4]:7:2,nflops/sec[4]:10:0);
  WRITELN;
  WRITELN ('Based on ',nflops,' floating-point operations per type.');
  WRITELN;
  WRITELN ('Clock overhead:',overhead:7:4,' second');
  WRITELN ('Setup Time:     ',hhmmss(setup));
  WRITELN ('Elapsed Time:   ',hhmmss(Clk1.Elapsed))
END {Flops}.
