{$M $2000,0,0}
PROGRAM Timer;

 {This program uses the Clocks UNIT to time any DOS command executed
  from native DOS or via a BAT file.

  (C) Copyright 1989, Earl F. Glynn, Overland Park, KS.  Compuserve 73257,3527

  Use

       TIMER dos command

  to time any DOS comamand.  Output is always displayed on the screen.
  A timer log file entry will be written to the file specified by
  the DOS TIMER environment variable.  Use

       SET TIMER=filename.ext to

  to specify this environment variable.  If no TIMER environment
  variable exists, output will only be made to the screen.}

  USES
    Clocks,
    DOS;  {PathStr,GetEnv}

  VAR
    clk1     :  Clock;
    clk2     :  Clock;
    command  :  STRING;
    error    :  WORD;
    i        :  WORD;
    log      :  TEXT;
    logfile  :  PathStr;
    seconds1 :  REAL;
    seconds2 :  REAL;
    WriteFlag:  BOOLEAN;

BEGIN
  logfile := GetEnv('TIMER');
  WriteFlag := (LENGTH(logfile) > 0);
  IF   ParamCount = 0
  THEN command := '*'                     {Use '*' for comments.}
  ELSE BEGIN
    command := '';
    FOR  i := 1 TO ParamCount DO
      command := command + ParamStr(i) + ' ';
  END;
  IF   COPY(command,1,1) <> '*'
  THEN BEGIN
    SwapVectors;
    clk1.Start(DOSClock);
    clk2.Start(CMOSClock);
    EXEC (GetEnv('COMSPEC'),'/C '+command);
    seconds1 := clk1.Elapsed;
    seconds2 := clk2.Elapsed;
    SwapVectors;
  END;
  IF   WriteFlag
  THEN BEGIN
    ASSIGN (log,logfile);
    {$I-} APPEND (log); {$I+}
    error := IORESULT;
    IF   error <> 0          {File does not exist.  Create it.}
    THEN BEGIN
      {$I-} REWRITE (log); {$I+}
      error := IORESULT;
      IF   error <> 0
      THEN BEGIN
        WRITELN ('Cannot APPEND or REWRITE Timer file ''',logfile,'''.');
        HALT
      END;
      WRITELN (log,'   Start (CMOS)      Elapsed Time');
      WRITELN (log,'  Date     Time     CMOS     DOS           Command');
      WRITELN (log,'-------- --------  ------ ---------  -------------------');
    END;
    IF   COPY(command,1,1) = '*'
    THEN WRITELN (log,' ':37,COPY(command,2,LENGTH(command)-1))
    ELSE WRITELN (log,clk2.Date('U'),' ',clk2.Time('N'),
        seconds2:8:0,seconds1:10:2,'  ',command);
    CLOSE (log)
  END;
  IF   COPY(command,1,1) <> '*'
  THEN BEGIN
    WRITELN (command);       {repeat command in case not on screen now}
    WRITELN ('Start:  ',clk2.Date('U'),' ',clk2.Time(''),'  Elapsed:  ',
      seconds2:6:0,' (CMOS) ',seconds1:8:2,' (DOS) second(s)');
  END
END {Timer}.
