      {******************************************************************}
      {   Source File: CD.pas                                            }
      {   Unit File: CDC.Pas                                             }
      {   Resource File: CD.Res                                          }
      {   Description: Pascal Source file for CD Player                  }
      {   Date:        Fri Dec 04 19:45:57 1992                          }
      {   Copyright 1992 by M. W. Armstrong                              }
      {******************************************************************}

{$X+}

program CD;

{$R CD.RES}

uses
   WinProcs, WinTypes, Objects, OWindows, OMemory,
   ODialogs, Strings, bwcc, MMSystem, CDC;

const
   AppName: PChar = 'CD';

   Shuffle      = 102;
   RepeatSong   = 103;
   CDPlay       = 104;
   CDStop       = 105;
   Rewind       = 106;
   FastForward  = 107;
   CDPause      = 108;
   CDEject      = 109;
   CDLoud       = 113;
   CDStereoE    = 114;
   CDReverb     = 115;

type

{--------------- Main Window Object ---------------}

   PCD = ^TCD;
   TCD = object(TApplication)
      procedure   InitMainWindow; virtual;
   end;

{--------------- Main Window Dialog of the application -------------------}

  PMainWindow = ^TMainWindow;
  TMainWindow = object(TDlgWindow)
    VLeft,
    VRight,
    BassBar,
    TrebBar,
    MidBar  : PScrollBar;
    RepeatBtn,
    ShuffleBtn : PRadioButton;
    LoudBtn,
    StereoBtn,
    ReverbBtn : PCheckBox;
    TotTime,
    SongTime,
    CurTrack  : PStatic;
    procedure Play;
    procedure OpenDevices;
    procedure SetUpCD;
    procedure DefChildProc(var Msg: TMessage); virtual;
    procedure CDBass(var Msg : TMessage);
      virtual id_first + 110;
    procedure CDMidrange(var Msg : TMessage);
      virtual id_first + 111;
    procedure CDTreble(var Msg : TMessage);
      virtual id_first + 112;
    procedure CDVLeft(var Msg : TMessage);
      virtual id_first + 117;
    procedure CDVRight(var Msg : TMessage);
      virtual id_first + 118;
    procedure Notify(var Msg : TMessage);
      virtual MCI_Notify;
    procedure TUpDate(var Msg: TMessage);
       virtual wm_Timer;
    procedure CheckCD;
    constructor Init(AParent: PWindowsObject; ATitle: PChar);
    destructor Done; virtual;
    procedure SetupWindow; virtual;
    private
      TimerId: word;
  end;

var
  Tracks : Array[0..99] of Integer;
  TrackLen : Array[0..99] of TrackRecord;
  NowPlaying,
  TotalMin,
  TotalSec : Integer;
  TotalPlay,
  SongPlay,
  StartPos,
  CurPos,
  SongPos,
  TMSF       : TimeTMSF;
  CDError,
  EndOfList,
  Repeating,
  Shuffled   : Boolean;

{ Initialize CD Dialog and install controls }

constructor TMainWindow.Init(AParent: PWindowsObject; ATitle: PChar);
begin
   inherited Init(AParent, ATitle);
   BassBar := New(PScrollBar, InitResource(@Self, 110));
   MidBar  := New(PScrollBar, InitResource(@Self, 111));
   TrebBar := New(PScrollBar, InitResource(@Self, 112));
   VLeft   := New(PScrollBar, InitResource(@Self, 117));
   VRight  := New(PScrollBar, InitResource(@Self, 118));

   LoudBtn   := New(PCheckBox, InitResource(@Self, 113));
   StereoBtn := New(PCheckBox, InitResource(@Self, 114));
   ReverbBtn := New(PCheckBox, InitResource(@Self, 115));

   ShuffleBtn := New(PRadioButton, InitResource(@Self, 120));
   RepeatBtn  := New(PRadioButton, InitResource(@Self, 121));

   TotTime  := New(PStatic, InitResource(@Self, 201, 7));
   SongTime := New(PStatic, InitResource(@Self, 202, 7));
   CurTrack := New(PStatic, InitResource(@Self, 203, 3));

end;

{ Sets timer for UpDate procedure }

procedure TMainWindow.SetupWindow;
begin
   inherited SetupWindow;
   OpenDevices;
   SetUpCD;
   TimerId := SetTimer( HWindow, 1, 1000, Nil);
end;

procedure TMainWindow.OpenDevices;
begin
   WinHandle := HWindow;
   MixerAvail := OpenMixer;
   CDAvail := OpenCD;
   SetTMSF;
end;

{ Reads information from MCI for CD tracks }

procedure TMainWindow.SetUpCD;
var I : integer;
begin
   Randomize;
   FillChar(Tracks, SizeOf(Tracks), 0);
   NumTracks := 0;
   If (CDAvail) THEN
   Begin
      StopCD;
      For NumTracks := 1 to NumberOfTracks DO
          Tracks[NumTracks] := NumTracks;
      ConvTMSF(StartPos, StartCD);

      For I := 1 to Numtracks DO
      Begin
        ConvMSF(SongPlay, LengthTrack(I));
        ConvMSF(SongPos, StartTrack(I));
        TrackLen[I].Minutes := SongPlay.Minutes;
        TrackLen[I].Seconds := SongPlay.Seconds;
        TrackLen[I].Frames  := SongPlay.Frames;
        TrackLen[I].StartMin := SongPos.Minutes;
        TrackLen[I].StartSec := SongPos.Seconds;
        TrackLen[I].StartFrame  := SongPos.Frames;
      End;
      CDError := FALSE;
   End
   ELSE
   Begin
     CDError := TRUE;
   End;
   NowPlaying := 0;
   Shuffled := FALSE;
   EndOfList := FALSE;
   Repeating := FALSE;

   BassBar^.SetRange(0, 100);
   MidBar^.SetRange(0, 100);
   TrebBar^.SetRange(0, 100);
   VLeft^.SetRange(0, 100);
   VRight^.SetRange(0, 100);

   BassBar^.SetPosition(95);
   Bass(95);
   MidBar^.SetPosition(50);
   MidRange(50);
   TrebBar^.SetPosition(95);
   Treble(95);
   VLeft^.SetPosition(35);
   Volume('left', 35);
   VRight^.SetPosition(35);
   Volume('right', 35);

   If (Loudness(-101) = 0) THEN
      LoudBtn^.SetCheck(0)
   ELSE
      LoudBtn^.SetCheck(1);

   If (Reverb(-101) = 0) THEN
      ReverbBtn^.SetCheck(0)
   ELSE
      ReverbBtn^.SetCheck(1);

   If (StereoEnhance(-101) = 0) THEN
      StereoBtn^.SetCheck(0)
   ELSE
      StereoBtn^.SetCheck(1);

end;

{------------- Main Window Destructor ---------}

destructor TMainWindow.Done;
begin
   KillTimer( 0, TimerId);
   CloseCD;
   CloseMixer;

   inherited Done;
end;

{ Handles the buttons on the CD Dialog }

procedure TMainWindow.DefChildProc(var Msg: TMessage);
var
  I, J : Integer;
begin
  if (Msg.WParamHi = 0) and (Msg.LParamHi = bn_Clicked) then
  Case Msg.WParamLo OF
       Shuffle :
               begin
                 If Shuffled THEN
                 Begin
                    For NumTracks := 1 to NumberOfTracks DO
                        Tracks[NumTracks] := NumTracks;
                    ShuffleBtn^.SetCheck(0);
                 End
                 ELSE
                 Begin
                   I := 2;
                   Tracks[1] := Random(NumTracks) + 1;;
                   Repeat
                     Tracks[I] := Random(NumTracks) + 1;
                     J := 1;
                     Repeat
                       If Tracks[J] = Tracks[I] THEN
                          Tracks[I] := Random(NumTracks) + 1
                       ELSE
                          Inc(J);
                     Until (J = I);
                     Inc(I);
                   Until (I > NumTracks);
                   ShuffleBtn^.SetCheck(1);
                 end;
                 Shuffled := NOT Shuffled;
               end;
       RepeatSong :
               begin
                 Repeating := NOT Repeating;
                 If Repeating THEN
                 Begin
                   If NowPlaying > 0 THEN
                      Dec(NowPlaying);
                   Repeating := TRUE;
                   RepeatBtn^.SetCheck(1);
                 End
                 ELSE
                   RepeatBtn^.SetCheck(0);
               end;
       CDStop : StopCD;
       Rewind :
               begin
                 If NowPlaying > 1 THEN
                    Dec(NowPlaying, 2);
                 Play;
               end;
       CDPlay: Begin
                 Play;
               End;
       FastForward : Play;
       CDPause :
               Begin
                 PauseCD;
                 Paused := TRUE;
               end;
       CDEject : EjectCD;
       CDLoud :
               begin
                 If LoudBtn^.GetCheck = bf_Unchecked then
                    Loudness(-1)
                 ELSE
                    Loudness(1);
                 end;
       CDStereoE :
                 begin
                   If StereoBtn^.GetCheck = bf_Unchecked then
                      StereoEnhance(-1)
                   ELSE
                      StereoEnhance(1);
                 end;
       CDReverb :
                 begin
                   If ReverbBtn^.GetCheck = bf_Unchecked then
                      Reverb(-1)
                   ELSE
                      Reverb(1);
                 end;
   end; { Case }
  TDlgWindow.DefChildProc(Msg);
end;

{ MCI notifies the program when any changes to the 'OPEN' status of the CD
  or the 'PLAY' status have occured }

procedure TMainWindow.Notify(var Msg : TMessage);
begin
  Case Msg.wParam OF
       MCI_Notify_Successful : If NOT EndOfList THEN Play;
       MCI_Notify_Failure    :
                             Begin
                               MessageBox(HWindow, 'The CD Player has stopped',
                                          'Check your CD', mb_OK);
                               CDError := TRUE;
                             End;
  End; { Case }
end;

procedure TMainWindow.CheckCD;
begin
  If MediaPresent AND Ready THEN
     SetUpCD;
end;

{ The following procedures set the mixer's levels }

procedure TMainWindow.CDBass(var Msg : TMessage);
Begin
  Bass(BassBar^.GetPosition);
End;

procedure TMainWindow.CDMidrange(var Msg : TMessage);
Begin
  MidRange(MidBar^.GetPosition);
End;

procedure TMainWindow.CDTreble(var Msg : TMessage);
Begin
  Treble(TrebBar^.GetPosition);
End;

procedure TMainWindow.CDVLeft(var Msg : TMessage);
Begin
  Volume('left', VLeft^.GetPosition);
  Volume('right', Vright^.GetPosition);
End;

procedure TMainWindow.CDVRight(var Msg : TMessage);
Begin
  Volume('left', VLeft^.GetPosition);
  Volume('right', Vright^.GetPosition);
End;

{ This procedure plays the next track.  If all tracks have been played,
  it does nothing until the play button has been pressed again }

procedure TMainWindow.Play;
var
  CStr : String[3];
  SStr : PChar;
  I    : Integer;
begin
  If Repeating THEN
     Begin
       RepeatBtn^.SetCheck(0);
       Repeating := FALSE;
     End;
  If Paused THEN
     ResumeCD
  ELSE
  Begin
    If Tracks[NowPlaying + 1] <> 0 THEN
    Begin
       REPEAT
         Inc(NowPlaying);
       UNTIL ( PlayCD(Tracks[NowPlaying], 0) OR (NowPlaying = NumTracks));
       Str(Tracks[NowPlaying], CStr);
       GetMem(SStr, 5);
       StrPCopy(SStr, CStr);
       CurTrack^.SetText(SStr);
       FreeMem(SStr, 5);
       TotalMin := 0;
       TotalSec := 0;
       For I := NowPlaying TO NumTracks DO
           Begin
             TotalMin := TotalMin + TrackLen[I].Minutes;
             TotalSec := TotalSec + TrackLen[I].Seconds;
           End;
       TotalMin := TotalMin + (TotalSec DIV 60);
       TotalSec := TotalSec MOD 60;
       EndOfList := FALSE;
    End
  ELSE
    EndofList := TRUE;
  End;
  Paused := FALSE;
end;

{ Converts Minute and Second display to a string }

function TimeString(Min, Sec, MLen : Integer) : String;
var
  MStr,
  SStr : String[3];
begin
  Str(Min, MStr);
  While Length(MStr) < MLen DO
    MStr := '0' + MStr;

  Str(Sec, SStr);
  While Length(SStr) < 2 DO
    SStr := '0' + SStr;

  TimeString := MStr + ':' + SStr;
End;

{ This procedure updates the Time displays.  It is called approximately
  once each second by the Windows SetTimer callback function }

procedure TMainWindow.TUpDate;
var
  TStr,
  SStr : String[10];
  ShowStr : PChar;
  I,
  Min,
  Sec : Integer;
begin

  If CDError THEN CheckCD
  ELSE
  Begin

    Min := 0;
    Sec := 0;

    ConvTMSF(SongPlay, Position);

    Min := (TotalMin *60) + TotalSec;
    Sec := (SongPlay.Minutes * 60) + SongPlay.Seconds;
    Min := Abs(Min - Sec);
    Sec := Min;
    Min := Min DIV 60;
    Sec := Sec MOD 60;

    GetMem(ShowStr, 10);
    StrPCopy(ShowStr, TimeString(Min, Sec, 3));
    TotTime^.SetText(ShowStr);

    Min := (SongPlay.Minutes *60) + SongPlay.Seconds;
    Sec := (TrackLen[Tracks[NowPlaying]].Minutes * 60) +
            TrackLen[Tracks[NowPlaying]].Seconds;
    Min := Abs(Min - Sec);
    Sec := Min;
    Min := Min DIV 60;
    Sec := Sec MOD 60;

    StrPCopy(ShowStr, TimeString(Min, Sec, 2));
    SongTime^.SetText(ShowStr);

    FreeMem(ShowStr, 10);
  end;
end;

{ Create the application's main window }

procedure TCD.InitMainWindow;
begin
   MainWindow := New(PMainWindow, Init(nil, 'DIALOG_1'));
end;

var
  MainApp: TCD;

begin
   MainApp.Init('CD');
   MainApp.Run;
   MainApp.Done;
end.
