Program BuffTest;

Uses BuffAray,Crt;

Const
  Size = 2000;
Var
  R,P     : BufferedArray;
  I,J,K,L : LongInt;

Begin
  ClrScr;
  RandomIze;
  R.Create;
  P.Create;
  WriteLn ('MemAvail before Initialization = ',MemAvail);
  WriteLn ('Initializing...');
  R.Init (Size,SizeOf(LongInt),MemAvail Div 2,'Test1.dat');
  P.Init (1,1,1,'Test2.dat');
  WriteLn ('Initialization Complete.');
  WriteLn ('MemAvail after Initialization = ',MemAvail);
  WriteLn ('Object size = ',SizeOf(R));

  ClrScr;
  For I := Size-1 downto 0 do
    Begin
      J := I;
      GoToXY (20,13);
      Write ('Loading Element # ',I);
      ClrEol;
      R.Accept (J,I,SizeOf(J))
    End;

  GoToXY (1,14);
  Write ('Press Return to Continue...');
  ReadLn;
  GoToXY (1,14);
  Write ('Copying...');
  ClrEol;
  WriteLn;

  P.Copy (R);

  WriteLn ('MemAvail after Copying = ',MemAvail);
  Write ('Press Return to Continue...');
  ReadLn;
  WriteLn ('Storing Both Arrays...');

  R.Store;
  P.Store;

  WriteLn ('MemAvail after Storing = ',MemAvail);
  Write ('Press Return to Continue...');
  ReadLn;  WriteLn ('Loading Both Arrays...');

  R.Load ('Test1.Dat',SizeOf (LongInt),MemAvail Div 2);
  P.Load ('Test2.Dat',SizeOf(LongInt),MemAvail);

  WriteLn ('MemAvail after Loading = ',MemAvail);
  Write ('Press Return to Continue...');
  ReadLn;
  GoToXY (20,12);
  Write ('500 random accesses.');

  For I := 1 to 500 do
    Begin
      K := Round (Random * (Size-1));
      GoToXY (20,14);
      Write (I);
      GoToXY (20,13);
      P.Retrieve (J,K,SizeOf(J));
      R.Retrieve (L,K,SizeOf(J));
      If (J <> L) or (L <> K) Then
        Begin
          ClrEol;
          Write ('Accessing Element # ',K);
          Write ('  Error at : ',K,' J = ',J,' L = ',L);
          ReadLn
        End
      Else
        Begin
          ClrEol;
          Write ('Accessing Element # ',K);
          Write ('  Element is: ',L:5);
        End
    End;

  GoToXY (1,22);
  Write ('Press Return to Continue...');
  ReadLn;
  WriteLn ('Destroying...');

  R.Destroy;
  P.Destroy;

  WriteLn ('Done. Press Return to Continue...');
  ReadLn
End.

