{***************************************************************************}
{                                                                           }
{  File: BPR.PAS                                                            }
{  Borland Pascal 7.0 Auto corrector                                        }
{                                                                           }
{  Copyright (c) 1994                                                       }
{     Alexander Petrosyan (General idea+BP reverse engineering+programming) }
{     Slava Gostrenko (Fast subwords searching algorithm)                   }
{                                                                           }
{***************************************************************************}

{$IFNDEF DPMI}
  {Target: Protected mode Application}!
{$ENDIF}

{$A+,B-,D+,E-,F+,G+,I-,L+,N-,P-,Q-,R-,S-,T-,V-,X+,Y+}

uses
  Dos,
  Objects,

  WRDList;

type
  TCh = record C: Char; H: Byte end;

  PArr = ^TArr;
  TArr = array [0..26*26] of Integer;

  PCorrectorRec = ^TCorrectorRec;
  TCorrectorRec = record
    ID: Word;
    Sub: string;
  end;

  PCorrectorList = ^TCorrectorList;
  TCorrectorList = object (TWordList)
    IDs: PArr;
    function CreateRec (const S: String): Pointer;
    procedure FreeItem (Item: Pointer); virtual;
    function Compare (Key1, Key2: Pointer): Integer; virtual;
    procedure SetLimit (ALimit: Integer); virtual;
    procedure _Insert (Item: Pointer);
    procedure _AtInsert (Index: Integer; Item: Pointer);
    procedure _AtDelete (Index: Integer);
    procedure _AtFree (Index: Integer);
  end;

var
  WordList: array [MinWordLen..MaxWordLen] of TCorrectorList;
const
  MaxLen: Byte = 0;

{  }

procedure CalcMaxLen;
var
  I: Integer;
begin
  for I := Low (WordList) to High (WordList) do
    if WordList [I].Count <> 0 then MaxLen := I;
end;

{ TCorrectorList }

function TCorrectorList.CreateRec;
var
  CR: PCorrectorRec;
begin
  GetMem (CR, SizeOf (CR^.ID)+1+Length (S));
  CR^.Sub := S;
  CR^.ID :=
    (Byte (LowCase (CR^.Sub [1]))-Byte ('a'))*26  +
     Byte (LowCase (CR^.Sub [2]))-Byte ('a');
  CreateRec := CR;
end;

procedure TCorrectorList.FreeItem;
begin
  with PCorrectorRec (Item)^ do
    FreeMem (PCorrectorRec (Item), SizeOf (ID)+1+Length (Sub));
end;

function TCorrectorList.Compare;
begin
  Compare := inherited Compare (
    @PCorrectorRec (Key1)^.Sub, @PCorrectorRec (Key2)^.Sub);
end;

procedure TCorrectorList.SetLimit;
var
  OldLimit: Integer;
begin
  OldLimit := Limit;

  inherited SetLimit (ALimit);

  if Limit <> OldLimit then
  begin
    if (Limit = 0) and (OldLimit <> 0) then Dispose (IDs);
    if (OldLimit = 0) and (Limit <> 0) then
    begin
      New (IDs);
      FillChar (IDs^, SizeOf (IDs^), 0);
    end;
  end;
end;

procedure TCorrectorList._Insert;
var
  I: Integer;
begin
  if not Search (Item, I) then _AtInsert (I, Item);
end;

procedure TCorrectorList._AtFree;
var
  Item: Pointer;
begin
  Item := At (Index);
  _AtDelete (Index);
  FreeItem (Item);
end;

procedure TCorrectorList._AtInsert;
var
  I: Integer;
begin
  inherited AtInsert (Index, Item);
  for I := PCorrectorRec (Item)^.ID + 1 to High (IDs^) do
    Inc (IDs^ [I]);
end;

procedure TCorrectorList._AtDelete;
var
  I: Integer;
begin
  for I := PCorrectorRec (At (Index))^.ID + 1 to High (IDs^) do
    Dec (IDs^ [I]);
  inherited AtDelete (Index);
end;

{  }

function GetID (const S: string): Word;
begin
  GetID :=
    (Byte (LowCase (S [1]))-Byte ('a'))*26  +
     Byte (LowCase (S [2]))-Byte ('a');
end;

{  }

var
  Old16, Old65, Old66, Old68: procedure;
const
  DoUpdate: Byte = 0;

procedure WriteWordList; forward;

procedure New16 (Flags, CS, IP, AX, BX, CX, DX, SI, Di, DS, ES, BP: Integer); interrupt;
const
  MaxX = 132;
var
  ScreenWidth: ^Word;
  Buf: array [0..MaxX-1] of TCH;
  Cursor: LongInt;

  procedure Clear;
  var
    I: Integer;
  begin
    ScreenWidth := Ptr (Seg0040, $4A);
    for I := 0 to ScreenWidth^-1 do Word (Buf [I]) := $0720;
    Cursor := $06070000;
  end;

  procedure Swap;
  var
    LocalCursor: LongInt;

    procedure DoSwap (var A, B; Size: Word);
    var
      I: Word;
      M: Byte;
    begin
      for I := 0 to Size - 1 do
      begin
        M := TByteArray (A) [I];
        TByteArray (A) [I] := TByteArray (B) [I];
        TByteArray (B) [I] := M;
      end;
    end;

  begin
    asm
      mov  ah, 03
      xor  bh, bh
      int  10h
      mov  WORD PTR LocalCursor [2], cx
      mov  WORD PTR LocalCursor [0], dx
    end;
    DoSwap (Ptr (SegB800, 0)^, Buf, ScreenWidth^ * 2);
    DoSwap (Cursor, LocalCursor, SizeOf (Cursor));
    asm
      mov  ah, 02
      xor  bh, bh
      mov  dx, WORD PTR LocalCursor [0]
      int  10h
      mov  ah, 01
      mov  cx, WORD PTR LocalCursor [2]
      int  10h
    end;
  end;

const
  kbAltBkSp = $0800;
  kbEnter = $1C0D;
  kbCtrlEnter = $1C0A;
  kbShiftIns = $0500;

  kbShiftDel = $0700;
  kbCtrlDel = $0600;
  kbBkSp = $0E08;
  kbCtrlBkSp = $0EF7;
  kbDel0 = $5300;
  kbDel1 = $53E0;
  kbSpace = $3920;
  kbCtrlT = $1414;

  kbAltIns = $A200;
  kbAltDel = $A300;

  BitZ = $40;

const
  InsDel: array [1..2] of string [13] = (
    'Insert word: ',
    'Delete word: ');
  DoInsDel: Integer = 0;

var
  A: TCh absolute AX;
  Flag, Flag1: Boolean;
  S: string;
  CR: PCorrectorRec;
  Index: Integer;

begin
  if A.H = $01 then A.H := $11;
  Flag1 := A.H = $11;
  Flag := A.H in [$00, $10];
  asm
    mov  ax, &ax
    mov  bx, &bx
    mov  cx, &cx
    pushf
    call Old16
    mov  &ax, ax
    pushf
    pop  ax
    mov  Flags, ax
  end;
  if Flag1 and ((Flags and BitZ) = 0) then
  begin
    if Word (AX) = kbAltIns then DoInsDel := 1;
    if Word (AX) = kbAltDel then DoInsDel := 2;
    if DoInsDel <> 0 then
    begin
      asm
        mov  ax, 2
        int  33h
      end;
      Clear;
      Swap;
      Write (InsDel [DoInsDel]);
      ReadLn (S);
      Swap;
      asm
        mov  ax, 1
        int  33h
      end;

      if ValidStr (S) then
        with WordList [Length (S)] do
        begin
          CR := CreateRec (S);
          case DoInsDel of
            1:
            begin
              _Insert (CR);
              WriteWordList;
            end;
            2:
              if Search (CR, Index)
              then
              begin
                _AtFree (Index);
                WriteWordList;
              end
              else
                FreeItem (CR);
          end;
          CalcMaxLen;
        end;

      DoInsDel := 0;
      Flags := Flags or BitZ;
      Exit;
    end;
  end;
  if Flag then
    case AX of
      kbAltBkSp:
        DoUpdate := 4;
      kbEnter,
      kbCtrlEnter,
      kbShiftIns,
{      kbShiftDel,}
      kbCtrlDel,
      kbBkSp,
      kbDel0,
      kbDel1,
      kbCtrlBkSp:
        DoUpdate := 3;
      kbSpace,
      kbCtrlT:
        DoUpdate := 2;
      else
        if not (A.C in [#$00..#$1F, '''', #$E0])
        then DoUpdate := 1
        else DoUpdate := 0;
    end;
end;

var
  {CursorX, }CursorY: ^Integer;
  Y: Byte;

procedure New66 (Flags, CS, IP, AX, BX, CX, DX, SI, DI, DS, ES, BP: Integer); interrupt;
begin
  { 2FBAC }
  asm
    mov  bx,&bp
    les  di,ss:[bx+6]
    mov  &es,es
    mov  &di,di
  end;
  {  }
  CursorY := Ptr (ES, DI+$12+2);
  {CursorX := Ptr (ES, DI+$90);}
end;

procedure New68 (Flags, CS, IP, AX, BX, CX, DX, SI, DI, DS, ES, BP: Integer); interrupt;
begin
  { 238E2 }
  WordRec (AX).Hi := 0;
  {  }
  Y := WordRec (AX).Lo;
end;

var
  PC, PI: array [0..26*26] of Byte;
  PP: array [Byte] of Byte;
  IS: array [Byte] of Word;
  ISCnt: Integer;
  Cnt, Beg: Byte;

procedure New65 (Flags, CS, IP, AX, BX, CX, DX, SI, DI, DS, ES, BP: Integer); interrupt;
const
  ValidLetters = ['a'..'z'];
var
  L, R: Integer;
  M: set of Byte;
  S, C: PChar;

  procedure Analise;

    procedure DoCorrect (var Sub: String);
    label
      Skip;
    var
      P, I, X: Integer;
    begin
      for P := 0 to Cnt-1 do
      begin
        X := L + PP [Beg+P];
        if X+Length (Sub) <= CX then
          if X-L in M then
          begin
            if not (X-L+1 in M) then goto Skip;

            for I := 2 to Length (Sub)-1 do
              if not (X-L+I in M) or
                (LowCase (S [X+I]) <> LowCase (Sub [1+I])) then
                goto Skip;

            Move (Sub [1], S [X], Length (Sub));
            M := M - [X-L..X-L+Length (Sub)-1];
          end;
Skip:
      end;
    end;

  var
    X: Integer;
    C: Word;
    B: Integer;
    Len: Byte;
    Index: Integer;
    ID: Word;
    First: Boolean;
  label
    Found;
  begin
    if L <= R then
    begin
      if R-L > High (Byte)-1 then L := R-(High (Byte)-1);
      M := [0..R-L];

      if L <> R then
      begin
        IS [0] := 26*26;
        ISCnt := 1;
        for X := L to R-1 do
        begin
          C := (Byte (LowCase (S [X]))-Byte ('a'))*26  +
                Byte (LowCase (S [X+1]))-Byte ('a');
          asm
            mov   ax, ds
            mov   es, ax
            mov   di, OFFSET IS
            mov   ax, C
            mov   cx, ISCnt
            cld
            repne scasw
            je    Found
          end;
          IS [ISCnt] := C;
          PI [IS [Pred (ISCnt)]] := 1;

          Inc (ISCnt);
          Continue;
Found:
          asm
            sub   di, 2*2
            mov   di, [di]
            inc   BYTE PTR PI [di]
          end;
        end;
        PI [IS [Pred (ISCnt)]] := 0;

        for B := ISCnt-3 downto 1 do Inc (PI [IS [B]], PI [IS [Succ (B)]]);

        for X := L to R-1 do
        begin
          C := (Byte (LowCase (S [X]))-Byte ('a'))*26  +
                Byte (LowCase (S [X+1]))-Byte ('a');
          PP [PI [C]+PC [C]] := X-L;
          Inc (PC [C]);
        end;

        for Len := MaxLen downto Low (WordList) do
          with WordList [Len] do
            if Count <> 0 then
              for B := 1 to ISCnt-1 do
              begin
                ID := IS [B];
                First := True;
                for Index := IDs^ [ID] to IDs^ [ID+1]-1 do
                begin
                  if First then
                  begin
                    Cnt := PC [ID];
                    Beg := PI [ID];
                    First := False;
                  end;
                  DoCorrect (PCorrectorRec (At (Index))^.Sub);
                end;
              end;

        for B := 1 to ISCnt-1 do
          PC [IS [B]] := 0;
      end;

      for X := L to R do
        if X-L in M then
          S [X] := UpCase (S [X]);
    end;
  end;

const
  IDKeyword = #$03;
  IDNumber = #$07;
  IDIdentifier = #$04;

var
  X: Integer;
  SY: Integer;
  Flag: Word;

begin
  { 23569 }
  DX := 0;
  asm
    mov  bx, &bp
    mov  ax, ss:[bx-24h]
    mov  Flag, ax
  end;
  if (Flag <> 0) and (DoUpdate <> 0) then
  begin
    SY := CursorY^;
    if (((DoUpdate <= 2) and (SY = Y)) or
      ((DoUpdate = 3) and (SY-Y+1 in [0..2])) or
      ((DoUpdate = 4) and (SY-Y in [0, 1]))) and
      (CX <> 0) then
    begin

      S := Ptr (ES, SI);
      C := Ptr (SSeg, Word (Ptr (SSeg, BP-$26)^));

      X := 0;
      while X < CX do
      begin
        if C [X] = IDKeyword then
          S [X] := LowCase (S [X]);

        if C [X] = IDNumber then
          S [X] := UpCase (S [X]);

        if (C [X] = IDIdentifier) and (LowCase (S [X]) in ValidLetters) then
        begin
          L := X;
          while (X < CX) and
            (C [X] = IDIdentifier) and (LowCase (S [X]) in ValidLetters) do
            Inc (X);
          Dec (X);
          R := X;
          Analise;
        end;

        Inc (X);
      end;
    end;
  end;
end;

var
  SearchPath: String;

procedure SetSearchPath;
var
  D: DirStr;
  N: NameStr;
  E: ExtStr;
begin
  FSplit (ParamsTR (0), D, N, E);
  SearchPath := GetEnv ('PATH')+';'+D;
end;

var
  WordListPath: string;

procedure ReadWordList;
var
  F: Text;
  S: string;
  I: Integer;
begin
  FileMode := 0;
  WordListPath := FSearch ('words', SearchPath);
  if WordListPath = '' then
  begin
    WriteLn ('File "WORDS." not found');
    Halt (1);
  end;
  Assign (F, WordListPath);
  ReSet (F);
  if IOResult <> 0 then
  begin
    WriteLn ('Can''t read "', WordListPath, '"');
    Halt (2);
  end;
  for I := Low (WordList) to High (WordList) do
    with WordList [I] do
    begin
      Init (0, 5);
      Duplicates := True;
    end;
  while not EOF (F) do
  begin
    ReadLn (F, S);
    if ValidStr (S) then
      with WordList [Length (S)] do
        _Insert (CreateRec (S));
  end;
  Close (F);
  CalcMaxLen;
end;

procedure WriteWordList;
var
  F: Text;

  procedure DoWrite (var CR: TCorrectorRec);
  begin
    WriteLn (F, CR.Sub);
  end;

var
  S: string;
  I: Integer;
begin
  Assign (F, WordListPath);
  ReWrite (F);
  if IOResult <> 0 then
  begin
    Assign (F, 'words');
    SetFAttr (F, Archive);
    ReWrite (F);
  end;
  if IOResult = 0
  then
  begin
    for I := High (WordList) downto Low (WordList) do
      WordList [I].ForEach (@DoWrite);
    Close (F);
  end
  else
    Write (#7);
end;

function Parameters: string;
var
  Result: string;
  I: Integer;
begin
  Result := '';
  for I := 1 to ParamCount do
    Result := Result + ParamStr (I);
  Parameters := Result;
end;

procedure TypeWordCount;
var
  I: Integer;
  Total: Integer;
begin
  Total := 0;
  for I := Low (WordList) to High (WordList) do
    Inc (Total, WordList [I].Count);
  WriteLn ('Words: ', Total);
end;

var
  BP: string;
  P: procedure;
  AlreadyStarted: Boolean;
  I: Integer;
begin
  FillChar (PC, SizeOf (PC), 0);
  WriteLn ('Auto Corrector  Version 3.0  (c) 1994 Alexander Petrosyan & Slava Gostrenko');
  SetSearchPath;

  BP := FSearch ('bp.xxx', SearchPath);
  if BP = '' then
  begin
    WriteLn ('Can''t locate "BP.XXX".');
    Halt (4);
  end;
  GetIntVec ($16, @P);
  AlreadyStarted := Ofs (P) = Ofs (New16);
  if not AlreadyStarted then
  begin
    ReadWordList;  TypeWordCount;
    GetIntVec ($16, @Old16);  SetIntVec ($16, @New16);
    GetIntVec ($65, @Old65);  SetIntVec ($65, @New65);
    GetIntVec ($66, @Old66);  SetIntVec ($66, @New66);
    GetIntVec ($68, @Old68);  SetIntVec ($68, @New68);
  end;
  SwapVectors;
  Exec (BP, Parameters);
  SwapVectors;
  if DosError <> 0 then
    WriteLn ('Can''t start "', BP, '". ErrorNo: ', DosError);
  if not AlreadyStarted then
  begin
    SetIntVec ($68, @Old68);
    SetIntVec ($66, @Old66);
    SetIntVec ($65, @Old65);
    SetIntVec ($16, @Old16);
    if DosError = 0 then TypeWordCount;
    for I := Low (WordList) to High (WordList) do
      WordList [I].Done;
  end;
end.
