{ test program for displaying PCX file written by WRITE13H.PAS}
{ using standard 256 color VGA mode, 13h; 320x200 }
{ use WRITE13H.PAS prior to running this program }
{ You can replace const: fPcxIn with any PCX file to decode to mode 12h }
uses Crt, graph, uBGI256, uPcxVga, uVga, uPal;

const
	fPcxIn  = 'TEST256.PCX';
	XLoc = 0;
	YLoc = 0;

var
	Adapter: PVga;
	MaxVesaMode: integer;

procedure Pause;
begin
	repeat until keypressed;
	Mem[Seg0040:$1C] := Mem[Seg0040:$1A];
end;

function LoadPcx: integer;
var
	pcx: PPcxDecoder_Vga;
	PicW, PicH: integer;
begin
	LoadPcx := 0;
	pcx := nil;
	pcx := New(PPcxDecoder_Vga, Init(fPcxIn, Adapter));
  if not (pcx = nil) then
  begin
    pcx^.Decode(ToRam);
    if PcxError = PcxError0 then
		begin
    	PicW := pcx^.GetMxX;
    	PicH := pcx^.GetMxY;
      pcx^.Set_Palette;
	    pcx^.Show(New(PPosWin, Init(
				XLoc, YLoc, 0,0,PicW,PicH)));
      Dispose(pcx, Done);
    end;
	end
	else Exit;
	LoadPcx := 1;
end;

begin
	Adapter := New(PVga, Init);
	if Adapter = nil then Halt(0); {no VESA TSR loaded}
	if InitBGI_BGI256 = 0 then Halt(0);
	SetGraphMode(Mode200);
	Adapter^.UpdateVga;
	SetTextStyle(SmallFont, HorizDir, 4);
	if LoadPcx = 0 then
	begin
		Dispose(Adapter, Done);
		Halt(0);
	end;
	Pause;
	Dispose(Adapter, Done);
end.
