{ Demo program for TPPCX-VGA256 to show PCX files in 256 color mode }
{ Load your VESA TSR first if you want high res }
{ Copyright 1994, Mark D. Rafn, MDRUtils(tm) }

program DemoPCX;
uses graph, crt, uPcxVGA, uVesa, uVga, uPal, uBGI256;
{ tabs = 2 }
{
  *** NOTE ***
  A 256 color image displayed in 16 color video mode will use gray scaling.
  A 16 color image displayed in 256 color video mode will sum colors.
  Registered users will be able to manipulate palettes to produce quality
  results.
}

var
	Adapter: PVga;         { VGA object }
	Picx, Picy, PicW, PicH: integer;
	MaxVESAMode: integer;

const
{	BGIRegister = 240;  Vga palette register number }
  NoRegisters = 16;  { number of registers to set  }
  TextX: integer = 10;
  TextY: integer = 10;

{ *** PCX file names to use *** }
	VGAPCX  = 'COLOR256.PCX';
	VESAPCX = 'THECOVER.PCX';

function IntToStr(i: integer): string;
var
	s: string;
begin
	Str(i, s);
	IntToStr := s;
end;

procedure Pause;
begin
  repeat until keypressed;
	MemW[$0000:$041C] := MemW[$0000:$041A]; {clear kbd buffer}
end;

procedure WriteOut(S : string);
begin
  Adapter^.SetColor(255,63,63,63);
  SetColor(BGIRegister + White);
  SetTextStyle(DefaultFont, HorizDir, 1);
  SetTextJustify(LeftText,TopText);
  OutTextxy(Textx, Texty, S);
  Inc(TextY, 15);
end; { WriteOut }

procedure ShowVesa;
var
	 Pcx: PPcxDecoder_VGA; { PCX decoder object }
	 Size: longint;
	 SaveDac: PDac_256;
begin
	WriteOut('VESA mode: ' + IntToStr(GetMaxX+1) +
		'x' + IntToStr(GetMaxY+1) + 'x256');
	Pcx := nil;
	{ create VESA descendant PCX object }
	Pcx := New(PPcxDecoder_VESA, Init(VESAPCX, PVesa(Adapter)));
  { was object created? }
  if not (Pcx = nil) then
  begin
    { decode image to RAM, will automatically decode to disk if no memory }
    Pcx^.Decode(ToRam);
    { decoded OK? }
    if PcxError = PcxError0 then
		begin
      PicW := Pcx^.GetMxX; { width of image }
      PicH := Pcx^.GetMxY; { height of image }
			PicX := (Adapter^.GetMaxX div 2) - (PicW div 2); { center horiz }
			PicY := (Adapter^.GetMaxY div 2) - (PicH div 2); { center vert  }
      { set Vga palette registers to PCX info }
      Pcx^.Set_Palette;
      { show image at x, y, full image - no clipping }
	    Pcx^.Show(New(PPosWin, Init(PicX, PicY, 0, 0, PicW, PicH)));

      { if you want the BGI colors, it is best to relocate them to a high   }
      { register number. Usually a 256 color image does not use the last    }
      { 8 to 16 registers (240-255). And they generally never remap color   }
      { 255. Worst case you can set register 255 to white for your text     }
      { output. Run COLOR256.PCX with the following SetColorBlock proc and  }
      { see what happens. You can play with the beginning register number   }
      { and quantity. I tried BGIRegister=128 and NoRegisters=8 which worked}
			{ fairly well. Note: that you are then limited to 8 known colors,     }
			{ black thru lightgray                                                }

      {comment out if you want all 256 colors un-modified }
      {
      Adapter^.SetColorBlock(BGIRegister, NoRegisters, @Dac16_bgi);
			graph.SetColor(BGIRegister + White);
			}
			Rectangle(Picx -1, Picy-1, Picx + PicW+1, Picy+1 + PicH);
			{ destroy VESA PCX object }
			Dispose(Pcx, Done);

			WriteOut('256 GrayScale, palette loaded.');
			WriteOut('press any key ...');
			WriteOut('');
			Pause;

			{ decode and display new image }

			Pcx := New(PPcxDecoder_VESA, Init(VGAPCX, PVesa(Adapter)));
			Pcx^.Decode(ToRam);
			Pcx^.Show(New(PPosWin, Init(
				PicX + 50, PicY + 50, 0, 0, Pcx^.GetMxX, Pcx^.GetMxY)));
			Pcx^.Set_Palette;
			Dispose(Pcx, Done);

			WriteOut('256 color image, palette loaded.');
			WriteOut('press any key ...');
			WriteOut('');
			Pause;

      { Sum the Vga palette registers to gray }
      Adapter^.SumToGray(0, 256);
      WriteOut('256 colors summed to gray.');
      WriteOut('press any key ...');
    end;
  end;
end;

{also see ShowVESA for further palette information}
procedure ShowVGA;
var
	 Pcx: PPcxDecoder_VGA; { PCX decoder object }
begin
	Pcx := nil;
	{ create a VGA PCX object }
	Pcx := New(PPcxDecoder_VGA, Init(VGAPCX, Adapter));
	{ was object created? }
	if not (Pcx = nil) then
	begin
		{ decode image to RAM, will automatically decode to disk if no memory }
		Pcx^.Decode(ToRam);
		{ decoded OK? }
		if PcxError = PcxError0 then
		begin
			PicW := Pcx^.GetMxX;
			PicH := Pcx^.GetMxY;
			Picx := (Adapter^.GetMaxX div 2) - (PicW div 2);
			Picy := (Adapter^.GetMaxY div 2) - (PicH div 2);
			Pcx^.Set_Palette;
			Pcx^.Show(New(PPosWin, Init(Picx, Picy, 0, 0, PicW, PicH)));
			graph.SetColor(BGIRegister + White);
			Rectangle(Picx -1, Picy-1, Picx + PicW+1, Picy+1 + PicH);
			Dispose(Pcx, Done);
		end;
	end;
end;

begin
	{ is system VGA? }
	if not Vga_Detect then Halt;
	{ next we need a video adapter object, either VESA or VGA }
	{ check first for VESA }
	Adapter := New(PVesa, Init);
	{ is VESA present? }
	if Adapter <> nil then
	begin
		{ VESA is present }
		{ initialize graphics, no other graphics initialization is needed }
		if InitBGI_BGI256 = 0 then Halt(0);
		MaxVesaMode := GetMaxMode;
		SetGraphMode(MaxVesaMode);
		{IMPORTANT! Sync Adapter object to BGI256 driver}
		{The BGI256 driver has one non-Vesa mode, 0 = 320x200 13h}
		PVesa(Adapter)^.SetVesaMode(Vesa_Modes[Equate_VesaMode(MaxVesaMode)]);
		ShowVesa;
		Pause;
	end
	else
	begin
		{ VESA is not supported, use standard VGA 256 mode (13h) }
		writeln('VESA Bios Extensions not detected.');
		writeln('Using VGA mode 13h instead.');
		writeln('press any key ... ');
		Pause;
		Adapter := New(PVga, Init);
		{ initialize graphics}
		InitBGI_BGI256;
		Adapter^.UpdateVga;
		ShowVga;
		Pause;
	end;
	Dispose(Adapter, Done);
end.

