(* ====================================================== *)
(*                       HELPMGR.PAS                      *)
(*     Implementation of the functions of HLPMGR.DLL      *)
(*          Translated to Pascal by wr / toolbox mag      *)
(* ====================================================== *)
{$IFNDEF OS2}
  Error: Wrong target/Compiler not patched
{$ENDIF}

UNIT HelpMgr;

INTERFACE

USES
  Os2Def;


(**********************************************************)
(* HelpSubTable entry structure                           *)
(**********************************************************)

TYPE
  HelpSubTable = INTEGER;

(**********************************************************)
(* HelpTable entry structure                              *)
(**********************************************************)

TYPE
  HelpTable = RECORD   (* ht *)
    idAppWindow      : WORD;
    phstHelpSubTable : ^HelpSubTable;
    idExtPanel       : WORD;
  END;

(**********************************************************)
(* IPF Initialization Structure used on the               *)
(* WinCreateHelpInstance() call.                          *)
(**********************************************************)

TYPE
  HelpInit = RECORD  (* hinit *)
    cb                       : WORD;
    ulReturnCode             : LongInt;
    pszTutorialName          : pChar;
    phtHelpTable             : ^HelpTable;
    hmodHelpTableModule      : hModule;
    hmodAccelActionBarModule : hModule;
    idAccelTable             : WORD;
    idActionBar              : WORD;
    pszHelpWindowTitle       : pChar;
    usShowPanelId            : WORD;
    pszHelpLibraryName       : pChar;
  END;


(**********************************************************)
(* Search parent chain indicator for                      *)
(* HM_SET_ACTIVE_WINDOW message.                          *)
(**********************************************************)

CONST
  HWND_PARENT  = 0;

(**********************************************************)
(* Constants used to define whether user wants to display *)
(*  panel using panel number or panel name.               *)
(**********************************************************)

CONST
  HM_RESOURCEID      = 0;
  HM_PANELNAME       = 1;

  HMPANELTYPE_NUMBER = 0;
  HMPANELTYPE_NAME   = 1;

(**********************************************************)
(* Constants used to define the how the panel IDs are     *)
(* displayed on help panels.                              *)
(**********************************************************)

CONST
  CMIC_HIDE_PANEL_ID    = $0000;
  CMIC_SHOW_PANEL_ID    = $0001;
  CMIC_TOGGLE_PANEL_ID  = $0002;

(**********************************************************)
(* Window Help function declarations.                     *)
(**********************************************************)

FUNCTION WinDestroyHelpInstance(a : hWnd): BOOL;

FUNCTION WinCreateHelpInstance(a: HAB; b: HelpInit): hWnd;

FUNCTION WinAssociateHelpInstance(a : hWnd; b: hWnd): BOOL;

FUNCTION WinQueryHelpInstance(a : hWnd): hWnd;

FUNCTION WinLoadHelpTable(a : hWnd;
                          b : WORD;
                          d : hModule) : BOOL;

FUNCTION WinCreateHelpTable(a : hWnd;
                            b : HelpTable) : BOOL;

(**********************************************************)
(* IPF message base.                                      *)
(**********************************************************)

CONST
  HM_MSG_BASE               = $0220;

(**********************************************************)
(* Messages applications can send to the IPF.             *)
(**********************************************************)

CONST
  HM_DISMISS_WINDOW         = HM_MSG_BASE + $0001;
  HM_DISPLAY_HELP           = HM_MSG_BASE + $0002;
  HM_EXT_HELP               = HM_MSG_BASE + $0003;
  HM_SET_ACTIVE_WINDOW      = HM_MSG_BASE + $0004;
  HM_LOAD_HELP_TABLE        = HM_MSG_BASE + $0005;
  HM_CREATE_HELP_TABLE      = HM_MSG_BASE + $0006;
  HM_SET_HELP_WINDOW_TITLE  = HM_MSG_BASE + $0007;
  HM_SET_SHOW_PANEL_ID      = HM_MSG_BASE + $0008;
  HM_REPLACE_HELP_FOR_HELP  = HM_MSG_BASE + $0009;
  HM_HELP_INDEX             = HM_MSG_BASE + $000A;
  HM_HELP_CONTENTS          = HM_MSG_BASE + $000B;
  HM_KEYS_HELP              = HM_MSG_BASE + $000C;
  HM_SET_HELP_LIBRARY_NAME  = HM_MSG_BASE + $000D;

(**********************************************************)
(* Messages the IPF sends to the applications active      *)
(* window as defined by the IPF.                          *)
(**********************************************************)

CONST
  HM_ERROR                  = HM_MSG_BASE + $000E;
  HM_HELPSUBITEM_NOT_FOUND  = HM_MSG_BASE + $000F;
  HM_QUERY_KEYS_HELP        = HM_MSG_BASE + $0010;
  HM_TUTORIAL               = HM_MSG_BASE + $0011;
  HM_EXT_HELP_UNDEFINED     = HM_MSG_BASE + $0012;
  HM_ACTIONBAR_COMMAND      = HM_MSG_BASE + $0013;
  HM_INFORM                 = HM_MSG_BASE + $0014;

(**********************************************************)
(* HMERR_NO_FRAME_WND_IN_CHAIN - There is no frame window *)
(* in the window chain from which to find or set the      *)
(* associated help instance.                              *)
(**********************************************************)

CONST
  HMERR_NO_FRAME_WND_IN_CHAIN  = $00001001;

(**********************************************************)
(* HMERR_INVALID_ASSOC_APP_WND - The application window   *)
(* handle specified on the WinAssociateHelpInstance()     *)
(* call is not a valid window handle.                     *)
(**********************************************************)

CONST
  HMERR_INVALID_ASSOC_APP_WND = $00001002;

(**********************************************************)
(* HMERR_INVALID_ASSOC_HELP_INST - The help instance      *)
(* handle specified on the WinAssociateHelpInstance()     *)
(* call is not a valid window handle.                     *)
(**********************************************************)

CONST
  HMERR_INVALID_ASSOC_HELP_INST = $00001003;

(**********************************************************)
(* HMERR_INVALID_DESTROY_HELP_INST - The window handle    *)
(* specified as the help instance to destroy is not of    *)
(* the help instance class.                               *)
(**********************************************************)

CONST
  HMERR_INVALID_DESTROY_HELP_INST  = $00001004;

(**********************************************************)
(* HMERR_NO_HELP_INST_IN_CHAIN - The parent or owner      *)
(* chain of the application window specified does not     *)
(* have a help instance associated with it.               *)
(**********************************************************)

CONST
  HMERR_NO_HELP_INST_IN_CHAIN  = $00001005;

(**********************************************************)
(* HMERR_INVALID_HELP_INSTANCE_HDL - The handle specified *)
(* to be a help instance does not have the class name of  *)
(* a IPF help instance.                                   *)
(**********************************************************)

CONST
  HMERR_INVALID_HELP_INSTANCE_HDL  = $00001006;

(**********************************************************)
(* HMERR_INVALID_QUERY_APP_WND - The application window   *)
(* specified on a WinQueryHelpInstance() call is not a    *)
(* valid window handle.                                   *)
(**********************************************************)

CONST
  HMERR_INVALID_QUERY_APP_WND = $00001007;

(**********************************************************)
(* HMERR_HELP_INST_CALLED_INVALID -  The handle of the    *)
(* help instance specified on an API call to the IPF does *)
(* not have the class name of an IPF help instance.       *)
(**********************************************************)

CONST
  HMERR_HELP_INST_CALLED_INVALID   = $00001008;
  HMERR_HELPTABLE_UNDEFINE         = $00001009;
  HMERR_HELP_INSTANCE_UNDEFINE     = $0000100A;
  HMERR_HELPITEM_NOT_FOUND         = $0000100B;
  HMERR_INVALID_HELPSUBITEM_SIZE   = $0000100C;
  HMERR_HELPSUBITEM_NOT_FOUND      = $0000100D;

(**********************************************************)
(* HMERR_INDEX_NOT_FOUND - No index in library file.      *)
(**********************************************************)

CONST
  HMERR_INDEX_NOT_FOUND = $00002001;

(**********************************************************)
(* HMERR_CONTENT_NOT_FOUND -                              *)
(* Library file does not have any content                 *)
(**********************************************************)

CONST
  HMERR_CONTENT_NOT_FOUND = $00002002;

(**********************************************************)
(* HMERR_OPEN_LIB_FILE     - Cannot open library file     *)
(**********************************************************)

CONST
  HMERR_OPEN_LIB_FILE = $00002003;

(**********************************************************)
(* HMERR_READ_LIB_FILE     - Cannot read library file     *)
(**********************************************************)

CONST
  HMERR_READ_LIB_FILE = $00002004;

(**********************************************************)
(* HMERR_CLOSE_LIB_FILE    - Cannot close library file    *)
(**********************************************************)

CONST
  HMERR_CLOSE_LIB_FILE = $00002005;

(**********************************************************)
(* HMERR_INVALID_LIB_FILE - Improper library file         *)
(* provided                                               *)
(**********************************************************)

CONST
  HMERR_INVALID_LIB_FILE  = $00002006;

(**********************************************************)
(* HMERR_NO_MEMORY - Unable to allocate the requested     *)
(*  amount of memory                                      *)
(**********************************************************)

CONST
  HMERR_NO_MEMORY = $00002007;

(**********************************************************)
(* HMERR_ALLOCATE_SEGMENT - Unable                        *)
(* to allocate a segment of memory for memory allocation  *)
(* requested                                              *)
(* from the IPF.                                          *)
(**********************************************************)

CONST
  HMERR_ALLOCATE_SEGMENT = $00002008;

(**********************************************************)
(* HMERR_FREE_MEMORY - Unable to free allocated  memory.  *)
(**********************************************************)

CONST
  HMERR_FREE_MEMORY = $00002009;

(**********************************************************)
(* HMERR_PANEL_NOT_FOUND  - Unable                        *)
(* to find a help panel requested to IPF.                 *)
(**********************************************************)

CONST
  HMERR_PANEL_NOT_FOUND = $00002010;

(**********************************************************)
(* HMERR_DATABASE_NOT_OPEN - Unable to read the unopened  *)
(* database.                                              *)
(**********************************************************)

CONST
  HMERR_DATABASE_NOT_OPEN = $00002011;

IMPLEMENTATION

  FUNCTION WinCreateHelpInstance;
    EXTERNAL 'HELPMGR' INDEX 1;

  FUNCTION WinDestroyHelpInstance;
    EXTERNAL 'HELPMGR' INDEX 2;

  FUNCTION WinQueryHelpInstance; EXTERNAL 'HELPMGR' INDEX 3;

  FUNCTION WinAssociateHelpInstance;
    EXTERNAL 'HELPMGR' INDEX 4;

  FUNCTION WinLoadHelpTable;     EXTERNAL 'HELPMGR' INDEX 5;

  FUNCTION WinCreateHelpTable;   EXTERNAL 'HELPMGR' INDEX 6;

END.

(* ====================================================== *)
(*                   Ende von HELPMGR.PAS                 *)
