(* ====================================================== *)
(*                       DOSCALLS.PAS                     *)
(*     Implementation of the functions of DOSCALLS.DLL    *)
(*        Translation to Pascal by wr+jb/toolbox mag      *)
(* ====================================================== *)
{$IFNDEF OS2}
  Error: Wrong target/Compiler not patched
{$ENDIF}

UNIT DosCalls;

INTERFACE

USES
  Os2Def;

TYPE
  hModule = WORD;

(* Strings are passed to the dos functions by address, and are assiiz, *)
(* that is termianted by a 0C.  You can pass a Modula-2 string by      *)
(* using the ADR function from SYSTEM.  When constructing strings to   *)
(* pass to OS2 procedures, be sure to leave enough space in the string *)
(* for the 0C terminator.  Normally, the terminator will be put in by  *)
(* by the assignment of any string shorter than the variable being     *)
(* assigned to.                                                        *)



(* The record used to get and set the date and time *)

  DateTime = RECORD
    hours               : CHAR;
    Minutes             : CHAR;
    Seconds             : CHAR;
    hundreths           : CHAR;
    day                 : CHAR;
    Month               : BYTE;
    year                : WORD;
    timezone            : INTEGER;
    Weekday             : BYTE;
    END;

(* The record returned by DosQFSInfo *)

  FsData = RECORD
    id                  : LongInt;
    SectorsPerUnit      : LongInt;
    Units               : LongInt;
    UnitsAvailable      : LongInt;
    BytesPerSector      : WORD;
  END;

(* The exection flags for DosExecPgm.  These determine    *)
(* how the program is executed                            *)

CONST
  EXEC_SYNC          = 0; (* execute synchonously, result code returned *)
  EXEC_ASYNC         = 1; (* execute asynchronously and discard result code *)
  EXEC_ASYNCRESULT   = 2; (* execute asynchronously and save result code *)
  EXEC_TRACE         = 3; (* execute under trace control - for debuggers *)
  EXEC_BACKGROUND    = 4; (* execute as a background process *)
  EXEC_LOAD          = 5; (* not documented but in the C headers *)
                     (* not in C headers any more *)

(* The result code of a child process returned by  *)
(* DosExecPgm and DosCWait                         *)
TYPE
  ResultCodes = RECORD
    CASE WORD OF
      EXEC_SYNC       : (codeTerminate    : WORD ;
                         codeResult       : WORD);
{ELSE}EXEC_ASYNC,
      EXEC_ASYNCRESULT,
      EXEC_TRACE      ,
      EXEC_BACKGROUND ,
      EXEC_LOAD       : (ProcessID : WORD); (* see above *)
  END;

(* The termination type codes for DosExecPgm *)

CONST
  TC_EXIT             = 0;
  TC_HARDERROR        = 1;
  TC_TRAP             = 2;
  TC_KILLPROCESS      = 3;


(* Global info seg.   Use DosGetInfoSet to get it's selector *)

TYPE
  GInfoSeg = RECORD
    time                : LongInt;
    mSecs               : LongInt;
    hour                : CHAR;
    Minutes             : CHAR;
    Seconds             : CHAR;
    hundreths           : CHAR;
    timezone            : WORD;
    cusecTimeInterval   : WORD;
    day                 : CHAR;
    Month               : CHAR;
    year                : WORD;
    Weekday             : CHAR;
    uchMajorVersion     : CHAR;
    uchMinorVersion     : CHAR;
    chRevisionLetter    : CHAR;
    sgCurrent           : CHAR;
    sgMax               : CHAR;
    cHugeShift          : CHAR;
    fProtectModeOnly    : BOOLEAN;
    pidForeground       : WORD;
    fDynamicSched       : BOOLEAN;
    csecMaxWait         : CHAR;
    cmsecMinSlice       : WORD;
    cmsecMaxSlice       : WORD;
    bootdrive           : WORD;
    amedRAS             : ARRAY [0..31] OF CHAR;
    csgWindowableVioMax : CHAR;
    csgPMMax            : CHAR;
  END;

(* Local info segment.  Use DosGetInfoSeg to get it's selector *)

 LInfoSeg = RECORD
  pidCurrent          : WORD;
  pidParent           : WORD;
  ptryCurrent         : WORD;
  tidCurrent          : WORD;
  sgCurrent           : WORD;
  rfProcStatus        : CHAR;
  dummy1              : CHAR;
  fForeground         : WORD;
  typeProcess         : CHAR;
  dummy2              : CHAR;
  selEnvironment      : WORD;
  offCmdLine          : WORD;
  cbDataSegment       : WORD;
  cbStack             : WORD;
  cbHeap              : WORD;
  hMod                : hModule;
  selDS               : WORD;
END;

CONST
  PT_FULLSCREEN       = #0;
  PT_REALMODE         = #1;
  PT_WINDOWABLEVIO    = #2;
  PT_PM               = #3;
  PT_DETACHED         = #4;

  PS_EXITLIST         = #1;


(* The sharable flag for memory allocation, the constants below *)
(* correspond to the values in the Microsoft documentation *)

(* Allocate a huge ( > 64K ) block of memory *)

FUNCTION DosAllocHuge(
    NumSeg              : WORD;     (* Number of segments to alloc  *)
    PartialSeg          : WORD;     (* Size of last segment, 0 => 64K *)
    VAR Sel             : WORD;     (* Returned selector *)
    MaxNumSeg           : WORD;     (* Max size it can be realloced to *)
    flags               : WORD      (* Sharing and discardable flags *)
    ) : WORD;
FUNCTION Dos16AllocHuge(
    NumSeg              : WORD;     (* Number of segments to alloc  *)
    PartialSeg          : WORD;     (* Size of last segment, 0 => 64K *)
    VAR Sel             : WORD;     (* Returned selector *)
    MaxNumSeg           : WORD;     (* Max size it can be realloced to *)
    flags               : WORD      (* Sharing and discardable flags *)
    ) : WORD;

(* Allocate a segment of 1 to 65536 bytes *)

FUNCTION DosAllocSeg(
    Size                : WORD;     (* Size in bytes, 0 => 64K *)
    VAR Sel             : WORD;     (* Returned selector *)
    flags               : WORD      (* See above *)
    ) : WORD;
FUNCTION Dos16AllocSeg(
    Size                : WORD;     (* Size in bytes, 0 => 64K *)
    VAR Sel             : WORD;     (* Returned selector *)
    flags               : WORD      (* See above *)
    ) : WORD;

(* Allocate a shared segment *)

FUNCTION DosAllocShrSeg(
    Size        : WORD;    (* Size in bytes 0 => 65536 *)
    SegName     : pChar;   (* name of the form: \SHAREMEM\name *)
    VAR Sel     : WORD     (* returned selector *)
    ) : WORD;
FUNCTION Dos16AllocShrSeg(
    Size        : WORD;    (* Size in bytes 0 => 65536 *)
    SegName     : pChar;   (* name of the form: \SHAREMEM\name *)
    VAR Sel     : WORD     (* returned selector *)
    ) : WORD;

(* flush buffers for a file or for all files *)

FUNCTION DosBufReset(
    Handle      : WORD   (* file handle or 0FFFFH to flush all *)
    ) : WORD;
FUNCTION Dos16BufReset(
    Handle      : WORD   (* file handle or 0FFFFH to flush all *)
    ) : WORD;

(* change current directory *)

FUNCTION DosChDir(DirPath   : pChar;   (* new directory path *)
                  Reserved  : LongInt   (* must be zero *)
                          ) : WORD;
FUNCTION Dos16ChDir(DirPath : pChar;   (* new directory path *)
                    Reserved: LongInt   (* must be zero *)
                          ) : WORD;

(* change file pointer *)

(* use this call also to get current position by using:  *)
(*                                                       *)
(*     DosChgFilePtr(handle, 0, FromCurrent, newpos)     *)
(*                                                       *)
(* and to get the length of the file by:                 *)
(*                                                       *)
(*     DosChgFilePtr(handle, 0, FromEnd, newpos)         *)

FUNCTION DosChgFilePtr(Handle      : WORD;  (* file handle to position *)
                       Distance    : LongInt;   (* number of bytes to move *)
                       Method      : WORD;  (* starting position, see above *)
                       VAR NewPtr  : LongInt    (* returned position *)
                                 ) : WORD;
FUNCTION Dos16ChgFilePtr(Handle      : WORD;  (* file handle to position *)
                         Distance    : LongInt;   (* number of bytes to move *)
                         Method      : WORD;  (* starting position, see above *)
                         VAR NewPtr  : LongInt    (* returned position *)
                                   ) : WORD;

(* request CLI / STI privilege *)

FUNCTION DosCLIAccess  : WORD;
FUNCTION Dos16CLIAccess: WORD;

(* close a file handle *)

FUNCTION DosClose(HFile: WORD   (* handle returned by create or open file *)
                     ) : WORD;
FUNCTION Dos16Close(HFile : WORD   (* handle returned by create or open file *)
                        ) : WORD;

CONST
  SEG_NON_SHARABLE    = 0;
  SEG_GIVEABLE        = 1;
  SEG_GETTABLE        = 2;
  SEG_DISCARDABLE     = 4;


(* The following structures are used in the            *)
(* DosMuxSemWait call to wait for one of several       *)
(* semaphores.  The sem list is actually contains      *)
(* only as many semaphores as needed.  You should      *)
(* allocate it to the needed length                    *)

TYPE
  MUXSEM = RECORD
    zero    : WORD;         (* must be zero *)
    hSEM    : SemaPhore;    (* the semaphore *)
  END;
    
  MUXSemList = RECORD
    cmxs  : WORD;                (* number of semaphores *)
    amxs  : ARRAY [0..15] OF MUXSEM; (* the list of them *)
  END;


(* close a semaphore *)

FUNCTION DosCloseSem(  hSEM : SemaPhore    (* handle of the semaphore *)
                           ) : WORD;
FUNCTION Dos16CloseSem(hSEM : SemaPhore    (* handle of the semaphore *)
                           ) : WORD;

(* create a code selector for a data segment *)

FUNCTION DosCreateCSAlias(
                          DataSegment     : WORD;  (* selector of the data segment *)
                          VAR CodeSegment : WORD   (* returned code segment alias selector *)
                          ) : WORD;

FUNCTION Dos16CreateCSAlias(
                                DataSegment   : WORD;  (* selector of the data segment *)
                            VAR CodeSegment   : WORD   (* returned code segment alias selector *)
                                             ) : WORD;

FUNCTION DosCreateSem(
                       NoExclusive   : WORD;(* do not want exclusive access *)
                       VAR SemHandle : SemaPhore;   (* handle for the semaphore *)
                       SemName       : pChar       (* name of the semaphore *)
                       ) : WORD;
FUNCTION Dos16CreateSem(
                         NoExclusive   : WORD;(* do not want exclusive access *)
                         VAR SemHandle : SemaPhore;   (* handle for the semaphore *)
                         SemName       : pChar       (* name of the semaphore *)
                         ) : WORD;

(* create a new thread of execution *)

(* wait for completion of child process *)

CONST
  DCWA_PROCESS        = 0;
  DCWA_PROCESSTREE    = 1;

  DCWW_WAIT           = 0;
  DCWW_NOWAIT         = 1;

FUNCTION DosCWait(    Scope       : WORD;     (* single process or entire tree *)
                       NoWait      : WORD;    (* wait for completion or not *)
                   VAR Results     : ResultCodes;  (* Return code of the completed process *)
                   VAR ProcessID   : WORD;     (* Process ID of completed process *)
                       WaitProcess : WORD      (* Process ID, 0 => any child process *)
                                 ) : WORD;
FUNCTION Dos16CWait(    Scope         : WORD;     (* single process or entire tree *)
                         NoWait        : WORD;    (* wait for completion or not *)
                     VAR Results       : ResultCodes;  (* Return code of the completed process *)
                     VAR ProcessID     : WORD;     (* Process ID of completed process *)
                         WaitProcess   : WORD      (* Process ID, 0 => any child process *)
                                     ) : WORD;

(* delete a file *)

FUNCTION DosDelete(Name    : pChar;       (* name of file to delete *)
                    Reserved: LongInt       (* must be zero *)
                          ) : WORD;
FUNCTION Dos16Delete(Name    : pChar;       (* name of file to delete *)
                      Reserved: LongInt       (* must be zero *)
                            ) : WORD;

(* get information about hardware configuration *)

CONST
  NumPrinters      = 0;
  NumRS232         = 1;
  NumFloppy        = 2;
  Coprocessor      = 3;
  PCSubmodel       = 4;
  PCModel          = 5;
  PrimaryDisplay   = 6;

FUNCTION DosDevConfig(VAR DeviceInfo  : BYTE;         (* returned info *)
                           Item        : WORD;     (* item requested, see above *)
                           Parameter   : WORD      (* reserved, must be zero *)
                                      ): WORD;
FUNCTION Dos16DevConfig(VAR DeviceInfo  : BYTE;         (* returned info *)
                             Item        : WORD;     (* item requested, see above *)
                             Parameter   : WORD      (* reserved, must be zero *)
                                        ): WORD;

(* perform I/O control functions on devices.  This function sends *)
(* or requests information from a device driver.  The format of the *)
(* information request and data are device dependent *)

FUNCTION DosDevIOCtl(
    Data                : Pointer;      (* address of data buffer *)
    ParamList           : Pointer;      (* command specific arguments *)
    aFunction           : WORD;     (* device specific function code *)
    Category            : WORD;     (* device category *)
    Handle              : WORD      (* handle for the device *)
    ) : WORD;
FUNCTION Dos16DevIOCtl(
    Data                : Pointer;      (* address of data buffer *)
    ParamList           : Pointer;      (* command specific arguments *)
    aFunction           : WORD;     (* device specific function code *)
    Category            : WORD;     (* device category *)
    Handle              : WORD      (* handle for the device *)
    ) : WORD;

(* Duplicate a file handle *)

FUNCTION DosDupHandle(
    oldHandle           : WORD;     (* old file handle *)
    VAR newHandle       : WORD      (* new handle or 0FFFF for next *)
    ) : WORD;
FUNCTION Dos16DupHandle(
    oldHandle           : WORD;     (* old file handle *)
    VAR newHandle       : WORD      (* new handle or 0FFFF for next *)
    ) : WORD;

(* Temporarily suspend activity of all other threads.  This call must *)
(* be used when manipulating data global to multiple threads.  You must *)
(* call DosExitCritSec when you are finished *)

PROCEDURE DosEnterCritSec;
PROCEDURE Dos16EnterCritSec;

(* Classify an error.  The values returned are defined in Os2Error.DEF *)

FUNCTION DosErrClass {139} (
    Code                : WORD;     (* the error code to classify *)
    VAR Class           : WORD;     (* the returned error class *)
    VAR Action          : WORD;     (* the recommended action *)
    VAR Locus           : WORD      (* the error locus *)
    ) : WORD;
FUNCTION Dos16ErrClass {139} (
    Code                : WORD;     (* the error code to classify *)
    VAR Class           : WORD;     (* the returned error class *)
    VAR Action          : WORD;     (* the recommended action *)
    VAR Locus           : WORD      (* the error locus *)
    ) : WORD;

(* Control hard error processing.  If suspended, all hard errors are *)
(* returned to the process, dos does not intervene *)

CONST
    DisableHard         = 0;
    EnableHard          = 1;
    DisableException    = 2;

FUNCTION DosError {120} (
    Flag                : WORD      (* see above values *)
    ) : WORD;
FUNCTION Dos16Error {120} (
    Flag                : WORD      (* see above values *)
    ) : WORD;

(* execute a program *)

FUNCTION DosExecPgm {'DOSCALLS@144'} (
    FailName            : Pointer;      (* address of buffer to receive name *)
    FailNameLength      : WORD;     (* length of above buffer *)
    ExecFlags           : WORD;    (* see above *)
    Args                : pChar;       (* command arguments *)
    Environment         : Pointer;      (* Environent address or 0 to inherit *)
    VAR Results         : ResultCodes;  (* Return codes from program *)
    PgmName             : pChar        (* name of the program to execute *)
    ) : WORD;
FUNCTION Dos16ExecPgm {'DOSCALLS@144'} (
    FailName            : Pointer;      (* address of buffer to receive name *)
    FailNameLength      : WORD;     (* length of above buffer *)
    ExecFlags           : WORD;    (* see above *)
    Args                : pChar;       (* command arguments *)
    Environment         : Pointer;      (* Environent address or 0 to inherit *)
    VAR Results         : ResultCodes;  (* Return codes from program *)
    PgmName             : pChar        (* name of the program to execute *)
    ) : WORD;

(* Terminate a thread *)

CONST
  EXIT_THREAD         = 0;
  EXIT_PROCESS        = 1;

(* resume execution of other threads *)
PROCEDURE DosExitCritSec {6};
PROCEDURE Dos16ExitCritSec {'DOSCALLS@6};
(* Maintain a list of procedures to be called when terminating *)
CONST
    EXLST_ADD           = 1;            (* add an exit procedure *)
    EXLST_REMOVE        = 2;            (* remove an exit procedure *)
    EXLST_EXIT          = 3;            (* exit from an exit procedure *)

(* Define a type for the termination procedure.  The parameter is *)
(* the termination reason *)

TYPE
  TermProc = FUNCTION: WORD{ [LONG, LOADDS]};

FUNCTION DosExitList {7} (
    FnCode              : WORD;     (* function, see above type *)
    RtnAddress          : TermProc      (* the procedure *)
    ) : WORD;
FUNCTION Dos16ExitList {7} (
    FnCode              : WORD;     (* function, see above type *)
    RtnAddress          : TermProc      (* the procedure *)
    ) : WORD;

(* Manage file locks *)

TYPE
  LockRange = RECORD
    FileOffset          : LongInt;      (* offset of start of range *)
    RangeLength         : LongInt;      (* length of range in bytes *)
  END;

FUNCTION DosFileLocks {62} (
    FileHandle          : WORD;     (* handle for the file *)
    UnlockRange         : LockRange;    (* range to unlock *)
    LockRange           : LockRange     (* range to lock *)
    ) : WORD;
FUNCTION Dos16FileLocks {62} (
    FileHandle          : WORD;     (* handle for the file *)
    UnlockRange         : LockRange;    (* range to unlock *)
    LockRange           : LockRange     (* range to lock *)
    ) : WORD;

(* closes the handle used for DosFindFirst and DosFindNext *)

FUNCTION DosFindClose {63} (
    DirHandle           : WORD      (* DosFind handle *)
    ) : WORD;
FUNCTION Dos16FindClose {63} (
    DirHandle           : WORD      (* DosFind handle *)
    ) : WORD;


TYPE
  FileAttribute =
    (faReadOnly, faHidden, faSystem, faVolumeLabel, faDirectory, faArchive,
     Att40, Att80, Att100, Att200, Att400, Att800, Att1000,
     Att2000, Att4000, Att8000);

  AttributeSet = SET OF FileAttribute;

(* This is the record type returned by DosFindFirst and DosFindNext *)
(* Actually, they can return multiple files at once, with the name portion *)
(* being variable in length.  This record will work fine, if you request *)
(* one file at a time *)

CONST
  FIO_LOCK            = 0;
  FIO_UNLOCK          = 1;
  FIO_SEEK            = 2;
  FIO_READ            = 3;
  FIO_WRITE           = 4;

  FIO_NOSHARE         = 0;
  FIO_SHAREREAD       = 1;

TYPE
  FioLockCmd = RECORD
    usCmd           : WORD;
    cLockCnt        : WORD;
    cTimeOut        : LongInt{LONGCARD};
  END;

  FioLockRec = RECORD
    fShare          : WORD;
    cbStart         : LongInt{LONGCARD};
    cbLength        : LongInt{LONGCARD};
  END;
        
  FioUnlockCmd = RECORD
    usCmd           : WORD;
    cUnlockCnt      : WORD;
  END;

  FioUnlockRec = RECORD
    cbStart         : LongInt{LONGCARD};
    cbLength        : LongInt{LONGCARD};
  END;

  FioSeekCmd = RECORD
    usCmd           : WORD;
    fsMethod        : WORD;
    cbDistance      : LongInt{LONGCARD};
    cbNewPosition   : LongInt{LONGCARD};
  END;

  FioReadWrite = RECORD
    usCmd           : WORD;
    pbBuffer        : Pointer;
    cbBufferLen     : WORD;
    cbActualLen     : WORD;
  END;

CONST
  FIL_STANDARD        = 1;
  FIL_QUERYEASIZE     = 2;
  FIL_QUERYEAFROMLIST = 3;

  FIL_QUERYFULLNAME   = 5;
  FIL_NAMEISVALID     = 6;

  FNOTIL_STANDARD     = 1;

  FSATTACH            = 0;
  FSDETACH            = 1;

  FSCTL_HANDLE        = 1;
  FSCTL_PATHNAME      = 2;
  FSCTL_FSDNAME       = 3;

  FSAIL_QUERYNAME     = 1;
  FSAIL_DEVNUMBER     = 2;
  FSAIL_DRVNUMBER     = 3;

  FSAT_CHARDEV        = 1;
  FSAT_PSEUDODEV      = 2;
  FSAT_LOCALDRV       = 3;
  FSAT_REMOTEDRV      = 4;

TYPE
  FQSBuffer = RECORD
    iType           : WORD;
    cbName          : WORD;
    szName          : ARRAY [0..0] OF CHAR;
    cbFSDName       : WORD;
    szFSDName       : ARRAY [0..0] OF CHAR;
    cbFSAData       : WORD;
    rgFSAData       : ARRAY [0..0] OF CHAR;
  END;

CONST
  FSIL_ALLOC          = 1;
  FSIL_VOLSER         = 2;

  HANDTYPE_FILE       = 0;
  HANDTYPE_DEVICE     = 1;
  HANDTYPE_PIPE       = 2;
  HANDTYPE_NETWORK    = $8000;

  FHT_DISKFILE        = 0;
  FHT_CHRDEV          = 1;
  FHT_PIPE            = 2;

  FHB_DSKREMOTE       = $8000;
  FHB_CHRDEVREMOTE    = $8001;
  FHB_PIPEREMOTE      = $8002;

  CCHMAXPATH          = 260;
  CCHMAXPATHCOMP      = 256;

TYPE
  fTime       = WORD;
  fDate       = WORD;

  FileFindBuf = RECORD
    fDateCreation           : fDate;
    fTimeCreation           : fTime;
    fDateLastAccess         : fDate;
    fTimeLastAccess         : fTime;
    fDateLastWrite          : fDate;
    fTimeLastWrite          : fTime;
    cbFile                  : LongInt{LONGCARD};
    cbFileAlloc             : LongInt{LONGCARD};
    attrFile                : WORD;
    cchName                 : CHAR;
    achName                 : ARRAY [0..12] OF CHAR;
  END;

  FileFindBuf2 = RECORD
    fDateCreation           : fDate;
    fTimeCreation           : fTime;
    fDateLastAccess         : fDate;
    fTimeLastAccess         : fTime;
    fDateLastWrite          : fDate;
    fTimeLastWrite          : fTime;
    cbFile                  : LongInt{LONGCARD};
    cbFileAlloc             : LongInt{LONGCARD};
    attrFile                : WORD;
    cbList                  : LongInt{LONGCARD};
    cchName                 : CHAR;
    achName                 : ARRAY [0..CCHMAXPATHCOMP-1] OF CHAR;
  END;

  Gea = RECORD
    cbName  : CHAR;
    szName  : ARRAY [0..0] OF CHAR;
  END;

  GeaList = RECORD
    cbList  : LongInt{LONGCARD};
    list    : ARRAY [0..0] OF Gea;
  END;

  Fea = RECORD
    Fea     : CHAR;
    cbName  : CHAR;
    cbValue : WORD;
  END;

CONST
  FEA_NEEDEA  = $80;

TYPE
  FEALIST = RECORD
    cbList  : LongInt{LONGCARD};
    list    : ARRAY [0..0] OF Fea;
  END;

  EaOp = RECORD
    fpGeaList       : ^GeaList;
    fpFeaList       : ^FEALIST;
    oError          : LongInt{LONGCARD};
  END;

CONST
  EAT_BINARY          = $0FFFE;
  EAT_ASCII           = $0FFFD;
  EAT_BITMAP          = $0FFFB;
  EAT_METAFILE        = $0FFFA;
  EAT_ICON            = $0FFF9;
  EAT_EA              = $0FFEE;
  EAT_MVMT            = $0FFDF;
  EAT_MVST            = $0FFDE;
  EAT_ANS1            = $0FFDD;


(* find first file matching a wildcard file spec *)

FUNCTION DosFindFirst {64} (
    Name                : pChar;       (* the file name, * and ? allowed *)
    VAR Handle          : WORD;     (* handle, 0FFFF means allocate one *)
    attribute           : AttributeSet; (* attributes to match *)
    VAR ResultBuf       : FileFindBuf;  (* returned file information *)
    ResultBufLen        : WORD;     (* length of result area *)
    VAR count           : WORD;     (* # of files to return / returned *)
    Reserved            : LongInt       (* must be zero *)
    ) : WORD;
FUNCTION Dos16FindFirst {64} (
    Name                : pChar;       (* the file name, * and ? allowed *)
    VAR Handle          : WORD;     (* handle, 0FFFF means allocate one *)
    attribute           : AttributeSet; (* attributes to match *)
    VAR ResultBuf       : FileFindBuf;  (* returned file information *)
    ResultBufLen        : WORD;     (* length of result area *)
    VAR count           : WORD;     (* # of files to return / returned *)
    Reserved            : LongInt       (* must be zero *)
    ) : WORD;

(* find next file matching a wildcard spec *)

FUNCTION DosFindNext {65} (
    Handle              : WORD;     (* the handle returned by DosFindFist *)
    VAR ResultBuf       : FileFindBuf;  (* returned file information *)
    ResultBufLen        : WORD;     (* length of result area *)
    VAR count           : WORD      (* # of files to return / returned *)
    ) : WORD;
FUNCTION Dos16FindNext {65} (
    Handle              : WORD;     (* the handle returned by DosFindFist *)
    VAR ResultBuf       : FileFindBuf;  (* returned file information *)
    ResultBufLen        : WORD;     (* length of result area *)
    VAR count           : WORD      (* # of files to return / returned *)
    ) : WORD;

(* Signal an external event to a process *)

CONST
  PFLG_A       = 0;
  PFLG_B       = 1;
  PFLG_C       = 2;

  FLGP_SUBTREE = 0;
  FLGP_PID     = 1;

FUNCTION DosFlagProcess {15} (
    ProcessID           : WORD;     (* ID of process to flag *)
    Action              : WORD;     (* flag progency or just the process *)
    FlagNum             : WORD;     (* flag A, B, or C *)
    FlagArg             : WORD      (* argument to send to handler *)
    ) : WORD;
FUNCTION Dos16FlagProcess {15} (
    ProcessID           : WORD;     (* ID of process to flag *)
    Action              : WORD;     (* flag progency or just the process *)
    FlagNum             : WORD;     (* flag A, B, or C *)
    FlagArg             : WORD      (* argument to send to handler *)
    ) : WORD;

(* Free a dynamic link module *)

FUNCTION DosFreeModule {46} (
    ModuleHandle        : WORD      (* handle of module to free *)
    ) : WORD;
FUNCTION Dos16FreeModule {46} (
    ModuleHandle        : WORD      (* handle of module to free *)
    ) : WORD;

(* Free a segment of memory *)

FUNCTION DosFreeSeg {39} (
    Selector            : WORD      (* selector for segment to free *)
    ) : WORD;
FUNCTION Dos16FreeSeg {39} (
    Selector            : WORD      (* selector for segment to free *)
    ) : WORD;


FUNCTION DosGetCP {130} (
    Length              : WORD;     (* length of the list buffer *)
    CodePageList        : Pointer;      (* buffer with a word for each CP *)
                                        (* first word returned is current *)
    VAR DataLength      : WORD      (* size of returned list *)
    ) : WORD;
FUNCTION Dos16GetCP(
    Length              : WORD;     (* length of the list buffer *)
    CodePageList        : Pointer;      (* buffer with a word for each CP *)
                                        (* first word returned is current *)
    VAR DataLength      : WORD      (* size of returned list *)
    ) : WORD;

(* Get the current date and time *)

FUNCTION DosGetDateTime {33} (
    VAR dt              : DateTime      (* returned date and time *)
    ) : WORD;
FUNCTION Dos16GetDateTime {33} (
    VAR dt              : DateTime      (* returned date and time *)
    ) : WORD;

(* Get the address of the environment strings *)

FUNCTION DosGetEnv {91} (
    VAR Segment         : WORD;     (* segment containing environment *)
    VAR Offset          : WORD      (* offset to commmand parameters *)
    ) : WORD;
FUNCTION Dos16GetEnv {91} (
    VAR Segment         : WORD;     (* segment containing environment *)
    VAR Offset          : WORD      (* offset to commmand parameters *)
    ) : WORD;

(* Get the number you must shift 1 by to increment between segments in *)
(* a huge block of memory *)

FUNCTION DosGetHugeShift {41} (
    VAR ShiftCount      : WORD      (* Returned shift count *)
    ) : WORD;
FUNCTION Dos16GetHugeShift {41} (
    VAR ShiftCount      : WORD      (* Returned shift count *)
    ) : WORD;

(* Get segment selectors for the local and global info segments *)

PROCEDURE DosGetInfoSeg {8} (
    VAR GlobalSeg       : WORD;     (* Returned global info seg *)
    VAR LocalSeg        : WORD);    (* Returned local info seg *)
PROCEDURE Dos16GetInfoSeg {8} (
    VAR GlobalSeg       : WORD;     (* Returned global info seg *)
    VAR LocalSeg        : WORD);    (* Returned local info seg *)

(* Get the mode in which the machine is executing. *)

PROCEDURE DosGetMachineMode {49} (
    VAR MachineMode     : WORD);    (* 0 => real mode, 1 => protected *)
PROCEDURE Dos16GetMachineMode {49} (
    VAR MachineMode     : WORD);    (* 0 => real mode, 1 => protected *)

(* Get the handle of an already loaded dynamic link module *)

FUNCTION DosGetModHandle {47} (
    ModName             : pChar;       (* the module name *)
    VAR Handle          : WORD      (* the returned handle *)
    ) : WORD;
FUNCTION Dos16GetModHandle {47} (
    ModName             : pChar;       (* the module name *)
    VAR Handle          : WORD      (* the returned handle *)
    ) : WORD;

(* Get the name of a dynamic link module *)

FUNCTION DosGetModName {48} (
    ModuleHandle        : WORD;     (* the module handle to get name for *)
    BufferLength        : WORD;     (* the length of the output buffer *)
    Buffer              : pChar        (* the address of output buffer *)
    ) : WORD;
FUNCTION Dos16GetModName {48} (
    ModuleHandle        : WORD;     (* the module handle to get name for *)
    BufferLength        : WORD;     (* the length of the output buffer *)
    Buffer              : pChar        (* the address of output buffer *)
    ) : WORD;

    
(* Get the current process id *)
TYPE
  PidInfo = RECORD
    pID         : WORD;     (* current process id *)
    tId         : WORD;     (* current thread id *)
    pidParent   : WORD;     (* process id of our parent *)
  END;

FUNCTION DosGetPID {94} (
    VAR pID     : PidInfo       (* record to return *)
    ) : WORD;
FUNCTION Dos16GetPID {94} (
    VAR pID     : PidInfo       (* record to return *)
    ) : WORD;

(* Get the address of a procedure in a dynamic link module *)
FUNCTION DosGetProcAddr {45} (
    ModuleHandle        : WORD;     (* the module handle containing it *)
    ProcName            : pChar;       (* address of name of the proc *)
    VAR ProcAddress     : Pointer       (* the returned address *)
    ) : WORD;
FUNCTION Dos16GetProcAddr {45} (
    ModuleHandle        : WORD;     (* the module handle containing it *)
    ProcName            : pChar;       (* address of name of the proc *)
    VAR ProcAddress     : Pointer       (* the returned address *)
    ) : WORD;

(* Get the priority of a process *)

CONST
  PRTYS_PROCESS       = 0;
  PRTYS_PROCESSTREE   = 1;
  PRTYS_THREAD        = 2;

FUNCTION DosGetPrty {9} (
    Scope               : WORD;(* see above values *)
    VAR Priority        : WORD;     (* returned priority *)
    id                  : WORD      (* process or thread id *)
    ) : WORD;
FUNCTION Dos16GetPrty {9} (
    Scope               : WORD;(* see above values *)
    VAR Priority        : WORD;     (* returned priority *)
    id                  : WORD      (* process or thread id *)
    ) : WORD;

(* Get access to a segment allocated by DosGetSeg with flags bit 1 on *)
FUNCTION DosGetSeg {121} (
    Selector            : WORD      (* selector for the seg to access *)
    ) : WORD;
FUNCTION Dos16GetSeg {121} (
    Selector            : WORD      (* selector for the seg to access *)
    ) : WORD;

(* Get access to a shared segment created by another process *)

FUNCTION DosGetShrSeg {36} (
    Name                : pChar;       (* address of shared seg name *)
    VAR Selector        : WORD      (* the returned selector *)
    ) : WORD;
FUNCTION Dos16GetShrSeg {36} (
    Name                : pChar;       (* address of shared seg name *)
    VAR Selector        : WORD      (* the returned selector *)
    ) : WORD;


(* Get the version of DOS that is running *)

PROCEDURE DosGetVersion  {92} (
    VAR Version         : WORD);    (* returned version number *)
                                        (* high byte is major vers *)
                                        (* low byte is minor vers *)
PROCEDURE Dos16GetVersion  {92} (
    VAR Version         : WORD);    (* returned version number *)
                                        (* high byte is major vers *)
                                        (* low byte is minor vers *)


(* Give another process access to a segment *)

FUNCTION DosGiveSeg {37} (
    CallerSegHandle     : WORD;     (* segment selector of giver *)
    ProcessID           : WORD;     (* id of process to give to *)
    VAR RecipientSegHandle      : WORD      (* segment selector in other process *)
    ) : WORD;
FUNCTION Dos16GiveSeg {37} (
    CallerSegHandle     : WORD;     (* segment selector of giver *)
    ProcessID           : WORD;     (* id of process to give to *)
    VAR RecipientSegHandle      : WORD      (* segment selector in other process *)
    ) : WORD;

(* Disable or enable signals from being sent to the current process *)

FUNCTION DosHoldSignal {13} (
    ActionCode          : WORD      (* 0 => enable, 1 => disable  *)
    ) : WORD;
FUNCTION Dos16HoldSignal {13} (
    ActionCode          : WORD      (* 0 => enable, 1 => disable  *)
    ) : WORD;

(* Terminate a process *)
CONST
    DKP_PROCESSTREE     = 0;
    DKP_PROCESS         = 1;

FUNCTION DosKillProcess {10} (
    Scope               : WORD;(* 0 => kill all children, 1 not *)
    ProcessID           : WORD      (* ID of process to kill *)
    ) : WORD;
FUNCTION Dos16KillProcess {10} (
    Scope               : WORD;(* 0 => kill all children, 1 not *)
    ProcessID           : WORD      (* ID of process to kill *)
    ) : WORD;

(* Load a dynamic link module *)

FUNCTION DosLoadModule {44} (
    ObjNameBufAdr       : pChar;       (* buf to return name of failure obj *)
    ObjNameBufL         : WORD;     (* length of above *)
    ModuleName          : pChar;       (* module name *)
    VAR ModuleHandle    : WORD      (* returned module handle *)
    ) : WORD;
FUNCTION Dos16LoadModule {44} (
    ObjNameBufAdr       : pChar;       (* buf to return name of failure obj *)
    ObjNameBufL         : WORD;     (* length of above *)
    ModuleName          : pChar;       (* module name *)
    VAR ModuleHandle    : WORD      (* returned module handle *)
    ) : WORD;

(* Lock a discardable segment in memory *)

FUNCTION DosLockSeg {122} (
    Selector            : WORD      (* selector of segment to lock *)
    ) : WORD;
FUNCTION Dos16LockSeg {122} (
    Selector            : WORD      (* selector of segment to lock *)
    ) : WORD;

(* Create a pipe *)

FUNCTION DosMakePipe {16} (
    VAR ReadHandle      : WORD;     (* Returned handle for reading *)
    VAR WriteHandle     : WORD;     (* Returned handle for writing *)
    PipeSize            : WORD      (* Buffer size for the pipe *)
    ) : WORD;
FUNCTION Dos16MakePipe {16} (
    VAR ReadHandle      : WORD;     (* Returned handle for reading *)
    VAR WriteHandle     : WORD;     (* Returned handle for writing *)
    PipeSize            : WORD      (* Buffer size for the pipe *)
    ) : WORD;

(* Get the size of the largest free memory block *)

FUNCTION DosMemAvail {127} (
    VAR MemAvailSize    : LongInt{LONGCARD}      (* returned size *)
    ) : WORD;
FUNCTION Dos16MemAvail {127} (
    VAR MemAvailSize    : LongInt{LONGCARD}      (* returned size *)
    ) : WORD;

(* Create a subdirectory *)

FUNCTION DosMkDir {66} (
    Path                : Pointer;      (* path name of directory to create *)
    Reserved            : LongInt       (* must be zero *)
    ) : WORD;
FUNCTION Dos16MkDir {66} (
    Path                : Pointer;      (* path name of directory to create *)
    Reserved            : LongInt       (* must be zero *)
    ) : WORD;

(* Move (rename) a file *)

FUNCTION DosMove {67} (
    Old                 : pChar;       (* old file specification *)
    New                 : pChar;       (* new file specification *)
    Reserved            : LongInt       (* must be zero *)
    ) : WORD;
FUNCTION Dos16Move {67} (
    Old                 : pChar;       (* old file specification *)
    New                 : pChar;       (* new file specification *)
    Reserved            : LongInt       (* must be zero *)
    ) : WORD;

(* Wait for one of several semaphores *)

FUNCTION DosMuxSemWait {22} (
    VAR IndexNum        : WORD;     (* returned index of sem that cleared *)
    ListAddr            : MUXSemList;   (* list of semaphores to wait for *)
    TimeOut             : LongInt       (* timeout, -1 for none, 0 for nowait *)
    ) : WORD;
FUNCTION Dos16MuxSemWait {22} (
    VAR IndexNum        : WORD;     (* returned index of sem that cleared *)
    ListAddr            : MUXSemList;   (* list of semaphores to wait for *)
    TimeOut             : LongInt       (* timeout, -1 for none, 0 for nowait *)
    ) : WORD;

(* Change the size of a file *)

FUNCTION DosNewSize {68} (
    FileHandle          : WORD;     (* handle of the file to change *)
    Size                : LongInt       (* the new size *)
    ) : WORD;
FUNCTION Dos16NewSize {68} (
    FileHandle          : WORD;     (* handle of the file to change *)
    Size                : LongInt       (* the new size *)
    ) : WORD;

(* Open or create a file. *)

(* action returns one of the following values *)

CONST
  FILE_EXISTED                = 1;    (* existing file was opened *)
  FILE_CREATED                = 2;    (* new file was created *)
  FILE_TRUNCATED              = 3;    (* existing file was truncated *)

(* flag determines the action to be taken if the file if found or       *)
(* not found as follows.  You can use any combinataion of the following *)
(* values: *)

CONST
  FILE_OPEN           = 1;    (* open a file if it exists *)
  FILE_TRUNCATE       = 2;    (* truncate a file if it exists *)
  FILE_CREATE         = $10;  (* create a file if it does not exist *)

(* Open mode is defined as follows:                                     *)
(* bits 0..2 are access mode, 0 -> read, 1-> write, 2-> readwrite       *)
(* bits 4..6 are Sharing mode, 1 -> deny both, 2 -> deny write,         *)
(*                             3 -> deny read, 4 -> allow either        *)
(* bit 7 is inheritance flag, 0-> inherited by children, 1 -> not       *)
(* bit 13 is fail errors, 0 -> normal hadling, 1 -> return all erros    *)
(* bit 14 is write through, 0 -> normal caching, 1 -> write is done     *)
(* bit 15 is DASD open, 0 -> normal, 1 -> open devive for direct access *)
(*                                                                      *)
(* Use the following constants to specify open modes:                   *)

CONST
  OM_READ_ONLY        = $0000;        (* read only access to the file *)
  OM_WRITE_ONLY       = $0001;

  FILE_NORMAL         = 0;
  FILE_READONLY       = 1;
  FILE_HIDDEN         = 2;
  FILE_SYSTEM         = 4;
  FILE_DIRECTORY      = $10;
  FILE_ARCHIVED       = $20;

  DCPY_EXISTING       = 1;
  DCPY_APPEND         = 2;

  HDIR_SYSTEM         = 1;
  HDIR_CREATE         = $FFFF;

  FILE_BEGIN          = 0;
  FILE_CURRENT        = 1;
  FILE_END            = 2;

  OPEN_ACTION_FAIL_IF_EXISTS          = 0;
  OPEN_ACTION_OPEN_IF_EXISTS          = 1;
  OPEN_ACTION_REPLACE_IF_EXISTS       = 2;

  OPEN_ACTION_FAIL_IF_NEW             = 0;
  OPEN_ACTION_CREATE_IF_NEW           = $10;

  OPEN_ACCESS_READONLY                = 0;
  OPEN_ACCESS_WRITEONLY               = 1;
  OPEN_ACCESS_READWRITE               = 2;
  OPEN_SHARE_DENYREADWRITE            = $10;
  OPEN_SHARE_DENYWRITE                = $20;
  OPEN_SHARE_DENYREAD                 = $30;
  OPEN_SHARE_DENYNONE                 = $40;
  OPEN_FLAGS_NOINHERIT                = $80;
  OPEN_FLAGS_NO_LOCALITY              = 0;
  OPEN_FLAGS_SEQUENTIAL               = $100;
  OPEN_FLAGS_RANDOM                   = $200;
  OPEN_FLAGS_RANDOMSEQUENTIAL         = $300;
  OPEN_FLAGS_NO_CACHE                 = $1000;
  OPEN_FLAGS_FAIL_ON_ERROR            = $2000;
  OPEN_FLAGS_WRITE_THROUGH            = $4000;
  OPEN_FLAGS_DASD                     = $8000;

FUNCTION DosOpen {70} (
    Name                : pChar;       (* path name of file *)
    VAR Handle          : WORD;     (* returned handle *)
    VAR Action          : WORD;     (* see above *)
    Size                : LongInt;      (* initial allocation if created *)
    Attr                : AttributeSet; (* file attributes if created *)
    Flag                : WORD;     (* see above *)
    Mode                : WORD;     (* see above *)
    Reserved            : LongInt       (* must be zero *)
    ) : WORD;
FUNCTION Dos16Open {70} (
    Name                : pChar;       (* path name of file *)
    VAR Handle          : WORD;     (* returned handle *)
    VAR Action          : WORD;     (* see above *)
    Size                : LongInt;      (* initial allocation if created *)
    Attr                : AttributeSet; (* file attributes if created *)
    Flag                : WORD;     (* see above *)
    Mode                : WORD;     (* see above *)
    Reserved            : LongInt       (* must be zero *)
    ) : WORD;

(* Open a queue.  Queue was created by another process via DosCreateQueue *)

CONST
  CSEM_PRIVATE        = 0;
  CSEM_PUBLIC         = 1;
(* Open a system semaphore.  System semaphores are created by DosCreateSem *)
(* and are shared by all processes. *)

FUNCTION DosOpenSem {25} (
    VAR SemHandle       : Pointer;      (* returned semaphore handle *)
    SemName             : pChar        (* prefixed with \SEM\ *)
    ) : WORD;
FUNCTION Dos16OpenSem {25} (
    VAR SemHandle       : Pointer;      (* returned semaphore handle *)
    SemName             : pChar        (* prefixed with \SEM\ *)
    ) : WORD;

(* Get info about partioned disk *)

FUNCTION DosPhysicalDisk {129} (
    aFunction           : WORD;     (* type of info to get *)
    DataPtr             : Pointer;      (* address of buffer *)
    DataLength          : WORD;     (* length of buffer *)
    ParmPtr             : Pointer;      (* pointer to parameters *)
    ParmLength          : WORD      (* length of parameters *)
    ) : WORD;
FUNCTION Dos16PhysicalDisk {129} (
    aFunction           : WORD;     (* type of info to get *)
    DataPtr             : Pointer;      (* address of buffer *)
    DataLength          : WORD;     (* length of buffer *)
    ParmPtr             : Pointer;      (* pointer to parameters *)
    ParmLength          : WORD      (* length of parameters *)
    ) : WORD;

(* Request access to I/O ports *)

FUNCTION DosPortAccess {69} (
    Rervered            : WORD;     (* must be zero *)
    TypeOfAccess        : WORD;     (* 0 -> request, 1 -> release *)
    FirstPort           : WORD;     (* number of first port requested *)
    LastPort            : WORD      (* number of last port requested *)
    ) : WORD;
FUNCTION Dos16PortAccess {69} (
    Rervered            : WORD;     (* must be zero *)
    TypeOfAccess        : WORD;     (* 0 -> request, 1 -> release *)
    FirstPort           : WORD;     (* number of first port requested *)
    LastPort            : WORD      (* number of last port requested *)
    ) : WORD;

(* Debugger interface *)

FUNCTION DosPTrace {12} (
    Ptrace_B            : Pointer       (* address of buffer *)
    ) : WORD;

(* Get the name of the current directory *)

FUNCTION DosQCurDir {71} (
    Drive               : WORD;     (* drive number, 0 = default, 1=A... *)
    Path                : Pointer;      (* returned path name of directory *)
    VAR PathLen         : WORD      (* length of returned path name *)
    ) : WORD;
FUNCTION Dos16QCurDir {71} (
    Drive               : WORD;     (* drive number, 0 = default, 1=A... *)
    Path                : Pointer;      (* returned path name of directory *)
    VAR PathLen         : WORD      (* length of returned path name *)
    ) : WORD;

(* Get the number of the current disk *)

FUNCTION DosQCurDisk {72} (
    VAR Drive           : WORD;     (* returned drive, 1=A, 2=B... *)
    VAR DMap            : LongInt       (* bits on for each existing drive *)
    ) : WORD;
FUNCTION Dos16QCurDisk {72} (
    VAR Drive           : WORD;     (* returned drive, 1=A, 2=B... *)
    VAR DMap            : LongInt       (* bits on for each existing drive *)
    ) : WORD;

(* Get the state of a file handle *)

FUNCTION DosQFHandState {73} (
    FileHandle          : WORD;     (* file system handle *)
    VAR State           : WORD      (* same def as mode param to open *)
    ) : WORD;
FUNCTION Dos16QFHandState {73} (
    FileHandle          : WORD;     (* file system handle *)
    VAR State           : WORD      (* same def as mode param to open *)
    ) : WORD;

(* Get directory information about an open file *)

FUNCTION DosQFileInfo {74} (
    Handle      : WORD;             (* the file handle *)
    Level       : WORD;             (* must be 1 *)
    VAR Buffer  : FileFindBuf;          (* returned info *)
    Size        : WORD              (* size of buffer *)
    ) : WORD;
FUNCTION Dos16QFileInfo {74} (
    Handle      : WORD;             (* the file handle *)
    Level       : WORD;             (* must be 1 *)
    VAR Buffer  : FileFindBuf;          (* returned info *)
    Size        : WORD              (* size of buffer *)
    ) : WORD;

(* Get the attribute of a named file *)

FUNCTION DosQFileMode {75} (
    FileName            : pChar;       (* the path name for the file *)
    VAR attribute       : BYTE{BITSET}; (* returned attribute bits *)
    Reserved            : LongInt       (* must be zero *)
    ) : WORD;
FUNCTION Dos16QFileMode {75} (
    FileName            : pChar;       (* the path name for the file *)
    VAR attribute       : BYTE{BITSET}; (* returned attribute bits *)
    Reserved            : LongInt       (* must be zero *)
    ) : WORD;

(* Get file system information about a drive *)

FUNCTION DosQFSInfo {76} (
    Drive               : WORD;     (* drive number, 1=A, 2=B... *)
    Level               : WORD;     (* must be 1 *)
    VAR fsInfoBuf       : FsData;       (* retured info *)
    BufSize             : WORD      (* size of returned info buffer *)
    ) : WORD;
FUNCTION Dos16QFSInfo {76} (
    Drive               : WORD;     (* drive number, 1=A, 2=B... *)
    Level               : WORD;     (* must be 1 *)
    VAR fsInfoBuf       : FsData;       (* retured info *)
    BufSize             : WORD      (* size of returned info buffer *)
    ) : WORD;

(* Determine if a handle is a device or a file *)

FUNCTION DosQHandType {77} (
    FileHandle          : WORD;     (* the file handle *)
    VAR HandType        : WORD;     (* Returned type, 0 is file 1 device *)
    VAR FlagWord        : WORD      (* Returns device drivers flag word *)
    ) : WORD;
FUNCTION Dos16QHandType {77} (
    FileHandle          : WORD;     (* the file handle *)
    VAR HandType        : WORD;     (* Returned type, 0 is file 1 device *)
    VAR FlagWord        : WORD      (* Returns device drivers flag word *)
    ) : WORD;

(* Get the setting of the verify flag *)

FUNCTION DosQVerify {78} (
    VAR VerifyFlag      : WORD      (* returned verify flag *)
    ) : WORD;
FUNCTION Dos16QVerify {78} (
    VAR VerifyFlag      : WORD      (* returned verify flag *)
    ) : WORD;

(* Read from an open file or device *)

FUNCTION DosRead {137} (
    Handle              : WORD;     (* the handle of the file or device *)
    Buffer              : Pointer;      (* address of the data buffer *)
    Length              : WORD;     (* length of the data buffer *)
    VAR Read            : WORD      (* returned number of bytes read *)
    ) : WORD;
FUNCTION Dos16Read {137} (
    Handle              : WORD;     (* the handle of the file or device *)
    Buffer              : Pointer;      (* address of the data buffer *)
    Length              : WORD;     (* length of the data buffer *)
    VAR Read            : WORD      (* returned number of bytes read *)
    ) : WORD;

(* Read from an open file or device asynchornously *)

FUNCTION DosReadAsync {149} (
    Handle              : WORD;     (* the handle of the file or device *)
    SemHandle           : SemaPhore;    (* address of a Ram semaphore to *)
                                        (* clear when the read completes *)
    VAR ReturnCode      : WORD;     (* address of word to recive status *)
    Buffer              : Pointer;      (* address of the data buffer *)
    Length              : WORD;     (* length of the data buffer *)
    VAR Read            : WORD      (* returned number of bytes read *)
    ) : WORD;
FUNCTION Dos16ReadAsync {149} (
    Handle              : WORD;     (* the handle of the file or device *)
    SemHandle           : SemaPhore;    (* address of a Ram semaphore to *)
                                        (* clear when the read completes *)
    VAR ReturnCode      : WORD;     (* address of word to recive status *)
    Buffer              : Pointer;      (* address of the data buffer *)
    Length              : WORD;     (* length of the data buffer *)
    VAR Read            : WORD      (* returned number of bytes read *)
    ) : WORD;

(* Change size of a memory allocated by DosAllocHuge *)

FUNCTION DosReAllocHuge {42} (
    NumSeg              : WORD;     (* new number of segments *)
    Size                : WORD;     (* new size of last seg, 0 -> 64K *)
    Selector            : WORD      (* selector for the memory *)
    ) : WORD;
FUNCTION Dos16ReAllocHuge {42} (
    NumSeg              : WORD;     (* new number of segments *)
    Size                : WORD;     (* new size of last seg, 0 -> 64K *)
    Selector            : WORD      (* selector for the memory *)
    ) : WORD;

(* Change size of a memory segment *)

FUNCTION DosReAllocSeg {38} (
    Size                : WORD;     (* new size of last seg, 0 -> 64K *)
    Selector            : WORD      (* selector for the memory *)
    ) : WORD;
FUNCTION Dos16ReAllocSeg {38} (
    Size                : WORD;     (* new size of last seg, 0 -> 64K *)
    Selector            : WORD      (* selector for the memory *)
    ) : WORD;

(* Resume a suspended thread *)

FUNCTION DosResumeThread {26} (
    ThreadID            : WORD      (* ID of thread to resume *)
    ) : WORD;
FUNCTION Dos16ResumeThread {26} (
    ThreadID            : WORD      (* ID of thread to resume *)
    ) : WORD;

(* Remove (delete) a directory *)

FUNCTION DosRmDir {80} (
    Path                : pChar;       (* path name of the directory *)
    Reserved            : LongInt       (* must be zero *)
    ) : WORD;
FUNCTION Dos16RmDir {80} (
    Path                : pChar;       (* path name of the directory *)
    Reserved            : LongInt       (* must be zero *)
    ) : WORD;

(* Scan the environrment symbols for a name and return its value *)

FUNCTION DosScanEnv {152} (
    Name                : pChar;       (* name of symbol to look for *)
    VAR Def             : Pointer       (* returned address of result *)
    ) : WORD;
FUNCTION Dos16ScanEnv {152} (
    Name                : pChar;       (* name of symbol to look for *)
    VAR Def             : Pointer       (* returned address of result *)
    ) : WORD;


(* Search for a file in a path list *)

(* bits defined for the control paramter *)

CONST
    IMPLIEDCURRENT      = 0;    (* if on, current path is searched first *)
    PATHSYMBOL          = 1;    (* if on, path is the name of an env symbol *)

   SEARCH_PATH          = 0;
   SEARCH_CUR_DIRECTORY = 1;
   SEARCH_ENVIRONMENT   = 2;
   SEARCH_IGNORENETERRS = 4;

   DSP_PATH             = 0;
   DSP_CUR_DIRECTORY    = 1;
   DSP_ENVIRONMENT      = 2;
   DSP_IGNORENETERR     = 4;
    
FUNCTION DosSearchPath {151} (
    Control             : BYTE{BITSET};       (* Control bits, see above *)
    PathRef             : pChar;       (* path string or name dep on above *)
    FileName            : pChar;       (* name of file to search for *)
    ResultBuffer        : pChar;       (* returned path name *)
    ResultBufferLen     : WORD      (* length of above *)
    ) : WORD;
FUNCTION Dos16SearchPath {151} (
    Control             : BYTE{BITSET};       (* Control bits, see above *)
    PathRef             : pChar;       (* path string or name dep on above *)
    FileName            : pChar;       (* name of file to search for *)
    ResultBuffer        : pChar;       (* returned path name *)
    ResultBufferLen     : WORD      (* length of above *)
    ) : WORD;

(* Select a new current drive *)

FUNCTION DosSelectDisk {81} (
    Drive               : WORD      (* drive number, 1=A, 2=B... *)
    ) : WORD;
FUNCTION Dos16SelectDisk {81} (
    Drive               : WORD      (* drive number, 1=A, 2=B... *)
    ) : WORD;

CONST
    SEM_INDEFINITE_WAIT         = -1 { MAX(LONGCARD) (* = -1 *)};
    SEM_IMMDEIATE_RETURN        = 0;
(* Free up a semaphore *)

FUNCTION DosSemClear {141} (
    SemHandle           : SemaPhore     (* the semaphore handle *)
    ) : WORD;
FUNCTION Dos16SemClear {141} (
    SemHandle           : SemaPhore     (* the semaphore handle *)
    ) : WORD;

(* Request ownership of a semphore *)

FUNCTION DosSemRequest {140} (
    SemHandle           : SemaPhore;    (* the semaphore handle *)
    TimeOut             : LongInt       (* timeout interval in msec *)
                                        (* -1 implies wait forever *)
                                        (* 0 implies return immediately *)
    ) : WORD;
FUNCTION Dos16SemRequest {140} (
    SemHandle           : SemaPhore;    (* the semaphore handle *)
    TimeOut             : LongInt       (* timeout interval in msec *)
                                        (* -1 implies wait forever *)
                                        (* 0 implies return immediately *)
    ) : WORD;

(* Set a semaphore as owned *)

FUNCTION DosSemSet {143} (
    SemHandle           : SemaPhore     (* the semaphore handle *)
    ) : WORD;
FUNCTION Dos16SemSet {143} (
    SemHandle           : SemaPhore     (* the semaphore handle *)
    ) : WORD;


(* Set and wait for clear of a semaphore *)

FUNCTION DosSemSetWait {20} (
    SemHandle           : SemaPhore;    (* the semaphore handle *)
    TimeOut             : LongInt       (* timeout interval in msec *)
                                        (* -1 implies wait forever *)
                                        (* 0 implies return immediately *)
    ) : WORD;
FUNCTION Dos16SemSetWait {20} (
    SemHandle           : SemaPhore;    (* the semaphore handle *)
    TimeOut             : LongInt       (* timeout interval in msec *)
                                        (* -1 implies wait forever *)
                                        (* 0 implies return immediately *)
    ) : WORD;

(* wait for clear of a semaphore *)

FUNCTION DosSemWait {142} (
    SemHandle           : SemaPhore;    (* the semaphore handle *)
    TimeOut             : LongInt       (* timeout interval in msec *)
                                        (* -1 implies wait forever *)
                                        (* 0 implies return immediately *)
    ) : WORD;
FUNCTION Dos16SemWait {142} (
    SemHandle           : SemaPhore;    (* the semaphore handle *)
    TimeOut             : LongInt       (* timeout interval in msec *)
                                        (* -1 implies wait forever *)
                                        (* 0 implies return immediately *)
    ) : WORD;

(* Set the Code Page *)

FUNCTION DosSetCP {153} (
    codepage            : WORD;     (* new code page for the process *)
    Reserved            : WORD      (* must be zero *)
    ) : WORD;
FUNCTION Dos16SetCP {153} (
    codepage            : WORD;     (* new code page for the process *)
    Reserved            : WORD      (* must be zero *)
    ) : WORD;

(* Set the system date and time *)

FUNCTION DosSetDateTime {28} (
    NewDateTime         : DateTime      (* the new date and time *)
    ) : WORD;
FUNCTION Dos16SetDateTime {28} (
    NewDateTime         : DateTime      (* the new date and time *)
    ) : WORD;

(* Set the state of a file handle *)

FUNCTION DosSetFHandState {82} (
    FileHandle          : WORD;     (* the file handle *)
    FileHandleState     : WORD      (* same as flags in DosOpen, but *)
                                        (* accmode and shrmore must be zero *)
    ) : WORD;
FUNCTION Dos16SetFHandState {82} (
    FileHandle          : WORD;     (* the file handle *)
    FileHandleState     : WORD      (* same as flags in DosOpen, but *)
                                        (* accmode and shrmore must be zero *)
    ) : WORD;

(* Sets the date and time info for a file *)

FUNCTION DosSetFileInfo {83} (
    FileHandle          : WORD;     (* the file handle *)
    FileInfoLevel       : WORD;     (* must be 1 *)
    FileInfoBuf         : Pointer;      (* Same as first 6 words of *)
                                        (* DirectoryInfo type *)
    FileInfoBufSize     : WORD      (* size of above *)
    ) : WORD;
FUNCTION Dos16SetFileInfo {83} (
    FileHandle          : WORD;     (* the file handle *)
    FileInfoLevel       : WORD;     (* must be 1 *)
    FileInfoBuf         : Pointer;      (* Same as first 6 words of *)
                                        (* DirectoryInfo type *)
    FileInfoBufSize     : WORD      (* size of above *)
    ) : WORD;

(* Sets the attributes of a file *)

FUNCTION DosSetFileMode {84} (
    FileName            : pChar;       (* path name of the file *)
    attribute           : BYTE{BITSET};       (* attribute bits *)
    Reserved            : LongInt       (* must be zero *)
    ) : WORD;
FUNCTION Dos16SetFileMode {84} (
    FileName            : pChar;       (* path name of the file *)
    attribute           : BYTE{BITSET};       (* attribute bits *)
    Reserved            : LongInt       (* must be zero *)
    ) : WORD;

(* Sets the volume label for a drive *)

FUNCTION DosSetFSInfo {97} (
    DriveNumber         : WORD;     (* drive number, 1=A, 2=B... *)
    fsInfoLevel         : WORD;     (* must be 2 *)
    Buffer              : Pointer       (* byte connted volumn label string *)
    ) : WORD;
FUNCTION Dos16SetFSInfo {97} (
    DriveNumber         : WORD;     (* drive number, 1=A, 2=B... *)
    fsInfoLevel         : WORD;     (* must be 2 *)
    Buffer              : Pointer       (* byte connted volumn label string *)
    ) : WORD;

(* Set the maximum number of file handles *)

FUNCTION DosSetMaxFH {85} (
    NumberHandles       : WORD      (* max number of handles *)
    ) : WORD;
FUNCTION Dos16SetMaxFH {85} (
    NumberHandles       : WORD      (* max number of handles *)
    ) : WORD;

(* Set priority of a child process or a thread *)
CONST
    PRTYC_NOCHANGE              = 0;
    PRTYC_IDLETIME              = 1;
    PRTYC_REGULAR               = 2;
    PRTYC_TIMECRITICAL          = 3;
    PRTYC_FOREGROUNDSERVER      = 4;

    PRTYD_MINIMUM               = -31;
    PRTYD_MAXIMUM               = 31;
    
FUNCTION DosSetPrty {11} (
    Scope               : WORD;(* see DosGetPtry for values *)
    PriorityClass       : INTEGER;(* see above for values *)
    PriorityDelta       : INTEGER;      (* amount by which to change priority *)
                                        (* -31 .. 31 *)
    id                  : WORD      (* process or thread id, 0 -> current *)
    ) : WORD;
FUNCTION Dos16SetPrty {11} (
    Scope               : WORD;(* see DosGetPtry for values *)
    PriorityClass       : INTEGER;(* see above for values *)
    PriorityDelta       : INTEGER;      (* amount by which to change priority *)
                                        (* -31 .. 31 *)
    id                  : WORD      (* process or thread id, 0 -> current *)
    ) : WORD;

(* Control the action taken when a signal occurs *)

CONST
    SIGA_KILL           = 0; (* use system default action for the signal *)
    SIGA_DEFAULT        = 0; (* I think the above should really be this *)
    SIGA_IGNORE         = 1; (* signal is to be ignored *)
    SIGA_HANDLER        = 2; (* the specified procedure is the handler *)
    SIGA_ERROR          = 3; (* an error occurs if another process signals *)
    SIGA_ACKNOWLEDGE    = 4; (* the current signal is reset *)

    HLDSIG_ENABLE       = 0;
    HLDSIG_DISABLE      = 1;

CONST
    SIG_CTRLC           = 1;    (* control/c signal *)
{   SIG_BROKENPIPE      =       (* broken pipe *)}
    SIG_KILLPROCESS     = 3;    (* program terminated signal *)
    SIG_CTRLBREAK       = 4;    (* control/break signal *)
    SIG_PFLG_A          = 5;    (* process flag A *)
    SIG_PFLG_B          = 6;    (* process flag B *)
    SIG_PFLG_C          = 7;    (* process flag C *)
    SIG_CSIGNALS        = 8;

TYPE
  SignalProc = PROCEDURE (a, b: WORD) {[LOADDS]};

FUNCTION DosSetSigHandler {14} (
    RoutineAddress      : SignalProc;   (* handler procedure *)
    VAR PrevAddress     : SignalProc;   (* returned previous handler *)
    VAR PrevAction      : WORD;     (* returned previous action *)
    Action              : WORD;     (* action to take, see above *)
    SigNumber           : WORD      (* signal number, see above *)
    ) : WORD;
FUNCTION Dos16SetSigHandler {14} (
    RoutineAddress      : SignalProc;   (* handler procedure *)
    VAR PrevAddress     : SignalProc;   (* returned previous handler *)
    VAR PrevAction      : WORD;     (* returned previous action *)
    Action              : WORD;     (* action to take, see above *)
    SigNumber           : WORD      (* signal number, see above *)
    ) : WORD;

(* Set and exeception vector.  Use the following codes for the vectors *)

CONST
    DSV_ZERO_DIVIDE             = 0;
    DSV_OVERFLOW                = 4;
    DSV_BOUND                   = 5;
    DSV_INVALID_OPCODE          = 6;
    DSV_NO_PROCESSOR_EXT        = 7;
    DSV_PROCESSOR_EXT_ERROR     = 16;

TYPE
  IntHandler = PROCEDURE{()[LONG, INTERRUPT]};

(* Set the verify flag.  When on, disk data is verified after writing *)

FUNCTION DosSetVerify {86} (
    VerifySetting       : WORD      (* 0 -> verify off, 1 -> verify on *)
    ) : WORD;
FUNCTION Dos16SetVerify {86} (
    VerifySetting       : WORD      (* 0 -> verify off, 1 -> verify on *)
    ) : WORD;

(* Put a process to sleep for a while *)

FUNCTION DosSleep {32} (
    TimeInterval        : LongInt       (* the time in milliseconds *)
    ) : WORD;
FUNCTION Dos16Sleep {32} (
    TimeInterval        : LongInt       (* the time in milliseconds *)
    ) : WORD;

(* Suballocate memory within a segment.  The segment must first be *)
(* initialized by DosSubSet. *)

FUNCTION DosSubAlloc {147} (
    Selector            : WORD;     (* selector of segment to alloc from *)
    VAR BlockOffset     : WORD;     (* returned offset of block *)
    Size                : WORD      (* size of block to allocate *)
    ) : WORD;
FUNCTION Dos16SubAlloc {147} (
    Selector            : WORD;     (* selector of segment to alloc from *)
    VAR BlockOffset     : WORD;     (* returned offset of block *)
    Size                : WORD      (* size of block to allocate *)
    ) : WORD;

(* Free memory allocated by DosSubAlloc *)

FUNCTION DosSubFree {148} (
    Selector            : WORD;     (* selector for segment *)
    BlockOffset         : WORD;     (* offset of block to free *)
    Size                : WORD      (* size of block to free *)
    ) : WORD;
FUNCTION Dos16SubFree {148} (
    Selector            : WORD;     (* selector for segment *)
    BlockOffset         : WORD;     (* offset of block to free *)
    Size                : WORD      (* size of block to free *)
    ) : WORD;

(* Initialize or change size of a segment for sub-allocation *)

FUNCTION DosSubSet {146} (
    Selector            : WORD;     (* selector for the segment *)
    flags               : WORD;     (* 0 -> re-size, 1 -> initialize *)
    Size                : WORD      (* new size of segment *)
    ) : WORD;
FUNCTION Dos16SubSet {146} (
    Selector            : WORD;     (* selector for the segment *)
    flags               : WORD;     (* 0 -> re-size, 1 -> initialize *)
    Size                : WORD      (* new size of segment *)
    ) : WORD;

(* Suspend a thread until further notice *)

FUNCTION DosSuspendThread {27} (
    ThreadID            : WORD      (* ID of thread to suspend *)
    ) : WORD;
FUNCTION Dos16SuspendThread {27} (
    ThreadID            : WORD      (* ID of thread to suspend *)
    ) : WORD;

(* Services for session controllers *)

FUNCTION DosSystemService {88} (
    ServiceCategory     : WORD;     (* 0 -> session manager services *)
                                        (* 1 -> Hard error services *)
                                        (* 2 -> Print screen services *)
    RequestPacket       : Pointer;      (* function dependent info *)
    ResponsePacket      : Pointer       (* function dependent output info *)
    ) : WORD;
FUNCTION Dos16SystemService {88} (
    ServiceCategory     : WORD;     (* 0 -> session manager services *)
                                        (* 1 -> Hard error services *)
                                        (* 2 -> Print screen services *)
    RequestPacket       : Pointer;      (* function dependent info *)
    ResponsePacket      : Pointer       (* function dependent output info *)
    ) : WORD;

(* Start a timer that clears a semaphore when done *)

FUNCTION DosTimerAsync {29} (
    TimeInterval        : LongInt;      (* interval in milliseconds *)
    SemHandle           : SemaPhore;    (* system semaphore to clear when done *)
    VAR Handle          : WORD      (* returned timer handle *)
    ) : WORD;
FUNCTION Dos16TimerAsync {29} (
    TimeInterval        : LongInt;      (* interval in milliseconds *)
    SemHandle           : SemaPhore;    (* system semaphore to clear when done *)
    VAR Handle          : WORD      (* returned timer handle *)
    ) : WORD;

(* Start a periodic timer *)

FUNCTION DosTimerStart {30} (
    TimeInterval        : LongInt;      (* interval in milliseconds *)
    SemHandle           : SemaPhore;    (* system semaphore to clear when done *)
    VAR Handle          : WORD      (* returned timer handle *)
    ) : WORD;
FUNCTION Dos16TimerStart {30} (
    TimeInterval        : LongInt;      (* interval in milliseconds *)
    SemHandle           : SemaPhore;    (* system semaphore to clear when done *)
    VAR Handle          : WORD      (* returned timer handle *)
    ) : WORD;

(* Stop a timer *)

FUNCTION DosTimerStop {31} (
    Handle              : WORD      (* timer handle to stop *)
    ) : WORD;
FUNCTION Dos16TimerStop {31} (
    Handle              : WORD      (* timer handle to stop *)
    ) : WORD;

(* Unlock a discardable segment from memory *)

FUNCTION DosUnlockSeg {123} (
    Selector            : WORD      (* segment selector to unlock *)
    ) : WORD;
FUNCTION Dos16UnlockSeg {123} (
    Selector            : WORD      (* segment selector to unlock *)
    ) : WORD;

(* Write to a device or file asynchronously *)

FUNCTION DosWriteAsync {150} (
    Handle              : WORD;     (* the handle to write to *)
    RamSemaphore        : SemaPhore;    (* semaphore to clear when done *)
    VAR ReturnCode      : WORD;     (* address of word to return status *)
    Buffer              : Pointer;      (* data buffer address *)
    Length              : WORD;     (* length of data to write *)
    VAR Written         : WORD      (* returned length actually written *)
    ) : WORD;
FUNCTION Dos16WriteAsync {150} (
    Handle              : WORD;     (* the handle to write to *)
    RamSemaphore        : SemaPhore;    (* semaphore to clear when done *)
    VAR ReturnCode      : WORD;     (* address of word to return status *)
    Buffer              : Pointer;      (* data buffer address *)
    Length              : WORD;     (* length of data to write *)
    VAR Written         : WORD      (* returned length actually written *)
    ) : WORD;

(* new OS/2 1.2 (!) procedures *)

TYPE
    FileStatus =
        RECORD
        fDateCreation           : fDate;
        fTimeCreation           : fTime;
        fDateLastAccess         : fDate;
        fTimeLastAccess         : fTime;
        fDateLastWrite          : fDate;
        fTimeLastWrite          : fTime;
        cbFile                  :LongInt {LONGCARD};
        cbFileAlloc             :LongInt {LONGCARD};
        attrFile                : WORD;
        END;

    FileStatus2 =
        RECORD
        fDateCreation           : fDate;
        fTimeCreation           : fTime;
        fDateLastAccess         : fDate;
        fTimeLastAccess         : fTime;
        fDateLastWrite          : fDate;
        fTimeLastWrite          : fTime;
        cbFile                  :LongInt {LONGCARD};
        cbFileAlloc             :LongInt {LONGCARD};
        attrFile                : WORD;
        cbList                  :LongInt {LONGCARD};
        END;

    FSAllocate =
        RECORD
        ulReserved      :LongInt {LONGCARD};
        cSectorUnit     :LongInt {LONGCARD};
        cUnit           :LongInt {LONGCARD};
        cUnitAvail      :LongInt {LONGCARD};
        cbSector        : WORD;
        END;

    VolumeLabel =
        RECORD
        cch             : CHAR;
        szVolLabel      : ARRAY [0..11] OF CHAR;
        END;
        
    fsInfo =
        RECORD
        ulVSN   :LongInt {LONGCARD};
        Vol     : VolumeLabel;
        END;

    FileLock =
        RECORD
        lOffset : LongInt;
        lRange  : LongInt;
        END;


FUNCTION DosGetPPID {156} (a : WORD; VAR b : WORD) : WORD;
FUNCTION Dos16GetPPID{156}(a : WORD; VAR b : WORD) : WORD;

FUNCTION DosOplockRelease {198} (a : LongInt {LONGCARD};
                                 b : WORD) : WORD;
FUNCTION Dos16OplockRelease{198}(a : LongInt {LONGCARD};
                                 b : WORD) : WORD;

FUNCTION DosOplockWait {198} (VAR a : LongInt {LONGCARD};
                              VAR b : LongInt {LONGCARD}
                                  ) : WORD;
FUNCTION Dos16OplockWait{198}(VAR a : LongInt {LONGCARD};
                              VAR b : LongInt {LONGCARD}
                                  ) : WORD;

FUNCTION DosOpen2 {95} (   a : pChar;
                       VAR b : WORD;
                       VAR c : WORD;
                           d : LongInt;
                           e : AttributeSet;
                           f : WORD;
                           g : WORD;
                           h : LongInt {LONGCARD};
                       VAR i : EaOp;
                           j : LongInt {LONGCARD}
                           ) : WORD;
FUNCTION Dos16Open2{95}(   a : pChar;
                       VAR b : WORD;
                       VAR c : WORD;
                           d : LongInt;
                           e : AttributeSet;
                           f : WORD;
                           g : WORD;
                           h : LongInt {LONGCARD};
                       VAR i : EaOp;
                           j : LongInt {LONGCARD}
                           ) : WORD;

FUNCTION DosShutdown {206} (a : LongInt {LONGCARD}
                            ) : WORD;
FUNCTION Dos16Shutdown{206}(a : LongInt {LONGCARD}
                            ) : WORD;

FUNCTION DosFindFirst2 {184} (    Name         : pChar;       (* the file name, * and ? allowed *)
                              VAR Handle       : WORD;     (* handle, 0FFFF means allocate one *)
                                  attribute    : AttributeSet; (* attributes to match *)
                              VAR ResultBuf    : FileFindBuf;  (* returned file information *)
                                  ResultBufLen : WORD;     (* length of result area *)
                              VAR count        : WORD;     (* # of files to return / returned *)
                                  a            : WORD;
                                  Reserved     : LongInt       (* must be zero *)
                                             ) : WORD;

FUNCTION Dos16FindFirst2{184}(    Name         : pChar;       (* the file name, * and ? allowed *)
                              VAR Handle       : WORD;     (* handle, 0FFFF means allocate one *)
                                  attribute    : AttributeSet; (* attributes to match *)
                              VAR ResultBuf    : FileFindBuf;  (* returned file information *)
                                  ResultBufLen : WORD;     (* length of result area *)
                              VAR count        : WORD;     (* # of files to return / returned *)
                                  a            : WORD;
                                  Reserved     : LongInt       (* must be zero *)
                                             ) : WORD;

FUNCTION DosFSAttach {181} (    a : pChar;
                                b : pChar;
                            VAR c : CHAR;
                                d : WORD;
                                e : WORD;
                                f : LongInt {LONGCARD}
                                ) : WORD;
FUNCTION Dos16FSAttach{181}(    a : pChar;
                                b : pChar;
                            VAR c : CHAR;
                                d : WORD;
                                e : WORD;
                                f :LongInt {LONGCARD}
                                ) : WORD;

FUNCTION DosQFSAttach {182} (    a : pChar;
                                 b : WORD;
                                 c : WORD;
                             VAR d : CHAR;
                             VAR e : WORD;
                                 f : LongInt {LONGCARD}
                                 ) : WORD;
FUNCTION Dos16QFSAttach{182}(    a : pChar;
                                 b : WORD;
                                 c : WORD;
                             VAR d : CHAR;
                             VAR e : WORD;
                                 f : LongInt {LONGCARD}
                                 ) : WORD;

FUNCTION DosFSCtl {183} (VAR a : CHAR;
                             b : WORD;
                         VAR c : WORD;
                         VAR d : CHAR;
                             e : WORD;
                         VAR f : WORD;
                             g : WORD;
                             h : pChar;
                             i : WORD;
                             j : WORD;
                             k : LongInt {LONGCARD}
                             ) : WORD;
FUNCTION Dos16FSCtl{183}(VAR a : CHAR;
                             b : WORD;
                         VAR c : WORD;
                         VAR d : CHAR;
                             e : WORD;
                         VAR f : WORD;
                             g : WORD;
                             h : pChar;
                             i : WORD;
                             j : WORD;
                             k : LongInt {LONGCARD}
                             ) : WORD;

FUNCTION DosCopy {201} (a : pChar;
                        b : pChar;
                        c : WORD;
                        d : LongInt {LONGCARD}
                        ) : WORD;
FUNCTION Dos16Copy{201}(a : pChar;
                        b : pChar;
                        c : WORD;
                        d : LongInt {LONGCARD}
                        ) : WORD;

FUNCTION DosEditName {191} (    a : WORD;
                                b : pChar;
                                c : pChar;
                            VAR d : CHAR;
                                e : WORD
                                ) : WORD;
FUNCTION Dos16EditName{191}(    a : WORD;
                                b : pChar;
                                c : pChar;
                            VAR d : CHAR;
                                e : WORD
                                ) : WORD;

FUNCTION DosFileIO {186} (    a : WORD;
                          VAR b : CHAR;
                              c : WORD;
                          VAR d : WORD
                              ) : WORD;
FUNCTION Dos16FileIO{186}(    a : WORD;
                          VAR b : CHAR;
                              c : WORD;
                          VAR d : WORD
                              ) : WORD;

FUNCTION DosMkDir2 {185} (    a : pChar;
                          VAR b : EaOp;
                              c : LongInt {LONGCARD}
                              ) : WORD;
FUNCTION Dos16MkDir2{185}(    a : pChar;
                          VAR b : EaOp;
                              c : LongInt {LONGCARD}
                              ) : WORD;

FUNCTION DosQPathInfo {98} (    a : pChar;
                                b : WORD;
                            VAR c : CHAR;
                                d : WORD;
                                e : LongInt {LONGCARD}
                                ) : WORD;
FUNCTION Dos16QPathInfo{98}(    a : pChar;
                                b : WORD;
                            VAR c : CHAR;
                                d : WORD;
                                e : LongInt {LONGCARD}
                                ) : WORD;

FUNCTION DosSetPathInfo {104} (    a : pChar;
                                   b : WORD;
                               VAR c : CHAR;
                                   d : WORD;
                                   e : WORD;
                                   f : LongInt {LONGCARD}
                                   ) : WORD;
FUNCTION Dos16SetPathInfo{104}(    a : pChar;
                                   b : WORD;
                               VAR c : CHAR;
                                   d : WORD;
                                   e : WORD;
                                   f : LongInt {LONGCARD}
                                   ) : WORD;

CONST
    DSPI_WRTTHRU                = $10;

    ENUMEA_REFTYPE_FHANDLE      = 0;
    ENUMEA_REFTYPE_PATH         = 1;
    ENUMEA_LEVEL_NO_VALUE       = 1;

FUNCTION DosEnumAttribute {204} (    a : WORD;
                                     b : Pointer;
                                     c : LongInt {LONGCARD};
                                     d : Pointer;
                                     e : LongInt {LONGCARD};
                                 VAR f : LongInt {LONGCARD};
                                     g : LongInt {LONGCARD};
                                     h : LongInt {LONGCARD}
                                     ) : WORD;
FUNCTION Dos16EnumAttribute{204}(    a : WORD;
                                     b : Pointer;
                                     c : LongInt {LONGCARD};
                                     d : Pointer;
                                     e : LongInt {LONGCARD};
                                 VAR f : LongInt {LONGCARD};
                                     g : LongInt {LONGCARD};
                                     h : LongInt {LONGCARD}
                                     ) : WORD;

TYPE
  Dena1 = RECORD
    Reserved : CHAR;
    cbName   : CHAR;
    cbValue  : WORD;
    szName   : ARRAY [0..0] OF CHAR;
  END;


FUNCTION DosSizeSeg {126} (    a : WORD;
                           VAR b : LongInt {LONGCARD}
                               ) : WORD;
FUNCTION Dos16SizeSeg{126}(    a : WORD;
                           VAR b : LongInt {LONGCARD}
                               ) : WORD;

TYPE
  DosFsRSem = RECORD
    cb      : WORD;
    pID     : WORD;
    tId     : WORD;
    cUsage  : WORD;
    client  : WORD;
    Sem     :LongInt {LONGCARD};
  END;

FUNCTION DosFSRamSemRequest {161} (VAR a : DosFsRSem;
                                       b : LongInt {LONGCARD}
                                       ) : WORD;
FUNCTION Dos16FSRamSemRequest{161}(VAR a : DosFsRSem;
                                       b : LongInt {LONGCARD}
                                       ) : WORD;

FUNCTION DosFSRamSemClear {162} (VAR a : DosFsRSem) : WORD;
FUNCTION Dos16FSRamSemClear{162}(VAR a : DosFsRSem) : WORD;

CONST
    RT_POINTER          = 1;
    RT_BITMAP           = 2;
    RT_MENU             = 3;
    RT_DIALOG           = 4;
    RT_STRING           = 5;
    RT_FONTDIR          = 6;
    RT_FONT             = 7;
    RT_ACCELTABLE       = 8;
    RT_RCDATA           = 9;
    RT_MESSAGE          = 10;
    RT_DLGINCLUDE       = 11;
    RT_VKEYTBL          = 12;
    RT_KEYTBL           = 13;
    RT_CHARTBL          = 14;
    RT_DISPLAYINFO      = 15;

    RT_FKASHORT         = 16;
    RT_FKALONG          = 17;

    RT_HELPTABLE        = 18;
    RT_HELPSUBTABLE     = 19;

    RT_FDDIR            = 20;
    RT_FD               = 21;

    RT_MAX              = 22;

FUNCTION DosGetResource {155} (    a : hModule;
                                   b : WORD;
                                   c : WORD;
                               VAR d : WORD) : WORD;
FUNCTION Dos16GetResource{155}(    a : hModule;
                                   b : WORD;
                                   c : WORD;
                               VAR d : WORD) : WORD;

FUNCTION DosGetResource2 {207} (a : hModule;
                                b : WORD;
                                c : WORD;
                                d : Pointer) : WORD;
FUNCTION Dos16GetResource2{207}(a : hModule;
                                b : WORD;
                                c : WORD;
                                d : Pointer) : WORD;

FUNCTION DosFreeResource {208} (a : Pointer) : WORD;
FUNCTION Dos16FreeResource{208}(a : Pointer) : WORD;

CONST
  DATEFMT_MM_DD_YY    = 0;
  DATEFMT_DD_MM_YY    = 1;
  DATEFMT_YY_MM_DD    = 2;

  CURRENCY_FOLLOW     = 1;
  CURRENTY_SPACE      = 2;
  CURRENCY_DECIMAL    = 4;

FUNCTION DosSetProcCP {164} (a, b : WORD) : WORD;
FUNCTION Dos16SetProcCP{164}(a, b : WORD) : WORD;

FUNCTION DosSendSignal {134} (a, b: WORD): WORD;
FUNCTION Dos16SendSignal{134}(a, b: WORD): WORD;

CONST
  MONITOR_DEFAULT     = 0;
  MONITOR_BEGIN       = 1;
  MONITOR_END         = 2;

TYPE
  MonIn = RECORD
    cb      : WORD;
    res1    : ARRAY [0..17] OF CHAR;
    res2    : ARRAY [0..107] OF CHAR;
  END;

  MonOut = RECORD
    cb      : WORD;
    Buffer  : ARRAY [0..17] OF CHAR;
    abBuf   : ARRAY [0..107] OF CHAR;
  END;

  QueueResult = RECORD
    pidProcess      : WORD;
    usEventCode     : WORD;
  END;

CONST
  Q_MAX_PATH_LENGTH   = 0;

  HARDERROR_ENABLE    = 1;
  HARDERROR_DISABLE   = 0;
  EXCEPTION_ENABLE    = 0;
  EXCEPTION_DISABLE   = 2;

  VECTOR_DIVIDE_BY_ZERO       = 0;
  VECTOR_OVERFLOW             = 4;
  VECTOR_OUTOFBOUNDS          = 5;
  VECTOR_INVALIDOPCODE        = 6;
  VECTOR_NO_EXTENSION         = 7;
  VECTOR_EXTENSION_ERROR      = $10;

  MODE_REAL           = 0;
  MODE_PROTECTED      = 1;

FUNCTION DosQSysInfo {166} (a : WORD;
                            b : Pointer;
                            c : WORD
                            ) : WORD;
FUNCTION Dos16QSysInfo{166}(a : WORD;
                            b : Pointer;
                            c : WORD
                            ) : WORD;

CONST
  NOTSPECIFIED        = 0;
  NOTWINDOWCOMPAT     = 1;
  WINDOWCOMPAT        = 2;
  WINDOWAPI           = 3;
  BOUND               = 4;
  DynamicLink         = 8;
  DOSFORMAT           = $10;

  TARGET_UNCHANGED    = 0;
  TARGET_CHILD        = 1;
  TARGET_NOT_SELECTABLE = 2;

  BOND_UNCHANGED      = 0;
  BOND_CHILD          = 1;
  BOND_NONE           = 2;

FUNCTION DosQAppType {163} (    a : pChar;
                            VAR b : WORD) : WORD;
FUNCTION Dos16QAppType{163}(   a : pChar;
                           VAR b : WORD) : WORD;

CONST
  INFO_COUNT_PARTITIONABLE_DISKS      = 1;
  INFO_GETIOCTLHANDLE                 = 2;
  INFO_FREEIOCTLHANDLE                = 3;

  DEVINFO_PRINTER             = 0;
  DEVINFO_RS232               = 1;
  DEVINFO_FLOPPY              = 2;
  DEVINFO_COPROCESSOR         = 3;
  DEVINFO_SUBMODEL            = 4;
  DEVINFO_MODEL               = 5;
  DEVINFO_ADAPTOR             = 6;

FUNCTION DosDevIOCtl2 {99} (
    Data                : Pointer;      (* address of data buffer *)
    a : WORD;
    ParamList           : Pointer;      (* command specific arguments *)
    aFunction           : WORD;     (* device specific function code *)
    Category            : WORD;     (* device category *)
    Handle              : WORD;     (* handle for the device *)
    b : WORD
    ) : WORD;
FUNCTION Dos16DevIOCtl2 {99} (
    Data                : Pointer;      (* address of data buffer *)
    a : WORD;
    ParamList           : Pointer;      (* command specific arguments *)
    aFunction           : WORD;     (* device specific function code *)
    Category            : WORD;     (* device category *)
    Handle              : WORD;     (* handle for the device *)
    b : WORD
    ) : WORD;

FUNCTION DosR2StackRealloc {160}(a : WORD) : WORD;
FUNCTION Dos16R2StackRealloc{160}(a : WORD) : WORD;

FUNCTION DosCallback {157} (a : Pointer(*!!!PFN*)) : WORD;
FUNCTION Dos16Callback{157}(a : Pointer(*!!!PFN*)) : WORD;

FUNCTION DosSetVec  (    VecNum  : WORD;
                         Handler : Pointer;
                     VAR PrevHandler : Pointer): WORD;
FUNCTION Dos16SetVec(    VecNum  : WORD;
                         Handler : Pointer;
                     VAR PrevHandler : Pointer) : WORD;

PROCEDURE DosWrite  (    Handle : WORD;
                         Buf    : pChar;
                         count  : WORD;
                     VAR WCount : WORD);
PROCEDURE Dos16Write(    Handle : WORD;
                     VAR Buf;
                         count : WORD;
                     VAR WCount : WORD);

FUNCTION  DosBeep  (Freq, Duration : WORD) : WORD;
FUNCTION  Dos16Beep(Freq, Duration : WORD) : WORD;

PROCEDURE DosExit  (x : WORD; ExitCode : WORD);
PROCEDURE Dos16Exit(x : WORD; ExitCode : WORD);

FUNCTION  DosCreateThread(      Proc  : Pointer;
                            VAR tId   : WORD;
                                Stack : Pointer) : WORD;
FUNCTION  Dos16CreateThread(    Proc  : Pointer;
                            VAR tId   : WORD;
                                Stack : Pointer) : WORD;

IMPLEMENTATION

  FUNCTION DosCWait(* ------------- *);
    EXTERNAL 'DosCalls' INDEX   2;
  FUNCTION Dos16CWait(* ------------- *);
    EXTERNAL 'DosCalls' INDEX   2;

  PROCEDURE DosEnterCritSec(* ------------- *);
    EXTERNAL 'DosCalls' INDEX   3;
  PROCEDURE Dos16EnterCritSec(* ------------- *);
    EXTERNAL 'DosCalls' INDEX   3;

(* ====================================================== *)


  PROCEDURE DosExit;   EXTERNAL 'DosCalls' INDEX  5;
  PROCEDURE Dos16Exit; EXTERNAL 'DosCalls' INDEX  5;


  PROCEDURE DosExitCritSec(* ------------- *);
    EXTERNAL 'DosCalls' INDEX   6;
  PROCEDURE Dos16ExitCritSec(* ------------- *);
    EXTERNAL 'DosCalls' INDEX   6;

  FUNCTION DosExitList(* ------------- *);
    EXTERNAL 'DosCalls' INDEX   7;
  FUNCTION Dos16ExitList(* ------------- *);
    EXTERNAL 'DosCalls' INDEX   7;

  PROCEDURE  DosGetInfoSeg(* ------------- *);
    EXTERNAL 'DosCalls' INDEX   8;
  PROCEDURE  Dos16GetInfoSeg(* ------------- *);
    EXTERNAL 'DosCalls' INDEX   8;

  FUNCTION DosGetPrty(* ------------- *);
    EXTERNAL 'DosCalls' INDEX   9;
  FUNCTION Dos16GetPrty(* ------------- *);
    EXTERNAL 'DosCalls' INDEX   9;

  FUNCTION DosKillProcess(* ------------- *);
    EXTERNAL 'DosCalls' INDEX  10;
  FUNCTION Dos16KillProcess(* ------------- *);
    EXTERNAL 'DosCalls' INDEX  10;

  FUNCTION DosSetPrty(* ------------- *);
    EXTERNAL 'DosCalls' INDEX  11;
  FUNCTION Dos16SetPrty(* ------------- *);
    EXTERNAL 'DosCalls' INDEX  11;

  FUNCTION DosPTrace(* ------------- *);
    EXTERNAL 'DosCalls' INDEX  12;

  FUNCTION DosHoldSignal(* ------------- *);
    EXTERNAL 'DosCalls' INDEX  13;
  FUNCTION Dos16HoldSignal(* ------------- *);
    EXTERNAL 'DosCalls' INDEX  13;

  FUNCTION DosSetSigHandler(* ------------- *);
    EXTERNAL 'DosCalls' INDEX  14;
  FUNCTION Dos16SetSigHandler(* ------------- *);
    EXTERNAL 'DosCalls' INDEX  14;

  FUNCTION DosFlagProcess(* ------------- *);
    EXTERNAL 'DosCalls' INDEX  15;
  FUNCTION Dos16FlagProcess(* ------------- *);
    EXTERNAL 'DosCalls' INDEX  15;

  FUNCTION DosMakePipe(* ------------- *);
    EXTERNAL 'DosCalls' INDEX  16;
  FUNCTION Dos16MakePipe(* ------------- *);
    EXTERNAL 'DosCalls' INDEX  16;

  FUNCTION DosSemSetWait(* ------------- *);
    EXTERNAL 'DosCalls' INDEX  20;
  FUNCTION Dos16SemSetWait(* ------------- *);
    EXTERNAL 'DosCalls' INDEX  20;

(* ====================================================== *)

  FUNCTION DosMuxSemWait(* ------------- *);
    EXTERNAL 'DosCalls' INDEX  22;
  FUNCTION Dos16MuxSemWait(* ------------- *);
    EXTERNAL 'DosCalls' INDEX  22;

  FUNCTION DosCloseSem(* ------------- *);
    EXTERNAL 'DosCalls' INDEX  23;
  FUNCTION Dos16CloseSem(* ------------- *);
    EXTERNAL 'DosCalls' INDEX  23;

  FUNCTION DosCreateSem(* ------------- *);
    EXTERNAL 'DosCalls' INDEX  24;
  FUNCTION Dos16CreateSem(* ------------- *);
    EXTERNAL 'DosCalls' INDEX  24;

  FUNCTION DosOpenSem(* ------------- *);
    EXTERNAL 'DosCalls' INDEX  25;
  FUNCTION Dos16OpenSem(* ------------- *);
    EXTERNAL 'DosCalls' INDEX  25;

  FUNCTION DosResumeThread(* ------------- *);
    EXTERNAL 'DosCalls' INDEX  26;
  FUNCTION Dos16ResumeThread(* ------------- *);
    EXTERNAL 'DosCalls' INDEX  26;

  FUNCTION DosSuspendThread(* ------------- *);
    EXTERNAL 'DosCalls' INDEX  27;
  FUNCTION Dos16SuspendThread(* ------------- *);
    EXTERNAL 'DosCalls' INDEX  27;

  FUNCTION DosSetDateTime(* ------------- *);
    EXTERNAL 'DosCalls' INDEX  28;
  FUNCTION Dos16SetDateTime(* ------------- *);
    EXTERNAL 'DosCalls' INDEX  28;

  FUNCTION DosTimerAsync(* ------------- *);
    EXTERNAL 'DosCalls' INDEX  29;
  FUNCTION Dos16TimerAsync(* ------------- *);
    EXTERNAL 'DosCalls' INDEX  29;

  FUNCTION DosTimerStart(* ------------- *);
    EXTERNAL 'DosCalls' INDEX  30;
  FUNCTION Dos16TimerStart(* ------------- *);
    EXTERNAL 'DosCalls' INDEX  30;

  FUNCTION DosTimerStop(* ------------- *);
    EXTERNAL 'DosCalls' INDEX  31;
  FUNCTION Dos16TimerStop(* ------------- *);
    EXTERNAL 'DosCalls' INDEX  31;

  FUNCTION DosSleep(* ------------- *);
    EXTERNAL 'DosCalls' INDEX  32;
  FUNCTION Dos16Sleep(* ------------- *);
    EXTERNAL 'DosCalls' INDEX  32;

  FUNCTION DosGetDateTime(* ------------- *);
    EXTERNAL 'DosCalls' INDEX  33;
  FUNCTION Dos16GetDateTime(* ------------- *);
    EXTERNAL 'DosCalls' INDEX  33;

  FUNCTION DosAllocSeg(* ------------- *);
    EXTERNAL 'DosCalls' INDEX  34;
  FUNCTION Dos16AllocSeg(* ------------- *);
    EXTERNAL 'DosCalls' INDEX  34;

  FUNCTION DosAllocShrSeg(* ------------- *);
    EXTERNAL 'DosCalls' INDEX  35;
  FUNCTION Dos16AllocShrSeg(* ------------- *);
    EXTERNAL 'DosCalls' INDEX  35;

  FUNCTION DosGetShrSeg(* ------------- *);
    EXTERNAL 'DosCalls' INDEX  36;
  FUNCTION Dos16GetShrSeg(* ------------- *);
    EXTERNAL 'DosCalls' INDEX  36;

  FUNCTION DosGiveSeg(* ------------- *);
    EXTERNAL 'DosCalls' INDEX  37;
  FUNCTION Dos16GiveSeg(* ------------- *);
    EXTERNAL 'DosCalls' INDEX  37;

  FUNCTION DosReAllocSeg(* ------------- *);
    EXTERNAL 'DosCalls' INDEX  38;
  FUNCTION Dos16ReAllocSeg(* ------------- *);
    EXTERNAL 'DosCalls' INDEX  38;

  FUNCTION DosFreeSeg(* ------------- *);
    EXTERNAL 'DosCalls' INDEX  39;
  FUNCTION Dos16FreeSeg(* ------------- *);
    EXTERNAL 'DosCalls' INDEX  39;

  FUNCTION DosAllocHuge(* ------------- *);
    EXTERNAL 'DosCalls' INDEX  40;
  FUNCTION Dos16AllocHuge(* ------------- *);
    EXTERNAL 'DosCalls' INDEX  40;

  FUNCTION DosGetHugeShift(* ------------- *);
    EXTERNAL 'DosCalls' INDEX  41;
  FUNCTION Dos16GetHugeShift(* ------------- *);
    EXTERNAL 'DosCalls' INDEX  41;

  FUNCTION DosReAllocHuge(* ------------- *);
    EXTERNAL 'DosCalls' INDEX  42;
  FUNCTION Dos16ReAllocHuge(* ------------- *);
    EXTERNAL 'DosCalls' INDEX  42;

  FUNCTION DosCreateCSAlias(* ------------- *);
    EXTERNAL 'DosCalls' INDEX  43;
  FUNCTION Dos16CreateCSAlias(* ------------- *);
    EXTERNAL 'DosCalls' INDEX  43;

  FUNCTION DosLoadModule(* ------------- *);
    EXTERNAL 'DosCalls' INDEX  44;
  FUNCTION Dos16LoadModule(* ------------- *);
    EXTERNAL 'DosCalls' INDEX  44;

  FUNCTION DosGetProcAddr(* ------------- *);
    EXTERNAL 'DosCalls' INDEX  45;
  FUNCTION Dos16GetProcAddr(* ------------- *);
    EXTERNAL 'DosCalls' INDEX  45;

  FUNCTION DosFreeModule(* ------------- *);
    EXTERNAL 'DosCalls' INDEX  46;
  FUNCTION Dos16FreeModule(* ------------- *);
    EXTERNAL 'DosCalls' INDEX  46;

  FUNCTION DosGetModHandle(* ------------- *);
    EXTERNAL 'DosCalls' INDEX  47;
  FUNCTION Dos16GetModHandle(* ------------- *);
    EXTERNAL 'DosCalls' INDEX  47;

  FUNCTION DosGetModName(* ------------- *);
    EXTERNAL 'DosCalls' INDEX  48;
  FUNCTION Dos16GetModName(* ------------- *);
    EXTERNAL 'DosCalls' INDEX  48;

  PROCEDURE DosGetMachineMode(* ------------- *);
    EXTERNAL 'DosCalls' INDEX  49;
  PROCEDURE Dos16GetMachineMode(* ------------- *);
    EXTERNAL 'DosCalls' INDEX  49;


  FUNCTION DosBeep;     EXTERNAL 'DosCalls' INDEX  50;
  FUNCTION Dos16Beep;   EXTERNAL 'DosCalls' INDEX  50;


  FUNCTION DosCLIAccess(* ------------- *);
    EXTERNAL 'DosCalls' INDEX  51;
  FUNCTION Dos16CLIAccess(* ------------- *);
    EXTERNAL 'DosCalls' INDEX  51;

  FUNCTION DosDevConfig(* ------------- *);
    EXTERNAL 'DosCalls' INDEX  52;
  FUNCTION Dos16DevConfig(* ------------- *);
    EXTERNAL 'DosCalls' INDEX  52;

  FUNCTION DosDevIOCtl(* ------------- *);
    EXTERNAL 'DosCalls' INDEX  53;
  FUNCTION Dos16DevIOCtl(* ------------- *);
    EXTERNAL 'DosCalls' INDEX  53;

(* ====================================================== *)

  FUNCTION DosBufReset(* ------------- *);
    EXTERNAL 'DosCalls' INDEX  56;
  FUNCTION Dos16BufReset(* ------------- *);
    EXTERNAL 'DosCalls' INDEX  56;

  FUNCTION DosChDir(* ------------- *);
    EXTERNAL 'DosCalls' INDEX  57;
  FUNCTION Dos16ChDir(* ------------- *);
    EXTERNAL 'DosCalls' INDEX  57;

  FUNCTION DosChgFilePtr(* ------------- *);
    EXTERNAL 'DosCalls' INDEX  58;
  FUNCTION Dos16ChgFilePtr(* ------------- *);
    EXTERNAL 'DosCalls' INDEX  58;

  FUNCTION DosClose(* ------------- *);
    EXTERNAL 'DosCalls' INDEX  59;
  FUNCTION Dos16Close(* ------------- *);
    EXTERNAL 'DosCalls' INDEX  59;

  FUNCTION DosDelete(* ------------- *);
    EXTERNAL 'DosCalls' INDEX  60;
  FUNCTION Dos16Delete(* ------------- *);
    EXTERNAL 'DosCalls' INDEX  60;

  FUNCTION DosDupHandle(* ------------- *);
    EXTERNAL 'DosCalls' INDEX  61;
  FUNCTION Dos16DupHandle(* ------------- *);
    EXTERNAL 'DosCalls' INDEX  61;

  FUNCTION DosFileLocks(* ------------- *);
    EXTERNAL 'DosCalls' INDEX  62;
  FUNCTION Dos16FileLocks(* ------------- *);
    EXTERNAL 'DosCalls' INDEX  62;

  FUNCTION DosFindClose(* ------------- *);
    EXTERNAL 'DosCalls' INDEX  63;
  FUNCTION Dos16FindClose(* ------------- *);
    EXTERNAL 'DosCalls' INDEX  63;

  FUNCTION DosFindFirst(* ------------- *);
    EXTERNAL 'DosCalls' INDEX  64;
  FUNCTION Dos16FindFirst(* ------------- *);
    EXTERNAL 'DosCalls' INDEX  64;

  FUNCTION DosFindNext(* ------------- *);
    EXTERNAL 'DosCalls' INDEX  65;
  FUNCTION Dos16FindNext(* ------------- *);
    EXTERNAL 'DosCalls' INDEX  65;

  FUNCTION DosMkDir(* ------------- *);
    EXTERNAL 'DosCalls' INDEX  66;
  FUNCTION Dos16MkDir(* ------------- *);
    EXTERNAL 'DosCalls' INDEX  66;

  FUNCTION DosMove(* ------------- *);
    EXTERNAL 'DosCalls' INDEX  67;
  FUNCTION Dos16Move(* ------------- *);
    EXTERNAL 'DosCalls' INDEX  67;

  FUNCTION DosNewSize(* ------------- *);
    EXTERNAL 'DosCalls' INDEX  68;
  FUNCTION Dos16NewSize(* ------------- *);
    EXTERNAL 'DosCalls' INDEX  68;

  FUNCTION DosPortAccess(* ------------- *);
    EXTERNAL 'DosCalls' INDEX  69;
  FUNCTION Dos16PortAccess(* ------------- *);
    EXTERNAL 'DosCalls' INDEX  69;

  FUNCTION DosOpen(* ------------- *);
    EXTERNAL 'DosCalls' INDEX  70;
  FUNCTION Dos16Open(* ------------- *);
    EXTERNAL 'DosCalls' INDEX  70;

  FUNCTION DosQCurDir(* ------------- *);
    EXTERNAL 'DosCalls' INDEX  71;
  FUNCTION Dos16QCurDir(* ------------- *);
    EXTERNAL 'DosCalls' INDEX  71;

  FUNCTION DosQCurDisk(* ------------- *);
    EXTERNAL 'DosCalls' INDEX  72;
  FUNCTION Dos16QCurDisk(* ------------- *);
    EXTERNAL 'DosCalls' INDEX  72;

  FUNCTION DosQFHandState(* ------------- *);
    EXTERNAL 'DosCalls' INDEX  73;
  FUNCTION Dos16QFHandState(* ------------- *);
    EXTERNAL 'DosCalls' INDEX  73;

  FUNCTION DosQFileInfo(* ------------- *);
    EXTERNAL 'DosCalls' INDEX  74;
  FUNCTION Dos16QFileInfo(* ------------- *);
    EXTERNAL 'DosCalls' INDEX  74;

  FUNCTION DosQFileMode(* ------------- *);
    EXTERNAL 'DosCalls' INDEX  75;
  FUNCTION Dos16QFileMode(* ------------- *);
    EXTERNAL 'DosCalls' INDEX  75;

  FUNCTION DosQFSInfo(* ------------- *);
    EXTERNAL 'DosCalls' INDEX  76;
  FUNCTION Dos16QFSInfo(* ------------- *);
    EXTERNAL 'DosCalls' INDEX  76;

  FUNCTION DosQHandType(* ------------- *);
    EXTERNAL 'DosCalls' INDEX  77;
  FUNCTION Dos16QHandType(* ------------- *);
    EXTERNAL 'DosCalls' INDEX  77;

  FUNCTION DosQVerify(* ------------- *);
    EXTERNAL 'DosCalls' INDEX  78;
  FUNCTION Dos16QVerify(* ------------- *);
    EXTERNAL 'DosCalls' INDEX  78;

  FUNCTION DosRmDir(* ------------- *);
    EXTERNAL 'DosCalls' INDEX  80;
  FUNCTION Dos16RmDir(* ------------- *);
    EXTERNAL 'DosCalls' INDEX  80;

  FUNCTION DosSelectDisk(* ------------- *);
    EXTERNAL 'DosCalls' INDEX  81;
  FUNCTION Dos16SelectDisk(* ------------- *);
    EXTERNAL 'DosCalls' INDEX  81;

  FUNCTION DosSetFHandState(* ------------- *);
    EXTERNAL 'DosCalls' INDEX  82;
  FUNCTION Dos16SetFHandState(* ------------- *);
    EXTERNAL 'DosCalls' INDEX  82;

  FUNCTION DosSetFileInfo(* ------------- *);
    EXTERNAL 'DosCalls' INDEX  83;
  FUNCTION Dos16SetFileInfo(* ------------- *);
    EXTERNAL 'DosCalls' INDEX  83;

  FUNCTION DosSetFileMode(* ------------- *);
    EXTERNAL 'DosCalls' INDEX  84;
  FUNCTION Dos16SetFileMode(* ------------- *);
    EXTERNAL 'DosCalls' INDEX  84;

  FUNCTION DosSetMaxFH(* ------------- *);
    EXTERNAL 'DosCalls' INDEX  85;
  FUNCTION Dos16SetMaxFH(* ------------- *);
    EXTERNAL 'DosCalls' INDEX  85;

  FUNCTION DosSetVerify(* ------------- *);
    EXTERNAL 'DosCalls' INDEX  86;
  FUNCTION Dos16SetVerify(* ------------- *);
    EXTERNAL 'DosCalls' INDEX  86;

  FUNCTION DosSystemService(* ------------- *);
    EXTERNAL 'DosCalls' INDEX  88;
  FUNCTION Dos16SystemService(* ------------- *);
    EXTERNAL 'DosCalls' INDEX  88;

  FUNCTION DosSetVec(* ------------- *);
    EXTERNAL 'DosCalls' INDEX  89;
  FUNCTION Dos16SetVec(* ------------- *);
    EXTERNAL 'DosCalls' INDEX  89;
{
  FUNCTION DosSysTrace(* ------------- *);
    External 'DosCalls' INDEX  90;
  FUNCTION Dos16SysTrace(* ------------- *);
    External 'DosCalls' INDEX  90;
}
  FUNCTION DosGetEnv(* ------------- *);
    EXTERNAL 'DosCalls' INDEX  91;
  FUNCTION Dos16GetEnv(* ------------- *);
    EXTERNAL 'DosCalls' INDEX  91;

  PROCEDURE DosGetVersion;
    EXTERNAL 'DosCalls' INDEX  92;
  PROCEDURE Dos16GetVersion;
    EXTERNAL 'DosCalls' INDEX  92;

(* ====================================================== *)

  FUNCTION DosGetPID(* ------------- *);
    EXTERNAL 'DosCalls' INDEX  94;
  FUNCTION Dos16GetPID(* ------------- *);
    EXTERNAL 'DosCalls' INDEX  94;

  FUNCTION DosOpen2(* ------------- *);
    EXTERNAL 'DosCalls' INDEX  95;
  FUNCTION Dos16Open2(* ------------- *);
    EXTERNAL 'DosCalls' INDEX  95;
{
  FUNCTION DosLibInit(* ------------- *);
    External 'DosCalls' INDEX  96;
  FUNCTION Dos16LibInit(* ------------- *);
    External 'DosCalls' INDEX  96;
}
  FUNCTION DosSetFSInfo(* ------------- *);
    EXTERNAL 'DosCalls' INDEX  97;
  FUNCTION Dos16SetFSInfo(* ------------- *);
    EXTERNAL 'DosCalls' INDEX  97;

  FUNCTION DosQPathInfo(* ------------- *);
    EXTERNAL 'DosCalls' INDEX  98;
  FUNCTION Dos16QPathInfo(* ------------- *);
    EXTERNAL 'DosCalls' INDEX  98;

  FUNCTION DosDevIOCtl2(* ------------- *);
    EXTERNAL 'DosCalls' INDEX  99;
  FUNCTION Dos16DevIOCtl2(* ------------- *);
    EXTERNAL 'DosCalls' INDEX  99;

(* ====================================================== *)

  FUNCTION DosSetPathInfo(* ------------- *);
    EXTERNAL 'DosCalls' INDEX 104;
  FUNCTION Dos16SetPathInfo(* ------------- *);
    EXTERNAL 'DosCalls' INDEX 104;
{
  FUNCTION DosISetRelMaxFh(* ------------- *);
    External 'DosCalls' INDEX 108;

  FUNCTION DosIDevIOCtl(* ------------- *);
    External 'DosCalls' INDEX 109;

  FUNCTION Dos32ForceDelete(* ------------- *);
    External 'DosCalls' INDEX 110;

  FUNCTION Dos32KillThread(* ------------- *);
    External 'DosCalls' INDEX 111;

  FUNCTION Dos32QueryRASInfo(* ------------- *);
    External 'DosCalls' INDEX 112;
}
(* ====================================================== *)

  FUNCTION DosError(* ------------- *);
    EXTERNAL 'DosCalls' INDEX 120;
  FUNCTION Dos16Error(* ------------- *);
    EXTERNAL 'DosCalls' INDEX 120;

  FUNCTION DosGetSeg(* ------------- *);
    EXTERNAL 'DosCalls' INDEX 121;
  FUNCTION Dos16GetSeg(* ------------- *);
    EXTERNAL 'DosCalls' INDEX 121;

  FUNCTION DosLockSeg(* ------------- *);
    EXTERNAL 'DosCalls' INDEX 122;
  FUNCTION Dos16LockSeg(* ------------- *);
    EXTERNAL 'DosCalls' INDEX 122;

  FUNCTION DosUnlockSeg(* ------------- *);
    EXTERNAL 'DosCalls' INDEX 123;
  FUNCTION Dos16UnlockSeg(* ------------- *);
    EXTERNAL 'DosCalls' INDEX 123;

  FUNCTION DosSizeSeg(* ------------- *);
    EXTERNAL 'DosCalls' INDEX 126;
  FUNCTION Dos16SizeSeg(* ------------- *);
    EXTERNAL 'DosCalls' INDEX 126;

  FUNCTION DosMemAvail(* ------------- *);
    EXTERNAL 'DosCalls' INDEX 127;
  FUNCTION Dos16MemAvail(* ------------- *);
    EXTERNAL 'DosCalls' INDEX 127;

  FUNCTION DosPhysicalDisk(* ------------- *);
    EXTERNAL 'DosCalls' INDEX 129;
  FUNCTION Dos16PhysicalDisk(* ------------- *);
    EXTERNAL 'DosCalls' INDEX 129;

  FUNCTION DosGetCP(* ------------- *);
    EXTERNAL 'DosCalls' INDEX 130;
  FUNCTION Dos16GetCP(* ------------- *);
    EXTERNAL 'DosCalls' INDEX 130;

(* ====================================================== *)

  FUNCTION DosSendSignal(* ------------- *);
    EXTERNAL 'DosCalls' INDEX 134;
  FUNCTION Dos16SendSignal(* ------------- *);
    EXTERNAL 'DosCalls' INDEX 134;
{
  FUNCTION DosHugeShift(* ------------- *);
    External 'DosCalls' INDEX 135;
  FUNCTION Dos16HugeShift(* ------------- *);
    External 'DosCalls' INDEX 135;

  FUNCTION DosHugeIncr(* ------------- *);
    External 'DosCalls' INDEX 136;
  FUNCTION Dos16HugeIncr(* ------------- *);
    External 'DosCalls' INDEX 136;
}
  FUNCTION DosRead(* ------------- *);
    EXTERNAL 'DosCalls' INDEX 137;
  FUNCTION Dos16Read(* ------------- *);
    EXTERNAL 'DosCalls' INDEX 137;

  PROCEDURE DosWrite;   EXTERNAL 'DosCalls' INDEX 138;
  PROCEDURE Dos16Write; EXTERNAL 'DosCalls' INDEX 138;


  FUNCTION DosErrClass(* ------------- *);
    EXTERNAL 'DosCalls' INDEX 139;
  FUNCTION Dos16ErrClass(* ------------- *);
    EXTERNAL 'DosCalls' INDEX 139;

  FUNCTION DosSemRequest(* ------------- *);
    EXTERNAL 'DosCalls' INDEX 140;
  FUNCTION Dos16SemRequest(* ------------- *);
    EXTERNAL 'DosCalls' INDEX 140;

  FUNCTION DosSemClear(* ------------- *);
    EXTERNAL 'DosCalls' INDEX 141;
  FUNCTION Dos16SemClear(* ------------- *);
    EXTERNAL 'DosCalls' INDEX 141;

  FUNCTION DosSemWait(* ------------- *);
    EXTERNAL 'DosCalls' INDEX 142;
  FUNCTION Dos16SemWait(* ------------- *);
    EXTERNAL 'DosCalls' INDEX 142;

  FUNCTION DosSemSet(* ------------- *);
    EXTERNAL 'DosCalls' INDEX 143;
  FUNCTION Dos16SemSet(* ------------- *);
    EXTERNAL 'DosCalls' INDEX 143;

  FUNCTION DosExecPgm(* ------------- *);
    EXTERNAL 'DosCalls' INDEX 144;
  FUNCTION Dos16ExecPgm(* ------------- *);
    EXTERNAL 'DosCalls' INDEX 144;

  FUNCTION DosCreateThread;   EXTERNAL 'DosCalls' INDEX 145;
  FUNCTION Dos16CreateThread; EXTERNAL 'DosCalls' INDEX 145;

  FUNCTION DosSubSet(* ------------- *);
    EXTERNAL 'DosCalls' INDEX 146;
  FUNCTION Dos16SubSet(* ------------- *);
    EXTERNAL 'DosCalls' INDEX 146;

  FUNCTION DosSubAlloc(* ------------- *);
    EXTERNAL 'DosCalls' INDEX 147;
  FUNCTION Dos16SubAlloc(* ------------- *);
    EXTERNAL 'DosCalls' INDEX 147;

  FUNCTION DosSubFree(* ------------- *);
    EXTERNAL 'DosCalls' INDEX 148;
  FUNCTION Dos16SubFree(* ------------- *);
    EXTERNAL 'DosCalls' INDEX 148;

  FUNCTION DosReadAsync(* ------------- *);
    EXTERNAL 'DosCalls' INDEX 149;
  FUNCTION Dos16ReadAsync(* ------------- *);
    EXTERNAL 'DosCalls' INDEX 149;

  FUNCTION DosWriteAsync(* ------------- *);
    EXTERNAL 'DosCalls' INDEX 150;
  FUNCTION Dos16WriteAsync(* ------------- *);
    EXTERNAL 'DosCalls' INDEX 150;

  FUNCTION DosSearchPath(* ------------- *);
    EXTERNAL 'DosCalls' INDEX 151;
  FUNCTION Dos16SearchPath(* ------------- *);
    EXTERNAL 'DosCalls' INDEX 151;

  FUNCTION DosScanEnv(* ------------- *);
    EXTERNAL 'DosCalls' INDEX 152;
  FUNCTION Dos16ScanEnv(* ------------- *);
    EXTERNAL 'DosCalls' INDEX 152;

  FUNCTION DosSetCP(* ------------- *);
    EXTERNAL 'DosCalls' INDEX 153;
  FUNCTION Dos16SetCP(* ------------- *);
    EXTERNAL 'DosCalls' INDEX 153;

  FUNCTION DosGetResource(* ------------- *);
    EXTERNAL 'DosCalls' INDEX 155;
  FUNCTION Dos16GetResource(* ------------- *);
    EXTERNAL 'DosCalls' INDEX 155;

  FUNCTION DosGetPPID(* ------------- *);
    EXTERNAL 'DosCalls' INDEX 156;
  FUNCTION Dos16GetPPID(* ------------- *);
    EXTERNAL 'DosCalls' INDEX 156;

  FUNCTION DosCallback(* ------------- *);
    EXTERNAL 'DosCalls' INDEX 157;
  FUNCTION Dos16Callback(* ------------- *);
    EXTERNAL 'DosCalls' INDEX 157;

  FUNCTION DosR2StackRealloc(* ------------- *);
    EXTERNAL 'DosCalls' INDEX 160;
  FUNCTION Dos16R2StackRealloc(* ------------- *);
    EXTERNAL 'DosCalls' INDEX 160;

  FUNCTION DosFSRamSemRequest(* ------------- *);
    EXTERNAL 'DosCalls' INDEX 161;
  FUNCTION Dos16FSRamSemRequest(* ------------- *);
    EXTERNAL 'DosCalls' INDEX 161;

  FUNCTION DosFSRamSemClear(* ------------- *);
    EXTERNAL 'DosCalls' INDEX 162;
  FUNCTION Dos16FSRamSemClear(* ------------- *);
    EXTERNAL 'DosCalls' INDEX 162;

  FUNCTION DosQAppType(* ------------- *);
    EXTERNAL 'DosCalls' INDEX 163;
  FUNCTION Dos16QAppType(* ------------- *);
    EXTERNAL 'DosCalls' INDEX 163;

  FUNCTION DosSetProcCP(* ------------- *);
    EXTERNAL 'DosCalls' INDEX 164;
  FUNCTION Dos16SetProcCP(* ------------- *);
    EXTERNAL 'DosCalls' INDEX 164;
{
  FUNCTION DosDynamicTrace(* ------------- *);
    External 'DosCalls' INDEX 165;
  FUNCTION Dos16DynamicTrace(* ------------- *);
    External 'DosCalls' INDEX 165;
}
  FUNCTION DosQSysInfo(* ------------- *);
    EXTERNAL 'DosCalls' INDEX 166;
  FUNCTION Dos16QSysInfo(* ------------- *);
    EXTERNAL 'DosCalls' INDEX 166;

(* ====================================================== *)

  FUNCTION DosFSAttach(* ------------- *);
    EXTERNAL 'DosCalls' INDEX 181;
  FUNCTION Dos16FSAttach(* ------------- *);
    EXTERNAL 'DosCalls' INDEX 181;

  FUNCTION DosQFSAttach(* ------------- *);
    EXTERNAL 'DosCalls' INDEX 182;
  FUNCTION Dos16QFSAttach(* ------------- *);
    EXTERNAL 'DosCalls' INDEX 182;

  FUNCTION DosFSCtl(* ------------- *);
    EXTERNAL 'DosCalls' INDEX 183;
  FUNCTION Dos16FSCtl(* ------------- *);
    EXTERNAL 'DosCalls' INDEX 183;

  FUNCTION DosFindFirst2(* ------------- *);
    EXTERNAL 'DosCalls' INDEX 184;
  FUNCTION Dos16FindFirst2(* ------------- *);
    EXTERNAL 'DosCalls' INDEX 184;
  FUNCTION DosMkDir2(* ------------- *);

    EXTERNAL 'DosCalls' INDEX 185;
  FUNCTION Dos16MkDir2(* ------------- *);
    EXTERNAL 'DosCalls' INDEX 185;

  FUNCTION DosFileIO(* ------------- *);
    EXTERNAL 'DosCalls' INDEX 186;
  FUNCTION Dos16FileIO(* ------------- *);
    EXTERNAL 'DosCalls' INDEX 186;
{
  FUNCTION DosFindNotifyClose(* ------------- *);
    External 'DosCalls' INDEX 187;
  FUNCTION Dos16FindNotifyClose(* ------------- *);
    External 'DosCalls' INDEX 187;

  FUNCTION DosFindNotifyFirst(* ------------- *);
    External 'DosCalls' INDEX 188;
  FUNCTION Dos16FindNotifyFirst(* ------------- *);
    External 'DosCalls' INDEX 188;

  FUNCTION DosFindNotifyNext(* ------------- *);
    External 'DosCalls' INDEX 189;
  FUNCTION Dos16FindNotifyNext(* ------------- *);
    External 'DosCalls' INDEX 189;
}
  FUNCTION DosEditName(* ------------- *);
    EXTERNAL 'DosCalls' INDEX 191;
  FUNCTION Dos16EditName(* ------------- *);
    EXTERNAL 'DosCalls' INDEX 191;

  FUNCTION DosOplockRelease;   EXTERNAL 'DosCalls' INDEX 198;
  FUNCTION Dos16OplockRelease; EXTERNAL 'DosCalls' INDEX 198;

  FUNCTION DosOplockWait;   EXTERNAL 'DosCalls' INDEX 198;
  FUNCTION Dos16OplockWait; EXTERNAL 'DosCalls' INDEX 198;

  FUNCTION DosCopy(* ------------- *);
    EXTERNAL 'DosCalls' INDEX 201;
  FUNCTION Dos16Copy(* ------------- *);
    EXTERNAL 'DosCalls' INDEX 201;
{
  FUNCTION DosForceDelete(* ------------- *);
    External 'DosCalls' INDEX 203;
  FUNCTION Dos16ForceDelete(* ------------- *);
    External 'DosCalls' INDEX 203;
}
  FUNCTION DosEnumAttribute(* ------------- *);
    EXTERNAL 'DosCalls' INDEX 204;
  FUNCTION Dos16EnumAttribute(* ------------- *);
    EXTERNAL 'DosCalls' INDEX 204;

  FUNCTION DosShutdown(* ------------- *);
    EXTERNAL 'DosCalls' INDEX 206;
  FUNCTION Dos16Shutdown(* ------------- *);
    EXTERNAL 'DosCalls' INDEX 206;

  FUNCTION DosGetResource2(* ------------- *);
    EXTERNAL 'DosCalls' INDEX 207;
  FUNCTION Dos16GetResource2(* ------------- *);
    EXTERNAL 'DosCalls' INDEX 207;
  FUNCTION DosFreeResource(* ------------- *);
    EXTERNAL 'DosCalls' INDEX 208;
  FUNCTION Dos16FreeResource(* ------------- *);
    EXTERNAL 'DosCalls' INDEX 208;


(* ====================================================== *)
(*                         32 Bit                         *)
{                     nicht implementiert
  FUNCTION Dos32SetMaxFH(* ------------- *);
    External 'DosCalls' INDEX 209;

  FUNCTION Dos32SetVerify(* ------------- *);
    External 'DosCalls' INDEX 210;

  FUNCTION Dos32ErrClass(* ------------- *);
    External 'DosCalls' INDEX 211;

  FUNCTION Dos32Error(* ------------- *);
    External 'DosCalls' INDEX 212;
}

(* ====================================================== *)
(*                         16 Bit                         *)
{
  FUNCTION DosMaxPathLen(* ------------- *);
    External 'DosCalls' INDEX 214;
  FUNCTION Dos16MaxPathLen(* ------------- *);
    External 'DosCalls' INDEX 214;

  FUNCTION DosPageSize(* ------------- *);
    External 'DosCalls' INDEX 215;
  FUNCTION Dos16PageSize(* ------------- *);
    External 'DosCalls' INDEX 215;

  FUNCTION DosLocalInfo(* ------------- *);
    External 'DosCalls' INDEX 216;
  FUNCTION Dos16LocalInfo(* ------------- *);
    External 'DosCalls' INDEX 216;

  FUNCTION DosGlobalInfo(* ------------- *);
    External 'DosCalls' INDEX 217;
  FUNCTION Dos16GlobalInfo(* ------------- *);
    External 'DosCalls' INDEX 217;
}
(* ====================================================== *)
(*                         32 Bit                         *)
{                   nicht implementiert
  FUNCTION Dos32SetFileInfo(* ------------- *);
    External 'DosCalls' INDEX 218;

  FUNCTION Dos32SetPathInfo(* ------------- *);
    External 'DosCalls' INDEX 219;

  FUNCTION Dos32SetDefaultDisk(* ------------- *);
    External 'DosCalls' INDEX 220;

  FUNCTION Dos32SetFHState(* ------------- *);
    External 'DosCalls' INDEX 221;

  FUNCTION Dos32SetFSInfo(* ------------- *);
    External 'DosCalls' INDEX 222;

  FUNCTION Dos32QueryPathInfo(* ------------- *);
    External 'DosCalls' INDEX 223;

  FUNCTION Dos32QueryHType(* ------------- *);
    External 'DosCalls' INDEX 224;

  FUNCTION Dos32QueryVerify(* ------------- *);
    External 'DosCalls' INDEX 225;

  FUNCTION Dos32DeleteDir(* ------------- *);
    External 'DosCalls' INDEX 226;

  FUNCTION Dos32ScanEnv(* ------------- *);
    External 'DosCalls' INDEX 227;

  FUNCTION Dos32SearchPath(* ------------- *);
    External 'DosCalls' INDEX 228;

  FUNCTION Dos32Sleep(* ------------- *);
    External 'DosCalls' INDEX 229;

  FUNCTION Dos32GetDateTime(* ------------- *);
    External 'DosCalls' INDEX 230;

  FUNCTION Dos32DevConfig(* ------------- *);
    External 'DosCalls' INDEX 231;

  FUNCTION Dos32EnterCritSec(* ------------- *);
    External 'DosCalls' INDEX 232;

  FUNCTION Dos32ExitCritSec(* ------------- *);
    External 'DosCalls' INDEX 233;

  FUNCTION Dos32Exit(* ------------- *);
    External 'DosCalls' INDEX 234;

  FUNCTION Dos32KillProcess(* ------------- *);
    External 'DosCalls' INDEX 235;

  FUNCTION Dos32SetPriority(* ------------- *);
    External 'DosCalls' INDEX 236;

  FUNCTION Dos32ResumeThread(* ------------- *);
    External 'DosCalls' INDEX 237;

  FUNCTION Dos32SuspendThread(* ------------- *);
    External 'DosCalls' INDEX 238;

  FUNCTION Dos32CreatePipe(* ------------- *);
    External 'DosCalls' INDEX 239;

  FUNCTION Dos32CallNPipe(* ------------- *);
    External 'DosCalls' INDEX 240;

  FUNCTION Dos32ConnectNPipe(* ------------- *);
    External 'DosCalls' INDEX 241;

  FUNCTION Dos32DisConnectNPipe(* ------------- *);
    External 'DosCalls' INDEX 242;

  FUNCTION Dos32CreateNPipe(* ------------- *);
    External 'DosCalls' INDEX 243;

  FUNCTION Dos32PeekNPipe(* ------------- *);
    External 'DosCalls' INDEX 244;

  FUNCTION Dos32QueryNPHState(* ------------- *);
    External 'DosCalls' INDEX 245;

  FUNCTION Dos32RawReadNPipe(* ------------- *);
    External 'DosCalls' INDEX 246;

  FUNCTION Dos32RawWriteNPipe(* ------------- *);
    External 'DosCalls' INDEX 247;

  FUNCTION Dos32QueryNPipeInfo(* ------------- *);
    External 'DosCalls' INDEX 248;

  FUNCTION Dos32QueryNPipesemState(* ------------- *);
    External 'DosCalls' INDEX 249;

  FUNCTION Dos32SetNPHState(* ------------- *);
    External 'DosCalls' INDEX 250;

  FUNCTION Dos32SetNPipesem(* ------------- *);
    External 'DosCalls' INDEX 251;

  FUNCTION Dos32TransactNPipe(* ------------- *);
    External 'DosCalls' INDEX 252;

  FUNCTION Dos32WaitNPipe(* ------------- *);
    External 'DosCalls' INDEX 253;

  FUNCTION Dos32ReSetBuffer(* ------------- *);
    External 'DosCalls' INDEX 254;

  FUNCTION Dos32SetCurrentDir(* ------------- *);
    External 'DosCalls' INDEX 255;

  FUNCTION Dos32SetFilePtr(* ------------- *);
    External 'DosCalls' INDEX 256;

  FUNCTION Dos32Close(* ------------- *);
    External 'DosCalls' INDEX 257;

  FUNCTION Dos32Copy(* ------------- *);
    External 'DosCalls' INDEX 258;

  FUNCTION Dos32Delete(* ------------- *);
    External 'DosCalls' INDEX 259;

  FUNCTION Dos32DupHandle(* ------------- *);
    External 'DosCalls' INDEX 260;

  FUNCTION Dos32EditName(* ------------- *);
    External 'DosCalls' INDEX 261;

  FUNCTION Dos32FindClose(* ------------- *);
    External 'DosCalls' INDEX 263;

  FUNCTION Dos32FindFirst(* ------------- *);
    External 'DosCalls' INDEX 264;

  FUNCTION Dos32FindNext(* ------------- *);
    External 'DosCalls' INDEX 265;
}

(* ====================================================== *)
(*                         16 Bit                         *)
{
  FUNCTION DosOpenVDD(* ------------- *);
    External 'DosCalls' INDEX 266;
  FUNCTION Dos16OpenVDD(* ------------- *);
    External 'DosCalls' INDEX 266;

  FUNCTION DosRequestVDD(* ------------- *);
    External 'DosCalls' INDEX 267;
  FUNCTION Dos16RequestVDD(* ------------- *);
    External 'DosCalls' INDEX 267;

  FUNCTION DosCloseVDD(* ------------- *);
    External 'DosCalls' INDEX 268;
  FUNCTION Dos16CloseVDD(* ------------- *);
    External 'DosCalls' INDEX 268;
}
(* ====================================================== *)
(*                         32 Bit                         *)
{                    nicht implementiert

  FUNCTION Dos32FSAttach(* ------------- *);
    External 'DosCalls' INDEX 269;

  FUNCTION Dos32CreateDir(* ------------- *);
    External 'DosCalls' INDEX 270;

  FUNCTION Dos32Move(* ------------- *);
    External 'DosCalls' INDEX 271;

  FUNCTION Dos32SetFileSize(* ------------- *);
    External 'DosCalls' INDEX 272;

  FUNCTION Dos32Open(* ------------- *);
    External 'DosCalls' INDEX 273;

  FUNCTION Dos32QueryCurrentDir(* ------------- *);
    External 'DosCalls' INDEX 274;

  FUNCTION Dos32QueryCurrentDisk(* ------------- *);
    External 'DosCalls' INDEX 275;

  FUNCTION Dos32QueryFHState(* ------------- *);
    External 'DosCalls' INDEX 276;

  FUNCTION Dos32QueryFSAttach(* ------------- *);
    External 'DosCalls' INDEX 277;

  FUNCTION Dos32QueryFSInfo(* ------------- *);
    External 'DosCalls' INDEX 278;

  FUNCTION Dos32QueryFileInfo(* ------------- *);
    External 'DosCalls' INDEX 279;

  FUNCTION Dos32WaitChild(* ------------- *);
    External 'DosCalls' INDEX 280;

  FUNCTION Dos32Read(* ------------- *);
    External 'DosCalls' INDEX 281;

  FUNCTION Dos32Write(* ------------- *);
    External 'DosCalls' INDEX 282;

  FUNCTION Dos32ExecPgm(* ------------- *);
    External 'DosCalls' INDEX 283;

  FUNCTION Dos32DevIOCtl(* ------------- *);
    External 'DosCalls' INDEX 284;

  FUNCTION Dos32FSCtl(* ------------- *);
    External 'DosCalls' INDEX 285;

  FUNCTION Dos32Beep(* ------------- *);
    External 'DosCalls' INDEX 286;

  FUNCTION Dos32PhysicalDisk(* ------------- *);
    External 'DosCalls' INDEX 287;

  FUNCTION Dos32SetCp(* ------------- *);
    External 'DosCalls' INDEX 288;

  FUNCTION Dos32SetProcessCp(* ------------- *);
    External 'DosCalls' INDEX 289;

  FUNCTION Dos32StopTimer(* ------------- *);
    External 'DosCalls' INDEX 290;

  FUNCTION Dos32QueryCp(* ------------- *);
    External 'DosCalls' INDEX 291;

  FUNCTION Dos32SetDateTime(* ------------- *);
    External 'DosCalls' INDEX 292;

(* ====================================================== *)

  FUNCTION Dos32ExitList(* ------------- *);
    External 'DosCalls' INDEX 296;

(* ====================================================== *)

  FUNCTION Dos32AllocMem(* ------------- *);
    External 'DosCalls' INDEX 299;

  FUNCTION Dos32AllocSharedMem(* ------------- *);
    External 'DosCalls' INDEX 300;

  FUNCTION Dos32GetNamedSharedMem(* ------------- *);
    External 'DosCalls' INDEX 301;

  FUNCTION Dos32GetSharedMem(* ------------- *);
    External 'DosCalls' INDEX 302;

  FUNCTION Dos32GiveSharedMem(* ------------- *);
    External 'DosCalls' INDEX 303;

  FUNCTION Dos32FreeMem(* ------------- *);
    External 'DosCalls' INDEX 304;

  FUNCTION Dos32SetMem(* ------------- *);
    External 'DosCalls' INDEX 305;

  FUNCTION Dos32QueryMem(* ------------- *);
    External 'DosCalls' INDEX 306;

  FUNCTION Dos32OpenVDD(* ------------- *);
    External 'DosCalls' INDEX 308;

  FUNCTION Dos32RequestVDD(* ------------- *);
    External 'DosCalls' INDEX 309;

  FUNCTION Dos32CloseVDD(* ------------- *);
    External 'DosCalls' INDEX 310;

  FUNCTION Dos32CreateThread(* ------------- *);
    External 'DosCalls' INDEX 311;

  FUNCTION Dos32GetInfoBlocks(* ------------- *);
    External 'DosCalls' INDEX 312;

  FUNCTION Dos32DynamicTrace(* ------------- *);
    External 'DosCalls' INDEX 316;

  FUNCTION Dos32Debug(* ------------- *);
    External 'DosCalls' INDEX 317;

  FUNCTION Dos32LoadModule(* ------------- *);
    External 'DosCalls' INDEX 318;

  FUNCTION Dos32QueryModuleHandle(* ------------- *);
    External 'DosCalls' INDEX 319;

  FUNCTION Dos32QueryModuleName(* ------------- *);
    External 'DosCalls' INDEX 320;

  FUNCTION Dos32QueryProcAddr(* ------------- *);
    External 'DosCalls' INDEX 321;

  FUNCTION Dos32FreeModule(* ------------- *);
    External 'DosCalls' INDEX 322;

  FUNCTION Dos32QueryAppType(* ------------- *);
    External 'DosCalls' INDEX 323;

  FUNCTION Dos32CreateEventSem(* ------------- *);
    External 'DosCalls' INDEX 324;

  FUNCTION Dos32OpenEventSem(* ------------- *);
    External 'DosCalls' INDEX 325;

  FUNCTION Dos32CloseEventSem(* ------------- *);
    External 'DosCalls' INDEX 326;

  FUNCTION Dos32ReSetEventSem(* ------------- *);
    External 'DosCalls' INDEX 327;

  FUNCTION Dos32PostEventSem(* ------------- *);
    External 'DosCalls' INDEX 328;

  FUNCTION Dos32WaitEventSem(* ------------- *);
    External 'DosCalls' INDEX 329;

  FUNCTION Dos32QueryEventSem(* ------------- *);
    External 'DosCalls' INDEX 330;

  FUNCTION Dos32CreateMutexSem(* ------------- *);
    External 'DosCalls' INDEX 331;

  FUNCTION Dos32OpenMutexSem(* ------------- *);
    External 'DosCalls' INDEX 332;

  FUNCTION Dos32CloseMutexSem(* ------------- *);
    External 'DosCalls' INDEX 333;

  FUNCTION Dos32RequestMutexSem(* ------------- *);
    External 'DosCalls' INDEX 334;

  FUNCTION Dos32ReleaseMutexSem(* ------------- *);
    External 'DosCalls' INDEX 335;

  FUNCTION Dos32QueryMutexSem(* ------------- *);
    External 'DosCalls' INDEX 336;

  FUNCTION Dos32CreateMuxWaitSem(* ------------- *);
    External 'DosCalls' INDEX 337;

  FUNCTION Dos32OpenMuxWaitSem(* ------------- *);
    External 'DosCalls' INDEX 338;

  FUNCTION Dos32CloseMuxWaitSem(* ------------- *);
    External 'DosCalls' INDEX 339;

  FUNCTION Dos32WaitMuxWaitSem(* ------------- *);
    External 'DosCalls' INDEX 340;

  FUNCTION Dos32AddMuxWaitSem(* ------------- *);
    External 'DosCalls' INDEX 341;

  FUNCTION Dos32DeleteMuxWaitSem(* ------------- *);
    External 'DosCalls' INDEX 342;

  FUNCTION Dos32QueryMuxWaitSem(* ------------- *);
    External 'DosCalls' INDEX 343;

  FUNCTION Dos32SubSetMem(* ------------- *);
    External 'DosCalls' INDEX 344;

  FUNCTION Dos32SubAllocMem(* ------------- *);
    External 'DosCalls' INDEX 345;

  FUNCTION Dos32SubFreeMem(* ------------- *);
    External 'DosCalls' INDEX 346;

  FUNCTION Dos32SubUnSetMem(* ------------- *);
    External 'DosCalls' INDEX 347;

  FUNCTION Dos32QuerySysInfo(* ------------- *);
    External 'DosCalls' INDEX 348;

  FUNCTION Dos32WaitThread(* ------------- *);
    External 'DosCalls' INDEX 349;

  FUNCTION Dos32AsyncTimer(* ------------- *);
    External 'DosCalls' INDEX 350;

  FUNCTION Dos32StartTimer(* ------------- *);
    External 'DosCalls' INDEX 351;

  FUNCTION Dos32GetResource(* ------------- *);
    External 'DosCalls' INDEX 352;

  FUNCTION Dos32FreeResource(* ------------- *);
    External 'DosCalls' INDEX 353;

  FUNCTION Dos32SetExceptionHandler(* ------------- *);
    External 'DosCalls' INDEX 354;

  FUNCTION Dos32UnSetExceptionHandler(* ------------- *);
    External 'DosCalls' INDEX 355;

  FUNCTION Dos32RaiseException(* ------------- *);
    External 'DosCalls' INDEX 356;

  FUNCTION Dos32UnwindException(* ------------- *);
    External 'DosCalls' INDEX 357;

(* ====================================================== *)

  FUNCTION Dos32TmrQueryFreq(* ------------- *);
    External 'DosCalls' INDEX 362;

  FUNCTION Dos32TmrQueryTime(* ------------- *);
    External 'DosCalls' INDEX 363;

  FUNCTION Dos32RegisterPerfCtrs(* ------------- *);
    External 'DosCalls' INDEX 367;

(* ====================================================== *)

  FUNCTION Dos32EnumAttribute(* ------------- *);
    External 'DosCalls' INDEX 372;

  FUNCTION Dos32QueryDosProperty(* ------------- *);
    External 'DosCalls' INDEX 373;

  FUNCTION Dos32SetDosProperty(* ------------- *);
    External 'DosCalls' INDEX 374;

  FUNCTION DosQueryDosProperty(* ------------- *);
    External 'DosCalls' INDEX 375;
  FUNCTION Dos16QueryDosProperty(* ------------- *);
    External 'DosCalls' INDEX 375;

  FUNCTION DosSetDosProperty(* ------------- *);
    External 'DosCalls' INDEX 376;
  FUNCTION Dos16SetDosProperty(* ------------- *);
    External 'DosCalls' INDEX 376;

  FUNCTION Dos32Profile(* ------------- *);
    External 'DosCalls' INDEX 377;

  FUNCTION Dos32SetSignalExceptionFocus(* ------------- *);
    External 'DosCalls' INDEX 378;

  FUNCTION Dos32SendSignalException(* ------------- *);
    External 'DosCalls' INDEX 379;

  FUNCTION Dos32EnterMustComplete(* ------------- *);
    External 'DosCalls' INDEX 380;

  FUNCTION Dos32ExitMustComplete(* ------------- *);
    External 'DosCalls' INDEX 381;

  FUNCTION Dos32SetRelMaxFH(* ------------- *);
    External 'DosCalls' INDEX 382;

(* ====================================================== *)

  FUNCTION Dos32Shutdown(* ------------- *);
    External 'DosCalls' INDEX 415;

  FUNCTION Dos32ReplaceModule(* ------------- *);
    External 'DosCalls' INDEX 417;

  FUNCTION Dos32AcknowledgeSignalExc(* ------------- *);
    External 'DosCalls' INDEX 418;

  FUNCTION Dos32TIB(* ------------- *);
    External 'DosCalls' INDEX 419;
}

(* ====================================================== *)
(*                         16 Bit                         *)
{
  FUNCTION DosTMRQueryFreq(* ------------- *);
    External 'DosCalls' INDEX 420;
  FUNCTION Dos16TMRQueryFreq(* ------------- *);
    External 'DosCalls' INDEX 420;

  FUNCTION DosTMRQueryTime(* ------------- *);
    External 'DosCalls' INDEX 421;
  FUNCTION Dos16TMRQueryTime(* ------------- *);
    External 'DosCalls' INDEX 421;

  FUNCTION DosRegisterPerfctRS(* ------------- *);
    External 'DosCalls' INDEX 422;
  FUNCTION Dos16RegisterPerfctRS(* ------------- *);
    External 'DosCalls' INDEX 422;

  FUNCTION DosFlatToSel(* ------------- *);
    External 'DosCalls' INDEX 423;
  FUNCTION Dos16FlatToSel(* ------------- *);
    External 'DosCalls' INDEX 423;

  FUNCTION DosSelToFlat(* ------------- *);
    External 'DosCalls' INDEX 424;
  FUNCTION Dos16SelToFlat(* ------------- *);
    External 'DosCalls' INDEX 424;
}
(* ====================================================== *)
(*                         32 Bit                         *)
{
  FUNCTION Dos32FlatToSel(* ------------- *);
    External 'DosCalls' INDEX 425;

  FUNCTION Dos32SelToFlat(* ------------- *);
    External 'DosCalls' INDEX 426;

  FUNCTION Dos32SetFileLocks(* ------------- *);
    External 'DosCalls' INDEX 428;

  FUNCTION Dos32CancelLockRequest(* ------------- *);
    External 'DosCalls' INDEX 429;
}
(* ====================================================== *)
(*                         16 Bit                         *)
{
  FUNCTION DosOpenChangeNotify(* ------------- *);
    External 'DosCalls' INDEX 437;
  FUNCTION Dos16OpenChangeNotify(* ------------- *);
    External 'DosCalls' INDEX 437;

  FUNCTION DosResetChangeNotify(* ------------- *);
    External 'DosCalls' INDEX 438;
  FUNCTION Dos16ResetChangeNotify(* ------------- *);
    External 'DosCalls' INDEX 438;

  FUNCTION DosCloseChangeNotify(* ------------- *);
    External 'DosCalls' INDEX 439;
  FUNCTION Dos16CloseChangeNotify(* ------------- *);
    External 'DosCalls' INDEX 439;
}
(* ====================================================== *)
(*                         32 Bit                         *)
{
  FUNCTION Dos32OpenChangeNotify(* ------------- *);
    External 'DosCalls' INDEX 440;

  FUNCTION Dos32ResetChangeNotify(* ------------- *);
    External 'DosCalls' INDEX 441;

  FUNCTION Dos32CloseChangeNotify(* ------------- *);
    External 'DosCalls' INDEX 442;

(* ====================================================== *)

  FUNCTION Dos32QueryResourceSize(* ------------- *);
   External 'DosCalls' INDEX 572;
}
(* ====================================================== *)
(*                         16 Bit                         *)

{
  FUNCTION DosQueryResourceSize(* ------------- *);
    External 'DosCalls' INDEX 573;
  FUNCTION Dos16QueryResourceSize(* ------------- *);
    External 'DosCalls' INDEX 573;
}

(* ====================================================== *)
(*                         32 Bit                         *)
{                    nicht implementiert
  FUNCTION Dos32InitializePorthole(* ------------- *);
    External 'DosCalls' INDEX 580;

  FUNCTION Dos32QueryHeaderInfo(* ------------- *);
    External 'DosCalls' INDEX 582;
}

(* ====================================================== *)
(*                         16 Bit                         *)
{
  FUNCTION DosInitializePortHole(* ------------- *);
    External 'DosCalls' INDEX 583;
  FUNCTION Dos16InitializePortHole(* ------------- *);
    External 'DosCalls' INDEX 583;

  FUNCTION DosQueryHeaderInfo(* ------------- *);
    External 'DosCalls' INDEX 584;
  FUNCTION Dos16QueryHeaderInfo(* ------------- *);
    External 'DosCalls' INDEX 584;
}
(* ====================================================== *)
(*                         32 Bit                         *)
{                 nicht implementiert

  FUNCTION Dos32QueryProcType(* ------------- *);
    External 'DosCalls' INDEX 586;
}
(* ====================================================== *)
(*                         16 Bit                         *)
{
  FUNCTION DosQueryProcType(* ------------- *);
    External 'DosCalls' INDEX 587;
  FUNCTION Dos16QueryProcType(* ------------- *);
    External 'DosCalls' INDEX 587;
}

END.

(* ====================================================== *)
(*                 Ende von DOSCALLS.PAS                  *)
