(* ====================================================== *)
(*                         PMWIN.PAS                      *)
(*     Implementation of the functions of PMWIN.DLL       *)
(* ====================================================== *)
{$IFNDef OS2}
  Error: Wrong target/Compiler not patched
{$EndIF}

UNIT PMWin;

INTERFACE

USES Os2Def;

TYPE
  hMQ = LHandle;    (* hmq *)

  pFnWp = FUNCTION(aHwnd : hWnd;
                   Msg   : WORD;
                   Mp1   : mParam;
                   Mp2   : mParam) : mResult;

CONST
  HWND_DESKTOP       = hWnd(1);
  HWND_OBJECT        = hWnd(2);
  HWND_TOP           = hWnd(3);
  HWND_BOTTOM        = hWnd(4);
  HWND_THREADCAPTURE = hWnd(5);


(* Standard Window Styles *)
  WS_VISIBLE         = $080000000;
  WS_DISABLED        = $040000000;
  WS_CLIPCHILDREN    = $020000000;
  WS_CLIPSIBLINGS    = $010000000;
  WS_PARENTCLIP      = $008000000;
  WS_SAVEBITS        = $004000000;
  WS_SYNCPAINT       = $002000000;
  WS_MINIMIZED       = $001000000;
  WS_MAXIMIZED       = $000800000;

(* Dialog manager styles *)
  WS_GROUP           = $000010000;
  WS_TABSTOP         = $000020000;
  WS_MULTISELECT     = $40000;


(* Class styles *)
  CS_MOVENOTIFY      = $000000001;
  CS_SIZEREDRAW      = $000000004;
  CS_HITTEST         = $000000008;
  CS_PUBLIC          = $000000010;
  CS_FRAME           = $000000020;
  CS_CLIPCHILDREN    = $020000000;
  CS_CLIPSIBLINGS    = $010000000;
  CS_PARENTCLIP      = $008000000;
  CS_SAVEBITS        = $004000000;
  CS_SYNCPAINT       = $002000000;

(***************************************************************************)
(****       Window Manager Subsection part 1 - was INCL_WINCOMMON       ****)

  FUNCTION WinRegisterClass(ahab         : HAB;
                            pszClassName : pChar;
                            pfnWndProc   : {PFNWP}Pointer;
                            flStyle      : LongInt;
                            cbWindowData : WORD) : BOOLEAN;
  FUNCTION Win16RegisterClass(ahab         : HAB;
                             pszClassName : pChar;
                             pfnWndProc   : {PFNWP}Pointer;
                             flStyle      : LongInt;
                             cbWindowData : WORD) : BOOLEAN;

  FUNCTION WinDefWindowProc(aHwnd : hWnd;
                             Msg   : WORD;
                             Mp1   : mParam;
                             Mp2   : mParam) : mResult;
  FUNCTION Win16DefWindowProc(aHwnd : hWnd;
                             Msg   : WORD;
                             Mp1   : mParam;
                             Mp2   : mParam) : mResult;

  FUNCTION WinDestroyWindow(aHwnd : hWnd) : BOOLEAN;
  FUNCTION Win16DestroyWindow(aHwnd : hWnd) : BOOLEAN;

  FUNCTION WinShowWindow(aHwnd : hWnd; fShow : BOOLEAN) : BOOLEAN;
  FUNCTION Win16ShowWindow(aHwnd : hWnd; fShow : BOOLEAN) : BOOLEAN;

  FUNCTION WinQueryWindowRect(  aHwnd : hWnd;
                                prcl  : { LONG } pRectL) : BOOLEAN;
  FUNCTION Win16QueryWindowRect( aHwnd : hWnd;
                                prcl   : { LONG } pRectL) : BOOLEAN;

  FUNCTION WinGetPS(aHwnd : hWnd) : hPs;
  FUNCTION Win16GetPS(aHwnd : hWnd) : hPs;

  FUNCTION WinReleasePS(ahps : hPs) : BOOLEAN;
  FUNCTION Win16ReleasePS(ahps : hPs) : BOOLEAN;

  FUNCTION WinEndPaint(ahps : hPs) : BOOLEAN;
  FUNCTION Win16EndPaint(ahps : hPs) : BOOLEAN;

  FUNCTION WinGetClipPS(aHwnd    : hWnd;
                        hWndClip : hWnd;
                        fs       : WORD) : hPs;
  FUNCTION Win16GetClipPS(aHwnd    : hWnd;
                        hWndClip : hWnd;
                        fs       : WORD) : hPs;

  FUNCTION WinIsWindowShowing(a : hWnd) : BOOLEAN;
  FUNCTION Win16IsWindowShowing(a : hWnd) : BOOLEAN;

  FUNCTION WinBeginPaint(aHwnd     : hWnd;
                         ahps      : hPs;
                         prclPaint : { LONG } pRectL) : hPs;
  FUNCTION Win16BeginPaint(aHwnd     : hWnd;
                         ahps      : hPs;
                         prclPaint : { LONG } pRectL) : hPs;

  FUNCTION WinOpenWindowDC(aHwnd : hWnd) : hDC;
  FUNCTION Win16OpenWindowDC(aHwnd : hWnd) : hDC;

  FUNCTION WinScrollWindow(    aHwnd      : hWnd;
                               dx, dy     : INTEGER;
                               prclScroll : { LONG } pRectL;
                               prclClip   : { LONG } pRectL;
                               hrgnUpdate : HRGN;
                           VAR prclUpdate : { LONG } pRectL;
                               fs         : WORD) : INTEGER;
  FUNCTION Win16ScrollWindow(    aHwnd      : hWnd;
                               dx, dy     : INTEGER;
                               prclScroll : { LONG } pRectL;
                               prclClip   : { LONG } pRectL;
                               hrgnUpdate : HRGN;
                           VAR prclUpdate : { LONG } pRectL;
                               fs         : WORD) : INTEGER;

(* WinGetClipPS() flags *)
CONST
  PSF_LOCKWINDOWUPDATE = $00001;
  PSF_CLIPUPWARDS      = $00002;
  PSF_CLIPDOWNWARDS    = $00004;
  PSF_CLIPSIBLINGS     = $00008;
  PSF_CLIPCHILDREN     = $00010;
  PSF_PARENTCLIP       = $00020;

(* WinScrollWindow() flags *)
  SW_SCROLLCHILDREN    = $00001;
  SW_INVALIDATERGN     = $00002;

  FUNCTION WinFillRect(ahps : hPs;
                       rcl  : { LONG } pRectL;
                       clr  : Color) : BOOLEAN;
  FUNCTION Win16FillRect(ahps : hPs;
                       rcl  : { LONG } pRectL;
                       clr  : Color) : BOOLEAN;

(* WinInitialize/WinTerminate Interface declarations *)

TYPE
  QVersData = RECORD    (* qver *)
    Environment : WORD;
    Version     : WORD;
  END;

CONST
  QV_OS2      = $00000;
  QV_CMS      = $00001;
  QV_TSO      = $00002;
  QV_TSOBATCH = $00003;
  QV_OS400    = 4;


  FUNCTION WinQueryVersion(ahab : HAB) : LongInt;
  FUNCTION Win16QueryVersion(ahab : HAB) : LongInt;

  FUNCTION WinInitialize(fsOptions : WORD) : HAB;
  FUNCTION Win16Initialize(fsOptions : WORD) : HAB;

  FUNCTION WinTerminate(ahab : HAB) : BOOLEAN;
  FUNCTION Win16Terminate(ahab : HAB) : BOOLEAN;

  FUNCTION WinQueryAnchorBlock(a : hWnd) : HAB;
  FUNCTION Win16QueryAnchorBlock(a : hWnd) : HAB;

(******************  End of Window Manager COMMON section ******************)

  FUNCTION WinCreateWindow(hWndParent       : hWnd;
                           pszClass         : pChar;
                           pszName          : pChar;
                           flStyle          : LongInt;
                           x, y             : INTEGER;
                           cx, cy           : INTEGER;
                           hWndOwner        : hWnd;
                           hWndInsertBehind : hWnd;
                           id               : WORD;
                           pCtlData         : pVoid;
                           pPresParams      : pVoid) : hWnd;
  FUNCTION Win16CreateWindow(hWndParent       : hWnd;
                           pszClass         : pChar;
                           pszName          : pChar;
                           flStyle          : LongInt;
                           x, y             : INTEGER;
                           cx, cy           : INTEGER;
                           hWndOwner        : hWnd;
                           hWndInsertBehind : hWnd;
                           id               : WORD;
                           pCtlData         : pVoid;
                           pPresParams      : pVoid) : hWnd;

  FUNCTION WinEnableWindow(aHwnd : hWnd; fEnable : BOOLEAN) : BOOLEAN;
  FUNCTION Win16EnableWindow(aHwnd : hWnd; fEnable : BOOLEAN) : BOOLEAN;

  FUNCTION WinIsWindowEnabled(aHwnd : hWnd) : BOOLEAN;
  FUNCTION Win16IsWindowEnabled(aHwnd : hWnd) : BOOLEAN;

  FUNCTION WinEnableWindowUpdate(aHwnd : hWnd; fEnable : BOOLEAN) : BOOLEAN;
  FUNCTION Win16EnableWindowUpdate(aHwnd : hWnd; fEnable : BOOLEAN) : BOOLEAN;

  FUNCTION WinIsWindowVisible(aHwnd : hWnd) : BOOLEAN;
  FUNCTION Win16IsWindowVisible(aHwnd : hWnd) : BOOLEAN;

  FUNCTION WinQueryWindowText(aHwnd  : hWnd;
                              cbBuf  : INTEGER;
                              pszBuf : pChar) : INTEGER;
  FUNCTION Win16QueryWindowText(aHwnd  : hWnd;
                              cbBuf  : INTEGER;
                              pszBuf : pChar) : INTEGER;

  FUNCTION WinSetWindowText(aHwnd : hWnd; pszText : pChar) : BOOLEAN;
  FUNCTION Win16SetWindowText(aHwnd : hWnd; pszText : pChar) : BOOLEAN;

  FUNCTION WinQueryWindowTextLength(aHwnd : hWnd) : INTEGER;
  FUNCTION Win16QueryWindowTextLength(aHwnd : hWnd) : INTEGER;

  FUNCTION WinWindowFromID(hWndParent : hWnd; id : WORD) : hWnd;
  FUNCTION Win16WindowFromID(hWndParent : hWnd; id : WORD) : hWnd;

  FUNCTION WinIsWindow(ahab : HAB; aHwnd : hWnd) : BOOLEAN;
  FUNCTION Win16IsWindow(ahab : HAB; aHwnd : hWnd) : BOOLEAN;

  FUNCTION WinQueryWindow(aHwnd : hWnd;
                          cmd   : INTEGER;
                          fLock : BOOLEAN) : hWnd;
  FUNCTION Win16QueryWindow(aHwnd : hWnd;
                          cmd   : INTEGER;
                          fLock : BOOLEAN) : hWnd;

  FUNCTION WinMultWindowFromIDs(    hWndParent : hWnd;
                                VAR pHWnd      : hWnd;
                                    idFirst    : WORD;
                                    idLast     : WORD) : INTEGER;
  FUNCTION Win16MultWindowFromIDs(    hWndParent : hWnd;
                                VAR pHWnd      : hWnd;
                                    idFirst    : WORD;
                                    idLast     : WORD) : INTEGER;

(* WinQueryWindow() codes *)

CONST
  QW_NEXT       = 0;
  QW_PREV       = 1;
  QW_TOP        = 2;
  QW_BOTTOM     = 3;
  QW_OWNER      = 4;
  QW_PARENT     = 5;
  QW_NEXTTOP    = 6;
  QW_PREVTOP    = 7;
  QW_FRAMEOWNER = 8;

  FUNCTION WinSetParent(aHwnd         : hWnd;
                        hWndNewParent : hWnd;
                        fRedraw       : BOOLEAN) : BOOLEAN;
  FUNCTION Win16SetParent(aHwnd         : hWnd;
                        hWndNewParent : hWnd;
                        fRedraw       : BOOLEAN) : BOOLEAN;

  FUNCTION WinIsChild(aHwnd : hWnd; hWndParent : hWnd) : BOOLEAN;
  FUNCTION Win16IsChild(aHwnd : hWnd; hWndParent : hWnd) : BOOLEAN;

  FUNCTION WinSetOwner(aHwnd : hWnd; hWndNewOwner : hWnd) : BOOLEAN;
  FUNCTION Win16SetOwner(aHwnd : hWnd; hWndNewOwner : hWnd) : BOOLEAN;

  FUNCTION WinQueryWindowProcess(    aHwnd : hWnd;
                                 VAR pPID  : { LONG } pID;
                                 VAR pTID  : { LONG } tId) : BOOLEAN;
  FUNCTION Win16QueryWindowProcess(    aHwnd : hWnd;
                                 VAR pPID  : { LONG } pID;
                                 VAR pTID  : { LONG } tId) : BOOLEAN;

  FUNCTION WinQueryObjectWindow(hWndDesktop : hWnd) : hWnd;
  FUNCTION Win16QueryObjectWindow(hWndDesktop : hWnd) : hWnd;

  FUNCTION WinQueryDesktopWindow(ahab : HAB; ahdc : hDC) : hWnd;
  FUNCTION Win16QueryDesktopWindow(ahab : HAB; ahdc : hDC) : hWnd;

(*** Window positioning functions *)

(* WinSetMultWindowPos() structure *)

TYPE
  Swp = RECORD      (* swp *)
    fs               : WORD;
    cx, cy           :  INTEGER;
    y, x             :  INTEGER;
    hWndInsertBehind :   hWnd;
    aHwnd            :   hWnd;
  END;
  pSwp = ^Swp;

  FUNCTION WinSetWindowPos(aHwnd            : hWnd;
                           hWndInsertBehind : hWnd;
                           x, y, cx, cy     : INTEGER;
                           fs               : WORD) : BOOLEAN;
  FUNCTION Win16SetWindowPos(aHwnd            : hWnd;
                           hWndInsertBehind : hWnd;
                           x, y, cx, cy     : INTEGER;
                           fs               : WORD) : BOOLEAN;

  FUNCTION WinQueryWindowPos(    aHwnd : hWnd;
                             VAR pSwp  : { LONG } Swp) : BOOLEAN;
  FUNCTION Win16QueryWindowPos(    aHwnd : hWnd;
                             VAR pSwp  : { LONG } Swp) : BOOLEAN;

  FUNCTION WinSetMultWindowPos(ahab : HAB;
                               pSwp : { LONG } Swp;
                               cswp : WORD) : BOOLEAN;
  FUNCTION Win16SetMultWindowPos(ahab : HAB;
                               pSwp : { LONG } Swp;
                               cswp : WORD) : BOOLEAN;

CONST
  AWP_MINIMIZED   = $10000;
  AWP_MAXIMIZED   = $20000;
  AWP_RESTORED   = $40000;
  AWP_ACTIVATE   = $80000;
  AWP_DEACTIVATE = $100000;

(* WinSetWindowPos() flags *)

  SWP_SIZE            = $00001;
  SWP_MOVE            = $00002;
  SWP_ZORDER          = $00004;
  SWP_SHOW            = $00008;
  SWP_HIDE            = $00010;
  SWP_NOREDRAW        = $00020;
  SWP_NOADJUST        = $00040;
  SWP_ACTIVATE        = $00080;
  SWP_DEACTIVATE      = $00100;
  SWP_EXTSTATECHANGE  = $00200;
  SWP_MINIMIZE        = $00400;
  SWP_MAXIMIZE        = $00800;
  SWP_RESTORE         = $01000;
  SWP_FOCUSACTIVATE   = $02000;
  SWP_FOCUSDEACTIVATE = $04000;

(* Window painting *)

  FUNCTION WinUpdateWindow(aHwnd : hWnd) : BOOLEAN;
  FUNCTION Win16UpdateWindow(aHwnd : hWnd) : BOOLEAN;

  FUNCTION WinInvalidateRect(aHwnd            : hWnd;
                             VAR prcl         : { LONG } pRectL;
                             fIncludeChildren : BOOLEAN) : BOOLEAN;
  FUNCTION Win16InvalidateRect(aHwnd            : hWnd;
                             VAR prcl         : { LONG } pRectL;
                             fIncludeChildren : BOOLEAN) : BOOLEAN;

  FUNCTION WinInvalidateRegion(aHwnd            : hWnd;
                               ahRGN            : HRGN;
                               fIncludeChildren : BOOLEAN) : BOOLEAN;
  FUNCTION Win16InvalidateRegion(aHwnd            : hWnd;
                               ahRGN            : HRGN;
                               fIncludeChildren : BOOLEAN) : BOOLEAN;

(* Drawing helpers *)

  FUNCTION WinInvertRect(ahps : hPs;
                         prcl : { LONG } pRectL) : BOOLEAN;
  FUNCTION Win16InvertRect(ahps : hPs;
                         prcl : { LONG } pRectL) : BOOLEAN;

  FUNCTION WinDrawBitmap(hpsDst  : hPs;
                         hbm     : hBitmap;
                         prclSrc : { LONG } pRectL;
                         pptlDst : { LONG } PointL;
                         clrFore : LongInt;
                         clrBack : LongInt;
                         fs      : WORD) : BOOLEAN;
  FUNCTION Win16DrawBitmap(hpsDst  : hPs;
                         hbm     : hBitmap;
                         prclSrc : { LONG } pRectL;
                         pptlDst : { LONG } PointL;
                         clrFore : LongInt;
                         clrBack : LongInt;
                         fs      : WORD) : BOOLEAN;

(* WinDrawBitmap() flags *)

CONST
  DBM_NORMAL     = $00000;
  DBM_INVERT     = $00001;
  DBM_HALFTONE   = $00002;
  DBM_STRETCH    = $00004;
  DBM_IMAGEATTRS = $00008;

  FUNCTION WinDrawText(ahps    : hPs;
                       StrLen  : INTEGER;
                       pszText : pChar;
                       prcl    : { LONG } pRectL;
                       clrFore : LongInt;
                       clrBack : LongInt;
                       fsCmd   : WORD) : HPS; {Integer}
  FUNCTION Win16DrawText(ahps    : hPs;
                       cchText : INTEGER;
                       pszText : pChar;
                       prcl    : { LONG } pRectL;
                       clrFore : LongInt;
                       clrBack : LongInt;
                       fsCmd   : WORD) : INTEGER;

(*
 * WinDrawText() codes:
 * From DT_LEFT to DT_EXTERNALLEADING, the codes are designed to be OR'ed with
 * SS_TEXT to create variations of the basic text static item.
 *)
CONST
  DT_LEFT =             $00000;
  DT_EXTERNALLEADING =  $00080;
  DT_CENTER =           $00100;
  DT_RIGHT =            $00200;
  DT_TOP =              $00000;
  DT_VCENTER =          $00400;
  DT_BOTTOM =           $00800;
  DT_HALFTONE =         $01000;
  DT_MNEMONIC =         $02000;
  DT_WORDBREAK =        $04000;
  DT_ERASERECT =        $08000;
  DT_QUERYEXTENT =      $00002;
  DT_TEXTATTRS =        $00040;


  FUNCTION WinDrawBorder(ahps    : hPs;
                         prcl    : { LONG } pRectL;
                         cx, cy  : INTEGER;
                         clrFore : LongInt;
                         clrBack : LongInt;
                         fsCmd   : WORD) : BOOLEAN;
  FUNCTION Win16DrawBorder(ahps    : hPs;
                         prcl    : { LONG } pRectL;
                         cx, cy  : INTEGER;
                         clrFore : LongInt;
                         clrBack : LongInt;
                         fsCmd   : WORD) : BOOLEAN;

(* WinDrawBorder() flags *)

CONST
  DB_PATCOPY =          $00000;
  DB_PATINVERT =        $00001;
  DB_DESTINVERT =       $00002;
  DB_AREAMIXMODE =      $00003;

  DB_ROP =              $00007;
  DB_INTERIOR =         $00008;
  DB_AREAATTRS =        $00010;
  DB_STANDARD =         $00100;
  DB_DLGBORDER =        $00200;

(** Resource loading functions *)

  FUNCTION WinLoadString(ahab      : HAB;
                         hMod      : hModule;
                         id        : WORD;
                         cchMax    : INTEGER;
                         pszBuffer : pChar) : INTEGER;
  FUNCTION Win16LoadString(ahab      : HAB;
                         hMod      : hModule;
                         id        : WORD;
                         cchMax    : INTEGER;
                         pszBuffer : pChar) : INTEGER;

  FUNCTION WinLoadMessage(ahab      : HAB;
                          hMod      : hModule;
                          id        : WORD;
                          cchMax    : INTEGER;
                          pszBuffer : pChar) : INTEGER;
  FUNCTION Win16LoadMessage(ahab      : HAB;
                          hMod      : hModule;
                          id        : WORD;
                          cchMax    : INTEGER;
                          pszBuffer : pChar) : INTEGER;


(***************************************************************************)
(****                 Window Manager Subsection part 2                  ****)

  FUNCTION WinSetActiveWindow(hWndDesktop : hWnd; aHwnd : hWnd) : BOOLEAN;
  FUNCTION Win16SetActiveWindow(hWndDesktop : hWnd; aHwnd : hWnd) : BOOLEAN;

(* WM_CREATE structure *)
TYPE
  CreateStruct = RECORD     (* crst *)
    pPresParams      : pVoid;
    pCtlData         : pVoid;
    id               : WORD;
    hWndInsertBehind : hWnd;
    hWndOwner        : hWnd;
    cy, cx, y, x     : INTEGER;
    flStyle          : LongInt;
    pszText          : pChar;
    pszClass         : pChar;
    hWndParent       : hWnd;
  END;
  pCreateStruct = ^CreateStruct;

(* WinQueryClassInfo() structure *)

TYPE
  ClassInfo = RECORD      (* clsi *)
    flClassStyle  : LongInt;
    pfnWindowProc : pFnWp;
    cbWindowData  : WORD;
  END;
  pClassInfo = ^ClassInfo;

  FUNCTION WinSubclassWindow(aHwnd : hWnd; pFnWp : pFnWp) : { PFNWP } Pointer;
  FUNCTION Win16SubclassWindow(aHwnd : hWnd; pFnWp : pFnWp) : { PFNWP } Pointer;

  FUNCTION WinQueryClassName(aHwnd   : hWnd;
                             cchMax  : INTEGER;
                             pChar     : pChar) : INTEGER;
  FUNCTION Win16QueryClassName(aHwnd   : hWnd;
                             cchMax  : INTEGER;
                             pChar     : pChar) : INTEGER;

  FUNCTION WinQueryClassInfo(    ahab         : HAB;
                                 pszClassName : pChar;
                             VAR pclsi        : { LONG } ClassInfo) : BOOLEAN;
  FUNCTION Win16QueryClassInfo(    ahab         : HAB;
                                 pszClassName : pChar;
                             VAR pclsi        : { LONG } ClassInfo) : BOOLEAN;

  FUNCTION WinQueryActiveWindow(hWndDesktop : hWnd;
                                fLock       : BOOLEAN) : hWnd;
  FUNCTION Win16QueryActiveWindow(hWndDesktop : hWnd;
                                fLock       : BOOLEAN) : hWnd;

  FUNCTION WinIsThreadActive(ahab : HAB) : BOOLEAN;
  FUNCTION Win16IsThreadActive(ahab : HAB) : BOOLEAN;

  FUNCTION WinQuerySysModalWindow(hWndDesktop : hWnd;
                                  fLock       : BOOLEAN) : hWnd;
  FUNCTION Win16QuerySysModalWindow(hWndDesktop : hWnd;
                                  fLock       : BOOLEAN) : hWnd;

  FUNCTION WinLockWindow(aHwnd : hWnd; fLock : BOOLEAN) : hWnd;
  FUNCTION Win16LockWindow(aHwnd : hWnd; fLock : BOOLEAN) : hWnd;

  FUNCTION WinRegisterWindowDestroy(aHwnd     : hWnd;
                                    fRegister : BOOLEAN) : BOOLEAN;
  FUNCTION Win16RegisterWindowDestroy(aHwnd     : hWnd;
                                    fRegister : BOOLEAN) : BOOLEAN;

  FUNCTION WinSetSysModalWindow(hWndDesktop : hWnd; aHwnd : hWnd) : BOOLEAN;
  FUNCTION Win16SetSysModalWindow(hWndDesktop : hWnd; aHwnd : hWnd) : BOOLEAN;

  FUNCTION WinQueryWindowLockCount(aHwnd : hWnd) : INTEGER;
  FUNCTION Win16QueryWindowLockCount(aHwnd : hWnd) : INTEGER;

  FUNCTION WinQueryWindowUShort(aHwnd : hWnd; INDEX : INTEGER) : WORD;
  FUNCTION Win16QueryWindowUShort(aHwnd : hWnd; INDEX : INTEGER) : WORD;

  FUNCTION WinSetWindowUShort(aHwnd : hWnd;
                              INDEX : INTEGER;
                              us    : WORD) : BOOLEAN;
  FUNCTION Win16SetWindowUShort(aHwnd : hWnd;
                              INDEX : INTEGER;
                              us    : WORD) : BOOLEAN;

  FUNCTION WinQueryWindowULong(aHwnd : hWnd; INDEX : INTEGER) : LongInt;
  FUNCTION Win16QueryWindowULong(aHwnd : hWnd; INDEX : INTEGER) : LongInt;

  FUNCTION WinSetWindowULong(aHwnd : hWnd;
                             INDEX : INTEGER;
                             ul    : LongInt) : BOOLEAN;
  FUNCTION Win16SetWindowULong(aHwnd : hWnd;
                             INDEX : INTEGER;
                             ul    : LongInt) : BOOLEAN;

  FUNCTION WinQueryWindowPtr(aHwnd : hWnd; INDEX : INTEGER) : pVoid;
  FUNCTION Win16QueryWindowPtr(aHwnd : hWnd; INDEX : INTEGER) : pVoid;

  FUNCTION WinSetWindowPtr(aHwnd : hWnd;
                           INDEX : INTEGER;
                           P     : pVoid) : BOOLEAN;
  FUNCTION Win16SetWindowPtr(aHwnd : hWnd;
                           INDEX : INTEGER;
                           P     : pVoid) : BOOLEAN;

  FUNCTION WinSetWindowBits(aHwnd  : hWnd;
                            INDEX  : INTEGER;
                            flData : LongInt;
                            flMask : LongInt) : BOOLEAN;
  FUNCTION Win16SetWindowBits(aHwnd  : hWnd;
                            INDEX  : INTEGER;
                            flData : LongInt;
                            flMask : LongInt) : BOOLEAN;

(* Standard WinQueryWindowUShort/ULong() indexes *)

CONST
  QWS_USER =    0;
  QWS_ID   =  (-1);
  QWS_MIN  =  (-1);

  QWL_USER =    0;
  QWL_STYLE =  (-2);
  QWP_PFNWP =  (-3);
  QWL_HMQ   =  (-4);
  QWL_MIN   =  (-4);

(* WC_FRAME WinQueryWindowUShort/ULong() indexes *)

CONST
  QWL_HHEAP         = $00004;
  QWL_HWNDFOCUSSAVE = $00018;

  QWS_FLAGS         = $00008;
  QWS_RESULT        = $0000A;
  QWS_XRESTORE      = $0000C;
  QWS_YRESTORE      = $0000E;
  QWS_CXRESTORE     = $00010;
  QWS_CYRESTORE     = $00012;
  QWS_XMINIMIZE     = $00014;
  QWS_YMINIMIZE     = $00016;

(* Window enumeration *)
TYPE
  hEnum = LHandle;  (* henum *)

  FUNCTION WinBeginEnumWindows(aHwnd : hWnd) : hEnum;
  FUNCTION Win16BeginEnumWindows(aHwnd : hWnd) : hEnum;

  FUNCTION WinGetNextWindow(ahEnum : hEnum) : hWnd;
  FUNCTION Win16GetNextWindow(ahEnum : hEnum) : hWnd;

  FUNCTION WinEndEnumWindows(ahEnum : hEnum) : BOOLEAN;
  FUNCTION Win16EndEnumWindows(ahEnum : hEnum) : BOOLEAN;

  FUNCTION WinWindowFromPoint(aHwnd     : hWnd;
                              pptl      : { LONG } PointL;
                              fChildren : BOOLEAN;
                              fLock     : BOOLEAN) : hWnd;
  FUNCTION Win16WindowFromPoint(aHwnd     : hWnd;
                              pptl      : { LONG } PointL;
                              fChildren : BOOLEAN;
                              fLock     : BOOLEAN) : hWnd;

  FUNCTION WinMapWindowPoints(hWndFrom : hWnd;
                              hWndTo   : hWnd;
                              pptl     : { LONG } PointL;
                              cwpt     : INTEGER) : BOOLEAN;
  FUNCTION Win16MapWindowPoints(hWndFrom : hWnd;
                              hWndTo   : hWnd;
                              pptl     : { LONG } PointL;
                              cwpt     : INTEGER) : BOOLEAN;

(* WinExcludeUpdateRegion return values *)

CONST
  EXRGN_ERROR   = $00000;
  EXRGN_NULL    = $00001;
  EXRGN_RECT    = $00002;
  EXRGN_COMPLEX = $00003;

(* More window painting stuff *)

  FUNCTION WinValidateRect(aHwnd            : hWnd;
                           prcl             : { LONG } pRectL;
                           fIncludeChildren : BOOLEAN) : BOOLEAN;
  FUNCTION Win16ValidateRect(aHwnd            : hWnd;
                           prcl             : { LONG } pRectL;
                           fIncludeChildren : BOOLEAN) : BOOLEAN;

  FUNCTION WinValidateRegion(aHwnd            : hWnd;
                             ahRGN            : HRGN;
                             fIncludeChildren : BOOLEAN) : BOOLEAN;
  FUNCTION Win16ValidateRegion(aHwnd            : hWnd;
                             ahRGN            : HRGN;
                             fIncludeChildren : BOOLEAN) : BOOLEAN;

  FUNCTION WinWindowFromDC(ahdc : hDC) : hWnd;
  FUNCTION Win16WindowFromDC(ahdc : hDC) : hWnd;

  FUNCTION WinQueryWindowDC(aHwnd : hWnd) : hDC;
  FUNCTION Win16QueryWindowDC(aHwnd : hWnd) : hDC;

  FUNCTION WinGetScreenPS(hWndDesktop : hWnd) : hPs;
  FUNCTION Win16GetScreenPS(hWndDesktop : hWnd) : hPs;

  FUNCTION WinLockWindowUpdate(hWndDesktop    : hWnd;
                               hWndLockUpdate : hWnd) : BOOLEAN;
  FUNCTION Win16LockWindowUpdate(hWndDesktop    : hWnd;
                               hWndLockUpdate : hWnd) : BOOLEAN;

  FUNCTION WinLockVisRegions(hWndDesktop : hWnd; fLock : BOOLEAN) : BOOLEAN;
  FUNCTION Win16LockVisRegions(hWndDesktop : hWnd; fLock : BOOLEAN) : BOOLEAN;

  FUNCTION WinQueryUpdateRect(aHwnd : hWnd; VAR prcl : { LONG } pRectL) : BOOLEAN;
  FUNCTION Win16QueryUpdateRect(aHwnd : hWnd; VAR prcl : { LONG } pRectL) : BOOLEAN;

  FUNCTION WinQueryUpdateRegion(aHwnd : hWnd; ahRGN : HRGN) : INTEGER;
  FUNCTION Win16QueryUpdateRegion(aHwnd : hWnd; ahRGN : HRGN) : INTEGER;

  FUNCTION WinExcludeUpdateRegion(ahps : hPs; aHwnd : hWnd) : INTEGER;
  FUNCTION Win16ExcludeUpdateRegion(ahps : hPs; aHwnd : hWnd) : INTEGER;

(* QMSG structure *)
TYPE
  QMsg = RECORD   (* qmsg *)
    hWnd : hWnd;
    Msg  : WORD;
    Mp1  : mParam;
    Mp2  : mParam;
    time : LongInt;
    ptl  : PointL;
  END;
  pQMsg = ^QMsg;

(* Standard Window Messages *)

CONST
  WM_NULL     = 0000;
  WM_CREATE    = 0001;
  WM_DESTROY    = 0002;

  WM_OTHERWINDOWDESTROYED = 0003;

  WM_ENABLE    = 0004;
  WM_SHOW     = 0005;
  WM_MOVE     = 0006;
  WM_SIZE     = 0007;
  WM_ADJUSTWINDOWPOS  = 0008;

  WM_CALCVALIDRECTS  = 0009;

  WM_SETWINDOWPARAMS  = $000A;
  WM_QUERYWINDOWPARAMS  = $000B;
  WM_HITTEST    = $000C;
  WM_ACTIVATE    = $000D;
  WM_SETFOCUS    = $000F;
  WM_SETSELECTION   = $0010;

(* language support Winproc *)
  WM_PPAINT    = $0011;
  WM_PSETFOCUS    = $0012;
  WM_PSYSCOLORCHANGE  = $0013;
  WM_PSIZE    = $0014;
  WM_PACTIVATE    = $0015;
  WM_PCONTROL    = $0016;

  WM_COMMAND    = $0020;
  WM_SYSCOMMAND    = $0021;
  WM_HELP     = $0022;
  WM_PAINT    = $0023;

  WM_TIMER    = $0024;
  WM_SEM1     = $0025;
  WM_SEM2     = $0026;
  WM_SEM3     = $0027;
  WM_SEM4     = $0028;

  WM_CLOSE    = $0029;
  WM_QUIT     = $002A;
  WM_SYSCOLORCHANGE  = $002B;
  WM_SYSVALUECHANGED  = $002D;
  WM_APPTERMINATENOTIFY  = $002E;
  WM_PRESPARAMCHANGED  = $002F;

(* Control notification messages *)

  WM_CONTROL    = $0030;
  WM_VSCROLL    = $0031;
  WM_HSCROLL    = $0032;
  WM_INITMENU    = $0033;
  WM_MENUSELECT    = $0034;
  WM_MENUEND    = $0035;
  WM_DRAWITEM    = $0036;
  WM_MEASUREITEM  = $0037;
  WM_CONTROLPOINTER  = $0038;
  WM_CONTROLHEAP  = $0039;
  WM_QUERYDLGCODE   = $003A;
  WM_INITDLG    = $003B;
  WM_SUBSTITUTESTRING  = $003C;
  WM_MATCHMNEMONIC  = $003D;
  WM_SAVEAPPLICATION  = $003E;

(* Reserve a range of messages for help manager.  This range includes  *)
(* public messages, defined below, and private ones, which need to be  *)
(* reserved here to prevent clashing with application messages         *)
CONST
  WM_HELPBASE    = $0F00; (* Start of msgs for help manager *)
  WM_HELPTOP    = $0FFF; (* End of msgs for help manager   *)

  WM_USER     = $1000;

(* WM_COMMAND msg source codes *)

  CMDSRC_PUSHBUTTON  = 1;
  CMDSRC_MENU    = 2;
  CMDSRC_ACCELERATOR  = 3;
  CMDSRC_OTHER    = 0;

TYPE
  CommandMsg = RECORD
    Source  : WORD;          (* mp2 *)
    fMouse  : BOOLEAN;
    cmd    : WORD;          (* mp1 *)
    unused  : WORD;
  END;

(* The following structure is used by the WinQueryQueueInfo() routine *)

  MQInfo = RECORD
    cb    : WORD;
    pID    : pID;
    tId    : tId;
    cmsgs  : WORD;
    pReserved  : pVoid;
  END;
  pMQInfo = ^MQInfo;

(* WinCreateMsgQueue default size *)

CONST
  DEFAULT_QUEUE_SIZE =  0;

  FUNCTION WinSendMsg(aHwnd : hWnd;
                      Msg   : WORD;
                      Mp1   : mParam;
                      Mp2   : mParam) : mResult;
  FUNCTION Win16SendMsg(aHwnd : hWnd;
                      Msg   : WORD;
                      Mp1   : mParam;
                      Mp2   : mParam) : mResult;

  FUNCTION WinCreateMsgQueue(ahab : HAB; cMsg : INTEGER) : hMQ;
  FUNCTION Win16CreateMsgQueue(ahab : HAB; cMsg : INTEGER) : hMQ;

  FUNCTION WinDestroyMsgQueue(aHmq : hMQ) : BOOLEAN;
  FUNCTION Win16DestroyMsgQueue(aHmq : hMQ) : BOOLEAN;

  FUNCTION WinQueryQueueInfo(    hMQ    : hMQ;
                             VAR pmqi   : { LONG } MQInfo;
                                 cbCopy : WORD) : BOOLEAN;
  FUNCTION Win16QueryQueueInfo(    hMQ    : hMQ;
                             VAR pmqi   : { LONG } MQInfo;
                                 cbCopy : WORD) : BOOLEAN;

  FUNCTION WinCancelShutdown(aHmq : hMQ; fCancelAlways : BOOLEAN) : BOOLEAN;
  FUNCTION Win16CancelShutdown(aHmq : hMQ; fCancelAlways : BOOLEAN) : BOOLEAN;

  FUNCTION WinGetMsg(    ahab           : HAB;
                     VAR QMsg           : { LONG } QMsg;
                         hWndFilter     : hWnd;
                         MsgFilterFirst : WORD;
                         MsgFilterLast  : WORD) : BOOLEAN;
  FUNCTION Win16GetMsg(  ahab           : HAB;
                     VAR QMsg           : { LONG } QMsg;
                         hWndFilter     : hWnd;
                         MsgFilterFirst : WORD;
                         MsgFilterLast  : WORD) : BOOLEAN;

  FUNCTION WinPeekMsg(    ahab           : HAB;
                      VAR QMsg           : { LONG } QMsg;
                          hWndFilter     : hWnd;
                          MsgFilterFirst : WORD;
                          MsgFilterLast  : WORD;
                          fs             : WORD) : BOOLEAN;
  FUNCTION Win16PeekMsg(  ahab           : HAB;
                      VAR QMsg           : { LONG } QMsg;
                          hWndFilter     : hWnd;
                          MsgFilterFirst : WORD;
                          MsgFilterLast  : WORD;
                          fs             : WORD) : BOOLEAN;

  FUNCTION WinDispatchMsg(ahab : HAB;
                          QMsg : { LONG } QMsg) : LongInt;
  FUNCTION Win16DispatchMsg(ahab : HAB;
                            QMsg : { LONG } QMsg) : LongInt;

  FUNCTION WinPostMsg(aHwnd : hWnd;
                      Msg   : WORD;
                      Mp1   : pmParam;
                      Mp2   : pmParam) : WORD; {BOOLEAN; }
  FUNCTION Win16PostMsg(aHwnd : hWnd;
                      Msg   : WORD;
                      Mp1   : pmParam;
                      Mp2   : pmParam) : BOOLEAN;

  FUNCTION WinRegisterUserMsg(a : HAB;
                              b : WORD;
                              c : INTEGER;
                              d : INTEGER;
                              e : INTEGER;
                              f : INTEGER;
                              g : INTEGER) : BOOLEAN;
  FUNCTION Win16RegisterUserMsg(a : HAB;
                              b : WORD;
                              c : INTEGER;
                              d : INTEGER;
                              e : INTEGER;
                              f : INTEGER;
                              g : INTEGER) : BOOLEAN;

  FUNCTION WinRegisterUserDatatype(    a : HAB;
                                       b : INTEGER;
                                       c : INTEGER;
                                   VAR d : INTEGER) : BOOLEAN;
  FUNCTION Win16RegisterUserDatatype(    a : HAB;
                                       b : INTEGER;
                                       c : INTEGER;
                                   VAR d : INTEGER) : BOOLEAN;

  FUNCTION WinSetMsgMode(a : HAB; b : pChar; c : INTEGER) : BOOLEAN;
  FUNCTION Win16SetMsgMode(a : HAB; b : pChar; c : INTEGER) : BOOLEAN;

  FUNCTION WinSetSynchroMode(a : HAB; b : INTEGER) : BOOLEAN;
  FUNCTION Win16SetSynchroMode(a : HAB; b : INTEGER) : BOOLEAN;

(* WinPeekMsg() constants *)

CONST
  PM_REMOVE =       00001;
  PM_NOREMOVE =     00000;

  RUM_IN  = 1;
  RUM_OUT  = 2;
  RUM_INOUT  = 3;

  SMD_DELAYED    = 1;
  SMD_IMMEDIATE  = 2;

  SSM_SYNCHRONOUS  = 1;
  SSM_AYSYNCHRONOUS  = 2;
  SSM_MIXED    = 3;

(* WM_CALCVALIDRECTS return flags *)

CONST
  CVR_ALIGNLEFT =       $00001;
  CVR_ALIGNBOTTOM =     $00002;
  CVR_ALIGNRIGHT =      $00004;
  CVR_ALIGNTOP =        $00008;
  CVR_REDRAW =          $00010;


(* WM_HITTEST return codes *)

CONST
  HT_NORMAL =       0;
  HT_TRANSPARENT =  (-1);
  HT_DISCARD =      (-2);
  HT_ERROR =        (-3);

(* WM_SET/QUERYWINDOWPARAMS structures and flags *)

TYPE
  WndParams = RECORD    (* wprm *)
    fsStatus     : WORD;
    cchText      : WORD;
    pszText      : pChar;
    cbPresParams : WORD;
    pPresParams  : pVoid;
    cbCtlData    : WORD;
    pCtlData     : pVoid;
  END;
  pWndParams = ^WndParams;

(* Flags used by WM_SET/QUERYWINDOWPARAMS *)

CONST
  WPM_TEXT         = $00001;
  WPM_CTLDATA      = $00002;
  WPM_PRESPARAMS   = $00004;
  WPM_CCHTEXT      = $00008;
  WPM_CBCTLDATA    = $00010;
  WPM_CBPRESPARAMS = $00020;

  FUNCTION WinInSendMsg(ahab : HAB) : BOOLEAN;
  FUNCTION Win16InSendMsg(ahab : HAB) : BOOLEAN;

  FUNCTION WinBroadcastMsg(aHwnd : hWnd;
                           Msg   : WORD;
                           Mp1   : mParam;
                           Mp2   : mParam;
                           fs    : WORD) : BOOLEAN;
  FUNCTION Win16BroadcastMsg(aHwnd : hWnd;
                           Msg   : WORD;
                           Mp1   : mParam;
                           Mp2   : mParam;
                           fs    : WORD) : BOOLEAN;

(* WinBroadcastMsg codes *)
CONST
  BMSG_POST        = $00000;
  BMSG_SEND        = $00001;
  BMSG_POSTQUEUE   = $00002;
  BMSG_DESCENDANTS = $00004;
  BMSG_FRAMEONLY   = $00008;

  FUNCTION WinWaitMsg(ahab     : HAB;
                      msgFirst : WORD;
                      msgLast  : WORD) : BOOLEAN;
  FUNCTION Win16WaitMsg(ahab     : HAB;
                      msgFirst : WORD;
                      msgLast  : WORD) : BOOLEAN;

  FUNCTION WinQueryQueueStatus(hWndDesktop : hWnd) : LongInt;
  FUNCTION Win16QueryQueueStatus(hWndDesktop : hWnd) : LongInt;

(* WinQueryQueueStatus() constants *)

CONST
  QS_KEY =          $00001;
  QS_MOUSEBUTTON =  $00002;
  QS_MOUSEMOVE =    $00004;
  QS_MOUSE =        $00006;      (* QS_MOUSEMOVE|QS_MOUSEBUTTON *)
  QS_TIMER =        $00008;
  QS_PAINT =        $00010;
  QS_POSTMSG =      $00020;
  QS_SEM1 =         $00040;
  QS_SEM2 =         $00080;
  QS_SEM3 =         $00100;
  QS_SEM4 =         $00200;
  QS_SENDMSG =      $00400;


  FUNCTION WinQueryMsgPos(    ahab : HAB;
                          VAR pptl : { LONG } PointL) : BOOLEAN;
  FUNCTION Win16QueryMsgPos(    ahab : HAB;
                          VAR pptl : { LONG } PointL) : BOOLEAN;

  FUNCTION WinQueryMsgTime(ahab : HAB) : LongInt;
  FUNCTION Win16QueryMsgTime(ahab : HAB) : LongInt;

  FUNCTION WinMsgSemWait(hSEM : hSEM; lTimeout : LongInt) : WORD;
  FUNCTION Win16MsgSemWait(hSEM : hSEM; lTimeout : LongInt) : WORD;

  FUNCTION WinMsgMuxSemWait(VAR pisemCleared : WORD;
                                pmxsl        : pVoid;
                                lTimeout     : LongInt) : WORD;
  FUNCTION Win16MsgMuxSemWait(VAR pisemCleared : WORD;
                                pmxsl        : pVoid;
                                lTimeout     : LongInt) : WORD;

  FUNCTION WinPostQueueMsg(aHmq : hMQ;
                           Msg  : WORD;
                           Mp1  : mParam;
                           Mp2  : mParam) : BOOLEAN;
  FUNCTION Win16PostQueueMsg(aHmq : hMQ;
                           Msg  : WORD;
                           Mp1  : mParam;
                           Mp2  : mParam) : BOOLEAN;

(*** Keyboard and mouse input stuff *)

(*** Keyboard and mouse input COMMON subsection *)

  FUNCTION WinSetFocus(hWndDesktop : hWnd; hWndSetFocus : hWnd) : BOOLEAN;
  FUNCTION Win16SetFocus(hWndDesktop : hWnd; hWndSetFocus : hWnd) : BOOLEAN;

  FUNCTION WinFocusChange(hWndDesktop   : hWnd;
                          hWndSetFocus  : hWnd;
                          fsFocusChange : WORD) : BOOLEAN;
  FUNCTION Win16FocusChange(hWndDesktop   : hWnd;
                          hWndSetFocus  : hWnd;
                          fsFocusChange : WORD) : BOOLEAN;

CONST
  FC_NOSETFOCUS =              $00001;
  FC_NOLOSEFOCUS =             $00002;
  FC_NOSETACTIVE =             $00004;
  FC_NOLOSEACTIVE =            $00008;
  FC_NOSETSELECTION =          $00010;
  FC_NOLOSESELECTION =         $00020;

  QFC_NEXTINCHAIN =             $00001;
  QFC_ACTIVE =                  $00002;
  QFC_FRAME =                   $00003;
  QFC_SELECTACTIVE =            $00004;

  FUNCTION WinSetCapture(hWndDesktop : hWnd;
                         aHwnd       : hWnd) : BOOLEAN;
  FUNCTION Win16SetCapture(hWndDesktop : hWnd;
                         aHwnd       : hWnd) : BOOLEAN;

  FUNCTION WinQueryCapture(hWndDesktop : hWnd;
                           fLock       : BOOLEAN) : hWnd;
  FUNCTION Win16QueryCapture(hWndDesktop : hWnd;
                           fLock       : BOOLEAN) : hWnd;

(* Mouse input messages *)

CONST
  WM_MOUSEFIRST =       $00070;
  WM_MOUSELAST =        $00079;
  WM_BUTTONCLICKFIRST = $00071;
  WM_BUTTONCLICKLAST =  $00079;

  WM_MOUSEMOVE =        $00070;

  WM_BUTTON1DOWN =      $00071;

  WM_BUTTON1UP =        $00072;
  WM_BUTTON1DBLCLK =    $00073;
  WM_BUTTON2DOWN =      $00074;
  WM_BUTTON2UP =        $00075;
  WM_BUTTON2DBLCLK =    $00076;
  WM_BUTTON3DOWN =      $00077;
  WM_BUTTON3UP =        $00078;
  WM_BUTTON3DBLCLK =    $00079;

  FUNCTION WinQueryFocus(hWndDesktop : hWnd; fLock : BOOLEAN) : hWnd;
  FUNCTION Win16QueryFocus(hWndDesktop : hWnd; fLock : BOOLEAN) : hWnd;

(* Key/Character input msg     *)

CONST
  WM_CHAR =             $0007A;
  WM_VIOCHAR =          $0007B;

(* WM_CHAR fs field bits *)

CONST
  KC_CHAR =             $00001;
  KC_VIRTUALKEY =       $00002;
  KC_SCANCODE =         $00004;

  KC_SHIFT =            $00008;
  KC_CTRL =             $00010;
  KC_ALT =              $00020;
  KC_KEYUP =            $00040;
  KC_PREVDOWN =         $00080;
  KC_LONEKEY =          $00100;
  KC_DEADKEY =          $00200;
  KC_COMPOSITE =        $00400;
  KC_INVALIDCOMP =      $00800;

  KC_TOGGLE =           $01000;
  KC_INVALIDCHAR =      $02000;
  KC_DBCSRSRVD1 =       $04000;
  KC_DBCSRSRVD2 =       $08000;

TYPE
  MouseMsg = RECORD
    codeHitTest : WORD;
    unused      : WORD;
    x, y        : INTEGER;
  END;

  CharMsg = RECORD
    chr      : WORD;
    vKey     : WORD;
    fs       : WORD;
    cRepeat  : CHAR;
    scancode : CHAR;
  END;

(*** Virtual key values *)

CONST
  VK_BUTTON1   = $001;
  VK_BUTTON2   = $002;
  VK_BUTTON3   = $003;
  VK_BREAK     = $004;
  VK_BACKSPACE = $005;
  VK_TAB       = $006;
  VK_BACKTAB   = $007;
  VK_NEWLINE   = $008;
  VK_SHIFT     = $009;
  VK_CTRL      = $00A;
  VK_ALT       = $00B;
  VK_ALTGRAF   = $00C;
  VK_PAUSE     = $00D;
  VK_CAPSLOCK  = $00E;
  VK_ESC       = $00F;
  VK_SPACE     = $010;
  VK_PAGEUP    = $011;
  VK_PAGEDOWN  = $012;
  VK_END       = $013;
  VK_HOME      = $014;
  VK_LEFT      = $015;
  VK_UP        = $016;
  VK_RIGHT     = $017;
  VK_DOWN      = $018;
  VK_PRINTSCRN = $019;
  VK_INSERT    = $01A;
  VK_DELETE    = $01B;
  VK_SCRLLOCK  = $01C;
  VK_NUMLOCK   = $01D;
  VK_ENTER     = $01E;
  VK_SYSRQ     = $01F;
  VK_F1        = $020;
  VK_F2        = $021;
  VK_F3        = $022;
  VK_F4        = $023;
  VK_F5        = $024;
  VK_F6        = $025;
  VK_F7        = $026;
  VK_F8        = $027;
  VK_F9        = $028;
  VK_F10       = $029;
  VK_F11       = $02A;
  VK_F12       = $02B;
  VK_F13       = $02C;
  VK_F14       = $02D;
  VK_F15       = $02E;
  VK_F16       = $02F;
  VK_F17       = $030;
  VK_F18       = $031;
  VK_F19       = $032;
  VK_F20       = $033;
  VK_F21       = $034;
  VK_F22       = $035;
  VK_F23       = $036;
  VK_F24       = $037;
  VK_MENU      = VK_F10;

  VK_DBCSFIRST = $80;
  VK_DBCSLAST  = $0FF;

  VK_USERFIRST = $100;
  VK_USERLAST  = $1FF;

  FUNCTION WinGetKeyState(hWndDesktop : hWnd;
                          vKey        : INTEGER) : INTEGER;
  FUNCTION Win16GetKeyState(hWndDesktop : hWnd;
                          vKey        : INTEGER) : INTEGER;

  FUNCTION WinGetPhysKeyState(hWndDesktop : hWnd;
                              sc          : INTEGER) : INTEGER;
  FUNCTION Win16GetPhysKeyState(hWndDesktop : hWnd;
                              sc          : INTEGER) : INTEGER;

  FUNCTION WinEnablePhysInput(hWndDesktop : hWnd;
                              fEnable     : BOOLEAN) : BOOLEAN;
  FUNCTION Win16EnablePhysInput(hWndDesktop : hWnd;
                              fEnable     : BOOLEAN) : BOOLEAN;

  FUNCTION WinIsPhysInputEnabled(hWndDesktop : hWnd) : BOOLEAN;
  FUNCTION Win16IsPhysInputEnabled(hWndDesktop : hWnd) : BOOLEAN;

  FUNCTION WinSetKeyboardStateTable(hWndDesktop    : hWnd;
                                    pKeyStateTable : pBYTE;
                                    fSet           : BOOLEAN) : BOOLEAN;
  FUNCTION Win16SetKeyboardStateTable(hWndDesktop    : hWnd;
                                    pKeyStateTable : pBYTE;
                                    fSet           : BOOLEAN) : BOOLEAN;

(* Journal Notification messages  *)
CONST
  WM_JOURNALNOTIFY =    $0007C;

(*** Define the valid commands (lParm1) for journal notify message *)
  JRN_QUEUESTATUS =     $000000001;
  JRN_PHYSKEYSTATE =    $000000002;

(**** Dialog Manager *)

(**** Dialog Manager COMMON subsection *)

  FUNCTION WinGetDlgMsg(a : hWnd; VAR b : QMsg) : BOOLEAN;
  FUNCTION Win16GetDlgMsg(a : hWnd; VAR b : QMsg) : BOOLEAN;

  FUNCTION WinLoadDlg(hWndParent    : hWnd;
                      hWndOwner     : hWnd;
                      pfnDlgProc    : pFnWp;
                      hMod          : hModule;
                      idDlg         : WORD;
                      pCreateParams : pVoid) : hWnd;
  FUNCTION Win16LoadDlg(hWndParent    : hWnd;
                      hWndOwner     : hWnd;
                      pfnDlgProc    : pFnWp;
                      hMod          : hModule;
                      idDlg         : WORD;
                      pCreateParams : pVoid) : hWnd;

  FUNCTION WinDlgBox(hWndParent    : hWnd;
                     hWndOwner     : hWnd;
                     pfnDlgProc    : pFnWp;
                     hMod          : hModule;
                     idDlg         : WORD;
                     pCreateParams : pVoid) : WORD;
  FUNCTION Win16DlgBox(hWndParent    : hWnd;
                     hWndOwner     : hWnd;
                     pfnDlgProc    : pFnWp;
                     hMod          : hModule;
                     idDlg         : WORD;
                     pCreateParams : pVoid) : WORD;

  FUNCTION WinDismissDlg(hWndDlg : hWnd; usResult : WORD) : BOOLEAN;
  FUNCTION Win16DismissDlg(hWndDlg : hWnd; usResult : WORD) : BOOLEAN;

  FUNCTION WinQueryDlgItemShort(    hWndDlg : hWnd;
                                    idItem  : WORD;
                                VAR pResult : INTEGER;
                                    fSigned : BOOLEAN) : BOOLEAN;
  FUNCTION Win16QueryDlgItemShort(    hWndDlg : hWnd;
                                    idItem  : WORD;
                                VAR pResult : INTEGER;
                                    fSigned : BOOLEAN) : BOOLEAN;

  FUNCTION WinSetDlgItemShort(hWndDlg : hWnd;
                              idItem  : WORD;
                              usValue : WORD;
                              fSigned : BOOLEAN) : BOOLEAN;
  FUNCTION Win16SetDlgItemShort(hWndDlg : hWnd;
                              idItem  : WORD;
                              usValue : WORD;
                              fSigned : BOOLEAN) : BOOLEAN;

  FUNCTION WinSetDlgItemText(hWndDlg : hWnd;
                             idItem  : WORD;
                             pszText : pChar) : BOOLEAN;
  FUNCTION Win16SetDlgItemText(hWndDlg : hWnd;
                             idItem  : WORD;
                             pszText : pChar) : BOOLEAN;

  FUNCTION WinQueryDlgItemText(hWndDlg      : hWnd;
                               idItem       : WORD;
                               cchBufferMax : INTEGER;
                               pszBuf       : pChar) : WORD;
  FUNCTION Win16QueryDlgItemText(hWndDlg      : hWnd;
                               idItem       : WORD;
                               cchBufferMax : INTEGER;
                               pszBuf       : pChar) : WORD;

  FUNCTION WinQueryDlgItemTextLength(hWndDlg : hWnd;
                                     idItem  : WORD) : INTEGER;
  FUNCTION Win16QueryDlgItemTextLength(hWndDlg : hWnd;
                                     idItem  : WORD) : INTEGER;

  FUNCTION WinDefDlgProc(hWndDlg : hWnd;
                         Msg     : WORD;
                         Mp1     : mParam;
                         Mp2     : mParam) : mResult;
  FUNCTION Win16DefDlgProc(hWndDlg : hWnd;
                         Msg     : WORD;
                         Mp1     : mParam;
                         Mp2     : mParam) : mResult;

(* Special item IDs *)
CONST
  DID_OK     =  1;
  DID_CANCEL =  2;
  DID_ERROR  =  $FFFF;

  FUNCTION WinAlarm(hWndDesktop : hWnd; fsType : WORD) : BOOLEAN;
  FUNCTION Win16Alarm(hWndDesktop : hWnd; fsType : WORD) : BOOLEAN;

(* WinAlarm Codes *)
CONST
  WA_WARNING =              0;
  WA_NOTE =                 1;
  WA_ERROR =                2;

  WA_CWINALARMS =           3;

  FUNCTION WinMessageBox(hWndParent : hWnd;
                         hWndOwner  : hWnd;
                         pszText    : pChar;
                         pszCaption : pChar;
                         idWindow   : WORD;
                         flStyle    : WORD) : WORD;
  FUNCTION Win16MessageBox(hWndParent : hWnd;
                         hWndOwner  : hWnd;
                         pszText    : pChar;
                         pszCaption : pChar;
                         idWindow   : WORD;
                         flStyle    : WORD) : WORD;

(* Message box types *)
CONST
  MB_OK =                   $00000;
  MB_OKCANCEL =             $00001;
  MB_RETRYCANCEL =          $00002;
  MB_ABORTRETRYIGNORE =     $00003;
  MB_YESNO =                $00004;
  MB_YESNOCANCEL =          $00005;
  MB_CANCEL =               $00006;
  MB_ENTER =                $00007;
  MB_ENTERCANCEL =          $00008;

  MB_NOICON =               $00000;
  MB_CUANOTIFICATION =      $00000;
  MB_ICONQUESTION =         $00010;
  MB_ICONEXCLAMATION =      $00020;
  MB_CUAWARNING =           $00020;
  MB_ICONASTERISK =         $00030;
  MB_ICONHAND =             $00040;
  MB_CUACRITICAL =          $00040;

  MB_QUERY    = MB_ICONQUESTION;
  MB_WARNING    = MB_CUAWARNING;
  MB_INFORMATION  = MB_ICONASTERISK;
  MB_CRITICAL    = MB_CUACRITICAL;
  MB_ERROR    = MB_CRITICAL;

  MB_DEFBUTTON1 =           $00000;
  MB_DEFBUTTON2 =           $00100;
  MB_DEFBUTTON3 =           $00200;

  MB_APPLMODAL =            $00000;
  MB_SYSTEMMODAL =          $01000;
  MB_HELP =                 $02000;
  MB_MOVEABLE =             $04000;

(* Message box return codes *)

  MBID_OK =                 1;
  MBID_CANCEL =             2;
  MBID_ABORT =              3;
  MBID_RETRY =              4;
  MBID_IGNORE =             5;
  MBID_YES =                6;
  MBID_NO =                 7;
  MBID_HELP =               8;
  MBID_ENTER =              9;
  MBID_ERROR =              $FFFF;

(* Dialog codes: returned by WM_QUERYDLGCODE msg     *)
  DLGC_ENTRYFIELD =     $00001;    (* Entry field item understands EM_SETSEL) *)
  DLGC_BUTTON =         $00002;    (* Button item *)
  DLGC_RADIOBUTTON =    $00004;    (* Radio button *)
  DLGC_STATIC =         $00008;    (* Static item *)
  DLGC_DEFAULT =        $00010;    (* Default push button *)
  DLGC_PUSHBUTTON =     $00020;    (* Normal (Non-default) push button *)
  DLGC_CHECKBOX =       $00040;    (* Check box button control *)
  DLGC_SCROLLBAR =      $00080;    (* Scroll bar *)
  DLGC_MENU =           $00100;    (* Menu *)
  DLGC_TABONCLICK =     $00200;
  DLGC_MLE  = $400;

  FUNCTION WinProcessDlg(hWndDlg : hWnd) : WORD;
  FUNCTION Win16ProcessDlg(hWndDlg : hWnd) : WORD;

(*  FUNCTION WinStartDlg(a : HWND) : WORD;
     EXTERNAL 'PMWIN' INDEX ???;  *)

  FUNCTION WinSendDlgItemMsg(hWndDlg : hWnd;
                             idItem  : WORD;
                             Msg     : WORD;
                             Mp1     : mParam;
                             Mp2     : mParam) : mResult;
  FUNCTION Win16SendDlgItemMsg(hWndDlg : hWnd;
                             idItem  : WORD;
                             Msg     : WORD;
                             Mp1     : mParam;
                             Mp2     : mParam) : mResult;

  FUNCTION WinMapDlgPoints(    hWndDlg           : hWnd;
                           VAR prgwptl           : { LONG } PointL;
                               cwpt              : WORD;
                               fCalcWindowCoords : BOOLEAN) : BOOLEAN;
  FUNCTION Win16MapDlgPoints(    hWndDlg           : hWnd;
                           VAR prgwptl           : { LONG } PointL;
                               cwpt              : WORD;
                               fCalcWindowCoords : BOOLEAN) : BOOLEAN;

  FUNCTION WinEnumDlgItem(hWndDlg : hWnd;
                          aHwnd   : hWnd;
                          Code    : WORD;
                          fLock   : BOOLEAN) : hWnd;
  FUNCTION Win16EnumDlgItem(hWndDlg : hWnd;
                          aHwnd   : hWnd;
                          Code    : WORD;
                          fLock   : BOOLEAN) : hWnd;

  FUNCTION WinSubstituteStrings(aHwnd     : hWnd;
                                pszSrc    : pChar;
                                cchDstMax : INTEGER;
                                pszDst    : pChar) : INTEGER;
  FUNCTION Win16SubstituteStrings(aHwnd     : hWnd;
                                pszSrc    : pChar;
                                cchDstMax : INTEGER;
                                pszDst    : pChar) : INTEGER;

(* WinEnumDlgItem()  constants *)
CONST
  EDI_FIRSTTABITEM =        0;
  EDI_LASTTABITEM =         1;
  EDI_NEXTTABITEM =         2;
  EDI_PREVTABITEM =         3;
  EDI_FIRSTGROUPITEM =      4;
  EDI_LASTGROUPITEM =       5;
  EDI_NEXTGROUPITEM =       6;
  EDI_PREVGROUPITEM =       7;

(*** Dialog template definitions *)

(* Variable-sized dialog template items: *)

TYPE
  DlgTItem = RECORD     (* dlgti *)
    fsItemStatus:    WORD;
    cChildren:    WORD;
    cchClassName:    WORD;
    offClassName:    WORD;
    cchText:    WORD;
    offText:    WORD;
    flStyle:     LongInt;
    x:     INTEGER;
    y:     INTEGER;
    cx:     INTEGER;
    cy:     INTEGER;
    id:    WORD;
    offPresParams:    WORD;
    offCtlData:    WORD;
  END;
  pDlgTItem = ^DlgTItem;

(* Dialog Template structure *)
  DlgTemplate = RECORD           (* dlgt *)
    cbTemplate:      WORD;
    aType:      WORD;
    codepage:      WORD;
    offadlgti:      WORD;          (* Is always 12 for pm 1.1 *)
    fsTemplateStatus:      WORD;
    iItemFocus:      WORD;
    cOffPresParams:      WORD;     (* Reserved to be 0 for pm 1.1 *)
    adlgt: DlgTItem;
  END;
  pDlgTemplate = ^DlgTemplate;

  FUNCTION WinCreateDlg(hWndParent    : hWnd;
                        hWndOwner     : hWnd;
                        pfnDlgProc    : pFnWp;
                        pdlgt         : pDlgTemplate;
                        pCreateParams : pVoid) : hWnd;
  FUNCTION Win16CreateDlg(hWndParent    : hWnd;
                        hWndOwner     : hWnd;
                        pfnDlgProc    : pFnWp;
                        pdlgt         : pDlgTemplate;
                        pCreateParams : pVoid) : hWnd;

(**** Static Control Manager *)

(* Static control styles:
 *
 * NOTE: the top 9 bits of the LOWORD of the window flStyle are used for
 * DT_* flags.  The lower 7 bits are for SS_* styles.  This gives us up
 * to 128 distinct static control types (we currently use 11 of them).
 *)
CONST
  SS_TEXT =             $00001;
  SS_GROUPBOX =         $00002;
  SS_ICON =             $00003;
  SS_BITMAP =           $00004;
  SS_FGNDRECT =         $00005;
  SS_HALFTONERECT =     $00006;
  SS_BKGNDRECT =        $00007;
  SS_FGNDFRAME =        $00008;
  SS_HALFTONEFRAME =    $00009;
  SS_BKGNDFRAME =       $0000A;
  SS_SYSICON =          $0000B;

(* Static control class name *)

  WC_STATIC =       $0FFFF0005;

(* Static control messages *)

  SM_SETHANDLE =        $00100;
  SM_QUERYHANDLE =      $00101;
(**** Button Controls Subsection *)

(* Button control styles *)

  BS_PUSHBUTTON =       0;
  BS_CHECKBOX =         1;
  BS_AUTOCHECKBOX =     2;
  BS_RADIOBUTTON =      3;
  BS_AUTORADIOBUTTON =  4;
  BS_3STATE =           5;
  BS_AUTO3STATE =       6;

  BS_USERBUTTON =       7;
  BS_HELP =             $00100;
  BS_SYSCOMMAND =       $00200;
  BS_DEFAULT =          $00400;
  BS_NOPOINTERFOCUS =   $00800;
  BS_NOBORDER =         $01000;
  BS_NOCURSORSELECT  = $2000;

(* Button class name *)

  WC_BUTTON =   $0FFFF0003;

TYPE
  BtnCData = RECORD     (* btncd *)
    cb            : WORD;
    fsCheckState  : WORD;
    fsHiliteState : WORD;
  END;
  pBtnCData = ^BtnCData;

(* User button structure (passed in  msg: WM_CONTROL) *)

TYPE
  UserButton = RECORD   (* ubtn *)
    hWnd       : hWnd;
    hPs        : hPs;
    fsState    : WORD;
    fsStateOld : WORD;
  END;
  pUserButton = ^UserButton;

(* Button control messages *)
CONST
  BM_CLICK =            $00120;
  BM_QUERYCHECKINDEX =  $00121;
  BM_QUERYHILITE =      $00122;
  BM_SETHILITE =        $00123;
  BM_QUERYCHECK =       $00124;
  BM_SETCHECK =         $00125;
  BM_SETDEFAULT =       $00126;

(* Button notification codes *)

  BN_CLICKED =          1;
  BN_DBLCLICKED =       2;
  BN_PAINT =            3;

(* BN_PAINT button draw state codes (must be in high byte) *)

  BDS_HILITED =         $00100;
  BDS_DISABLED =        $00200;
  BDS_DEFAULT =         $00400;

(**** Entryfield controls Subsection *)

(* Entry field  styles *)

  ES_LEFT =             $000000000;
  ES_CENTER =           $000000001;
  ES_RIGHT =            $000000002;
  ES_AUTOSCROLL =       $000000004;
  ES_AUTOTAB =          $000000008;

    ES_READONLY    = $20;
    ES_COMMAND    = $40;
    ES_UNREADABLE  = $80;
    ES_PICTUREMASK  = $100;

    ES_ANY    = 0;
    ES_SBCS    = $100000;
    ES_DBCS    = $200000;
    ES_MIXED    = $300000;

  WC_ENTRYFIELD =     $0FFFF0006;
    WC_COMBOBOX    = $0FFFF0002;

    CBS_SIMPLE    = 1;
    CBS_DROPDOWN  = 2;
    CBS_DROPDOWNLIST  = 4;

    CBM_SHOWLISTT  = $170;
    CBM_HILITE    = $171;
    CBM_ISLISTSHOWING  = $172;

    CBN_EFCHANGE  = 1;
    CBN_EFSCROLL  = 2;
    CBN_MEMERROR  = 3;
    CBN_LBSELECT  = 4;
    CBN_LBSCROLL  = 5;
    CBN_SHOWLIST  = 6;
    CBN_ENTER    = 7;

TYPE
  EntryFData = RECORD        (* efd *)
    cb           : WORD;
    cchEditLimit : WORD;
    ichMinSel    : WORD;
    ichMaxSel    : WORD;
  END;
  pEntryFData = ^EntryFData;

(* Entry Field  messages *)
CONST
  EM_QUERYCHANGED =     $00140;
  EM_QUERYSEL =         $00141;
  EM_SETSEL =           $00142;
  EM_SETTEXTLIMIT =     $00143;

  EM_CUT =              $00144;
  EM_COPY =             $00145;
  EM_CLEAR =            $00146;
  EM_PASTE =            $00147;
  EM_QUERYFIRSTCHAR =   $00148;
  EM_SETFIRSTCHAR =     $00149;

(* Entry Field  notification messages *)

  EN_SETFOCUS =         $00001;
  EN_KILLFOCUS =        $00002;
  EN_CHANGE =           $00004;
  EN_SCROLL =           $00008;
  EN_MEMERROR =         $00010;

(**** Listboxes *)

(* List box styles *)

  LS_MULTIPLESEL =      $000000001;

  LS_OWNERDRAW =        $000000002;

  LS_NOADJUSTPOS =      $000000004;


(* Listbox class name *)

  WC_LISTBOX =      $0FFFF0007;

(* List box notification messages *)
  LN_SELECT =           1;
  LN_SETFOCUS =         2;
  LN_KILLFOCUS =        3;
  LN_SCROLL =           4;
  LN_ENTER =            5;

(* List box messages *)

  LM_QUERYITEMCOUNT =   $00160;
  LM_INSERTITEM =       $00161;
  LM_SETTOPINDEX =      $00162;
  LM_DELETEITEM =       $00163;
  LM_SELECTITEM =       $00164;
  LM_QUERYSELECTION =   $00165;
  LM_SETITEMTEXT =      $00166;
  LM_QUERYITEMTEXTLENGTH = $00167;
  LM_QUERYITEMTEXT =    $00168;

  LM_SETITEMHANDLE =    $00169;
  LM_QUERYITEMHANDLE =  $0016A;
  LM_SEARCHSTRING =     $0016B;
  LM_SETITEMHEIGHT =    $0016C;
  LM_QUERYTOPINDEX =    $0016D;
  LM_DELETEALL =        $0016E;

(* List box  CONSTants *)

  LIT_ERROR =            (-3);
  LIT_MEMERROR =         (-2);
  LIT_NONE =             (-1);
  LIT_FIRST =            (-1);

(* For LM_INSERTITEM msg     *)

  LIT_END =              (-1);
  LIT_SORTASCENDING =    (-2);
  LIT_SORTDESCENDING =   (-3);

(* For LM_SEARCHSTRING msg     *)

  LSS_SUBSTRING =       $00001;
  LSS_PREFIX =          $00002;
  LSS_CASESENSITIVE =   $00004;


(**** Menu Manager Subsection *)

(* Menu control styles *)

  MS_ACTIONBAR =        $000000001;
  MS_TITLEBUTTON =      $000000002;
  MS_VERTICALFLIP =     $000000004;

  FUNCTION WinLoadMenu(hWndFrame : hWnd;
                       hMod      : hModule;
                       idMenu    : WORD) : hWnd;
  FUNCTION Win16LoadMenu(hWndFrame : hWnd;
                       hMod      : hModule;
                       idMenu    : WORD) : hWnd;

(* Menu class name *)
CONST
  WC_MENU = $0FFFF0004;

(* Menu control messages *)

  MM_INSERTITEM =           $00180;
  MM_DELETEITEM =           $00181;
  MM_QUERYITEM =            $00182;
  MM_SETITEM =              $00183;
  MM_QUERYITEMCOUNT =       $00184;
  MM_STARTMENUMODE =        $00185;
  MM_ENDMENUMODE =          $00186;
  MM_REMOVEITEM =           $00188;
  MM_SELECTITEM =           $00189;
  MM_QUERYSELITEMID =       $0018A;
  MM_QUERYITEMTEXT =        $0018B;
  MM_QUERYITEMTEXTLENGTH =  $0018C;
  MM_SETITEMHANDLE =        $0018D;
  MM_SETITEMTEXT =          $0018E;
  MM_ITEMPOSITIONFROMID =   $0018F;
  MM_ITEMIDFROMPOSITION =   $00190;
  MM_QUERYITEMATTR =        $00191;
  MM_SETITEMATTR =          $00192;
  MM_ISITEMVALID =          $00193;

  FUNCTION WinCreateMenu(hWndParent : hWnd; pvmt : pVoid) : hWnd;
  FUNCTION Win16CreateMenu(hWndParent : hWnd; pvmt : pVoid) : hWnd;

(* Owner Item Structure (Also used for listboxes) *)
TYPE
   OwnerItem = RECORD
     hWnd           : hWnd;
     hPs            : hPs;
     fsState        : WORD;
     fsAttribute    : WORD;
     fsStateOld     : WORD;
     fsAttributeOld : WORD;
     rclItem        : RectL;
     idItem         : INTEGER;
       (* This field contains idItem for menus, iItem for lb. *)
     hItem          : LongInt;
   END;
   pOwnerItem = ^OwnerItem;

(* Menu item *)

TYPE
  MenuItem = RECORD     (* mi *)
    iPosition   : INTEGER;
    afStyle     : WORD;
    afAttribute : WORD;
    id          : WORD;
    hWndSubMenu : hWnd;
    hItem       : LongInt;
  END;
  pMenuItem = ^MenuItem;

CONST
  MIT_END =         (-1);
  MIT_NONE =        (-1);
  MIT_MEMERROR =    (-1);
  MIT_ERROR =       (-1);
  MID_NONE =        MIT_NONE;
  MID_ERROR =       (-1);

(* Menu item styles & attributes *)

  MIS_TEXT =            $00001;

  MIS_BITMAP =          $00002;
  MIS_SEPARATOR =       $00004;
  MIS_OWNERDRAW =       $00008;
  MIS_SUBMENU =         $00010;
  MIS_SYSCOMMAND =      $00040;
  MIS_HELP =            $00080;
  MIS_STATIC =          $00100;
  MIS_BUTTONSEPARATOR = $00200;
  MIS_BREAK =           $00400;
  MIS_BREAKSEPARATOR  = $00800;
  MIS_GROUP           = $1000;
  MIS_SINGLE          = $2000;

  MIA_NODISMISS =       $00020;
  MIA_FRAMED =          $01000;
  MIA_CHECKED =         $02000;
  MIA_DISABLED =        $04000;
  MIA_HILITED =         $08000;

(*** Scroll Bar controls Subsection *)

(* Scroll Bar styles *)

  SBS_HORZ =            0;
  SBS_VERT =            1;
    SBS_TTHUMBSIZE  = 2;
    SBS_AUTOTRACK  = 4;

(* Scroll bar class name *)


  WC_SCROLLBAR =    $0FFFF0008;

(* Scroll Bar messages *)

  SBM_SETSCROLLBAR =    $001A0;
  SBM_SETPOS =          $001A1;
  SBM_QUERYPOS =        $001A2;
  SBM_QUERYRANGE =      $001A3;
  SBM_SETHILITE =       $001A4;
  SBM_QUERYHILITE =     $001A5;
    SBM_SETTHUMBSIZE  = $1A6;

(* Scroll Bar Commands *)

  SB_LINEUP =           1;
  SB_LINEDOWN =         2;
  SB_LINELEFT =         1;
  SB_LINERIGHT =        2;
  SB_PAGEUP =           3;
  SB_PAGEDOWN =         4;
  SB_PAGELEFT =         3;
  SB_PAGERIGHT =        4;
  SB_SLIDERTRACK =      5;
  SB_SLIDERPOSITION =   6;
  SB_ENDSCROLL =        7;

TYPE
  SBCDATA = RECORD      (* sbcd *)
    cb: WORD;
    sHilite: WORD;         (* reserved, should be set to zero *)
    posFirst: INTEGER;
    posLast: INTEGER;
    posThumb: INTEGER;
  END;
  pSbcData = ^SBCDATA;

(*** Frame Manager Common subsection *)

TYPE
  FrameCData = RECORD     (* fcdata *)
    cb: WORD;
    flCreateFlags: LongInt;
    hmodResources: hModule;
    idResources: WORD;
  END;
  pFrameCData = ^FrameCData;

(* Frame window styles *)
CONST
  FCF_TITLEBAR =        $000000001;
  FCF_SYSMENU =         $000000002;
  FCF_MENU =            $000000004;
  FCF_SIZEBORDER =      $000000008;
  FCF_MINBUTTON =       $000000010;
  FCF_MAXBUTTON =       $000000020;
  FCF_MINMAX =          $000000030;     (* minmax means BOTH buttons *)
  FCF_VERTSCROLL =      $000000040;
  FCF_HORZSCROLL =      $000000080;
  FCF_DLGBORDER =       $000000100;
  FCF_BORDER =          $000000200;
  FCF_SHELLPOSITION =   $000000400;
  FCF_TASKLIST =        $000000800;
  FCF_NOBYTEALIGN =     $000001000;
  FCF_NOMOVEWITHOWNER = $000002000;
  FCF_ICON =            $000004000;
  FCF_ACCELTABLE =      $000008000;
  FCF_SYSMODAL =        $000010000;
  FCF_SCREENALIGN =     $000020000;
  FCF_MOUSEALIGN =      $000040000;

  FCF_PALETTE_NORMAL    = $80000;
  FCF_PALETTE_HELP      = $100000;
  FCF_PALETTE_POPUPODD  = $200000;
  FCF_PALETTE_POPUPEVEN = $400000;

  FCF_DBE_APPSTAT       = $80000000;

(* FCF_TITLEBAR | FCF_SYSMENU | FCF_MENU | FCF_SIZEBORDER | FCF_MINMAX |
   FCF_ICON | FCF_ACCELTABLE | FCF_SHELLPOSITION | FCF_TASKLIST *)

  FCF_STANDARD =        $00000CC3F;


  FS_ICON =             $000000001;
  FS_ACCELTABLE =       $000000002;

  FS_SHELLPOSITION =    $000000004;

  FS_TASKLIST =         $000000008;
  FS_NOBYTEALIGN =      $000000010;
  FS_NOMOVEWITHOWNER =  $000000020;
  FS_SYSMODAL =         $000000040;
  FS_DLGBORDER =        $000000080;
  FS_BORDER =           $000000100;
  FS_SCREENALIGN =      $000000200;
  FS_MOUSEALIGN =       $000000400;
  FS_SIZEBORDER =       $000000800;

    FS_DBE_APPSTAT  = $8000;

(* FS_ICON | FS_ACCELTABLE | FS_SHELLPOSITION | FS_TASKLIST *)
  FS_STANDARD =         $00000000F;

(* Frame Window Flags accessed via WinSet/QueryWindowUShort(QWS_FLAGS) *)

  FF_FLASHWINDOW =      $00001;
  FF_ACTIVE =           $00002;
  FF_FLASHHILITE =      $00004;
  FF_OWNERHIDDEN =      $00008;
  FF_DLGDISMISSED =     $00010;
  FF_OWNERDISABLED =    $00020;
  FF_SELECTED =         $00040;
  FF_NOACTIVATESWP =    $00080;

  FUNCTION WinCreateStdWindow(    hWndParent     : hWnd;
                                  flStyle        : LongInt;
                              VAR pflCreateFlags : LongInt;
                                  pszClientClass : pChar;
                                  pszTitle       : pChar;
                                  flClientStyle  : LongInt;
                                  hMod           : hModule;
                                  idResources    : WORD;
                              VAR hWndClient     : { LONG } hWnd) : hWnd;
  FUNCTION Win16CreateStdWindow(    hWndParent     : hWnd;
                                  flStyle        : LongInt;
                              VAR pflCreateFlags : LongInt;
                                  pszClientClass : pChar;
                                  pszTitle       : pChar;
                                  flClientStyle  : LongInt;
                                  hMod           : hModule;
                                  idResources    : WORD;
                              VAR hWndClient     : { LONG } hWnd) : hWnd;

  FUNCTION WinFlashWindow(hWndFrame : hWnd; fFlash : BOOLEAN) : BOOLEAN;
  FUNCTION Win16FlashWindow(hWndFrame : hWnd; fFlash : BOOLEAN) : BOOLEAN;

(* Frame window related messages *)
CONST
  WM_FLASHWINDOW =      $00040;
  WM_FORMATFRAME =      $00041;
  WM_UPDATEFRAME =      $00042;
  WM_FOCUSCHANGE =      $00043;

  WM_SETBORDERSIZE =    $00044;
  WM_TRACKFRAME =       $00045;
  WM_MINMAXFRAME =      $00046;
  WM_SETICON =          $00047;
  WM_QUERYICON =        $00048;
  WM_SETACCELTABLE =    $00049;
  WM_QUERYACCELTABLE =  $0004A;
  WM_TRANSLATEACCEL =   $0004B;
  WM_QUERYTRACKINFO =   $0004C;
  WM_QUERYBORDERSIZE =  $0004D;
  WM_NEXTMENU =         $0004E;
  WM_ERASEBACKGROUND =  $0004F;
  WM_QUERYFRAMEINFO =   $00050;
  WM_QUERYFOCUSCHAIN =  $00051;
    WM_CALCFRAMERECT  = $53;
    WM_WINDOWPOSCHANGED  = $55;
  WM_QUERYFRAMECTLCOUNT = $00059;
    WM_QUERYHELPINFO  = $5B;
    WM_SETHELPINFO  = $5C;
    WM_ERROR    = $5D;

(* WM_QUERYFRAMEINFO  constants *)
CONST
  FI_FRAME =            $000000001;
  FI_OWNERHIDE =        $000000002;
  FI_ACTIVATEOK =       $000000004;
  FI_NOMOVEWITHOWNER =  $000000008;

(* Frame class name *)

  WC_FRAME =        $0FFFF0001;

  FUNCTION WinCreateFrameControls(hWndFrame : hWnd;
                                  pfcdata   : { LONG } FrameCData;
                                  pszTitle  : pChar;
                                  h         : hModule) : BOOLEAN;
  FUNCTION Win16CreateFrameControls(hWndFrame : hWnd;
                                  pfcdata   : { LONG } FrameCData;
                                  pszTitle  : pChar;
                                  h         : hModule) : BOOLEAN;

  FUNCTION WinFormatFrame(    hWndFrame  : hWnd;
                              prclFrame  : { LONG } pRectL;
                              pSwp       : { LONG } Swp;
                              cswpMax    : WORD;
                          VAR prclClient : { LONG } pRectL) : INTEGER;
  FUNCTION Win16FormatFrame(    hWndFrame  : hWnd;
                              prclFrame  : { LONG } pRectL;
                              pSwp       : { LONG } Swp;
                              cswpMax    : WORD;
                          VAR prclClient : { LONG } pRectL) : INTEGER;

  FUNCTION WinCalcFrameRect(    hWndFrame : hWnd;
                            VAR prcl      : { LONG } pRectL;
                                fClient   : BOOLEAN) : BOOLEAN;
  FUNCTION Win16CalcFrameRect(    hWndFrame : hWnd;
                            VAR prcl      : { LONG } pRectL;
                                fClient   : BOOLEAN) : BOOLEAN;

  FUNCTION WinGetMinPosition(    hWnd : hWnd;
                             VAR pSwp : { LONG } Swp;
                             VAR pptl : { LONG } PointL) : BOOLEAN;
  FUNCTION Win16GetMinPosition(    hWnd : hWnd;
                             VAR pSwp : { LONG } Swp;
                             VAR pptl : { LONG } PointL) : BOOLEAN;

  FUNCTION WinGetMaxPosition(    hWnd : hWnd;
                             VAR pSwp : { LONG } Swp) : BOOLEAN;
  FUNCTION Win16GetMaxPosition(    hWnd : hWnd;
                             VAR pSwp : { LONG } Swp) : BOOLEAN;

(* Frame control IDs    *)
CONST
  FID_SYSMENU =         $08002;
  FID_TITLEBAR =        $08003;
  FID_MINMAX =          $08004;
  FID_MENU =            $08005;
  FID_VERTSCROLL =      $08006;
  FID_HORZSCROLL =      $08007;
  FID_CLIENT =          $08008;

    FID_DBE_APPSTAT  = $8010;
    FID_DBE_KBDSTAT  = $8011;
    FID_DBE_PECIC    = $8012;
    FID_DBE_KKPOPUP  = $8013;

(* Standard WM_SYSCOMMAND command values *)

  SC_SIZE =             $08000;
  SC_MOVE =             $08001;
  SC_MINIMIZE =         $08002;
  SC_MAXIMIZE =         $08003;
  SC_CLOSE =            $08004;
  SC_NEXT =             $08005;
  SC_APPMENU =          $08006;
  SC_SYSMENU =          $08007;
  SC_RESTORE =          $08008;
  SC_NEXTFRAME =        $08009;
  SC_NEXTWINDOW =       $08010;
  SC_TASKMANAGER =      $08011;
    SC_HELPKEYS    = $8012;
    SC_HELPINDEX  = $8013;
    SC_HELPEXTENDED  = $8014;
    SC_SWITCHPANELIDS  = $8015;
    SC_DBE_FIRST  = $8018;
    SC_DBE_LAST    = $801F;

(*** Frame controls *)

(** Title bar controls *)

(* Title bar control class name *)

  WC_TITLEBAR =  Pointer ($0FFFF0009);

(* Title bar control messages *)

  TBM_SETHILITE =           $001E3;
  TBM_QUERYHILITE =         $001E4;
  TBM_TRACKMOVE  = $1E5;

(*** Rectangle routines *)

  FUNCTION WinCopyRect(    ahab    : HAB;
                       VAR prclDst : { LONG } pRectL;
                           prclSrc : { LONG } pRectL) : BOOLEAN;
  FUNCTION Win16CopyRect(    ahab    : HAB;
                       VAR prclDst : { LONG } pRectL;
                           prclSrc : { LONG } pRectL) : BOOLEAN;

  FUNCTION WinSetRect(    ahab    : HAB;
                      VAR rcl     : { LONG } pRectL;
                          xLeft   : INTEGER;
                          yBottom : INTEGER;
                          xRight  : INTEGER;
                          yTop    : INTEGER) : BOOLEAN;
  FUNCTION Win16SetRect(    ahab    : HAB;
                      VAR rcl     : { LONG } pRectL;
                          xLeft   : INTEGER;
                          yBottom : INTEGER;
                          xRight  : INTEGER;
                          yTop    : INTEGER) : BOOLEAN;

  FUNCTION WinIsRectEmpty(ahab : HAB;
                          rcl  : { LONG } pRectL) : BOOLEAN;
  FUNCTION Win16IsRectEmpty(ahab : HAB;
                          rcl  : { LONG } pRectL) : BOOLEAN;

  FUNCTION WinEqualRect(ahab  : HAB;
                        prcl1 : { LONG } pRectL;
                        prcl2 : { LONG } pRectL) : BOOLEAN;
  FUNCTION Win16EqualRect(ahab  : HAB;
                        prcl1 : { LONG } pRectL;
                        prcl2 : { LONG } pRectL) : BOOLEAN;

  FUNCTION WinSetRectEmpty(    ahab : HAB;
                           VAR prcl : { LONG } pRectL) : BOOLEAN;
  FUNCTION Win16SetRectEmpty(    ahab : HAB;
                           VAR prcl : { LONG } pRectL) : BOOLEAN;

  FUNCTION WinOffsetRect(    ahab   : HAB;
                         VAR prcl   : { LONG } pRectL;
                             cx, cy : INTEGER) : BOOLEAN;
  FUNCTION Win16OffsetRect(    ahab   : HAB;
                         VAR prcl   : { LONG } pRectL;
                             cx, cy : INTEGER) : BOOLEAN;

  FUNCTION WinInflateRect(    ahab   : HAB;
                          VAR prcl   : { LONG } pRectL;
                              cx, cy : INTEGER) : BOOLEAN;
  FUNCTION Win16InflateRect(    ahab   : HAB;
                          VAR prcl   : { LONG } pRectL;
                              cx, cy : INTEGER) : BOOLEAN;

  FUNCTION WinPtInRect(ahab : HAB;
                       prcl : { LONG } pRectL;
                       pptl : { LONG } PointL) : BOOLEAN;
  FUNCTION Win16PtInRect(ahab : HAB;
                       prcl : { LONG } pRectL;
                       pptl : { LONG } PointL) : BOOLEAN;

  FUNCTION WinIntersectRect(    ahab     : HAB;
                            VAR prclDst  : { LONG } pRectL;
                                prclSrc1 : { LONG } pRectL;
                                prclSrc2 : { LONG } pRectL) : BOOLEAN;
  FUNCTION Win16IntersectRect(    ahab     : HAB;
                            VAR prclDst  : { LONG } pRectL;
                                prclSrc1 : { LONG } pRectL;
                                prclSrc2 : { LONG } pRectL) : BOOLEAN;

  FUNCTION WinUnionRect(    ahab     : HAB;
                        VAR prclDst  : { LONG } pRectL;
                            prclSrc1 : { LONG } pRectL;
                            prclSrc2 : { LONG } pRectL) : BOOLEAN;
  FUNCTION Win16UnionRect(    ahab     : HAB;
                        VAR prclDst  : { LONG } pRectL;
                            prclSrc1 : { LONG } pRectL;
                            prclSrc2 : { LONG } pRectL) : BOOLEAN;

  FUNCTION WinSubtractRect(    ahab     : HAB;
                           VAR prclDst  : { LONG } pRectL;
                               prclSrc1 : { LONG } pRectL;
                               prclSrc2 : { LONG } pRectL) : BOOLEAN;
  FUNCTION Win16SubtractRect(    ahab     : HAB;
                           VAR prclDst  : { LONG } pRectL;
                               prclSrc1 : { LONG } pRectL;
                               prclSrc2 : { LONG } pRectL) : BOOLEAN;

(*** System values *)

  FUNCTION WinQuerySysValue(hWndDesktop : hWnd;
                            iSysValue   : INTEGER) : LongInt;
  FUNCTION Win16QuerySysValue(hWndDesktop : hWnd;
                            iSysValue   : INTEGER) : LongInt;

  FUNCTION WinSetSysValue(hWndDesktop : hWnd;
                          iSysValue   : INTEGER;
                          lValue      : LongInt) : BOOLEAN;
  FUNCTION Win16SetSysValue(hWndDesktop : hWnd;
                          iSysValue   : INTEGER;
                          lValue      : LongInt) : BOOLEAN;

CONST
  SV_SWAPBUTTON =       0;
  SV_DBLCLKTIME =       1;
  SV_CXDBLCLK =         2;
  SV_CYDBLCLK =         3;
  SV_CXSIZEBORDER =     4;
  SV_CYSIZEBORDER =     5;
  SV_ALARM =            6;

  SV_RESERVEDFIRST1 =   7;
  SV_RESERVEDLAST1 =    8;

  SV_CURSORRATE =       9;
  SV_FIRSTSCROLLRATE =  10;
  SV_SCROLLRATE =       11;
  SV_NUMBEREDLISTS =    12;
  SV_WARNINGFREQ =      13;
  SV_NOTEFREQ =         14;
  SV_ERRORFREQ =        15;
  SV_WARNINGDURATION =  16;
  SV_NOTEDURATION =     17;
  SV_ERRORDURATION =    18;

  SV_RESERVEDFIRST =    19;
  SV_RESERVEDLAST =     19;

  SV_CXSCREEN =         20;
  SV_CYSCREEN =         21;
  SV_CXVSCROLL =        22;
  SV_CYHSCROLL =        23;
  SV_CYVSCROLLARROW =   24;
  SV_CXHSCROLLARROW =   25;
  SV_CXBORDER =         26;
  SV_CYBORDER =         27;
  SV_CXDLGFRAME =       28;
  SV_CYDLGFRAME =       29;
  SV_CYTITLEBAR =       30;
  SV_CYVSLIDER =        31;
  SV_CXHSLIDER =        32;
  SV_CXMINMAXBUTTON =   33;
  SV_CYMINMAXBUTTON =   34;
  SV_CYMENU =           35;
  SV_CXFULLSCREEN =     36;
  SV_CYFULLSCREEN =     37;
  SV_CXICON =           38;
  SV_CYICON =           39;
  SV_CXPOINTER =        40;
  SV_CYPOINTER =        41;

  SV_DEBUG =            42;
  SV_CMOUSEBUTTONS =    43;
  SV_POINTERLEVEL =     44;
  SV_CURSORLEVEL =      45;
  SV_TRACKRECTLEVEL =   46;

  SV_CTIMERS =          47;
  SV_MOUSEPRESENT =     48;
  SV_CXBYTEALIGN =      49;
  SV_CYBYTEALIGN =      50;

    SV_NOTRESERVED  = 56;
    SV_EXTRAKEYBEEP  = 57;

    SV_SETLIGHTS  = 58;
    SV_INSERTMODE  = 59;

    SV_MENUROLLDOWNDELAY  = 64;
    SV_MENUROLLUPDELAY    = 65;
    SV_ALTMNEMONIC    = 66;
    SV_TASKLISTMOUSEACCESS  = 67;
    SV_CSYSVALUESS    = 68;

    SV_CPOINTERBUTTONS    = 69;
    SV_CXALIGN      = 70;
    SV_CYALIGN      = 71;
    SV_MNEMONICSENABLED    = 72;

TYPE
  Param = RECORD
    id  : LongInt;
    cb  : LongInt;
    ab  : ARRAY [0..0] OF CHAR;
  END;

  PResParams = RECORD
    cb      : LongInt;
    aParam  : ARRAY [0..0] OF Param;
  END;

  FUNCTION WinSetPresParam(    a : hWnd;
                               b : LongInt;
                           VAR c : LongInt;
                               d : pVoid) : BOOLEAN;
  FUNCTION Win16SetPresParam(    a : hWnd;
                               b : LongInt;
                           VAR c : LongInt;
                               d : pVoid) : BOOLEAN;

  FUNCTION WinQueryPresParam(    a : hWnd;
                                 b : LongInt;
                                 c : LongInt;
                             VAR d : LongInt;
                                 e : LongInt;
                                 f : pVoid;
                                 g : WORD) : LongInt;
  FUNCTION Win16QueryPresParam(    a : hWnd;
                                 b : LongInt;
                                 c : LongInt;
                             VAR d : LongInt;
                                 e : LongInt;
                                 f : pVoid;
                                 g : WORD) : LongInt;

  FUNCTION WinRemovePresParam(a : hWnd; b : LongInt) : BOOLEAN;
  FUNCTION Win16RemovePresParam(a : hWnd; b : LongInt) : BOOLEAN;

CONST
  PP_FOREGROUNDCOLOR             =   1;
  PP_FOREGROUNDCOLORINDEX        =   2;
  PP_BACKGROUNDCOLOR             =   3;
  PP_BACKGROUNDCOLORINDEX        =   4;
  PP_HILITEFOREGROUNDCOLOR       =   5;
  PP_HILITEFOREGROUNDCOLORINDEX  =   6;
  PP_HILITEBACKGROUNDCOLOR       =   7;
  PP_HILITEBACKGROUNDCOLORINDEX  =   8;
  PP_DISABLEFOREGROUNDCOLOR      =   9;
  PP_DISABLEFOREGROUNDCOLORINDEX = $10;
  PP_DISABLEBACKGROUNDCOLOR      = $11;
  PP_DISABLEBACKGROUNDCOLORINDEX = $12;
  PP_BORDERCOLOR                 = $13;
  PP_BORDERCOLORINDEX            = $14;
  PP_FONTNAMESIZE                = $15;
  PP_FONTHANDLE                  = $16;

  QPF_NOINHERIT                  =   1;
  QPF_ID1COLORINDEX              =   2;
  QPF_ID2COLORINDEX              =   4;
  QPF_PURERGBCOLOR               =   8;
  QPF_VALIDFLAGS                 = $0F;

(*** System color functions *)

  FUNCTION WinQuerySysColor(hWndDesktop : hWnd;
                            clr         : Color;
                            lReserved   : LongInt) : Color;
  FUNCTION Win16QuerySysColor(hWndDesktop : hWnd;
                            clr         : Color;
                            lReserved   : LongInt) : Color;

  FUNCTION WinSetSysColors(hWndDesktop : hWnd;
                           flOptions   : LongInt;
                           flFormat    : LongInt;
                           clrFirst    : Color;
                           cclr        : LongInt;
                           pclr        : pColor) : BOOLEAN;
  FUNCTION Win16SetSysColors(hWndDesktop : hWnd;
                           flOptions   : LongInt;
                           flFormat    : LongInt;
                           clrFirst    : Color;
                           cclr        : LongInt;
                           pclr        : pColor) : BOOLEAN;

CONST
  SYSCLR_BUTTONLIGHT           = -41;
  SYSCLR_BUTTONMIDDLE          = -40;
  SYSCLR_BUTTONDARK            = -39;
  SYSCLR_BUTTONDEFAULT         = -38;
  SYSCLR_TITLEBOTTOM           = -37;
  SYSCLR_SHADOW                = -36;
  SYSCLR_ICONTEXT              = -35;
  SYSCLR_DIALOGBACKGROUND      = -34;
  SYSCLR_HILITEFOREGROUND      = -33;
  SYSCLR_HILITEBACKGROUND      = -32;
  SYSCLR_INACTIVETITLETEXTBGND = -31;
  SYSCLR_ACTIVETITLETEXTBGND   = -30;
  SYSCLR_INACTIVETITLETEXT     = -29;
  SYSCLR_ACTIVETITLETEXT       = -28;
  SYSCLR_OUTPUTTEXT            = -27;
  SYSCLR_WINDOWSTATICTEXT      = -26;
  SYSCLR_SCROLLBAR             = -25;
  SYSCLR_BACKGROUND            = -24;
  SYSCLR_ACTIVETITLE           = -23;
  SYSCLR_INACTIVETITLE    = -22;
  SYSCLR_MENU      = -21;
  SYSCLR_WINDOW      = -20;
  SYSCLR_WINDOWFRAME    = -19;
  SYSCLR_MENUTEXT     = -18;
  SYSCLR_WINDOWTEXT    = -17;
  SYSCLR_TITLETEXT    = -16;
  SYSCLR_ACTIVEBORDER    = -15;
  SYSCLR_INACTIVEBORDER    = -14;
  SYSCLR_APPWORKSPACE    = -13;
  SYSCLR_HELPBACKGROUND    = -12;
  SYSCLR_HELPTEXT     = -11;
  SYSCLR_HELPHILITE    = -10;

  SYSCLR_CSYSCOLORS    = $32;


(**** Timer manager *)

  FUNCTION WinStartTimer(ahab     : HAB;
                         aHwnd    : hWnd;
                         idTimer  : WORD;
                         lTimeout : WORD) : WORD;
  FUNCTION Win16StartTimer(ahab     : HAB;
                         aHwnd    : hWnd;
                         idTimer  : WORD;
                         lTimeout : WORD) : WORD;

  FUNCTION WinStopTimer(ahab : HAB; aHwnd : hWnd; idTimer : WORD) : BOOLEAN;
  FUNCTION Win16StopTimer(ahab : HAB; aHwnd : hWnd; idTimer : WORD) : BOOLEAN;

  FUNCTION WinGetCurrentTime(ahab : HAB) : LongInt;
  FUNCTION Win16GetCurrentTime(ahab : HAB) : LongInt;

CONST
  TID_CURSOR       = $0FFFF;  (* Reserved cursor timer ID *)
  TID_SCROLL       = $0FFFE;  (* Reserved scrolling timer ID *)
  TID_FLASHWINDOW  = $0FFFD;  (* Reserved for window flashing timer ID *)
  TID_USERMAX      = $7FFF;

(**** Accelerator functions *)

(* ACCEL fs bits
 *
 * NOTE: the first six AF_ code bits have the same value
 * as their KC_ counterparts
 *)
  AF_CHAR =         $00001;
  AF_VIRTUALKEY =   $00002;
  AF_SCANCODE =     $00004;
  AF_SHIFT =        $00008;
  AF_CONTROL =      $00010;
  AF_ALT =          $00020;
  AF_LONEKEY =      $00040;
  AF_SYSCOMMAND =   $00100;
  AF_HELP =         $00200;

TYPE
  hAccel = LHandle;  (* haccel *)

  Accel = RECORD        (* acc *)
    cmd : WORD;
    fs  : WORD;
    Key : WORD;
  END;
  pAccel = ^Accel;

  AccelTable = RECORD   (* acct  *)
    cAccel   : WORD;
    codepage : WORD;
    aAccel   : Accel;
  END;
  pAccelTable = ^AccelTable;

  FUNCTION WinLoadAccelTable(ahab         : HAB;
                             hMod         : hModule;
                             idAccelTable : WORD) : hAccel;
  FUNCTION Win16LoadAccelTable(ahab         : HAB;
                             hMod         : hModule;
                             idAccelTable : WORD) : hAccel;

  FUNCTION WinCreateAccelTable(    ahab  : HAB;
                               VAR pAcct : { LONG } AccelTable) : hAccel;
  FUNCTION Win16CreateAccelTable(    ahab  : HAB;
                               VAR pAcct : { LONG } AccelTable) : hAccel;

  FUNCTION WinDestroyAccelTable(ahAccel : hAccel) : BOOLEAN;
  FUNCTION Win16DestroyAccelTable(ahAccel : hAccel) : BOOLEAN;

  FUNCTION WinCopyAccelTable(    ahAccel   : hAccel;
                             VAR pAcct     : { LONG } AccelTable;
                                 cbCopyMax : WORD) : WORD;
  FUNCTION Win16CopyAccelTable(    ahAccel   : hAccel;
                             VAR pAcct     : { LONG } AccelTable;
                                 cbCopyMax : WORD) : WORD;

  FUNCTION WinTranslateAccel(    ahab    : HAB;
                                 aHwnd   : hWnd;
                                 ahAccel : hAccel;
                             VAR pQMsg   : { LONG } QMsg) : BOOLEAN;
  FUNCTION Win16TranslateAccel(    ahab    : HAB;
                                 aHwnd   : hWnd;
                                 ahAccel : hAccel;
                             VAR pQMsg   : { LONG } QMsg) : BOOLEAN;

  FUNCTION WinSetAccelTable(ahab      : HAB;
                            ahAccel   : hAccel;
                            hWndFrame : hWnd) : BOOLEAN;
  FUNCTION Win16SetAccelTable(ahab      : HAB;
                            ahAccel   : hAccel;
                            hWndFrame : hWnd) : BOOLEAN;

  FUNCTION WinQueryAccelTable(ahab      : HAB;
                              hWndFrame : hWnd) : hAccel;
  FUNCTION Win16QueryAccelTable(ahab      : HAB;
                              hWndFrame : hWnd) : hAccel;

CONST
  EAF_DEFAULTOWNER  = 1;
  EAF_UNCHANGEABLE  = 2;
  EAF_REUSEICON     = 4;

(*** WinTrackRect() stuff *)
(* WinTrackRect() tracking information structure *)

TYPE
  TrackInfo = RECORD    (* ti *)
    cxBorder        : INTEGER;
    cyBorder        : INTEGER;
    cxGrid          : INTEGER;
    cyGrid          : INTEGER;
    cxKeyboard      : INTEGER;
    cyKeyboard      : INTEGER;
    rclTrack        : RectL;
    rclBoundary     : RectL;
    ptlMinTrackSize : PointL;
    ptlMaxTrackSize : PointL;
    fs              : WORD;
    cxLeft          : WORD;
    cyBottom        : WORD;
    cxRight         : WORD;
    cyTop           : WORD;
  END;
  pTrackInfo = ^TrackInfo;

  FUNCTION WinTrackRect(    aHwnd : hWnd;
                            ahps  : hPs;
                        VAR pti   : { LONG } TrackInfo) : BOOLEAN;
  FUNCTION Win16TrackRect(    aHwnd : hWnd;
                            ahps  : hPs;
                        VAR pti   : { LONG } TrackInfo) : BOOLEAN;

  FUNCTION WinShowTrackRect(aHwnd : hWnd; fShow : BOOLEAN) : BOOLEAN;
  FUNCTION Win16ShowTrackRect(aHwnd : hWnd; fShow : BOOLEAN) : BOOLEAN;

(* WinTrackRect() flags *)
CONST
  TF_LEFT =              $00001;
  TF_TOP =               $00002;
  TF_RIGHT =             $00004;
  TF_BOTTOM =            $00008;
(* TF_MOVE = TF_LEFT | TF_TOP | TF_RIGHT | TF_BOTTOM *)
  TF_MOVE =              $0000F;

  TF_SETPOINTERPOS =     $00010;
  TF_GRID =              $00020;
  TF_STANDARD =          $00040;
  TF_ALLINBOUNDARY =     $00080;
  TF_VALIDATETRACKRECT = $00100;
  TF_PARTINBOUNDARY =    $00200;

(* Special rectangle relative flags *)
  TF_FIXLEFT =           $00400;
  TF_FIXTOP =            $00800;
  TF_FIXRIGHT =          $01000;
  TF_FIXBOTTOM =         $02000;

(**** Clipboard Manager *)

(* Clipboard messages *)

  WM_RENDERFMT =        $00060;
  WM_RENDERALLFMTS =    $00061;
  WM_DESTROYCLIPBOARD = $00062;
  WM_PAINTCLIPBOARD =   $00063;
  WM_SIZECLIPBOARD =    $00064;
  WM_HSCROLLCLIPBOARD = $00065;
  WM_VSCROLLCLIPBOARD = $00066;
  WM_DRAWCLIPBOARD =    $00067;

(* Standard Clipboard formats *)

  CF_TEXT =             1;
  CF_BITMAP =           2;
  CF_DSPTEXT =          3;
  CF_DSPBITMAP =        4;
  CF_METAFILE =         5;
  CF_DSPMETAFILE =      6;

  FUNCTION WinSetClipbrdOwner(ahab  : HAB;
                              aHwnd : hWnd) : BOOLEAN;
  FUNCTION Win16SetClipbrdOwner(ahab  : HAB;
                              aHwnd : hWnd) : BOOLEAN;

  FUNCTION WinSetClipbrdData(ahab      : HAB;
                             ulData    : LongInt;
                             fmt       : WORD;
                             fsFmtInfo : WORD) : BOOLEAN;
  FUNCTION Win16SetClipbrdData(ahab      : HAB;
                             ulData    : LongInt;
                             fmt       : WORD;
                             fsFmtInfo : WORD) : BOOLEAN;

  FUNCTION WinQueryClipbrdData(ahab : HAB;
                               fmt  : WORD) : LongInt;
  FUNCTION Win16QueryClipbrdData(ahab : HAB;
                               fmt  : WORD) : LongInt;

  FUNCTION WinQueryClipbrdFmtInfo(    ahab       : HAB;
                                      fmt        : WORD;
                                  VAR pfsFmtInfo : WORD) : BOOLEAN;
  FUNCTION Win16QueryClipbrdFmtInfo(    ahab       : HAB;
                                      fmt        : WORD;
                                  VAR pfsFmtInfo : WORD) : BOOLEAN;

  FUNCTION WinSetClipbrdViewer(ahab : HAB; aHwnd : hWnd) : BOOLEAN;
  FUNCTION Win16SetClipbrdViewer(ahab : HAB; aHwnd : hWnd) : BOOLEAN;

(* WinSetClipbrdData() flags *)
CONST
  CFI_OWNERFREE =       $00001;
  CFI_OWNERDISPLAY =    $00002;
  CFI_SELECTOR =        $00100;
  CFI_HANDLE =          $00200;

  FUNCTION WinEnumClipbrdFmts(ahab : HAB; fmt : WORD) : WORD;
  FUNCTION Win16EnumClipbrdFmts(ahab : HAB; fmt : WORD) : WORD;

  FUNCTION WinEmptyClipbrd(ahab : HAB) : BOOLEAN;
  FUNCTION Win16EmptyClipbrd(ahab : HAB) : BOOLEAN;

  FUNCTION WinOpenClipbrd(ahab : HAB) : BOOLEAN;
  FUNCTION Win16OpenClipbrd(ahab : HAB) : BOOLEAN;

  FUNCTION WinCloseClipbrd(ahab : HAB) : BOOLEAN;
  FUNCTION Win16CloseClipbrd(ahab : HAB) : BOOLEAN;

  FUNCTION WinQueryClipbrdOwner(ahab : HAB; fLock : BOOLEAN) : hWnd;
  FUNCTION Win16QueryClipbrdOwner(ahab : HAB; fLock : BOOLEAN) : hWnd;

  FUNCTION WinQueryClipbrdViewer(ahab : HAB; fLock : BOOLEAN) : hWnd;
  FUNCTION Win16QueryClipbrdViewer(ahab : HAB; fLock : BOOLEAN) : hWnd;

(**** Cursor manager common subsection *)

  FUNCTION WinDestroyCursor(aHwnd : hWnd) : BOOLEAN;
  FUNCTION Win16DestroyCursor(aHwnd : hWnd) : BOOLEAN;

  FUNCTION WinShowCursor(aHwnd : hWnd; fShow : BOOLEAN) : BOOLEAN;
  FUNCTION Win16ShowCursor(aHwnd : hWnd; fShow : BOOLEAN) : BOOLEAN;

  FUNCTION WinCreateCursor(aHwnd    : hWnd;
                           x, y     : INTEGER;
                           cx, cy   : INTEGER;
                           fs       : WORD;
                           prclClip : { LONG } pRectL) : BOOLEAN;
  FUNCTION Win16CreateCursor(aHwnd    : hWnd;
                           x, y     : INTEGER;
                           cx, cy   : INTEGER;
                           fs       : WORD;
                           prclClip : { LONG } pRectL) : BOOLEAN;

(* WinCreateCursor() flags *)
CONST
  CURSOR_SOLID =     $00000;
  CURSOR_HALFTONE =  $00001;
  CURSOR_FRAME =     $00002;
  CURSOR_FLASH =     $00004;
  CURSOR_SETPOS =    $08000;

TYPE
  CursorInfo = RECORD    (* csri *)
    aHwnd   :  hWnd;
    x       : INTEGER;
    y       : INTEGER;
    cx      : INTEGER;
    cy      : INTEGER;
    fs      : WORD;
    rclClip : RectL;
  END;
  pCursorInfo = ^CursorInfo;

  FUNCTION WinQueryCursorInfo(    hWndDesktop : hWnd;
                              VAR pcsri       : { LONG } CursorInfo) : BOOLEAN;
  FUNCTION Win16QueryCursorInfo(    hWndDesktop : hWnd;
                              VAR pcsri       : { LONG } CursorInfo) : BOOLEAN;

(**** Pointer manager *)
TYPE
  hPointer = LHandle;

  FUNCTION WinSetPointer(hWndDesktop : hWnd; hptrNew : hPointer) : BOOLEAN;
  FUNCTION Win16SetPointer(hWndDesktop : hWnd; hptrNew : hPointer) : BOOLEAN;

  FUNCTION WinShowPointer(hWndDesktop : hWnd; fShow : BOOLEAN) : BOOLEAN;
  FUNCTION Win16ShowPointer(hWndDesktop : hWnd; fShow : BOOLEAN) : BOOLEAN;

  FUNCTION WinQuerySysPointer(hWndDesktop : hWnd;
                              iptr        : INTEGER;
                              fLoad       : BOOLEAN) : hPointer;
  FUNCTION Win16QuerySysPointer(hWndDesktop : hWnd;
                              iptr        : INTEGER;
                              fLoad       : BOOLEAN) : hPointer;

(* System pointers (NOTE: these are 1-based) *)
CONST
  SPTR_ARROW =            1;
  SPTR_TEXT =             2;
  SPTR_WAIT =             3;
  SPTR_MOVE =             4;
  SPTR_SIZENWSE =         5;
  SPTR_SIZENESW =         6;
  SPTR_SIZEWE =           7;
  SPTR_SIZENS =           8;
  SPTR_APPICON =          9;
  SPTR_ICONINFORMATION =  10;
  SPTR_ICONQUESTION =     11;
  SPTR_ICONERROR =        12;
  SPTR_ICONWARNING =      13;
  SPTR_CPTR =             13;    (* count loaded by pmwin *)

  SPTR_ILLEGAL =          14;
  SPTR_FILE =             15;
  SPTR_FOLDER =           16;
  SPTR_MULTFILE =         17;
  SPTR_PROGRAM =          18;

  FUNCTION WinLoadPointer(hWndDesktop : hWnd;
                          hMod        : hModule;
                          idPtr       : WORD) : hPointer;
  FUNCTION Win16LoadPointer(hWndDesktop : hWnd;
                          hMod        : hModule;
                          idPtr       : WORD) : hPointer;

  FUNCTION WinDestroyPointer(hptr : hPointer) : BOOLEAN;
  FUNCTION Win16DestroyPointer(hptr : hPointer) : BOOLEAN;

  FUNCTION WinCreatePointer(hWndDesktop : hWnd;
                            hbmPointer  : hBitmap;
                            fPointer    : BOOLEAN;
                            xHotspot    : INTEGER;
                            yHotspot    : INTEGER) : hPointer;
  FUNCTION Win16CreatePointer(hWndDesktop : hWnd;
                            hbmPointer  : hBitmap;
                            fPointer    : BOOLEAN;
                            xHotspot    : INTEGER;
                            yHotspot    : INTEGER) : hPointer;

  FUNCTION WinQueryPointer(hWndDesktop : hWnd) : hPointer;
  FUNCTION Win16QueryPointer(hWndDesktop : hWnd) : hPointer;

  FUNCTION WinSetPointerPos(hWndDesktop : hWnd;
                            x, y        : INTEGER) : BOOLEAN;
  FUNCTION Win16SetPointerPos(hWndDesktop : hWnd;
                            x, y        : INTEGER) : BOOLEAN;

  FUNCTION WinQueryPointerPos(    hWndDesktop : hWnd;
                              VAR pptl        : { LONG } PointL) : BOOLEAN;
  FUNCTION Win16QueryPointerPos(    hWndDesktop : hWnd;
                              VAR pptl        : { LONG } PointL) : BOOLEAN;

TYPE
  PointerInfo = RECORD   (* ptri *)
    fPointer   : BOOLEAN;
    xHotspot   : INTEGER;
    yHotspot   : INTEGER;
    hbmPointer : hBitmap;
  END;
  pPointerInfo = ^PointerInfo;

  FUNCTION WinCreatePointerIndirect(a : hWnd; b : PointerInfo) : hPointer;
  FUNCTION Win16CreatePointerIndirect(a : hWnd; b : PointerInfo) : hPointer;

  FUNCTION WinQueryPointerInfo(    hptr  : hPointer;
                               VAR pptri : { LONG } PointerInfo) : BOOLEAN;
  FUNCTION Win16QueryPointerInfo(    hptr  : hPointer;
                               VAR pptri : { LONG } PointerInfo) : BOOLEAN;

  FUNCTION WinDrawPointer(ahps : hPs;
                          x, y : INTEGER;
                          hptr : hPointer;
                          fs: WORD) : BOOLEAN;
  FUNCTION Win16DrawPointer(ahps : hPs;
                          x, y : INTEGER;
                          hptr : hPointer;
                          fs: WORD) : BOOLEAN;

(* WinDrawPointer()  constants *)
CONST
  DP_NORMAL =      $00000;
  DP_HALFTONED =   $00001;
  DP_INVERTED =    $00002;

  FUNCTION WinGetSysBitmap(hWndDesktop : hWnd; ibm : WORD) : hBitmap;
  FUNCTION Win16GetSysBitmap(hWndDesktop : hWnd; ibm : WORD) : hBitmap;

(* System bitmaps (NOTE: these are 1-based) *)
CONST
  SBMP_SYSMENU =          1;
  SBMP_SBUPARROW =        2;
  SBMP_SBDNARROW =        3;
  SBMP_SBRGARROW =        4;
  SBMP_SBLFARROW =        5;
  SBMP_MENUCHECK =        6;
  SBMP_CHECKBOXES =       7;
  SBMP_BTNCORNERS =       8;
  SBMP_MINBUTTON =        9;
  SBMP_MAXBUTTON =        10;
  SBMP_RESTOREBUTTON =    11;
  SBMP_CHILDSYSMENU =     12;
  SBMP_DRIVE =            15;
  SBMP_FILE =             16;
  SBMP_FOLDER =           17;
  SBMP_TREEPLUS =         18;
  SBMP_TREEMINUS =        19;
  SBMP_PROGRAM =          22;
  SBMP_MENUATTACHED =     23;
  SBMP_SIZEBOX =          24;

(*
    SBMP_SYSMENU    = 25;
    SBMP_MINBUTTON    = 26;
    SBMP_MAXBUTTON    = 27;
    SBMP_RESTOREBUTTON  = 28;
    SBMP_CHILDSYSMENU  = 29;
*)
    SBMP_SYSMENUDEP   = 30;
    SBMP_MINBUTTONDEP  = 31;
    SBMP_MAXBUTTONDEP  = 32;
    SBMP_RESTOREBUTTONDEP  = 33;
    SBMP_CHILDSYSMENUDEP  = 34;
(*
    SBMP_SBUPARROW    = 35;
    SBMP_SBDNARROW    = 36;
    SBMP_SBLFARROW    = 37;
    SBMP_SBRGARROW    = 38;
*)
    SBMP_SBUPARROWDEP  = 39;
    SBMP_SBDNARROWDEP  = 40;
    SBMP_SBLFARROWDEP  = 41;
    SBMP_SBRGARROWDEP  = 42;
    SBMP_SBUPARROWDIS  = 43;
    SBMP_SBDNARROWDIS  = 44;
    SBMP_SBLFARROWDIS  = 45;
    SBMP_SBRGARROWDIS  = 46;
    SBMP_COMBODOWN  = 47;


(**** Hook manager *)

  FUNCTION WinSetHook(ahab    : HAB;
                      aHmq    : hMQ;
                      iHook   : INTEGER;
                      pfnHook : pFN;
                      hMod    : hModule) : BOOLEAN;
  FUNCTION Win16SetHook(ahab    : HAB;
                      aHmq    : hMQ;
                      iHook   : INTEGER;
                      pfnHook : pFN;
                      hMod    : hModule) : BOOLEAN;

  FUNCTION WinReleaseHook(ahab    : HAB;
                          aHmq    : hMQ;
                          iHook   : INTEGER;
                          pfnHook : pFN;
                          hMod    : hModule) : BOOLEAN;
  FUNCTION Win16ReleaseHook(ahab    : HAB;
                          aHmq    : hMQ;
                          iHook   : INTEGER;
                          pfnHook : pFN;
                          hMod    : hModule) : BOOLEAN;

  FUNCTION WinCallMsgFilter(    ahab  : HAB;
                            VAR pQMsg : { LONG } QMsg;
                                MsgF  : WORD) : BOOLEAN;
  FUNCTION Win16CallMsgFilter(    ahab  : HAB;
                            VAR pQMsg : { LONG } QMsg;
                                MsgF  : WORD) : BOOLEAN;

(* Hook codes *)
CONST
  HK_SENDMSG =          0;
  HK_INPUT =            1;
  HK_MSGFILTER =        2;
  HK_JOURNALRECORD =    3;
  HK_JOURNALPLAYBACK =  4;
  HK_HELP =             5;
    HK_LOADER  = 6;
    HK_REGISTERUSERMSG  = 7;
    HK_MSGCONTROLL  = 8;
    HK_PLIST_ENTRY  = 9;
    HK_PLIST_EXIT  = 10;
    HK_FINDWORD    = 11;
    HK_CODEPAGECHANGED  = 12;

  HMQ_CURRENT =         1;

(* WH_MSGFILTER context codes *)

  MSGF_DIALOGBOX =      1;
  MSGF_MESSAGEBOX =     2;
  MSGF_TRACK =          8;

(* HK_HELP Help modes *)

  HLPM_FRAME =          (-1);
  HLPM_WINDOW =         (-2);
  HLPM_MENU =           (-3);

(* HK_SENDMSG structure *)

TYPE
  SMHStruct = RECORD    (* smhs *)
    Mp2  : mParam;
    Mp1  : mParam;
    Msg  : WORD;
    hWnd :   hWnd;
  END;
  pSMHStruct = ^SMHStruct;

CONST
  LHK_DELETEPROC  = 1;
  LHK_DELETELIB  = 2;
  LHK_LOADPROC  = 3;
  LHK_LOADLIB    = 4;

  MCHK_MSGINTEREST  = 1;
  MCHK_CLASSMSGINTEREST  = 2;
  MCHK_SYNCHRONISATION  = 3;
  MCHK_MSGMODE    = 4;

  RUMHK_DATATYPE  = 1;
  RUMHK_MSGMODE  = 2;

  FUNCTION WinQueryCp(aHmq : hMQ) : WORD;
  FUNCTION Win16QueryCp(aHmq : hMQ) : WORD;

  FUNCTION WinSetCp(aHmq : hMQ; idcp : WORD) : BOOLEAN;
  FUNCTION Win16SetCp(aHmq : hMQ; idcp : WORD) : BOOLEAN;

  FUNCTION WinQueryCpList(    ahab   : HAB;
                              ccpMax : WORD;
                          VAR pacp   : WORD) : WORD;
  FUNCTION Win16QueryCpList(    ahab   : HAB;
                              ccpMax : WORD;
                          VAR pacp   : WORD) : WORD;

  FUNCTION WinCpTranslateString(ahab       : HAB;
                                cpSrc      : WORD;
                                pszSrc     : pChar;
                                cpDst      : WORD;
                                cchDestMax : WORD;
                                pszDest    : pChar) : BOOLEAN;
  FUNCTION Win16CpTranslateString(ahab       : HAB;
                                cpSrc      : WORD;
                                pszSrc     : pChar;
                                cpDst      : WORD;
                                cchDestMax : WORD;
                                pszDest    : pChar) : BOOLEAN;

  FUNCTION WinCpTranslateChar(ahab  : HAB;
                              cpSrc : WORD;
                              chSrc : BYTE;
                              cpDst : WORD) : BYTE;
  FUNCTION Win16CpTranslateChar(ahab  : HAB;
                              cpSrc : WORD;
                              chSrc : BYTE;
                              cpDst : WORD) : BYTE;

  FUNCTION WinUpper(ahab : HAB;
                    idcp : WORD;
                    idcc : WORD;
                    pChar  : pChar) : WORD;
  FUNCTION Win16Upper(ahab : HAB;
                    idcp : WORD;
                    idcc : WORD;
                    pChar  : pChar) : WORD;

  FUNCTION WinUpperChar(ahab : HAB;
                        idcp : WORD;
                        idcc : WORD;
                        c    : WORD) : WORD;
  FUNCTION Win16UpperChar(ahab : HAB;
                        idcp : WORD;
                        idcc : WORD;
                        c    : WORD) : WORD;

  FUNCTION WinNextChar(ahab : HAB;
                       idcp : WORD;
                       idcc : WORD;
                       pChar  : pChar) : pChar;
  FUNCTION Win16NextChar(ahab : HAB;
                       idcp : WORD;
                       idcc : WORD;
                       pChar  : pChar) : pChar;

  FUNCTION WinPrevChar(ahab     : HAB;
                       idcp     : WORD;
                       idcc     : WORD;
                       pszStart : pChar;
                       pChar      : pChar) : pChar;
  FUNCTION Win16PrevChar(ahab     : HAB;
                       idcp     : WORD;
                       idcc     : WORD;
                       pszStart : pChar;
                       pChar      : pChar) : pChar;

  FUNCTION WinCompareStrings(ahab     : HAB;
                             idcp     : WORD;
                             idcc     : WORD;
                             psz1     : pChar;
                             psz2     : pChar;
                             Reserved : WORD):  WORD;
  FUNCTION Win16CompareStrings(ahab     : HAB;
                             idcp     : WORD;
                             idcc     : WORD;
                             psz1     : pChar;
                             psz2     : pChar;
                             Reserved : WORD):  WORD;

CONST
  WCS_ERROR = 0;
  WCS_EQ =    1;
  WCS_LT =    2;
  WCS_GT =    3;

(* Heap Manager Interface declarations *)
TYPE
  hHeap = LHandle;

(* structure for moveable heap *)

TYPE
  MovBlockHdr = RECORD     (* mbhdr *)
    ppmem : ^nPByte;
    cb    :  WORD;
  END;
  pMovBlockHdr = ^MovBlockHdr;

(* macro for creating a back pointer *)
(*
#define SETMEMBACKPTR(npb) (((PMOVBLOCKHDR) npb)-1)->ppmem = &npb
*)

  FUNCTION WinCreateHeap(selHeapBase : WORD;
                         cbHeap      : WORD;
                         cbGrow      : WORD;
                         chMinDed    : WORD;
                         cbMaxDed    : WORD;
                         fsOptions   : WORD) : hHeap;
  FUNCTION Win16CreateHeap(selHeapBase : WORD;
                         cbHeap      : WORD;
                         cbGrow      : WORD;
                         chMinDed    : WORD;
                         cbMaxDed    : WORD;
                         fsOptions   : WORD) : hHeap;

  FUNCTION WinDestroyHeap(hHeap : hHeap) : hHeap;
  FUNCTION Win16DestroyHeap(hHeap : hHeap) : hHeap;

  FUNCTION WinAvailMem(ahHeap    : hHeap;
                       fCompact  : BOOLEAN;
                       cbMinFree : WORD) : WORD;
  FUNCTION Win16AvailMem(ahHeap    : hHeap;
                       fCompact  : BOOLEAN;
                       cbMinFree : WORD) : WORD;

  FUNCTION WinAllocMem(hHeap : hHeap; cb : WORD) : nPByte;
  FUNCTION Win16AllocMem(hHeap : hHeap; cb : WORD) : nPByte;

  FUNCTION WinReallocMem(hHeap : hHeap;
                         npMem : nPByte;
                         cbOld : WORD;
                         cbNew : WORD) : nPByte;
  FUNCTION Win16ReallocMem(hHeap : hHeap;
                         npMem : nPByte;
                         cbOld : WORD;
                         cbNew : WORD) : nPByte;

  FUNCTION WinFreeMem(ahHeap : hHeap;
                      npMem  : nPByte;
                      cbMem  : WORD) : nPByte;
  FUNCTION Win16FreeMem(ahHeap : hHeap;
                      npMem  : nPByte;
                      cbMem  : WORD) : nPByte;

  FUNCTION WinLockHeap(ahHeap : hHeap) : pVoid;
  FUNCTION Win16LockHeap(ahHeap : hHeap) : pVoid;

CONST
  HM_MOVEABLE =     $00001;      (* Parameters to WinCreateHeap *)
  HM_VALIDSIZE =    $00002;

(*** Atom Manager Interface declarations *)
TYPE
   hAtomTbl = LHandle;
   Atom     = WORD;

  FUNCTION WinQuerySystemAtomTable : hAtomTbl;
  FUNCTION Win16QuerySystemAtomTable : hAtomTbl;

  FUNCTION WinCreateAtomTable(cbInitial : WORD;
                              cBuckets  : WORD) : hAtomTbl;
  FUNCTION Win16CreateAtomTable(cbInitial : WORD;
                              cBuckets  : WORD) : hAtomTbl;

  FUNCTION WinDestroyAtomTable(hAtomTbl : hAtomTbl) : hAtomTbl;
  FUNCTION Win16DestroyAtomTable(hAtomTbl : hAtomTbl) : hAtomTbl;

  FUNCTION WinAddAtom(hAtomTbl    : hAtomTbl;
                      pszAtomName : pChar) : Atom;
  FUNCTION Win16AddAtom(hAtomTbl    : hAtomTbl;
                      pszAtomName : pChar) : Atom;

  FUNCTION WinFindAtom(hAtomTbl : hAtomTbl; pszAtomName : pChar) : Atom;
  FUNCTION Win16FindAtom(hAtomTbl : hAtomTbl; pszAtomName : pChar) : Atom;

  FUNCTION WinDeleteAtom(hAtomTbl : hAtomTbl; Atom : Atom) : Atom;
  FUNCTION Win16DeleteAtom(hAtomTbl : hAtomTbl; Atom : Atom) : Atom;

  FUNCTION WinQueryAtomUsage(hAtomTbl : hAtomTbl; Atom : Atom) : WORD;
  FUNCTION Win16QueryAtomUsage(hAtomTbl : hAtomTbl; Atom : Atom) : WORD;

  FUNCTION WinQueryAtomLength(hAtomTbl : hAtomTbl; Atom : Atom) : WORD;
  FUNCTION Win16QueryAtomLength(hAtomTbl : hAtomTbl; Atom : Atom) : WORD;

  FUNCTION WinQueryAtomName(ahAtomTbl    : hAtomTbl;
                            anAtom       : Atom;
                            pszBuffer    : pChar;
                            cchBufferMax : WORD) : WORD;
  FUNCTION Win16QueryAtomName(ahAtomTbl    : hAtomTbl;
                            anAtom       : Atom;
                            pszBuffer    : pChar;
                            cchBufferMax : WORD) : WORD;

(***
#define MAKEINTATOM(a)  ((PCH)MAKELongInt(a, 0xffff))
***)

(*** Catch/Throw Interface declarations *)
TYPE
  CatchBuf = RECORD   (* ctchbf *)
    Reserved : ARRAY [0..3] OF LongInt;
  END;
  pCatchBuf = ^CatchBuf;

  FUNCTION WinCatch(VAR pctchbf : { LONG } CatchBuf) : INTEGER;
  FUNCTION Win16Catch(VAR pctchbf : { LONG } CatchBuf) : INTEGER;

  FUNCTION WinThrow(VAR pctchbf      : { LONG } CatchBuf;
                        sErrorReturn : INTEGER) : INTEGER;
  FUNCTION Win16Throw(VAR pctchbf      : { LONG } CatchBuf;
                        sErrorReturn : INTEGER) : INTEGER;

CONST
  PMERR_INVALID_HWND =                  $01001;
  PMERR_INVALID_HMQ =                   $01002;
  PMERR_PARAMETER_OUT_OF_RANGE =        $01003;
  PMERR_WINDOW_LOCK_UNDERFLOW =         $01004;
  PMERR_WINDOW_LOCK_OVERFLOW =          $01005;
  PMERR_BAD_WINDOW_LOCK_COUNT =         $01006;
  PMERR_WINDOW_NOT_LOCKED =             $01007;
  PMERR_INVALID_SELECTOR =              $01008;
  PMERR_CALL_FROM_WRONG_THREAD =        $01009;
  PMERR_RESOURCE_NOT_FOUND =            $0100A;
  PMERR_INVALID_STRING_PARM =           $0100B;
  PMERR_INVALID_HHEAP =                 $0100C;
  PMERR_INVALID_HEAP_POINTER =          $0100D;
  PMERR_INVALID_HEAP_SIZE_PARM =        $0100E;
  PMERR_INVALID_HEAP_SIZE =             $0100F;
  PMERR_INVALID_HEAP_SIZE_WORD =        $01010;
  PMERR_HEAP_OUT_OF_MEMORY =            $01011;
  PMERR_HEAP_MAX_SIZE_REACHED =         $01012;
  PMERR_INVALID_HATOMTBL =              $01013;
  PMERR_INVALID_ATOM =                  $01014;
  PMERR_INVALID_ATOM_NAME =             $01015;
  PMERR_INVALID_INTEGER_ATOM =          $01016;
  PMERR_ATOM_NAME_NOT_FOUND =           $01017;
  PMERR_QUEUE_TOO_LARGE =               $01018;
  PMERR_INVALID_FLAG =                  $01019;
  PMERR_INVALID_HACCEL =                $0101A;
  PMERR_INVALID_HPTR =                  $0101B;
  PMERR_INVALID_HENUM =                 $0101C;
  PMERR_INVALID_SRC_CODEPAGE =          $0101D;
  PMERR_INVALID_DST_CODEPAGE =          $0101E;

(* These are not real error codes, but just used to access special   *)
(* error message strings used by WinGetErrorInfo to format an error *)
(* message.                                                         *)

  PMERR_UNKNOWN_COMPONENT_ID =          $0101F;
  PMERR_UNKNOWN_ERROR_CODE =            $01020;
  PMERR_SEVERITY_LEVELS =               $01021;
  PMERR_INVALID_RESOURCE_FORMAT =       $01034;

(* Error codes for debugging support *)

  WINDBG_HWND_NOT_DESTROYED =           $01022;
  WINDBG_HPTR_NOT_DESTROYED =           $01023;
  WINDBG_HACCEL_NOT_DESTROYED =         $01024;
  WINDBG_HENUM_NOT_DESTROYED =          $01025;
  WINDBG_VISRGN_SEM_BUSY =              $01026;
  WINDBG_USER_SEM_BUSY =                $01027;
  WINDBG_DC_CACHE_BUSY =                $01028;
  WINDBG_HOOK_STILL_INSTALLED =         $01029;
  WINDBG_WINDOW_STILL_LOCKED =          $0102A;
  WINDBG_UPDATEPS_ASSERTION_FAIL =      $0102B;
  WINDBG_SENDMSG_WITHIN_USER_SEM =      $0102C;
  WINDBG_USER_SEM_NOT_ENTERED =         $0102D;
  WINDBG_PROC_NOT_EXPORTED =            $0102E;
  WINDBG_BAD_SENDMSG_HWND =             $0102F;
  WINDBG_ABNORMAL_EXIT =                $01030;
  WINDBG_INTERNAL_REVISION =            $01031;
  WINDBG_INITSYSTEM_FAILED =            $01032;
  WINDBG_HATOMTBL_NOT_DESTROYED =       $01033;
  WINDBG_WINDOW_UNLOCK_WAIT =           $01035;

(* Get/Set Error Information Interface declarations *)

TYPE
  ERRINFO = RECORD    (* erri *)
    cbFixedErrInfo : WORD;
    idError        : ErrorId;
    cDetailLevel   : WORD;
    offaoffszMsg   : WORD;
    offBinaryData  : WORD;
  END;
  pErrInfo = ^ERRINFO;

  FUNCTION WinGetLastError(ahab : HAB) : ErrorId;
  FUNCTION Win16GetLastError(ahab : HAB) : ErrorId;

  FUNCTION WinGetErrorInfo(ahab : HAB) : pErrInfo;
  FUNCTION Win16GetErrorInfo(ahab : HAB) : pErrInfo;

  FUNCTION WinFreeErrorInfo(apErrInfo : pErrInfo) : BOOLEAN;
  FUNCTION Win16FreeErrorInfo(apErrInfo : pErrInfo) : BOOLEAN;

(* Dynamic Data Exchange (DDE) Structure Declaration *)
TYPE
  DdeInit = RECORD   (* ddei *)
    cb         : WORD;
    pszAppName : pChar;
    pszTopic   : pChar;
  END;
  pDdeInit = ^DdeInit;

  DdeStruct = RECORD    (* dde *)
    cbData        : LongInt;
    fsStatus      : WORD;
    usFormat      : WORD;
    offszItemName : WORD;
    offabData     : WORD;
  END;
  pDdeStruct = ^DdeStruct;

(* DDE  constants for wStatus field *)
CONST
  DDE_FACK =            $00001;
  DDE_FBUSY =           $00002;
  DDE_FNODATA =         $00004;
  DDE_FACKREQ =         $00008;
  DDE_FRESPONSE =       $00010;
  DDE_NOTPROCESSED =    $00020;
  DDE_FRESERVED =       $000C0;
  DDE_FAPPSTATUS =      $0FF00;

(* DDE public formats *)
  DDEFMT_TEXT =         $00001;

(* Dynamic Data Exchange (DDE) Routines *)

  FUNCTION WinDdeInitiate(hWndClient   : hWnd;
                          pszAppName   : pChar;
                          pszTopicName : pChar) : BOOLEAN;
  FUNCTION Win16DdeInitiate(hWndClient   : hWnd;
                          pszAppName   : pChar;
                          pszTopicName : pChar) : BOOLEAN;

  FUNCTION WinDdeRespond(hWndClient   : hWnd;
                         hWndServer   : hWnd;
                         pszAppName   : pChar;
                         pszTopicName : pChar) : mResult;
  FUNCTION Win16DdeRespond(hWndClient   : hWnd;
                         hWndServer   : hWnd;
                         pszAppName   : pChar;
                         pszTopicName : pChar) : mResult;

  FUNCTION WinDdePostMsg(hWndTo   : hWnd;
                         hWndFrom : hWnd;
                         wm       : WORD;
                         pddes    : { LONG } DdeStruct;
                         fRetry   : BOOLEAN) : BOOLEAN;
  FUNCTION Win16DdePostMsg(hWndTo   : hWnd;
                         hWndFrom : hWnd;
                         wm       : WORD;
                         pddes    : { LONG } DdeStruct;
                         fRetry   : BOOLEAN) : BOOLEAN;

(* Dynamic Data Exchange (DDE) Messages *)
CONST
  WM_DDE_FIRST =        $000A0;
  WM_DDE_INITIATE =     $000A0;
  WM_DDE_REQUEST =      $000A1;
  WM_DDE_ACK =          $000A2;
  WM_DDE_DATA =         $000A3;
  WM_DDE_ADVISE =       $000A4;
  WM_DDE_UNADVISE =     $000A5;
  WM_DDE_POKE =         $000A6;
  WM_DDE_EXECUTE =      $000A7;
  WM_DDE_TERMINATE =    $000A8;
  WM_DDE_INITIATEACK =  $000A9;
  WM_DDE_LAST =         $000AF;

  WM_QUERYCONVERTPOS =  $000B0;

(* Return values for WM_QUERYCONVERTPOS *)

  QCP_CONVERT =         $00001;
  QCP_NOCONVERT =       $00000;

TYPE
  hLib = hModule;

  FUNCTION WinDeleteProcedure  (a : HAB; b : pFnWp) : BOOLEAN;
  FUNCTION Win16DeleteProcedure(a : HAB; b : pFnWp) : BOOLEAN;

  FUNCTION WinDeleteLibrary  (a : HAB; b : hLib) : BOOLEAN;
  FUNCTION Win16DeleteLibrary(a : HAB; b : hLib) : BOOLEAN;

  FUNCTION WinLoadProcedure  (a : HAB; b : hLib; c : pChar) : { PFNWP } Pointer;
  FUNCTION Win16LoadProcedure(a : HAB; b : hLib; c : pChar) : { PFNWP } Pointer;

  FUNCTION WinLoadLibrary(a : HAB; b :  pChar) : hLib;
  FUNCTION Win16LoadLibrary(a : HAB; b :  pChar) : hLib;

CONST
    WM_DBCSFIRST    = $0B0;
    WM_DBCSLAST     = $0CF;
    WC_APPSTAT      = $0FFFF0010;
    WC_KBDSTAT      = $0FFFF0011;
    WC_PECIC        = $0FFFF0012;
    WC_DBE_KKPOPUP  = $0FFFF0013;

IMPLEMENTATION
  
  FUNCTION WinQueryDesktopWindow;   EXTERNAL 'PMWin'    INDEX   1;
  FUNCTION Win16QueryDesktopWindow; EXTERNAL 'PMWin'    INDEX   1;

  FUNCTION WinQueryObjectWindow;    EXTERNAL 'PMWin'    INDEX   2;
  FUNCTION Win16QueryObjectWindow;  EXTERNAL 'PMWin'    INDEX   2;

  FUNCTION WinRegisterClass;        EXTERNAL 'PMWin'    INDEX   3;
  FUNCTION Win16RegisterClass;      EXTERNAL 'PMWin'    INDEX   3;

  FUNCTION WinQueryClassName;       EXTERNAL 'PMWin'    INDEX   4;
  FUNCTION Win16QueryClassName;     EXTERNAL 'PMWin'    INDEX   4;

  FUNCTION WinQueryClassInfo;       EXTERNAL 'PMWin'    INDEX   5;
  FUNCTION Win16QueryClassInfo;     EXTERNAL 'PMWin'    INDEX   5;

  FUNCTION WinCreateWindow;         EXTERNAL 'PMWin'    INDEX   6;
  FUNCTION Win16CreateWindow;       EXTERNAL 'PMWin'    INDEX   6;

  FUNCTION WinDestroyWindow;        EXTERNAL 'PMWin'    INDEX   7;
  FUNCTION Win16DestroyWindow;      EXTERNAL 'PMWin'    INDEX   7;

  FUNCTION WinSetWindowPos;         EXTERNAL 'PMWin'    INDEX   8;
  FUNCTION Win16SetWindowPos;       EXTERNAL 'PMWin'    INDEX   8;

  FUNCTION WinSetMultWindowPos;     EXTERNAL 'PMWin'    INDEX   9;
  FUNCTION Win16SetMultWindowPos;   EXTERNAL 'PMWin'    INDEX   9;

  FUNCTION WinQueryWindowPos;       EXTERNAL 'PMWin'    INDEX  10;
  FUNCTION Win16QueryWindowPos;     EXTERNAL 'PMWin'    INDEX  10;

  FUNCTION WinEnableWindow;         EXTERNAL 'PMWin'    INDEX  11;
  FUNCTION Win16EnableWindow;       EXTERNAL 'PMWin'    INDEX  11;

  FUNCTION WinIsWindowEnabled;      EXTERNAL 'PMWin'    INDEX  12;
  FUNCTION Win16IsWindowEnabled;    EXTERNAL 'PMWin'    INDEX  12;

  FUNCTION WinShowWindow;           EXTERNAL 'PMWin'    INDEX  13;
  FUNCTION Win16ShowWindow;         EXTERNAL 'PMWin'    INDEX  13;

  FUNCTION WinEnableWindowUpdate;   EXTERNAL 'PMWin'    INDEX  14;
  FUNCTION Win16EnableWindowUpdate; EXTERNAL 'PMWin'    INDEX  14;

  FUNCTION WinIsWindowVisible;      EXTERNAL 'PMWin'    INDEX  15;
  FUNCTION Win16IsWindowVisible;    EXTERNAL 'PMWin'    INDEX  15;

  FUNCTION WinSetWindowText;        EXTERNAL 'PMWin'    INDEX  16;
  FUNCTION Win16SetWindowText;      EXTERNAL 'PMWin'    INDEX  16;

  FUNCTION WinQueryWindowText;      EXTERNAL 'PMWin'    INDEX  17;
  FUNCTION Win16QueryWindowText;    EXTERNAL 'PMWin'    INDEX  17;

  FUNCTION WinQueryWindowTextLength;EXTERNAL 'PMWin'    INDEX  18;
  FUNCTION Win16QueryWindowTextLength;EXTERNAL 'PMWin'  INDEX  18;
  FUNCTION WinWindowFromID;         EXTERNAL 'PMWin'    INDEX  19;
  FUNCTION Win16WindowFromID;       EXTERNAL 'PMWin'    INDEX  19;

  FUNCTION WinMultWindowFromIDs;    EXTERNAL 'PMWin'    INDEX  20;
  FUNCTION Win16MultWindowFromIDs;  EXTERNAL 'PMWin'    INDEX  20;

  FUNCTION WinIsWindow;             EXTERNAL 'PMWin'    INDEX  21;
  FUNCTION Win16IsWindow;           EXTERNAL 'PMWin'    INDEX  21;

  FUNCTION WinIsChild;              EXTERNAL 'PMWin'    INDEX  22;
  FUNCTION Win16IsChild;            EXTERNAL 'PMWin'    INDEX  22;

  FUNCTION WinSetParent;            EXTERNAL 'PMWin'    INDEX  23;
  FUNCTION Win16SetParent;          EXTERNAL 'PMWin'    INDEX  23;

  FUNCTION WinSetOwner;             EXTERNAL 'PMWin'    INDEX  24;
  FUNCTION Win16SetOwner;           EXTERNAL 'PMWin'    INDEX  24;

  FUNCTION WinQueryWindow;          EXTERNAL 'PMWin'    INDEX  25;
  FUNCTION Win16QueryWindow;        EXTERNAL 'PMWin'    INDEX  25;

  FUNCTION WinQueryWindowRect;      EXTERNAL 'PMWin'    INDEX  26;
  FUNCTION Win16QueryWindowRect;    EXTERNAL 'PMWin'    INDEX  26;

  FUNCTION WinQueryWindowProcess;   EXTERNAL 'PMWin'    INDEX  27;
  FUNCTION Win16QueryWindowProcess; EXTERNAL 'PMWin'    INDEX  27;

  FUNCTION WinSetWindowUShort;      EXTERNAL 'PMWin'    INDEX  28;
  FUNCTION Win16SetWindowUShort;    EXTERNAL 'PMWin'    INDEX  28;

  FUNCTION WinQueryWindowUShort;    EXTERNAL 'PMWin'    INDEX  29;
  FUNCTION Win16QueryWindowUShort;  EXTERNAL 'PMWin'    INDEX  29;

  FUNCTION WinSetWindowULong;       EXTERNAL 'PMWin'    INDEX  30;
  FUNCTION Win16SetWindowULong;     EXTERNAL 'PMWin'    INDEX  30;

  FUNCTION WinQueryWindowULong;     EXTERNAL 'PMWin'    INDEX  31;
  FUNCTION Win16QueryWindowULong;   EXTERNAL 'PMWin'    INDEX  31;

  FUNCTION WinBeginEnumWindows;     EXTERNAL 'PMWin'    INDEX  32;
  FUNCTION Win16BeginEnumWindows;   EXTERNAL 'PMWin'    INDEX  32;

  FUNCTION WinGetNextWindow;        EXTERNAL 'PMWin'    INDEX  33;
  FUNCTION Win16GetNextWindow;      EXTERNAL 'PMWin'    INDEX  33;

  FUNCTION WinEndEnumWindows;       EXTERNAL 'PMWin'    INDEX  34;
  FUNCTION Win16EndEnumWindows;     EXTERNAL 'PMWin'    INDEX  34;

  FUNCTION WinWindowFromPoint;      EXTERNAL 'PMWin'    INDEX  35;
  FUNCTION Win16WindowFromPoint;    EXTERNAL 'PMWin'    INDEX  35;

  FUNCTION WinMapWindowPoints;      EXTERNAL 'PMWin'    INDEX  36;
  FUNCTION Win16MapWindowPoints;    EXTERNAL 'PMWin'    INDEX  36;

  FUNCTION WinSubclassWindow;       EXTERNAL 'PMWin'    INDEX  37;
  FUNCTION Win16SubclassWindow;     EXTERNAL 'PMWin'    INDEX  37;

  FUNCTION WinLockWindow;           EXTERNAL 'PMWin'    INDEX  38;
  FUNCTION Win16LockWindow;         EXTERNAL 'PMWin'    INDEX  38;

  FUNCTION WinQueryWindowLockCount; EXTERNAL 'PMWin'    INDEX  39;
  FUNCTION Win16QueryWindowLockCount;EXTERNAL 'PMWin'   INDEX  39;

  FUNCTION WinRegisterWindowDestroy;EXTERNAL 'PMWin'    INDEX  40;
  FUNCTION Win16RegisterWindowDestroy;EXTERNAL 'PMWin'  INDEX  40;

  FUNCTION WinOpenWindowDC;         EXTERNAL 'PMWin'    INDEX  41;
  FUNCTION Win16OpenWindowDC;       EXTERNAL 'PMWin'    INDEX  41;

  FUNCTION WinGetScreenPS;          EXTERNAL 'PMWin'    INDEX  42;
  FUNCTION Win16GetScreenPS;        EXTERNAL 'PMWin'    INDEX  42;

  FUNCTION WinGetPS;                EXTERNAL 'PMWin'    INDEX  43;
  FUNCTION Win16GetPS;              EXTERNAL 'PMWin'    INDEX  43;

  FUNCTION WinReleasePS;            EXTERNAL 'PMWin'    INDEX  44;
  FUNCTION Win16ReleasePS;          EXTERNAL 'PMWin'    INDEX  44;

  FUNCTION WinBeginPaint;           EXTERNAL 'PMWin'    INDEX  45;
  FUNCTION Win16BeginPaint;         EXTERNAL 'PMWin'    INDEX  45;

  FUNCTION WinEndPaint;             EXTERNAL 'PMWin'    INDEX  46;
  FUNCTION Win16EndPaint;           EXTERNAL 'PMWin'    INDEX  46;

  FUNCTION WinInvalidateRect;       EXTERNAL 'PMWin'    INDEX  47;
  FUNCTION Win16InvalidateRect;     EXTERNAL 'PMWin'    INDEX  47;

  FUNCTION WinInvalidateRegion;     EXTERNAL 'PMWin'    INDEX  48;
  FUNCTION Win16InvalidateRegion;   EXTERNAL 'PMWin'    INDEX  48;

  FUNCTION WinValidateRect;         EXTERNAL 'PMWin'    INDEX  49;
  FUNCTION Win16ValidateRect;       EXTERNAL 'PMWin'    INDEX  49;

  FUNCTION WinValidateRegion;       EXTERNAL 'PMWin'    INDEX  50;
  FUNCTION Win16ValidateRegion;     EXTERNAL 'PMWin'    INDEX  50;

  FUNCTION WinQueryUpdateRect;      EXTERNAL 'PMWin'    INDEX  51;
  FUNCTION Win16QueryUpdateRect;    EXTERNAL 'PMWin'    INDEX  51;

  FUNCTION WinQueryUpdateRegion;    EXTERNAL 'PMWin'    INDEX  52;
  FUNCTION Win16QueryUpdateRegion;  EXTERNAL 'PMWin'    INDEX  52;

  FUNCTION WinUpdateWindow;         EXTERNAL 'PMWin'    INDEX  53;
  FUNCTION Win16UpdateWindow;       EXTERNAL 'PMWin'    INDEX  53;

  FUNCTION WinExcludeUpdateRegion;  EXTERNAL 'PMWin'    INDEX  54;
  FUNCTION Win16ExcludeUpdateRegion;EXTERNAL 'PMWin'    INDEX  54;

  FUNCTION WinLockWindowUpdate;     EXTERNAL 'PMWin'    INDEX  55;
  FUNCTION Win16LockWindowUpdate;   EXTERNAL 'PMWin'    INDEX  55;

  FUNCTION WinLockVisRegions;       EXTERNAL 'PMWin'    INDEX  56;
  FUNCTION Win16LockVisRegions;     EXTERNAL 'PMWin'    INDEX  56;

  FUNCTION WinWindowFromDC;         EXTERNAL 'PMWin'    INDEX  57;
  FUNCTION Win16WindowFromDC;       EXTERNAL 'PMWin'    INDEX  57;

  FUNCTION WinCreateMsgQueue;       EXTERNAL 'PMWin'    INDEX  58;
  FUNCTION Win16CreateMsgQueue;     EXTERNAL 'PMWin'    INDEX  58;

  FUNCTION WinDestroyMsgQueue;      EXTERNAL 'PMWin'    INDEX  59;
  FUNCTION Win16DestroyMsgQueue;    EXTERNAL 'PMWin'    INDEX  59;

  FUNCTION WinQueryQueueStatus;     EXTERNAL 'PMWin'    INDEX  60;
  FUNCTION Win16QueryQueueStatus;   EXTERNAL 'PMWin'    INDEX  60;

  FUNCTION WinSendMsg;              EXTERNAL 'PMWin'    INDEX  61;
  FUNCTION Win16SendMsg;            EXTERNAL 'PMWin'    INDEX  61;

(* ====================================================*)

  FUNCTION WinBroadcastMsg;         EXTERNAL 'PMWin'    INDEX  63;
  FUNCTION Win16BroadcastMsg;       EXTERNAL 'PMWin'    INDEX  63;

  FUNCTION WinInSendMsg;            EXTERNAL 'PMWin'    INDEX  64;
  FUNCTION Win16InSendMsg;          EXTERNAL 'PMWin'    INDEX  64;

  FUNCTION WinGetMsg;               EXTERNAL 'PMWin'    INDEX  65;
  FUNCTION Win16GetMsg;             EXTERNAL 'PMWin'    INDEX  65;

  FUNCTION WinPeekMsg;              EXTERNAL 'PMWin'    INDEX  66;
  FUNCTION Win16PeekMsg;            EXTERNAL 'PMWin'    INDEX  66;

  FUNCTION WinWaitMsg;              EXTERNAL 'PMWin'    INDEX  67;
  FUNCTION Win16WaitMsg;            EXTERNAL 'PMWin'    INDEX  67;

  FUNCTION WinDispatchMsg;          EXTERNAL 'PMWin'    INDEX  68;
  FUNCTION Win16DispatchMsg;        EXTERNAL 'PMWin'    INDEX  68;

  FUNCTION WinPostMsg;              EXTERNAL 'PMWin'    INDEX  69;
  FUNCTION Win16PostMsg;            EXTERNAL 'PMWin'    INDEX  69;

  FUNCTION WinPostQueueMsg;         EXTERNAL 'PMWin'    INDEX  70;
  FUNCTION Win16PostQueueMsg;       EXTERNAL 'PMWin'    INDEX  70;

  FUNCTION WinQueryMsgPos;          EXTERNAL 'PMWin'    INDEX  71;
  FUNCTION Win16QueryMsgPos;        EXTERNAL 'PMWin'    INDEX  71;

  FUNCTION WinQueryMsgTime;         EXTERNAL 'PMWin'    INDEX  72;
  FUNCTION Win16QueryMsgTime;       EXTERNAL 'PMWin'    INDEX  72;

  FUNCTION WinCallMsgFilter;        EXTERNAL 'PMWin'    INDEX  73;
  FUNCTION Win16CallMsgFilter;      EXTERNAL 'PMWin'    INDEX  73;
{
  FUNCTION WinSetMsgInterest;       External 'PMWin'    INDEX  74;
  FUNCTION Win16SetMsgInterest;     External 'PMWin'    INDEX  74;
}
  FUNCTION WinSetCapture;           EXTERNAL 'PMWin'    INDEX  75;
  FUNCTION Win16SetCapture;         EXTERNAL 'PMWin'    INDEX  75;

  FUNCTION WinQueryCapture;         EXTERNAL 'PMWin'    INDEX  76;
  FUNCTION Win16QueryCapture;       EXTERNAL 'PMWin'    INDEX  76;

  FUNCTION WinSetFocus;             EXTERNAL 'PMWin'    INDEX  77;
  FUNCTION Win16SetFocus;           EXTERNAL 'PMWin'    INDEX  77;

  FUNCTION WinQueryFocus;           EXTERNAL 'PMWin'    INDEX  78;
  FUNCTION Win16QueryFocus;         EXTERNAL 'PMWin'    INDEX  78;

  FUNCTION WinSetActiveWindow;      EXTERNAL 'PMWin'    INDEX  79;
  FUNCTION Win16SetActiveWindow;    EXTERNAL 'PMWin'    INDEX  79;

  FUNCTION WinQueryActiveWindow;    EXTERNAL 'PMWin'    INDEX  80;
  FUNCTION Win16QueryActiveWindow;  EXTERNAL 'PMWin'    INDEX  80;

  FUNCTION WinSetSysModalWindow;    EXTERNAL 'PMWin'    INDEX  81;
  FUNCTION Win16SetSysModalWindow;  EXTERNAL 'PMWin'    INDEX  81;

  FUNCTION WinQuerySysModalWindow;  EXTERNAL 'PMWin'    INDEX  82;
  FUNCTION Win16QuerySysModalWindow;EXTERNAL 'PMWin'    INDEX  82;

  FUNCTION WinIsThreadActive;       EXTERNAL 'PMWin'    INDEX  83;
  FUNCTION Win16IsThreadActive;     EXTERNAL 'PMWin'    INDEX  83;

  FUNCTION WinStartTimer;           EXTERNAL 'PMWin'    INDEX  84;
  FUNCTION Win16StartTimer;         EXTERNAL 'PMWin'    INDEX  84;

  FUNCTION WinStopTimer;            EXTERNAL 'PMWin'    INDEX  85;
  FUNCTION Win16StopTimer;          EXTERNAL 'PMWin'    INDEX  85;

  FUNCTION WinGetCurrentTime;       EXTERNAL 'PMWin'    INDEX  86;
  FUNCTION Win16GetCurrentTime;     EXTERNAL 'PMWin'    INDEX  86;

  FUNCTION WinLoadPointer;          EXTERNAL 'PMWin'    INDEX  87;
  FUNCTION Win16LoadPointer;        EXTERNAL 'PMWin'    INDEX  87;

  FUNCTION WinCreatePointer;        EXTERNAL 'PMWin'    INDEX  88;
  FUNCTION Win16CreatePointer;      EXTERNAL 'PMWin'    INDEX  88;

  FUNCTION WinDestroyPointer;       EXTERNAL 'PMWin'    INDEX  89;
  FUNCTION Win16DestroyPointer;     EXTERNAL 'PMWin'    INDEX  89;
{
  FUNCTION OldWinQueryPointerInfo;  External 'PMWin'    INDEX  90;
}
  FUNCTION WinQuerySysPointer;      EXTERNAL 'PMWin'    INDEX  91;
  FUNCTION Win16QuerySysPointer;    EXTERNAL 'PMWin'    INDEX  91;

  FUNCTION WinSetPointer;           EXTERNAL 'PMWin'    INDEX  92;
  FUNCTION Win16SetPointer;         EXTERNAL 'PMWin'    INDEX  92;

  FUNCTION WinQueryPointer;         EXTERNAL 'PMWin'    INDEX  93;
  FUNCTION Win16QueryPointer;       EXTERNAL 'PMWin'    INDEX  93;

  FUNCTION WinShowPointer;          EXTERNAL 'PMWin'    INDEX  94;
  FUNCTION Win16ShowPointer;        EXTERNAL 'PMWin'    INDEX  94;

  FUNCTION WinSetPointerPos;        EXTERNAL 'PMWin'    INDEX  95;
  FUNCTION Win16SetPointerPos;      EXTERNAL 'PMWin'    INDEX  95;

  FUNCTION WinQueryPointerPos;      EXTERNAL 'PMWin'    INDEX  96;
  FUNCTION Win16QueryPointerPos;    EXTERNAL 'PMWin'    INDEX  96;

  FUNCTION WinGetSysBitmap;         EXTERNAL 'PMWin'    INDEX  97;
  FUNCTION Win16GetSysBitmap;       EXTERNAL 'PMWin'    INDEX  97;

  FUNCTION WinCreateCursor;         EXTERNAL 'PMWin'    INDEX  98;
  FUNCTION Win16CreateCursor;       EXTERNAL 'PMWin'    INDEX  98;

  FUNCTION WinDestroyCursor;        EXTERNAL 'PMWin'    INDEX  99;
  FUNCTION Win16DestroyCursor;      EXTERNAL 'PMWin'    INDEX  99;

  FUNCTION WinShowCursor;           EXTERNAL 'PMWin'    INDEX 100;
  FUNCTION Win16ShowCursor;         EXTERNAL 'PMWin'    INDEX 100;

  FUNCTION WinQueryCursorInfo;      EXTERNAL 'PMWin'    INDEX 101;
  FUNCTION Win16QueryCursorInfo;    EXTERNAL 'PMWin'    INDEX 101;

  FUNCTION WinLoadAccelTable;       EXTERNAL 'PMWin'    INDEX 102;
  FUNCTION Win16LoadAccelTable;     EXTERNAL 'PMWin'    INDEX 102;

  FUNCTION WinCreateAccelTable;     EXTERNAL 'PMWin'    INDEX 103;
  FUNCTION Win16CreateAccelTable;   EXTERNAL 'PMWin'    INDEX 103;

  FUNCTION WinDestroyAccelTable;    EXTERNAL 'PMWin'    INDEX 104;
  FUNCTION Win16DestroyAccelTable;  EXTERNAL 'PMWin'    INDEX 104;

  FUNCTION WinTranslateAccel;       EXTERNAL 'PMWin'    INDEX 105;
  FUNCTION Win16TranslateAccel;     EXTERNAL 'PMWin'    INDEX 105;

  FUNCTION WinSetAccelTable;        EXTERNAL 'PMWin'    INDEX 106;
  FUNCTION Win16SetAccelTable;      EXTERNAL 'PMWin'    INDEX 106;

  FUNCTION WinQueryAccelTable;      EXTERNAL 'PMWin'    INDEX 107;
  FUNCTION Win16QueryAccelTable;    EXTERNAL 'PMWin'    INDEX 107;

  FUNCTION WinCopyAccelTable;       EXTERNAL 'PMWin'    INDEX 108;
  FUNCTION Win16CopyAccelTable;     EXTERNAL 'PMWin'    INDEX 108;

  FUNCTION WinSetHook;              EXTERNAL 'PMWin'    INDEX 109;
  FUNCTION Win16SetHook;            EXTERNAL 'PMWin'    INDEX 109;

  FUNCTION WinReleaseHook;          EXTERNAL 'PMWin'    INDEX 110;
  FUNCTION Win16ReleaseHook;        EXTERNAL 'PMWin'    INDEX 110;

  FUNCTION WinOpenClipbrd;          EXTERNAL 'PMWin'    INDEX 111;
  FUNCTION Win16OpenClipbrd;        EXTERNAL 'PMWin'    INDEX 111;

  FUNCTION WinCloseClipbrd;         EXTERNAL 'PMWin'    INDEX 112;
  FUNCTION Win16CloseClipbrd;       EXTERNAL 'PMWin'    INDEX 112;

  FUNCTION WinEmptyClipbrd;         EXTERNAL 'PMWin'    INDEX 113;
  FUNCTION Win16EmptyClipbrd;       EXTERNAL 'PMWin'    INDEX 113;

  FUNCTION WinSetClipbrdOwner;      EXTERNAL 'PMWin'    INDEX 114;
  FUNCTION Win16SetClipbrdOwner;    EXTERNAL 'PMWin'    INDEX 114;

  FUNCTION WinQueryClipbrdOwner;    EXTERNAL 'PMWin'    INDEX 115;
  FUNCTION Win16QueryClipbrdOwner;  EXTERNAL 'PMWin'    INDEX 115;

  FUNCTION WinSetClipbrdData;       EXTERNAL 'PMWin'    INDEX 116;
  FUNCTION Win16SetClipbrdData;     EXTERNAL 'PMWin'    INDEX 116;

  FUNCTION WinQueryClipbrdData;     EXTERNAL 'PMWin'    INDEX 117;
  FUNCTION Win16QueryClipbrdData;   EXTERNAL 'PMWin'    INDEX 117;

  FUNCTION WinEnumClipbrdFmts;      EXTERNAL 'PMWin'    INDEX 118;
  FUNCTION Win16EnumClipbrdFmts;    EXTERNAL 'PMWin'    INDEX 118;

  FUNCTION WinQueryClipbrdFmtInfo;  EXTERNAL 'PMWin'    INDEX 119;
  FUNCTION Win16QueryClipbrdFmtInfo;EXTERNAL 'PMWin'    INDEX 119;

  FUNCTION WinSetClipbrdViewer;     EXTERNAL 'PMWin'    INDEX 120;
  FUNCTION Win16SetClipbrdViewer;   EXTERNAL 'PMWin'    INDEX 120;

  FUNCTION WinQueryClipbrdViewer;   EXTERNAL 'PMWin'    INDEX 121;
  FUNCTION Win16QueryClipbrdViewer; EXTERNAL 'PMWin'    INDEX 121;

  FUNCTION WinLoadDlg;              EXTERNAL 'PMWin'    INDEX 122;
  FUNCTION Win16LoadDlg;            EXTERNAL 'PMWin'    INDEX 122;

  FUNCTION WinCreateDlg;            EXTERNAL 'PMWin'    INDEX 123;
  FUNCTION Win16CreateDlg;          EXTERNAL 'PMWin'    INDEX 123;

  FUNCTION WinProcessDlg;           EXTERNAL 'PMWin'    INDEX 124;
  FUNCTION Win16ProcessDlg;         EXTERNAL 'PMWin'    INDEX 124;

  FUNCTION WinDlgBox;               EXTERNAL 'PMWin'    INDEX 125;
  FUNCTION Win16DlgBox;             EXTERNAL 'PMWin'    INDEX 125;

  FUNCTION WinDismissDlg;           EXTERNAL 'PMWin'    INDEX 126;
  FUNCTION Win16DismissDlg;         EXTERNAL 'PMWin'    INDEX 126;

  FUNCTION WinSendDlgItemMsg;       EXTERNAL 'PMWin'    INDEX 127;
  FUNCTION Win16SendDlgItemMsg;     EXTERNAL 'PMWin'    INDEX 127;

  FUNCTION WinSetDlgItemShort;      EXTERNAL 'PMWin'    INDEX 128;
  FUNCTION Win16SetDlgItemShort;    EXTERNAL 'PMWin'    INDEX 128;

  FUNCTION WinQueryDlgItemShort;    EXTERNAL 'PMWin'    INDEX 129;
  FUNCTION Win16QueryDlgItemShort;  EXTERNAL 'PMWin'    INDEX 129;

  FUNCTION WinMapDlgPoints;         EXTERNAL 'PMWin'    INDEX 130;
  FUNCTION Win16MapDlgPoints;       EXTERNAL 'PMWin'    INDEX 130;

  FUNCTION WinSubstituteStrings;    EXTERNAL 'PMWin'    INDEX 132;
  FUNCTION Win16SubstituteStrings;  EXTERNAL 'PMWin'    INDEX 132;

  FUNCTION WinEnumDlgItem;          EXTERNAL 'PMWin'    INDEX 133;
  FUNCTION Win16EnumDlgItem;        EXTERNAL 'PMWin'    INDEX 133;

  FUNCTION WinSetDlgItemText;       EXTERNAL 'PMWin'    INDEX 134;
  FUNCTION Win16SetDlgItemText;     EXTERNAL 'PMWin'    INDEX 134;

  FUNCTION WinQueryDlgItemText;     EXTERNAL 'PMWin'    INDEX 135;
  FUNCTION Win16QueryDlgItemText;   EXTERNAL 'PMWin'    INDEX 135;

  FUNCTION WinLoadMenu;             EXTERNAL 'PMWin'    INDEX 136;
  FUNCTION Win16LoadMenu;           EXTERNAL 'PMWin'    INDEX 136;

  FUNCTION WinCreateMenu;           EXTERNAL 'PMWin'    INDEX 137;
  FUNCTION Win16CreateMenu;         EXTERNAL 'PMWin'    INDEX 137;

  FUNCTION WinAlarm;                EXTERNAL 'PMWin'    INDEX 138;
  FUNCTION Win16Alarm;              EXTERNAL 'PMWin'    INDEX 138;

  FUNCTION WinMessageBox;           EXTERNAL 'PMWin'    INDEX 139;
  FUNCTION Win16MessageBox;         EXTERNAL 'PMWin'    INDEX 139;

  FUNCTION WinCreateStdWindow;      EXTERNAL 'PMWin'    INDEX 140;
  FUNCTION Win16CreateStdWindow;    EXTERNAL 'PMWin'    INDEX 140;

  FUNCTION WinCreateFrameControls;  EXTERNAL 'PMWin'    INDEX 141;
  FUNCTION Win16CreateFrameControls;EXTERNAL 'PMWin'    INDEX 141;

  FUNCTION WinFormatFrame;          EXTERNAL 'PMWIN' INDEX 142;
  FUNCTION Win16FormatFrame;        EXTERNAL 'PMWIN' INDEX 142;

(* ====================================================== *)

  FUNCTION WinCalcFrameRect;        EXTERNAL 'PMWin'    INDEX 143;
  FUNCTION Win16CalcFrameRect;      EXTERNAL 'PMWin'    INDEX 143;

  FUNCTION WinFlashWindow;          EXTERNAL 'PMWin'    INDEX 144;
  FUNCTION Win16FlashWindow;        EXTERNAL 'PMWin'    INDEX 144;

(* ====================================================== *)

  FUNCTION WinGetMinPosition;       EXTERNAL 'PMWin'    INDEX 146;
  FUNCTION Win16GetMinPosition;     EXTERNAL 'PMWin'    INDEX 146;

  FUNCTION WinGetMaxPosition;       EXTERNAL 'PMWin'    INDEX 147;
  FUNCTION Win16GetMaxPosition;     EXTERNAL 'PMWin'    INDEX 147;

(* ====================================================*)

  FUNCTION WinQuerySysValue;        EXTERNAL 'PMWin'    INDEX 149;
  FUNCTION Win16QuerySysValue;      EXTERNAL 'PMWin'    INDEX 149;

  FUNCTION WinSetSysValue;          EXTERNAL 'PMWin'    INDEX 150;
  FUNCTION Win16SetSysValue;        EXTERNAL 'PMWin'    INDEX 150;

  FUNCTION WinSetSysColors;         EXTERNAL 'PMWin'    INDEX 151;
  FUNCTION Win16SetSysColors;       EXTERNAL 'PMWin'    INDEX 151;

  FUNCTION WinQuerySysColor;        EXTERNAL 'PMWin'    INDEX 152;
  FUNCTION Win16QuerySysColor;      EXTERNAL 'PMWin'    INDEX 152;

  FUNCTION WinScrollWindow;         EXTERNAL 'PMWin'    INDEX 153;
  FUNCTION Win16ScrollWindow;       EXTERNAL 'PMWin'    INDEX 153;

  FUNCTION WinTrackRect;            EXTERNAL 'PMWin'    INDEX 154;
  FUNCTION Win16TrackRect;          EXTERNAL 'PMWin'    INDEX 154;

  FUNCTION WinShowTrackRect;        EXTERNAL 'PMWin'    INDEX 155;
  FUNCTION Win16ShowTrackRect;      EXTERNAL 'PMWin'    INDEX 155;
{
  FUNCTION GPILoadBitmap;           External 'PMWin'    INDEX 156;
  FUNCTION GPI16LoadBitmap;         External 'PMWin'    INDEX 156;
}
  FUNCTION WinLoadString;           EXTERNAL 'PMWin'    INDEX 157;
  FUNCTION Win16LoadString;         EXTERNAL 'PMWin'    INDEX 157;

  FUNCTION WinLoadMessage;          EXTERNAL 'PMWin'    INDEX 158;
  FUNCTION Win16LoadMessage;        EXTERNAL 'PMWin'    INDEX 158;

  FUNCTION WinSetRectEmpty;         EXTERNAL 'PMWin'    INDEX 159;
  FUNCTION Win16SetRectEmpty;       EXTERNAL 'PMWin'    INDEX 159;

  FUNCTION WinSetRect;              EXTERNAL 'PMWin'    INDEX 160;
  FUNCTION Win16SetRect;            EXTERNAL 'PMWin'    INDEX 160;

  FUNCTION WinCopyRect;             EXTERNAL 'PMWin'    INDEX 161;
  FUNCTION Win16CopyRect;           EXTERNAL 'PMWin'    INDEX 161;

  FUNCTION WinIsRectEmpty;          EXTERNAL 'PMWin'    INDEX 162;
  FUNCTION Win16IsRectEmpty;        EXTERNAL 'PMWin'    INDEX 162;

  FUNCTION WinEqualRect;            EXTERNAL 'PMWin'    INDEX 163;
  FUNCTION Win16EqualRect;          EXTERNAL 'PMWin'    INDEX 163;

  FUNCTION WinPtInRect;             EXTERNAL 'PMWin'    INDEX 164;
  FUNCTION Win16PtInRect;           EXTERNAL 'PMWin'    INDEX 164;

  FUNCTION WinOffsetRect;           EXTERNAL 'PMWin'    INDEX 165;
  FUNCTION Win16OffsetRect;         EXTERNAL 'PMWin'    INDEX 165;

  FUNCTION WinInflateRect;          EXTERNAL 'PMWin'    INDEX 166;
  FUNCTION Win16InflateRect;        EXTERNAL 'PMWin'    INDEX 166;

  FUNCTION WinIntersectRect;        EXTERNAL 'PMWin'    INDEX 167;
  FUNCTION Win16IntersectRect;      EXTERNAL 'PMWin'    INDEX 167;

  FUNCTION WinUnionRect;            EXTERNAL 'PMWin'    INDEX 168;
  FUNCTION Win16UnionRect;          EXTERNAL 'PMWin'    INDEX 168;

  FUNCTION WinSubtractRect;         EXTERNAL 'PMWin'    INDEX 169;
  FUNCTION Win16SubtractRect;       EXTERNAL 'PMWin'    INDEX 169;
{
  FUNCTION WinMakeRect;             External 'PMWin'    INDEX 170;
  FUNCTION Win16MakeRect;           External 'PMWin'    INDEX 170;

  FUNCTION WinMakePoints;           External 'PMWin'    INDEX 171;
  FUNCTION Win16MakePoints;         External 'PMWin'    INDEX 171;
}
  FUNCTION WinInvertRect;           EXTERNAL 'PMWin'    INDEX 172;
  FUNCTION Win16InvertRect;         EXTERNAL 'PMWin'    INDEX 172;

  FUNCTION WinFillRect;             EXTERNAL 'PMWin'    INDEX 173;
  FUNCTION Win16FillRect;           EXTERNAL 'PMWin'    INDEX 173;
{
  FUNCTION KbdPacket;               External 'PMWin'    INDEX 174;
}
(* ====================================================*)

  FUNCTION WinDrawPointer;          EXTERNAL 'PMWin'    INDEX 177;
  FUNCTION Win16DrawPointer;        EXTERNAL 'PMWin'    INDEX 177;

  FUNCTION WinDefWindowProc;        EXTERNAL 'PMWin'    INDEX 178;
  FUNCTION Win16DefWindowProc;      EXTERNAL 'PMWin'    INDEX 178;

  FUNCTION WinDefDlgProc;           EXTERNAL 'PMWin'    INDEX 179;
  FUNCTION Win16DefDlgProc;         EXTERNAL 'PMWin'    INDEX 179;

(* ====================================================== *)

  FUNCTION WinGetKeyState;          EXTERNAL 'PMWin'    INDEX 211;
  FUNCTION Win16GetKeyState;        EXTERNAL 'PMWin'    INDEX 211;

  FUNCTION WinGetPhysKeyState;      EXTERNAL 'PMWin'    INDEX 212;
  FUNCTION Win16GetPhysKeyState;    EXTERNAL 'PMWin'    INDEX 212;

  FUNCTION WinSetKeyboardStateTable;EXTERNAL 'PMWin'    INDEX 213;
  FUNCTION Win16SetKeyboardStateTable;EXTERNAL 'PMWin'  INDEX 213;

  FUNCTION WinEnablePhysInput;      EXTERNAL 'PMWin'    INDEX 214;
  FUNCTION Win16EnablePhysInput;    EXTERNAL 'PMWin'    INDEX 214;

  FUNCTION WinSetCp;                EXTERNAL 'PMWin'    INDEX 215;
  FUNCTION Win16SetCp;              EXTERNAL 'PMWin'    INDEX 215;

  FUNCTION WinQueryCp;              EXTERNAL 'PMWin'    INDEX 216;
  FUNCTION Win16QueryCp;            EXTERNAL 'PMWin'    INDEX 216;

  FUNCTION WinQueryCpList;          EXTERNAL 'PMWin'    INDEX 217;
  FUNCTION Win16QueryCpList;        EXTERNAL 'PMWin'    INDEX 217;

  FUNCTION WinCpTranslateString;    EXTERNAL 'PMWin'    INDEX 218;
  FUNCTION Win16CpTranslateString;  EXTERNAL 'PMWin'    INDEX 218;

  FUNCTION WinCpTranslateChar;      EXTERNAL 'PMWin'    INDEX 219;
  FUNCTION Win16CpTranslateChar;    EXTERNAL 'PMWin'    INDEX 219;

  FUNCTION WinCompareStrings;       EXTERNAL 'PMWin'    INDEX 220;
  FUNCTION Win16CompareStrings;     EXTERNAL 'PMWin'    INDEX 220;

  FUNCTION WinUpper;                EXTERNAL 'PMWin'    INDEX 221;
  FUNCTION Win16Upper;              EXTERNAL 'PMWin'    INDEX 221;

  FUNCTION WinUpperChar;            EXTERNAL 'PMWin'    INDEX 222;
  FUNCTION Win16UpperChar;          EXTERNAL 'PMWin'    INDEX 222;

  FUNCTION WinNextChar;             EXTERNAL 'PMWin'    INDEX 223;
  FUNCTION Win16NextChar;           EXTERNAL 'PMWin'    INDEX 223;

  FUNCTION WinPrevChar;             EXTERNAL 'PMWin'    INDEX 224;
  FUNCTION Win16PrevChar;           EXTERNAL 'PMWin'    INDEX 224;

  FUNCTION WinCreateHeap;           EXTERNAL 'PMWin'    INDEX 225;
  FUNCTION Win16CreateHeap;         EXTERNAL 'PMWin'    INDEX 225;

  FUNCTION WinDestroyHeap;          EXTERNAL 'PMWin'    INDEX 226;
  FUNCTION Win16DestroyHeap;        EXTERNAL 'PMWin'    INDEX 226;

  FUNCTION WinAvailMem;             EXTERNAL 'PMWin'    INDEX 227;
  FUNCTION Win16AvailMem;           EXTERNAL 'PMWin'    INDEX 227;

  FUNCTION WinAllocMem;             EXTERNAL 'PMWin'    INDEX 228;
  FUNCTION Win16AllocMem;           EXTERNAL 'PMWin'    INDEX 228;

  FUNCTION WinReallocMem;           EXTERNAL 'PMWin'    INDEX 229;
  FUNCTION Win16ReallocMem;         EXTERNAL 'PMWin'    INDEX 229;

  FUNCTION WinFreeMem;              EXTERNAL 'PMWin'    INDEX 230;
  FUNCTION Win16FreeMem;            EXTERNAL 'PMWin'    INDEX 230;

  FUNCTION WinLockHeap;             EXTERNAL 'PMWin'    INDEX 231;
  FUNCTION Win16LockHeap;           EXTERNAL 'PMWin'    INDEX 231;

  FUNCTION WinCreateAtomTable;      EXTERNAL 'PMWin'    INDEX 233;
  FUNCTION Win16CreateAtomTable;    EXTERNAL 'PMWin'    INDEX 233;

  FUNCTION WinDestroyAtomTable;     EXTERNAL 'PMWin'    INDEX 234;
  FUNCTION Win16DestroyAtomTable;   EXTERNAL 'PMWin'    INDEX 234;

  FUNCTION WinAddAtom;              EXTERNAL 'PMWin'    INDEX 235;
  FUNCTION Win16AddAtom;            EXTERNAL 'PMWin'    INDEX 235;

  FUNCTION WinFindAtom;             EXTERNAL 'PMWin'    INDEX 236;
  FUNCTION Win16FindAtom;           EXTERNAL 'PMWin'    INDEX 236;

  FUNCTION WinDeleteAtom;           EXTERNAL 'PMWin'    INDEX 237;
  FUNCTION Win16DeleteAtom;         EXTERNAL 'PMWin'    INDEX 237;

  FUNCTION WinQueryAtomUsage;       EXTERNAL 'PMWin'    INDEX 238;
  FUNCTION Win16QueryAtomUsage;     EXTERNAL 'PMWin'    INDEX 238;

  FUNCTION WinQueryAtomLength;      EXTERNAL 'PMWin'    INDEX 239;
  FUNCTION Win16QueryAtomLength;    EXTERNAL 'PMWin'    INDEX 239;

  FUNCTION WinQueryAtomName;        EXTERNAL 'PMWin'    INDEX 240;
  FUNCTION Win16QueryAtomName;      EXTERNAL 'PMWin'    INDEX 240;

  FUNCTION WinQuerySystemAtomTable; EXTERNAL 'PMWin'    INDEX 241;
  FUNCTION Win16QuerySystemAtomTable;EXTERNAL 'PMWin'   INDEX 241;

  FUNCTION WinGetLastError;         EXTERNAL 'PMWin'    INDEX 243;
  FUNCTION Win16GetLastError;       EXTERNAL 'PMWin'    INDEX 243;

  FUNCTION WinGetErrorInfo;         EXTERNAL 'PMWin'    INDEX 244;
  FUNCTION Win16GetErrorInfo;       EXTERNAL 'PMWin'    INDEX 244;

  FUNCTION WinFreeErrorInfo;        EXTERNAL 'PMWin'    INDEX 245;
  FUNCTION Win16FreeErrorInfo;      EXTERNAL 'PMWin'    INDEX 245;

  FUNCTION WinInitialize;           EXTERNAL 'PMWin'    INDEX 246;
  FUNCTION Win16Initialize;         EXTERNAL 'PMWin'    INDEX 246;

  FUNCTION WinTerminate;            EXTERNAL 'PMWin'    INDEX 247;
  FUNCTION Win16Terminate;          EXTERNAL 'PMWin'    INDEX 247;

  FUNCTION WinCatch;                EXTERNAL 'PMWin'    INDEX 248;
  FUNCTION Win16Catch;              EXTERNAL 'PMWin'    INDEX 248;

  FUNCTION WinThrow;                EXTERNAL 'PMWin'    INDEX 249;
  FUNCTION Win16Throw;              EXTERNAL 'PMWin'    INDEX 249;

  FUNCTION WinQueryVersion;         EXTERNAL 'PMWin'    INDEX 250;
  FUNCTION Win16QueryVersion;       EXTERNAL 'PMWin'    INDEX 250;

  FUNCTION WinIsPhysInputEnabled;   EXTERNAL 'PMWin'    INDEX 264;
  FUNCTION Win16IsPhysInputEnabled; EXTERNAL 'PMWin'    INDEX 264;

  FUNCTION WinQueryWindowDC;        EXTERNAL 'PMWin'    INDEX 265;
  FUNCTION Win16QueryWindowDC;      EXTERNAL 'PMWin'    INDEX 265;

  FUNCTION WinDrawBorder;           EXTERNAL 'PMWin'    INDEX 266;
  FUNCTION Win16DrawBorder;         EXTERNAL 'PMWin'    INDEX 266;

  FUNCTION WinDrawText;             EXTERNAL 'PMWin'    INDEX 267;
  FUNCTION Win16DrawText;           EXTERNAL 'PMWin'    INDEX 267;

  FUNCTION WinDrawBitmap;           EXTERNAL 'PMWin'    INDEX 268;
  FUNCTION Win16DrawBitmap;         EXTERNAL 'PMWin'    INDEX 268;

  FUNCTION WinQueryWindowPtr;       EXTERNAL 'PMWin'    INDEX 269;
  FUNCTION Win16QueryWindowPtr;     EXTERNAL 'PMWin'    INDEX 269;

  FUNCTION WinSetWindowPtr;         EXTERNAL 'PMWin'    INDEX 270;
  FUNCTION Win16SetWindowPtr;       EXTERNAL 'PMWin'    INDEX 270;

  FUNCTION WinMsgSemWait;           EXTERNAL 'PMWin'    INDEX 274;
  FUNCTION Win16MsgSemWait;         EXTERNAL 'PMWin'    INDEX 274;

  FUNCTION WinMsgMuxSemWait;        EXTERNAL 'PMWin'    INDEX 275;
  FUNCTION Win16MsgMuxSemWait;      EXTERNAL 'PMWin'    INDEX 275;

  FUNCTION WinCancelShutdown;       EXTERNAL 'PMWin'    INDEX 277;
  FUNCTION Win16CancelShutdown;     EXTERNAL 'PMWin'    INDEX 277;

  FUNCTION WinSetWindowBits;        EXTERNAL 'PMWin'    INDEX 278;
  FUNCTION Win16SetWindowBits;      EXTERNAL 'PMWin'    INDEX 278;

  FUNCTION WinGetClipPS;            EXTERNAL 'PMWin'    INDEX 279;
  FUNCTION Win16GetClipPS;          EXTERNAL 'PMWin'    INDEX 279;

(* ====================================================== *)
{
  FUNCTION WinSaveWindowPos;        External 'PMWin'    INDEX 285;
  FUNCTION Win16SaveWindowPos;      External 'PMWin'    INDEX 285;
}
  FUNCTION WinFocusChange;          EXTERNAL 'PMWin'    INDEX 286;
  FUNCTION Win16FocusChange;        EXTERNAL 'PMWin'    INDEX 286;

  FUNCTION WinQueryQueueInfo;       EXTERNAL 'PMWin'    INDEX 287;
  FUNCTION Win16QueryQueueInfo;     EXTERNAL 'PMWin'    INDEX 287;
{
  FUNCTION WinSetClassMsgInterest;  External 'PMWin'    INDEX 292;
  FUNCTION Win16SetClassMsgInterest;External 'PMWin'    INDEX 292;
}
  FUNCTION WinQueryDlgItemTextLength;EXTERNAL 'PMWin'    INDEX 294;
  FUNCTION Win16QueryDlgItemTextLength;EXTERNAL 'PMWin'  INDEX 294;

  FUNCTION WinDdeInitiate;           EXTERNAL 'PMWin'    INDEX 297;
  FUNCTION Win16DdeInitiate;         EXTERNAL 'PMWin'    INDEX 297;

  FUNCTION WinDdeRespond;            EXTERNAL 'PMWin'    INDEX 298;
  FUNCTION Win16DdeRespond;          EXTERNAL 'PMWin'    INDEX 298;

  FUNCTION WinDdePostMsg;            EXTERNAL 'PMWin'    INDEX 299;
  FUNCTION Win16DdePostMsg;          EXTERNAL 'PMWin'    INDEX 299;

  FUNCTION WinSetPresParam;          EXTERNAL 'PMWin'    INDEX 301;
  FUNCTION Win16SetPresParam;        EXTERNAL 'PMWin'    INDEX 301;

  FUNCTION WinQueryPresParam;        EXTERNAL 'PMWin'    INDEX 302;
  FUNCTION Win16QueryPresParam;      EXTERNAL 'PMWin'    INDEX 302;

  FUNCTION WinRemovePresParam;       EXTERNAL 'PMWin'    INDEX 303;
  FUNCTION Win16RemovePresParam;     EXTERNAL 'PMWin'    INDEX 303;

(* ====================================================== *)
{
  FUNCTION DumWinCreateHelpInstance; External 'PMWin'    INDEX 311;

  FUNCTION DumWinDestroyHelpInstance;External 'PMWin'    INDEX 312;

  FUNCTION DumWinAssociateHelpInstance;External 'PMWin'  INDEX 313;

  FUNCTION DumWinCreateHelpTable;    External 'PMWin'    INDEX 314;

  FUNCTION DumWinLoadHelpTable;      External 'PMWin'    INDEX 315;

  FUNCTION DumWinQueryHelpInstance;  External 'PMWin'    INDEX 316;

  FUNCTION WinQueryWindowModeL;      External 'PMWin'    INDEX 317;
  FUNCTION Win16QueryWindowModeL;    External 'PMWin'    INDEX 317;

  FUNCTION WinSetDesktopBkGnd;       External 'PMWin'    INDEX 318;
  FUNCTION Win16SetDesktopBkGnd;     External 'PMWin'    INDEX 318;

  FUNCTION WinQueryDesktopBkGnd;     External 'PMWin'    INDEX 319;
  FUNCTION Win16QueryDesktopBkGnd;   External 'PMWin'    INDEX 319;

  FUNCTION WinPopupMenu;             External 'PMWin'    INDEX 320;
  FUNCTION Win16PopupMenu;           External 'PMWin'    INDEX 320;

  FUNCTION WinRealizePalette;        External 'PMWin'    INDEX 321;
  FUNCTION Win16RealizePalette;      External 'PMWin'    INDEX 321;

  FUNCTION DummyHelpEntry;           External 'PMWin'    INDEX 322;
}
(* ====================================================== *)

  FUNCTION WinDeleteLibrary;         EXTERNAL 'PMWin'    INDEX 602;
  FUNCTION Win16DeleteLibrary;       EXTERNAL 'PMWin'    INDEX 602;

  FUNCTION WinLoadProcedure;         EXTERNAL 'PMWin'    INDEX 603;
  FUNCTION Win16LoadProcedure;       EXTERNAL 'PMWin'    INDEX 603;

  FUNCTION WinDeleteProcedure;       EXTERNAL 'PMWin'    INDEX 604;
  FUNCTION Win16DeleteProcedure;     EXTERNAL 'PMWin'    INDEX 604;

  FUNCTION WinSetMsgMode;            EXTERNAL 'PMWin'    INDEX 605;
  FUNCTION Win16SetMsgMode;          EXTERNAL 'PMWin'    INDEX 605;

  FUNCTION WinSetSynchroMode;        EXTERNAL 'PMWin'    INDEX 606;
  FUNCTION Win16SetSynchroMode;      EXTERNAL 'PMWin'    INDEX 606;

  FUNCTION WinGetDlgMsg;             EXTERNAL 'PMWin'    INDEX 607;
  FUNCTION Win16GetDlgMsg;           EXTERNAL 'PMWin'    INDEX 607;

  FUNCTION WinRegisterUserMsg;       EXTERNAL 'PMWin'    INDEX 608;
  FUNCTION Win16RegisterUserMsg;     EXTERNAL 'PMWin'    INDEX 608;

  FUNCTION WinQueryAnchorBlock;      EXTERNAL 'PMWin'    INDEX 609;
  FUNCTION Win16QueryAnchorBlock;    EXTERNAL 'PMWin'    INDEX 609;

(* ====================================================*)

  FUNCTION WinRegisterUserDatatype;  EXTERNAL 'PMWin'    INDEX 612;
  FUNCTION Win16RegisterUserDatatype;EXTERNAL 'PMWin'    INDEX 612;

(* ====================================================*)

  FUNCTION WinIsWindowShowing;       EXTERNAL 'PMWin'    INDEX 614;
  FUNCTION Win16IsWindowShowing;     EXTERNAL 'PMWin'    INDEX 614;

  FUNCTION WinLoadLibrary;           EXTERNAL 'PMWin'    INDEX 615;
  FUNCTION Win16LoadLibrary;         EXTERNAL 'PMWin'    INDEX 615;

  FUNCTION WinCreatePointerIndirect; EXTERNAL 'PMWin'    INDEX 616;
  FUNCTION Win16CreatePointerIndirect;EXTERNAL 'PMWin'   INDEX 616;

  FUNCTION WinQueryPointerInfo;      EXTERNAL 'PMWin'    INDEX 617;
  FUNCTION Win16QueryPointerInfo;    EXTERNAL 'PMWin'    INDEX 617;

(* ====================================================*)
{
  FUNCTION WinGetErasePS;            External 'PMWin'    INDEX 624;
  FUNCTION Win16GetErasePS;          External 'PMWin'    INDEX 624;

  FUNCTION WinReleaseErasePS;        External 'PMWin'    INDEX 625;
  FUNCTION Win16ReleaseErasePS;      External 'PMWin'    INDEX 625;
}
(* ====================================================*)
{
  FUNCTION WinStretchPointer;        External 'PMWin'    INDEX 632;
  FUNCTION Win16StretchPointer;      External 'PMWin'    INDEX 632;

  FUNCTION WinSetPointerOwner;       External 'PMWin'    INDEX 633;
  FUNCTION Win16SetPointerOwner;     External 'PMWin'    INDEX 633;
}
(* ====================================================== *)
(*                         32 Bit                         *)
{                      NOT IMPLEMENTED
  FUNCTION Win32AddAtom;
    External 'PMWin'    INDEX 700;

  FUNCTION Win32Alarm;
    External 'PMWin'    INDEX 701;

  FUNCTION Win32BeginEnumWindows;
    External 'PMWin'    INDEX 702;

  FUNCTION Win32BeginPaint;
    External 'PMWin'    INDEX 703;

  FUNCTION Win32CalcFrameRect;
    External 'PMWin'    INDEX 704;

  FUNCTION Win32CancelShutdown;
    External 'PMWin'    INDEX 705;

  FUNCTION Win32CloseClipbrd;
    External 'PMWin'    INDEX 707;

  FUNCTION Win32CompareStrings;
    External 'PMWin'    INDEX 708;

  FUNCTION Win32CopyAccelTable;
    External 'PMWin'    INDEX 709;

  FUNCTION Win32CopyRect;
    External 'PMWin'    INDEX 710;

  FUNCTION Win32CpTranslateChar;
    External 'PMWin'    INDEX 711;

  FUNCTION Win32CpTranslateString;
    External 'PMWin'    INDEX 712;

  FUNCTION Win32CreateAccelTable;
    External 'PMWin'    INDEX 713;

  FUNCTION Win32CreateAtomTable;
    External 'PMWin'    INDEX 714;

  FUNCTION Win32CreateCursor;
    External 'PMWin'    INDEX 715;

  FUNCTION Win32CreateMsgQueue;
    External 'PMWin'    INDEX 716;

  FUNCTION Win32CreatePointer;
    External 'PMWin'    INDEX 717;

  FUNCTION Win32DdeInitiate;
    External 'PMWin'    INDEX 718;

  FUNCTION Win32DdePostMsg;
    External 'PMWin'    INDEX 719;

  FUNCTION Win32DdeRespond;
    External 'PMWin'    INDEX 720;

  FUNCTION Win32DeleteAtom;
    External 'PMWin'    INDEX 721;

  FUNCTION Win32DeleteLibrary;
    External 'PMWin'    INDEX 722;

  FUNCTION Win32DestroyAccelTable;
    External 'PMWin'    INDEX 723;

  FUNCTION Win32DestroyAtomTable;
    External 'PMWin'    INDEX 724;

  FUNCTION Win32DestroyCursor;
    External 'PMWin'    INDEX 725;

  FUNCTION Win32DestroyMsgQueue;
    External 'PMWin'    INDEX 726;

  FUNCTION Win32DestroyPointer;
    External 'PMWin'    INDEX 727;

  FUNCTION Win32DestroyWindow;
    External 'PMWin'    INDEX 728;

  FUNCTION Win32DismissDlg;
    External 'PMWin'    INDEX 729;
  
  FUNCTION Win32DrawBitmap;
    External 'PMWin'    INDEX 730;
  
  FUNCTION Win32DrawBorder;
    External 'PMWin'    INDEX 731;

  FUNCTION Win32DrawPointer;
    External 'PMWin'    INDEX 732;
  
  FUNCTION Win32EmptyClipbrd;
    External 'PMWin'    INDEX 733;
  
  FUNCTION Win32EnablePhysInput;
    External 'PMWin'    INDEX 734;
  
  FUNCTION Win32EnableWindow;
    External 'PMWin'    INDEX 735;

  FUNCTION Win32EnableWindowUpdate;
    External 'PMWin'    INDEX 736;
  
  FUNCTION Win32EndEnumWindows;
    External 'PMWin'    INDEX 737;
  
  FUNCTION Win32EndPaint;
    External 'PMWin'    INDEX 738;
  
  FUNCTION Win32EnumClipbrdFmts;
    External 'PMWin'    INDEX 739;
  
  FUNCTION Win32EnumDlgItem;
    External 'PMWin'    INDEX 740;
  
  FUNCTION Win32EqualRect;
    External 'PMWin'    INDEX 741;
  
  FUNCTION Win32ExcludeUpdateRegion;
    External 'PMWin'    INDEX 742;
  
  FUNCTION Win32FillRect;
    External 'PMWin'    INDEX 743;
  
  FUNCTION Win32FindAtom;
    External 'PMWin'    INDEX 744;
  
  FUNCTION Win32FlashWindow;
    External 'PMWin'    INDEX 745;
  
  FUNCTION Win32FocusChange;
    External 'PMWin'    INDEX 746;
  
  FUNCTION Win32FreeErrorInfo;
    External 'PMWin'    INDEX 748;
  
  FUNCTION Win32GetClipPS;
    External 'PMWin'    INDEX 749;
  
  FUNCTION Win32GetCurrentTime;
    External 'PMWin'    INDEX 750;
  
  FUNCTION Win32GetErrorInfo;
    External 'PMWin'    INDEX 751;

  FUNCTION Win32GetKeyState;
    External 'PMWin'    INDEX 752;
  
  FUNCTION Win32GetLastError;
    External 'PMWin'    INDEX 753;
  
  FUNCTION Win32GetMaxPosition;
    External 'PMWin'    INDEX 754;
  
  FUNCTION Win32GetMinPosition;
    External 'PMWin'    INDEX 755;
  
  FUNCTION Win32GetNextWindow;
    External 'PMWin'    INDEX 756;

  FUNCTION Win32GetPS;
    External 'PMWin'    INDEX 757;
  
  FUNCTION Win32GetPhysKeyState;
    External 'PMWin'    INDEX 758;
  
  FUNCTION Win32GetScreenPS;
    External 'PMWin'    INDEX 759;
  
  FUNCTION Win32GetSysBitmap;
    External 'PMWin'    INDEX 760;
  
  FUNCTION Win32InSendMsg;
    External 'PMWin'    INDEX 761;
  
  FUNCTION Win32InflateRect;
    External 'PMWin'    INDEX 762;
  
  FUNCTION Win32Initialize;
    External 'PMWin'    INDEX 763;
  
  FUNCTION Win32IntersectRect;
    External 'PMWin'    INDEX 764;
  
  FUNCTION Win32InvalidateRect;
    External 'PMWin'    INDEX 765;
  
  FUNCTION Win32InvalidateRegion;
    External 'PMWin'    INDEX 766;
  
  FUNCTION Win32InvertRect;
    External 'PMWin'    INDEX 767;
  
  FUNCTION Win32IsChild;
    External 'PMWin'    INDEX 768;
  
  FUNCTION Win32IsPhysInputEnabled;
    External 'PMWin'    INDEX 769;
  
  FUNCTION Win32IsRectEmpty;
    External 'PMWin'    INDEX 770;

  FUNCTION Win32IsThreadActive;
    External 'PMWin'    INDEX 771;
  
  FUNCTION Win32IsWindow;
    External 'PMWin'    INDEX 772;

  FUNCTION Win32IsWindowEnabled;
    External 'PMWin'    INDEX 773;
  
  FUNCTION Win32IsWindowShowing;
    External 'PMWin'    INDEX 774;
  
  FUNCTION Win32IsWindowVisible;
    External 'PMWin'    INDEX 775;
  
  FUNCTION Win32LoadAccelTable;
    External 'PMWin'    INDEX 776;

  FUNCTION Win32LoadLibrary;
    External 'PMWin'    INDEX 777;
  
  FUNCTION Win32LoadMenu;
    External 'PMWin'    INDEX 778;
  
  FUNCTION Win32LoadMessage;
    External 'PMWin'    INDEX 779;

  FUNCTION Win32LoadPointer;
    External 'PMWin'    INDEX 780;

  FUNCTION Win32LoadString;
    External 'PMWin'    INDEX 781;

  FUNCTION Win32LockVisRegions;
    External 'PMWin'    INDEX 782;

(* ====================================================== *)

  FUNCTION Win32LockWindowUpdate;
    External 'PMWin'    INDEX 784;

  FUNCTION Win32MakePoints;
    External 'PMWin'    INDEX 785;

  FUNCTION Win32MakeRect;
    External 'PMWin'    INDEX 786;
  
  FUNCTION Win32MapDlgPoints;
    External 'PMWin'    INDEX 787;
  
  FUNCTION Win32MapWindowPoints;
    External 'PMWin'    INDEX 788;
  
  FUNCTION Win32MessageBox;
    External 'PMWin'    INDEX 789;
  
  FUNCTION Win32MsgSemWait;
    External 'PMWin'    INDEX 790;
  
  FUNCTION Win32NextChar;
    External 'PMWin'    INDEX 791;
  
  FUNCTION Win32OffSetRect;
    External 'PMWin'    INDEX 792;

  FUNCTION Win32OpenClipbrd;
    External 'PMWin'    INDEX 793;
  
  FUNCTION Win32OpenWindowDC;
    External 'PMWin'    INDEX 794;
  
  FUNCTION Win32PrevChar;
    External 'PMWin'    INDEX 795;
  
  FUNCTION Win32ProcessDlg;
    External 'PMWin'    INDEX 796;
  
  FUNCTION Win32PtInRect;
    External 'PMWin'    INDEX 797;
  
  FUNCTION Win32QueryAccelTable;
    External 'PMWin'    INDEX 798;

  FUNCTION Win32QueryActiveWindow;
    External 'PMWin'    INDEX 799;
  
  FUNCTION Win32QueryAnchorBlock;
    External 'PMWin'    INDEX 800;
  
  FUNCTION Win32QueryAtomLength;
    External 'PMWin'    INDEX 801;
  
  FUNCTION Win32QueryAtomName;
    External 'PMWin'    INDEX 802;
  
  FUNCTION Win32QueryAtomUsage;
    External 'PMWin'    INDEX 803;

  FUNCTION Win32QueryCapture;
    External 'PMWin'    INDEX 804;
  
  FUNCTION Win32QueryClassName;
    External 'PMWin'    INDEX 805;
  
  FUNCTION Win32QueryClipbrdData;
    External 'PMWin'    INDEX 806;
  
  FUNCTION Win32QueryClipbrdFmtInfo;
    External 'PMWin'    INDEX 807;
  
  FUNCTION Win32QueryClipbrdOwner;
    External 'PMWin'    INDEX 808;
  
  FUNCTION Win32QueryClipbrdViewer;
    External 'PMWin'    INDEX 809;
  
  FUNCTION Win32QueryCp;
    External 'PMWin'    INDEX 810;
  
  FUNCTION Win32QueryCpList;
    External 'PMWin'    INDEX 811;
  
  FUNCTION Win32QueryCursorInfo;
    External 'PMWin'    INDEX 812;

  FUNCTION Win32QueryDesktopWindow;
    External 'PMWin'    INDEX 813;
  
  FUNCTION Win32QueryDlgItemShort;
    External 'PMWin'    INDEX 814;
  
  FUNCTION Win32QueryDlgItemText;
    External 'PMWin'    INDEX 815;
  
  FUNCTION Win32QueryDlgItemTextLength;
    External 'PMWin'    INDEX 816;
  
  FUNCTION Win32QueryFocus;
    External 'PMWin'    INDEX 817;

  FUNCTION Win32QueryMsgPos;
    External 'PMWin'    INDEX 818;
  
  FUNCTION Win32QueryMsgTime;
    External 'PMWin'    INDEX 819;
  
  FUNCTION Win32QueryObjectWindow;
    External 'PMWin'    INDEX 820;
  
  FUNCTION Win32QueryPointer;
    External 'PMWin'    INDEX 821;
  
  FUNCTION Win32QueryPointerInfo;
    External 'PMWin'    INDEX 822;
  
  FUNCTION Win32QueryPointerPos;
    External 'PMWin'    INDEX 823;

  FUNCTION Win32QueryQueueInfo;
    External 'PMWin'    INDEX 824;
  
  FUNCTION Win32QueryQueueStatus;
    External 'PMWin'    INDEX 825;
  
  FUNCTION Win32QuerySysColor;
    External 'PMWin'    INDEX 826;
  
  FUNCTION Win32QuerySysModalWindow;
    External 'PMWin'    INDEX 827;
  
  FUNCTION Win32QuerySysPointer;
    External 'PMWin'    INDEX 828;
  
  FUNCTION Win32QuerySysValue;
    External 'PMWin'    INDEX 829;
  
  FUNCTION Win32QuerySystemAtomTable;
    External 'PMWin'    INDEX 830;
  
  FUNCTION Win32QueryUpdateRect;
    External 'PMWin'    INDEX 831;
  
  FUNCTION Win32QueryUpdateRegion;
    External 'PMWin'    INDEX 832;

  FUNCTION Win32QueryVersion;
    External 'PMWin'    INDEX 833;
  
  FUNCTION Win32QueryWindow;
    External 'PMWin'    INDEX 834;
  
  FUNCTION Win32QueryWindowDC;
    External 'PMWin'    INDEX 835;
  
  FUNCTION Win32QueryWindowPos;
    External 'PMWin'    INDEX 837;

  FUNCTION Win32QueryWindowProcess;
    External 'PMWin'    INDEX 838;
  
  FUNCTION Win32QueryWindowPtr;
    External 'PMWin'    INDEX 839;
  
  FUNCTION Win32QueryWindowRect;
    External 'PMWin'    INDEX 840;
  
  FUNCTION Win32QueryWindowText;
    External 'PMWin'    INDEX 841;
  
  FUNCTION Win32QueryWindowTextLength;
    External 'PMWin'    INDEX 842;
  
  FUNCTION Win32QueryWindowULong;
    External 'PMWin'    INDEX 843;
  
  FUNCTION Win32QueryWindowUShort;
    External 'PMWin'    INDEX 844;

  FUNCTION Win32RegisterUserDatatype;
    External 'PMWin'    INDEX 845;
  
  FUNCTION Win32RegisterUserMsg;
    External 'PMWin'    INDEX 846;
  
  FUNCTION Win32ReleasePS;
    External 'PMWin'    INDEX 848;
  
  FUNCTION Win32ScrollWindow;
    External 'PMWin'    INDEX 849;
  
  FUNCTION Win32SetAccelTable;
    External 'PMWin'    INDEX 850;
  
  FUNCTION Win32SetActiveWindow;
    External 'PMWin'    INDEX 851;
  
  FUNCTION Win32SetCapture;
    External 'PMWin'    INDEX 852;
  
  FUNCTION Win32SetClassMsgInterest;
    External 'PMWin'    INDEX 853;
  
  FUNCTION Win32SetClipbrdData;
    External 'PMWin'    INDEX 854;

  FUNCTION Win32SetClipbrdOwner;
    External 'PMWin'    INDEX 855;
  
  FUNCTION Win32SetClipbrdViewer;
    External 'PMWin'    INDEX 856;
  
  FUNCTION Win32SetCp;
    External 'PMWin'    INDEX 857;

  FUNCTION Win32SetDlgItemShort;
    External 'PMWin'    INDEX 858;
  
  FUNCTION Win32SetDlgItemText;
    External 'PMWin'    INDEX 859;
  
  FUNCTION Win32SetFocus;
    External 'PMWin'    INDEX 860;
  
  FUNCTION Win32SetMsgInterest;
    External 'PMWin'    INDEX 861;
  
  FUNCTION Win32SetMsgMode;
    External 'PMWin'    INDEX 862;
  
  FUNCTION Win32SetMultWindowPos;
    External 'PMWin'    INDEX 863;
  
  FUNCTION Win32SetOwner;
    External 'PMWin'    INDEX 864;
  
  FUNCTION Win32SetParent;
    External 'PMWin'    INDEX 865;

  FUNCTION Win32SetPointer;
    External 'PMWin'    INDEX 866;
  
  FUNCTION Win32SetPointerPos;
    External 'PMWin'    INDEX 867;
  
  FUNCTION Win32SetRect;
    External 'PMWin'    INDEX 868;
  
  FUNCTION Win32SetRectEmpty;
    External 'PMWin'    INDEX 869;
  
  FUNCTION Win32SetSynchroMode;
    External 'PMWin'    INDEX 870;
  
  FUNCTION Win32SetSysColors;
    External 'PMWin'    INDEX 871;
  
  FUNCTION Win32SetSysModalWindow;
    External 'PMWin'    INDEX 872;
  
  FUNCTION Win32SetSysValue;
    External 'PMWin'    INDEX 873;
  
  FUNCTION Win32SetWindowBits;
    External 'PMWin'    INDEX 874;

  FUNCTION Win32SetWindowPos;
    External 'PMWin'    INDEX 875;
  
  FUNCTION Win32SetWindowPtr;
    External 'PMWin'    INDEX 876;

  FUNCTION Win32SetWindowText;
    External 'PMWin'    INDEX 877;
  
  FUNCTION Win32SetWindowULong;
    External 'PMWin'    INDEX 878;
  
  FUNCTION Win32SetWindowUShort;
    External 'PMWin'    INDEX 879;
  
  FUNCTION Win32ShowCursor;
    External 'PMWin'    INDEX 880;
  
  FUNCTION Win32ShowPointer;
    External 'PMWin'    INDEX 881;
  
  FUNCTION Win32ShowTrackRect;
    External 'PMWin'    INDEX 882;
  
  FUNCTION Win32ShowWindow;
    External 'PMWin'    INDEX 883;
  
  FUNCTION Win32StartTimer;
    External 'PMWin'    INDEX 884;
  
  FUNCTION Win32StopTimer;
    External 'PMWin'    INDEX 885;

  FUNCTION Win32SubstituteStrings;
    External 'PMWin'    INDEX 886;
  
  FUNCTION Win32SubtractRect;
    External 'PMWin'    INDEX 887;

  FUNCTION Win32Terminate;
    External 'PMWin'    INDEX 888;

(* ====================================================== *)

  FUNCTION Win32TrackRect;
    External 'PMWin'    INDEX 890;
  
  FUNCTION Win32UnionRect;
    External 'PMWin'    INDEX 891;
  
  FUNCTION Win32UpdateWindow;
    External 'PMWin'    INDEX 892;

  FUNCTION Win32Upper;
    External 'PMWin'    INDEX 893;
  
  FUNCTION Win32UpperChar;
    External 'PMWin'    INDEX 894;

  FUNCTION Win32ValidateRect;
    External 'PMWin'    INDEX 895;
  
  FUNCTION Win32ValidateRegion;
    External 'PMWin'    INDEX 896;
  
  FUNCTION Win32WaitMsg;
    External 'PMWin'    INDEX 897;
  
  FUNCTION Win32WindowFromDC;
    External 'PMWin'    INDEX 898;
  
  FUNCTION Win32WindowFromID;
    External 'PMWin'    INDEX 899;
  
  FUNCTION Win32WindowFromPoint;
    External 'PMWin'    INDEX 900;
  
  FUNCTION Win32BroadcastMsg;
    External 'PMWin'    INDEX 901;

  FUNCTION Win32PostQueueMsg;
    External 'PMWin'    INDEX 902;
  
  FUNCTION Win32SendDlgItemMsg;
    External 'PMWin'    INDEX 903;
  
  FUNCTION Win32TranslateAccel;
    External 'PMWin'    INDEX 904;
  
  FUNCTION Win32CallMsgFilter;
    External 'PMWin'    INDEX 905;
  
  FUNCTION Win32CreateFrameControls;
    External 'PMWin'    INDEX 906;
  
  FUNCTION Win32CreateMenu;
    External 'PMWin'    INDEX 907;
  
  FUNCTION Win32CreateStdWindow;
    External 'PMWin'    INDEX 908;

  FUNCTION Win32CreateWindow;
    External 'PMWin'    INDEX 909;
  
  FUNCTION Win32DefDlgProc;
    External 'PMWin'    INDEX 910;
  
  FUNCTION Win32DefWindowProc;
    External 'PMWin'    INDEX 911;
  
  FUNCTION Win32DispatchMsg;
    External 'PMWin'    INDEX 912;

  FUNCTION Win32DrawText;
    External 'PMWin'    INDEX 913;

  FUNCTION Win32GetDlgMsg;
    External 'PMWin'    INDEX 914;
  
  FUNCTION Win32GetMsg;
    External 'PMWin'    INDEX 915;
  
  FUNCTION Win32MsgMuxSemWait;
    External 'PMWin'    INDEX 916;
  
  FUNCTION Win32MultWindowFromIDs;
    External 'PMWin'    INDEX 917;
  
  FUNCTION Win32PeekMsg;
    External 'PMWin'    INDEX 918;
  
  FUNCTION Win32PostMsg;
    External 'PMWin'    INDEX 919;
  
  FUNCTION Win32SendMsg;
    External 'PMWin'    INDEX 920;
  
  FUNCTION Win32SetKeyboardStateTable;
    External 'PMWin'    INDEX 921;

  FUNCTION Win32CreateDlg;
    External 'PMWin'    INDEX 922;
  
  FUNCTION Win32DlgBox;
    External 'PMWin'    INDEX 923;
  
  FUNCTION Win32LoadDlg;
    External 'PMWin'    INDEX 924;
  
  FUNCTION Win32QueryClassInfo;
    External 'PMWin'    INDEX 925;
  
  FUNCTION Win32RegisterClass;
    External 'PMWin'    INDEX 926;
  
  FUNCTION Win32ReleaseHook;
    External 'PMWin'    INDEX 927;

  FUNCTION Win32SetHook;
    External 'PMWin'    INDEX 928;
  
  FUNCTION Win32SubclassWindow;
    External 'PMWin'    INDEX 929;
  
  FUNCTION Win32SetClassThunkProc;
    External 'PMWin'    INDEX 930;
  
  FUNCTION Win32QueryClassThunkProc;
    External 'PMWin'    INDEX 931;
  
  FUNCTION Win32SetWindowThunkProc;
    External 'PMWin'    INDEX 932;

  FUNCTION Win32QueryWindowThunkProc;
    External 'PMWin'    INDEX 933;
  
  FUNCTION Win32QueryWindowModel;
    External 'PMWin'    INDEX 934;
  
  FUNCTION Win32SetDesktopBkgnd;
    External 'PMWin'    INDEX 935;
  
  FUNCTION Win32QueryDesktopBkgnd;
    External 'PMWin'    INDEX 936;
  
  FUNCTION Win32PopupMenu;
    External 'PMWin'    INDEX 937;
  
  FUNCTION Win32SetPresParam;
    External 'PMWin'    INDEX 938;
  
  FUNCTION Win32QueryPresParam;
    External 'PMWin'    INDEX 939;

  FUNCTION Win32RemovePresParam;
    External 'PMWin'    INDEX 940;
  
  FUNCTION Win32RealizePalette;
    External 'PMWin'    INDEX 941;

  FUNCTION Win32CreatePointerIndirect;
    External 'PMWin'    INDEX 942;
  
  FUNCTION Win32SaveWindowPos;
    External 'PMWin'    INDEX 943;
  
  FUNCTION Win32GetErasePS;
    External 'PMWin'    INDEX 952;
  
  FUNCTION Win32ReleaseErasePS;
    External 'PMWin'    INDEX 953;
}
(* ====================================================== *)
(*                         16 Bit                         *)

{
  FUNCTION WinSetClassThunkProc;    External 'PMWin'    INDEX 959;
  FUNCTION Win16SetClassThunkProc;  External 'PMWin'    INDEX 959;

  FUNCTION WinQueryClassThunkProc;  External 'PMWin'    INDEX 960;
  FUNCTION Win16QueryClassThunkProc;External 'PMWin'    INDEX 960;

  FUNCTION WinSetWindowThunkProc;   External 'PMWin'    INDEX 961;
  FUNCTION Win16SetWindowThunkProc; External 'PMWin'    INDEX 961;

  FUNCTION WinQueryWindowThunkProc; External 'PMWin'    INDEX 962;
  FUNCTION Win16QueryWindowThunkProc;External 'PMWin'   INDEX 962;

}
(* ====================================================== *)
(*                         32 Bit                         *)
{                     NOT IMPLEMENTED

  FUNCTION Win32StretchPointer;
    External 'PMWin'    INDEX 968;

(* ====================================================== *)

  FUNCTION Win32SetPointerOwner;
    External 'PMWin'    INDEX 971;

(* ====================================================== *)

  FUNCTION Win32SetErrorInfo;
    External 'PMWin'    INDEX 977;

  FUNCTION Win32WaitEventSem;
    External 'PMWin'    INDEX 978;

  FUNCTION Win32RequestMutexSem;
    External 'PMWin'    INDEX 979;

  FUNCTION Win32WaitMuxWaitSem;
    External 'PMWin'    INDEX 980;

(* ====================================================== *)

  FUNCTION Win32LoadProcedure;   External 'PMWin' INDEX 986;
  FUNCTION Win32DeleteProcedure; External 'PMWin' INDEX 987;
}

END.

(* ======================================================= *)
(*                     Ende von PMWIN.PAS                  *)