(* ====================================================== *)
(*                         PMMLE.PAS                      *)
(*      Implementation of the MLE window styles           *)
(*       Translated to Pascal by wr/toolbox mag           *)
(* ====================================================== *)
{$IFNDEF OS2}
  Error: Wrong target/Compiler not patched
{$ENDIF}

UNIT PmMle;

INTERFACE

USES Os2Def;

(**********************************************************
* MLE Window styles ( in addition to WS_* )
\**********************************************************)
CONST
  MLS_WORDWRAP      = $00000001;
  MLS_BORDER        = $00000002;
  MLS_VSCROLL       = $00000004;
  MLS_HSCROLL       = $00000008;
  MLS_READONLY      = $00000010;
  MLS_IGNORETAB     = $00000020;

(***********************************************************
* MLE External Data Types
\**********************************************************)
TYPE
  Ipt  = LongInt;  (* insertion point      *)
  pIpt = ^Ipt;     (* insertion point      *)
  Pix  = LongInt;  (* pixel                *)
  Line = LongInt;  (* Line number          *)

TYPE
  (* MLEFRD format rectangle data  *)
  MLEformatRect = RECORD
    cxFormat : LongInt;     (* format rectangle width    *)
    cyFormat : LongInt;     (* format rectangle height    *)
  END;

  (* MLECTL control data      *)
  MLECtlData = RECORD
    cbCtlData  : WORD;         (* Length of the MLECTLDATA structure  *)
    afIEFormat : WORD;         (* import/export format     *)
    cchText    : LongInt;      (* text limit        *)
    iptAnchor  : Ipt;          (* beginning of selection    *)
    iptCursor  : Ipt;          (* ending of selection      *)
    cxFormat   : LongInt;      (* format rectangle width    *)
    cyFormat   : LongInt;      (* format rectangle height    *)
    afFormatFlags  : LongInt;  (* formatting rectangle flags    *)
  END;

(***********************************************************
* afFormatFlags mask
\**********************************************************)
CONST MLFFMTRECT_LIMITHORZ    = $00000001;
CONST MLFFMTRECT_LIMITVERT    = $00000002;
CONST MLFFMTRECT_MATCHWINDOW  = $00000004;
CONST MLFFMTRECT_FORMATRECT   = $00000007;
(***********************************************************
* afIEFormat - Import/Export Format flags
\**********************************************************)
CONST MLFIE_CFTEXT     = 0;
CONST MLFIE_NOTRANS    = 1;
CONST MLFIE_WINFMT     = 2;
CONST MLFIE_RTF        = 3;

(***********************************************************
* MLN_OVERFLOW structure
\**********************************************************)
TYPE
  MLEOverFlow = RECORD (* MLEOVR overflow structure        *)
    afErrInd     : LongInt;   (* see mask below          *)
    nBytesOver   : LongInt;  (* number of bytes overflowed        *)
    pixHorzOver  : LongInt;  (* number of pixels horizontally overflowed *)
    pixVertOver  : LongInt;  (* number of pixels vertically overflowed   *)
  END;

(***********************************************************
* afErrInd - error format rectangle flags
\**********************************************************)
CONST MLFEFR_RESIZE     = $00000001;
CONST MLFEFR_TABSTOP    = $00000002;
CONST MLFEFR_FONT       = $00000004;
CONST MLFEFR_TEXT       = $00000008;
CONST MLFEFR_WORDWRAP   = $00000010;
CONST MLFETL_TEXTBYTES  = $00000020;

(***********************************************************
* MLN_MARGIN structure
\**********************************************************)

TYPE
  MLEMargStruct = RECORD (* MLEMRG margin structure     *)
    afMargins : WORD;    (* margin indicator       *)
    usMouMsg  : WORD;    (* mouse message       *)
    iptNear   : Ipt;     (* geometrically nearest insertion point *)
  END;

(***********************************************************
* afFlags - margin notification indicators
\**********************************************************)
CONST MLFMARGIN_LEFT    = 0001;
CONST MLFMARGIN_BOTTOM  = 0002;
CONST MLFMARGIN_RIGHT   = 0003;
CONST MLFMARGIN_TOP     = 0004;

(***********************************************************
* MLM_QUERYSELECTION flags
\**********************************************************)
CONST MLFQS_MINMAXSEL   = 0;
CONST MLFQS_MINSEL      = 1;
CONST MLFQS_MAXSEL      = 2;
CONST MLFQS_ANCHORSEL   = 3;
CONST MLFQS_CURSORSEL   = 4;

(***********************************************************
* MLN_CLPBDFAIL flags
\**********************************************************)
CONST MLFCLPBD_TOOMUCHTEXT  = $00000001;
CONST MLFCLPBD_ERROR        = $00000002;

(***********************************************************
* MLM_SEARCH structure
\**********************************************************)
TYPE
  MLE_SearchData = RECORD (* mlesrch *)
    cb          : WORD;    (* size of search spec structure  *)
    pchFind     : pCh;     (* string to search for     *)
    pchReplace  : pCh;     (* string to replace with    *)
    cchFind     : INTEGER;  (* length of pchFindString    *)
    cchReplace  : INTEGER;  (* length of replace string    *)
    iptStart    : Ipt;    (* point at which to start search  *)
          (* (negative indicates cursor pt)  *)
          (* becomes pt where string found  *)
    iptStop    : Ipt;     (* point at which to stop search  *)
          (* (negative indicates EOT)    *)
    cchFound  : WORD;  (* Length of found string at iptStart  *)
  END;

(********************************       ********************
* MLM_SEARCH style flags
\********************************       *******************)
CONST MLFSEARCH_CASESENSITIVE   = $00000001;
CONST MLFSEARCH_SELECTMATCH     = $00000002;
CONST MLFSEARCH_CHANGEALL       = $00000004;

(********************************       ********************
* MLE messages - MLM from = 01b0 to = 01de; MLN from = 0001 to = 000f
\**********************************************************)
(* formatting messages *)
CONST MLM_SETTEXTLIMIT    = $01B0;
CONST MLM_QUERYTEXTLIMIT  = $01B1;
CONST MLM_SETFORMATRECT   = $01B2;
CONST MLM_QUERYFORMATRECT = $01B3;
CONST MLM_SETWRAP         = $01B4;
CONST MLM_QUERYWRAP       = $01B5;
CONST MLM_SETTABSTOP      = $01B6;
CONST MLM_QUERYTABSTOP    = $01B7;
CONST MLM_SETREADONLY     = $01B8;
CONST MLM_QUERYREADONLY   = $01B9;

(* text content manipulation and queries messages *)
CONST MLM_QUERYCHANGED    = $01BA;
CONST MLM_SETCHANGED      = $01BB;
CONST MLM_QUERYLINECOUNT  = $01BC;
CONST MLM_CHARFROMLINE    = $01BD;
CONST MLM_LINEFROMCHAR    = $01BE;
CONST MLM_QUERYLINELENGTH = $01BF;
CONST MLM_QUERYTEXTLENGTH = $01C0;

(* text import and export messages *)
CONST MLM_FORMAT                = $01C1;
CONST MLM_SETIMPORTEXPORT       = $01C2;
CONST MLM_IMPORT                = $01C3;
CONST MLM_EXPORT                = $01C4;
CONST MLM_DELETE                = $01C6;
CONST MLM_QUERYFORMATLINELENGTH = $01C7;
CONST MLM_QUERYFORMATTEXTLENGTH = $01C8;
CONST MLM_INSERT                = $01C9;

(* selection messages *)
CONST MLM_SETSEL                = $01CA;
CONST MLM_QUERYSEL              = $01CB;
CONST MLM_QUERYSELTEXT          = $01CC;

(* undo and redo messages *)
CONST MLM_QUERYUNDO             = $01CD;
CONST MLM_UNDO                  = $01CE;
CONST MLM_RESETUNDO             = $01CF;

(* text attributes messages *)
CONST MLM_QUERYFONT             = $01D0;
CONST MLM_SETFONT               = $01D1;
CONST MLM_SETTEXTCOLOR          = $01D2;
CONST MLM_QUERYTEXTCOLOR        = $01D3;
CONST MLM_SETBACKCOLOR          = $01D4;
CONST MLM_QUERYBACKCOLOR        = $01D5;

(* scrolling messages *)
CONST MLM_QUERYFIRSTCHAR        = $01D6;
CONST MLM_SETFIRSTCHAR          = $01D7;

(* clipboard messages *)
CONST MLM_CUT                   = $01D8;
CONST MLM_COPY                  = $01D9;
CONST MLM_PASTE                 = $01DA;
CONST MLM_CLEAR                 = $01DB;

(* display manipulation messages *)
CONST MLM_ENABLEREFRESH         = $01DC;
CONST MLM_DISABLEREFRESH        = $01DD;

(* search message *)
CONST MLM_SEARCH                = $01DE;
CONST MLM_QUERYIMPORTEXPORT     = $01DF;

(* notification messages *)
CONST MLN_OVERFLOW              = $0001;
CONST MLN_PIXHORZOVERFLOW       = $0002;
CONST MLN_PIXVERTOVERFLOW       = $0003;
CONST MLN_TEXTOVERFLOW          = $0004;
CONST MLN_VSCROLL               = $0005;
CONST MLN_HSCROLL               = $0006;
CONST MLN_CHANGE                = $0007;
CONST MLN_SETFOCUS              = $0008;
CONST MLN_KILLFOCUS             = $0009;
CONST MLN_MARGIN                = $000A;
CONST MLN_SEARCHPAUSE           = $000B;
CONST MLN_MEMERROR              = $000C;
CONST MLN_UNDOOVERFLOW          = $000D;
CONST MLN_CLPBDFAIL             = $000F;

IMPLEMENTATION
END.

(* ====================================================== *)
(*                      Ende von PMMLE.PAS                *)
