(* ====================================================== *)
(*                         MSG.PAS                        *)
(*     Implementation of the functions of MSG.DLL         *)
(*        Translated to Pascal by wr/toolbox mag          *)
(* ====================================================== *)
{$IFNDEF OS2}
  Error: Wrong target/Compiler not patched
{$ENDIF}

UNIT Msg;

INTERFACE

USES
  Os2Def;

(* Get a message from a message file and incorporate variable information *)
{
FUNCTION DosGetMessage (DOSGETMESSAGE) (
    IvTable             : Pointer;      (* array of pointers to strings *)
    IvCount             : WORD;     (* number of strings in above *)
    DataArea            : pChar;       (* address of buffer to get output *)
    DataLength          : WORD;     (* size of above buffer *)
    MsgNumber           : WORD;     (* the number of the message *)
    FileName            : pChar;       (* path name of message file *)
    VAR MsgLength       : WORD)     (* returned length of message *)
    : WORD;
}

FUNCTION DosInsMessage(
    IvTable             : Pointer;      (* array of pointers to strings *)
    IvCount             : WORD;     (* number of strings in above *)
    MsgInput            : pChar;       (* address of the message *)
    MsgInLength         : WORD;     (* length of input message *)
    DataArea            : pChar;       (* address of buffer to get output *)
    DataLength          : WORD;     (* size of above buffer *)
    VAR MsgLength       : WORD      (* returned length of message *)
    ) : WORD;

FUNCTION DosPutMessage(
    FileHandle          : WORD;     (* handle to write to *)
    MessageLength       : WORD;     (* length of message *)
    MessageBuffer       : Pointer       (* address of message buffer *)
    ) : WORD;
FUNCTION Dos16InsMessage(
    IvTable             : Pointer;      (* array of pointers to strings *)
    IvCount             : WORD;     (* number of strings in above *)
    MsgInput            : pChar;       (* address of the message *)
    MsgInLength         : WORD;     (* length of input message *)
    DataArea            : pChar;       (* address of buffer to get output *)
    DataLength          : WORD;     (* size of above buffer *)
    VAR MsgLength       : WORD      (* returned length of message *)
    ) : WORD;

FUNCTION Dos16PutMessage(
    FileHandle          : WORD;     (* handle to write to *)
    MessageLength       : WORD;     (* length of message *)
    MessageBuffer       : Pointer       (* address of message buffer *)
    ) : WORD;

IMPLEMENTATION

  FUNCTION DosPutMessage;     EXTERNAL 'Msg'      INDEX   1;
  FUNCTION Dos16PutMessage;   EXTERNAL 'Msg'      INDEX   1;
{
  FUNCTION DosTrueGetMessage; External 'Msg'      INDEX   2;
}
  FUNCTION DosInsMessage;     EXTERNAL 'Msg'      INDEX   3;

  FUNCTION Dos16InsMessage;   EXTERNAL 'Msg'      INDEX   3;

(* ====================================================== *)
(*                         32 Bit                         *)
{
  FUNCTION Dos32InsertMessage(* ------------- *);
    External 'Msg'      INDEX   4;

  FUNCTION Dos32PutMessage(* ------------- *);
    External 'Msg'      INDEX   5;

  FUNCTION Dos32TrueGetMessage(* ------------- *);
    External 'Msg'      INDEX   6;

  FUNCTION DosIQueryMessageCP(* ------------- *);
    External 'Msg'      INDEX   7;

  FUNCTION Dos32IQueryMessageCP(* ------------- *);
    External 'Msg'      INDEX   8;
}
END.

(* ====================================================== *)
