(* ====================================================== *)
(*                         OS2ERROR.PAS                   *)
(*           Implementation of the OS/2 error codes       *)
(*           Translation to Pascal by jb/toolbox mag      *)
(* =====================================================  *)

{$IFNDEF OS2}
  Error: Wrong target/Compiler not patched
{$ENDIF}

UNIT Os2Error;

INTERFACE

CONST
    NO_ERROR                            = 0;

    ERROR_INVALID_FUNCTION              = 1;
    ERROR_FILE_NOT_FOUND                = 2;
    ERROR_PATH_NOT_FOUND                = 3;
    ERROR_TOO_MANY_OPEN_FILES           = 4;
    ERROR_ACCESS_DENIED                 = 5;
    ERROR_INVALID_HANDLE                = 6;
    ERROR_ARENA_TRASHED                 = 7;
    ERROR_NOT_ENOUGH_MEMORY             = 8;
    ERROR_INVALID_BLOCK                 = 9;
    ERROR_BAD_ENVIRONMENT               = 10;
    ERROR_BAD_FORMAT                    = 11;
    ERROR_INVALID_ACCESS                = 12;
    ERROR_INVALID_DATA                  = 13;
(* 14 is reserved                        *)
    ERROR_INVALID_DRIVE                 = 15;
    ERROR_CURRENT_DIRECTORY             = 16;
    ERROR_NOT_SAME_DEVICE               = 17;
    ERROR_NO_MORE_FILES                 = 18;
    ERROR_WRITE_PROTECT                 = 19;
    ERROR_BAD_UNIT                      = 20;
    ERROR_NOT_READY                     = 21;
    ERROR_BAD_COMMAND                   = 22;
    ERROR_CRC                           = 23;
    ERROR_BAD_LENGTH                    = 24;
    ERROR_SEEK                          = 25;
    ERROR_NOT_DOS_DISK                  = 26;
    ERROR_SECTOR_NOT_FOUND              = 27;
    ERROR_OUT_OF_PAPER                  = 28;
    ERROR_WRITE_FAULT                   = 29;
    ERROR_READ_FAULT                    = 30;
    ERROR_GEN_FAILURE                   = 31;
    ERROR_SHARING_VIOLATION             = 32;
    ERROR_LOCK_VIOLATION                = 33;
    ERROR_WRONG_DISK                    = 34;
    ERROR_FCB_UNAVAILABLE               = 35;
    ERROR_SHARING_BUFFER_EXCEEDED       = 36;
    ERROR_NOT_SUPPORTED                 = 50;
    ERROR_REM_NOT_LIST                  = 51; (* Remote computer not listening   *)
    ERROR_DUP_NAME                      = 52 ;(* Duplicate name on network       *)
    ERROR_BAD_NETPATH                   = 53; (* Network path not found       *)
    ERROR_NETWORK_BUSY                  = 54; (* Network busy                 *)
    ERROR_DEV_NOT_EXIST                 = 55; (* Network device no longer exists *)
    ERROR_TOO_MANY_CMDS                 = 56; (* Net BIOS command limit exceeded *)
    ERROR_ADAP_HDW_ERR                  = 57; (* Network adapter hardware error  *)
    ERROR_BAD_NET_RESP                  = 58; (* Incorrect response from network *)
    ERROR_UNEXP_NET_ERR                 = 59; (* Unexpected network error             *)
    ERROR_BAD_REM_ADAP                  = 60; (* Incompatible remote adapter     *)
    ERROR_PRINTQ_FULL                   = 61; (* Print queue full                     *)
    ERROR_NO_SPOOL_SPACE                = 62; (* Not enough space for print file *)
    ERROR_PRINT_CANCELLED               = 63; (* Print file was cancelled             *)
    ERROR_NETNAME_DELETED               = 64; (* Network name was deleted             *)
    ERROR_NETWORK_ACCESS_DENIED         = 65; (* Access denied                *)
    ERROR_BAD_DEV_TYPE                  = 66; (* Network device type incorrect   *)
    ERROR_BAD_NET_NAME                  = 67; (* Network name not found       *)
    ERROR_TOO_MANY_NAMES                = 68; (* Network name limit exceeded     *)
    ERROR_TOO_MANY_SESS                 = 69; (* Net BIOS session limit exceeded *)
    ERROR_SHARING_PAUSED                = 70; (* Sharing temporarily paused      *)
    ERROR_REQ_NOT_ACCEP                 = 71; (* Network request not accepted    *)
    ERROR_REDIR_PAUSED                  = 72; (* Print|disk redirection is paused*)
    ERROR_FILE_EXISTS                   = 80;
    ERROR_DUP_FCB                       = 81;
    ERROR_CANNOT_MAKE                   = 82;
    ERROR_FAIL_I24                      = 83;
    ERROR_OUT_OF_STRUCTURES             = 84;
    ERROR_ALREADY_ASSIGNED              = 85;
    ERROR_INVALID_PASSWORD              = 86;
    ERROR_INVALID_PARAMETER             = 87;
    ERROR_NET_WRITE_FAULT               = 88;
    ERROR_NO_PROC_SLOTS                 = 89; (* no process slots available      *)
    ERROR_NOT_FROZEN                    = 90;
    ERR_TSTOVFL                         = 91; (* timer service table overflow    *)
    ERR_TSTDUP                          = 92; (* timer service table duplicate   *)
    ERROR_NO_ITEMS                      = 93; (* no items to operate upon             *)
    ERROR_INTERRUPT                     = 95; (* interrupted system call              *)
    ERROR_DEVICE_IN_USE                 = 99; (* Device in use by another thread *)
    ERROR_TOO_MANY_SEMAPHORES           = 100;
    ERROR_EXCL_SEM_ALREADY_OWNED        = 101;
    ERROR_SEM_IS_SET                    = 102;
    ERROR_TOO_MANY_SEM_REQUESTS         = 103;
    ERROR_INVALID_AT_INTERRUPT_TIME     = 104;
    ERROR_SEM_OWNER_DIED                = 105; (* waitsem found owner died       *)
    ERROR_SEM_USER_LIMIT                = 106; (* too many procs have this sem   *)
    ERROR_DISK_CHANGE                   = 107;
    ERROR_DRIVE_LOCKED                  = 108; (* drive locked by another process*)
    ERROR_BROKEN_PIPE                   = 109; (* write on pipe with no reader   *)
    ERROR_OPEN_FAILED                   = 110; (* open/created failed due to     *)
                                               (* explicit fail command          *)
    ERROR_BUFFER_OVERFLOW               = 111; (* buffer passed to system call   *)
                                               (* is too small to hold return    *)
                                               (* data.                          *)
    ERROR_DISK_FULL                     = 112; (* not enough space on the disk   *)
                                               (* (DOSNEWSIZE/w_NewSize)         *)
    ERROR_NO_MORE_SEARCH_HANDLES        = 113; (* can't allocate another search  *)
                                               (* structure and handle.          *)
                                               (* (DOSFINDFIRST/w_FindFirst)     *)
    ERROR_INVALID_TARGET_HANDLE         = 114; (* Target handle in DOSDUPHANDLE  *)
                                               (* is invalid                     *)
    ERROR_PROTECTION_VIOLATION          = 115; (* Bad user virtual address       *)
    ERROR_VIOKBD_REQUEST                = 116;
    ERROR_INVALID_CATEGORY              = 117; (* Category for DEVIOCTL in not   *)
                                               (* defined                        *)
    ERROR_INVALID_VERIFY_SWITCH         = 118; (* invalid value passed for       *)
                                               (* verify flag                    *)
    ERROR_BAD_DRIVER_LEVEL              = 119; (* DosDevIOCTL looks for a level  *)
                                               (* four driver. If the driver     *)
                                               (* is not level four we return    *)
                                               (* this code                      *)
    ERROR_CALL_NOT_IMPLEMENTED          = 120; (* returned from stub api calls.  *)
                                               (* This call will disappear when  *)
                                               (* all the api's are implemented. *)
    ERROR_SEM_TIMEOUT                   = 121; (* Time out happened from the     *)
                                               (* semaphore api functions.       *)
    ERROR_INSUFFICIENT_BUFFER           = 122; (* Some calls require the              *)
                                               (* application to pass in a buffer     *)
                                               (* filled with data.  This error is    *)
                                               (* returned if the data buffer is too  *)
                                               (* small.  For example: DosSetFileInfo *)
                                               (* requires 4 bytes of data.  If a     *)
                                               (* two byte buffer is passed in then   *)
                                               (* this error is returned.             *)
                                               (* error_buffer_overflow is used when  *)
                                               (* the output buffer in not big enough.*)
    ERROR_INVALID_NAME                  = 123; (* illegal character or malformed *)
                                               (* file system name               *)
    ERROR_INVALID_LEVEL                 = 124; (* unimplemented level for info   *)
                                               (* retrieval or setting           *)
    ERROR_NO_VOLUME_LABEL               = 125; (* no volume label found with     *)
                                               (* DosQFSInfo command             *)
    ERROR_MOD_NOT_FOUND                 = 126; (* w_getprocaddr,w_getmodhandle   *)
    ERROR_PROC_NOT_FOUND                = 127; (* w_getprocaddr               *)
    ERROR_WAIT_NO_CHILDREN              = 128; (* CWait finds to children             *)
    ERROR_CHILD_NOT_COMPLETE            = 129; (* CWait children not dead yet    *)
    ERROR_DIRECT_ACCESS_HANDLE          = 130; (* handle operation is invalid    *)
                                               (* for direct disk access         *)
                                               (* handles                        *)
    ERROR_NEGATIVE_SEEK                 = 131; (* application tried to seek      *)
                                               (* with negitive offset           *)
    ERROR_SEEK_ON_DEVICE                = 132; (* application tried to seek      *)
                                               (* on device or pipe              *)
    ERROR_IS_JOIN_TARGET                = 133;
    ERROR_IS_JOINED                     = 134;
    ERROR_IS_SUBSTED                    = 135;
    ERROR_NOT_JOINED                    = 136;
    ERROR_NOT_SUBSTED                   = 137;
    ERROR_JOIN_TO_JOIN                  = 138;
    ERROR_SUBST_TO_SUBST                = 139;
    ERROR_JOIN_TO_SUBST                 = 140;
    ERROR_SUBST_TO_JOIN                 = 141;
    ERROR_BUSY_DRIVE                    = 142;
    ERROR_SAME_DRIVE                    = 143;
    ERROR_DIR_NOT_ROOT                  = 144;
    ERROR_DIR_NOT_EMPTY                 = 145;
    ERROR_IS_SUBST_PATH                 = 146;
    ERROR_IS_JOIN_PATH                  = 147;
    ERROR_PATH_BUSY                     = 148;
    ERROR_IS_SUBST_TARGET               = 149;
    ERROR_SYSTEM_TRACE                  = 150; (* system trace error          *)
    ERROR_INVALID_EVENT_COUNT           = 151; (* DosMuxSemWait errors        *)
    ERROR_TOO_MANY_MUXWAITERS           = 152;
    ERROR_INVALID_LIST_FORMAT           = 153;
    ERROR_LABEL_TOO_LONG                = 154;
    ERROR_TOO_MANY_TCBS                 = 155;
    ERROR_SIGNAL_REFUSED                = 156;
    ERROR_DISCARDED                     = 157;
    ERROR_NOT_LOCKED                    = 158;
    ERROR_BAD_THREADID_ADDR             = 159;
    ERROR_BAD_ARGUMENTS                 = 160;
    ERROR_BAD_PATHNAME                  = 161;
    ERROR_SIGNAL_PENDING                = 162;
    ERROR_UNCERTAIN_MEDIA               = 163;
    ERROR_MAX_THRDS_REACHED             = 164;
    ERROR_MONITORS_NOT_SUPPORTED        = 165;
    ERROR_UNC_DRIVER_NOT_INSTALLED      = 166;

(*      The following error codes refer to demand loading segments     *)
    ERROR_LOCK_FAILED                   = 167;
    ERROR_SWAPIO_FAILED                 = 168;
    ERROR_SWAPIN_FAILED                 = 169;
    ERROR_BUSY                          = 170;

    ERROR_INVALID_SEGMENT_NUMBER        = 180;
    ERROR_INVALID_CALLGATE              = 181;
    ERROR_INVALID_ORDINAL               = 182;
    ERROR_ALREADY_EXISTS                = 183;
    ERROR_NO_CHILD_PROCESS              = 184;
    ERROR_CHILD_ALIVE_NOWAIT            = 185;
    ERROR_INVALID_FLAG_NUMBER           = 186;
    ERROR_SEM_NOT_FOUND                 = 187;

(* following error codes make loader error messages distinct  *)
    ERROR_INVALID_STARTING_CODESEG      = 188;
    ERROR_INVALID_STACKSEG              = 189;
    ERROR_INVALID_MODULETYPE            = 190;
    ERROR_INVALID_EXE_SIGNATURE         = 191;
    ERROR_EXE_MARKED_INVALID            = 192;
    ERROR_BAD_EXE_FORMAT                = 193;
    ERROR_ITERATED_DATA_EXCEEDS_64K     = 194;
    ERROR_INVALID_MINALLOCSIZE          = 195;
    ERROR_DYNLINK_FROM_INVALID_RING     = 196;
    ERROR_IOPL_NOT_ENABLED              = 197;
    ERROR_INVALID_SEGDPL                = 198;
    ERROR_AUTODATASEG_EXCEEDS_64k       = 199;
    ERROR_RING2SEG_MUST_BE_MOVABLE      = 200;
    ERROR_RELOC_CHAIN_XEEDS_SEGLIM      = 201;
    ERROR_INFLOOP_IN_RELOC_CHAIN        = 202;
    ERROR_ENVVAR_NOT_FOUND              = 203;
    ERROR_NOT_CURRENT_CTRY              = 204;
    ERROR_NO_SIGNAL_SENT                = 205;
    ERROR_FILENAME_EXCED_RANGE          = 206; (* if filename > 8.3 *)
    ERROR_RING2_STACK_IN_USE            = 207; (* for FAPI       *)
    ERROR_META_EXPANSION_TOO_LONG       = 208; (* if "*a" > 8.3  *)
    ERROR_INVALID_SIGNAL_NUMBER         = 209;
    ERROR_THREAD_1_INACTIVE             = 210;
    ERROR_INFO_NOT_AVAIL                = 211;
    ERROR_LOCKED                        = 212;
    ERROR_BAD_DYNALINK                  = 213;
    ERROR_TOO_MANY_MODULES              = 214;
    ERROR_NESTING_NOT_ALLOWED           = 215;
    ERROR_CANNOT_SHRINK                 = 216; (* attempt to shrink ring 2 stack *)
    ERROR_ZOMBIE_PROCESS                = 217;
    ERROR_STACK_IN_HIGH_MEMORY          = 218;
    ERROR_INVALID_EXITROUTINE_RING      = 219;
    ERROR_GETBUF_FAILED                 = 220;
    ERROR_FLUSHBUF_FAILED               = 221;
    ERROR_TRANSFER_TOO_LONG             = 222;
    ERROR_NO_CHILDREN                   = 228;
    ERROR_INVALID_SCREEN_GROUP          = 229;
(*
 * Error codes 230 - 249 are reserved
 *)
    ERROR_BAD_PIPE                      = 230; (* Non-existant pipe or bad operation *)
    ERROR_PIPE_BUSY                     = 231; (* Pipe is busy                *)
    ERROR_NO_DATA                       = 232; (* No data on non-blocking read   *)
    ERROR_PIPE_NOT_CONNECTED            = 233; (* Pipe was disconnected by server*)
    ERROR_MORE_DATA                     = 234; (* More data is available              *)

    ERROR_VC_DISCONNECTED               = 240;
    ERROR_CIRCULARITY_REQUESTED         = 250; (* When renaming a dir which      *)
                                               (* would cause a circularity      *)
    ERROR_DIRECTORY_IN_CDS              = 251; (* When renaming a dir         *)
                                               (* which is "in use"              *)
    ERROR_INVALID_FSD_NAME              = 252; (* when trying to access       *)
                                               (* nonexistent FSD                *)
    ERROR_INVALID_PATH                  = 253; (* bad pseudo device           *)
    ERROR_INVALID_EA_NAME               = 254; (* Illegal chars in name       *)
    ERROR_EA_LIST_INCONSISTENT          = 255; (* Size or some field bad              *)
    ERROR_EA_LIST_TOO_LONG              = 256; (* FEAlist > 64K-1 bytes       *)
    ERROR_NO_META_MATCH                 = 257; (* string doesn't match expression*)
    ERROR_FINDNOTIFY_TIMEOUT            = 258; (* FindNotify request timeout     *)
    ERROR_NO_MORE_ITEMS                 = 259; (* QFSAttach ordinal query             *)
    ERROR_SEARCH_STRUC_REUSED           = 260; (* 3xbox findfirst/next
                                                  search structure reused        *)
    ERROR_CHAR_NOT_FOUND                = 261; (* can not find character              *)
    ERROR_TOO_MUCH_STACK                = 262; (* Stack request exceeds sys limit*)
    ERROR_INVALID_ATTR                  = 263; (* invalid FS_ATTRIBUTE        *)
    ERROR_INVALID_STARTING_RING         = 264;
    ERROR_INVALID_DLL_INIT_RING         = 265;
    ERROR_CANNOT_COPY                   = 266; (* doscopy *)
    ERROR_DIRECTORY                     = 267; (* doscopy *)
    ERROR_OPLOCKED_FILE                 = 268;
    ERROR_OPLOCK_THREAD_EXISTS          = 269;

(* error codes for DosFindNotify *)
    ERROR_VOLUME_CHANGED                = 270;
    ERROR_FINDNOTIFY_HANDLE_IN_USE      = 271;
    ERROR_FINDNOTIFY_HANDLE_CLOSED      = 272;
    ERROR_NOTIFY_OBJECT_REMOVED         = 273;

(* Error to indicate that ShutDown already done *)
    ERROR_ALREADY_SHUTDOWN              = 274;

(* error code for DOSFINDFIRST2/NEXT *)
    ERROR_EAS_DIDNT_FIT                 = 275;

(* error codes for EA file format change *)
    ERROR_EA_FILE_CORRUPT               = 276;
    ERROR_EA_TABLE_FULL                 = 277;
    ERROR_INVALID_EA_HANDLE             = 278;
    ERROR_NO_CLUSTER                    = 279;
    ERROR_CREATE_EA_FILE                = 280;
    ERROR_CANNOT_OPEN_EA_FILE           = 281;

    ERROR_INVALID_PROCID                = 303;
    ERROR_INVALID_PDELTA                = 304;
    ERROR_NOT_DESCENDANT                = 305;
    ERROR_NOT_SESSION_MANAGER           = 306;
    ERROR_INVALID_PCLASS                = 307;
    ERROR_INVALID_SCOPE                 = 308;
    ERROR_INVALID_THREADID              = 309;
    ERROR_DOSSUB_SHRINK                 = 310;
    ERROR_DOSSUB_NOMEM                  = 311;
    ERROR_DOSSUB_OVERLAP                = 312;
    ERROR_DOSSUB_BADSIZE                = 313;
    ERROR_DOSSUB_BADFLAG                = 314;
    ERROR_DOSSUB_BADSELECTOR            = 315;
    ERROR_MR_MSG_TOO_LONG               = 316;
    ERROR_MR_MID_NOT_FOUND              = 317;
    ERROR_MR_UN_ACC_MSGF                = 318;
    ERROR_MR_INV_MSGF_FORMAT            = 319;
    ERROR_MR_INV_IVCOUNT                = 320;
    ERROR_MR_UN_PERFORM                 = 321;
    ERROR_TS_WAKEUP                     = 322;
    ERROR_TS_SEMHANDLE                  = 323;
    ERROR_TS_NOTIMER                    = 324;
    ERROR_TS_HANDLE                     = 326;
    ERROR_TS_DATETIME                   = 327;
    ERROR_SYS_INTERNAL                  = 328;
    ERROR_QUE_CURRENT_NAME              = 329;
    ERROR_QUE_PROC_NOT_OWNED            = 330;
    ERROR_QUE_PROC_OWNED                = 331;
    ERROR_QUE_DUPLICATE                 = 332;
    ERROR_QUE_ELEMENT_NOT_EXIST         = 333;
    ERROR_QUE_NO_MEMORY                 = 334;
    ERROR_QUE_INVALID_NAME              = 335;
    ERROR_QUE_INVALID_PRIORITY          = 336;
    ERROR_QUE_INVALID_HANDLE            = 337;
    ERROR_QUE_LINK_NOT_FOUND            = 338;
    ERROR_QUE_MEMORY_ERROR              = 339;
    ERROR_QUE_PREV_AT_END               = 340;
    ERROR_QUE_PROC_NO_ACCESS            = 341;
    ERROR_QUE_EMPTY                     = 342;
    ERROR_QUE_NAME_NOT_EXIST            = 343;
    ERROR_QUE_NOT_INITIALIZED           = 344;
    ERROR_QUE_UNABLE_TO_ACCESS          = 345;
    ERROR_QUE_UNABLE_TO_ADD             = 346;
    ERROR_QUE_UNABLE_TO_INIT            = 347;
    ERROR_VIO_INVALID_MASK              = 349;
    ERROR_VIO_PTR                       = 350;
    ERROR_VIO_APTR                      = 351;
    ERROR_VIO_RPTR                      = 352;
    ERROR_VIO_CPTR                      = 353;
    ERROR_VIO_LPTR                      = 354;
    ERROR_VIO_MODE                      = 355;
    ERROR_VIO_WIDTH                     = 356;
    ERROR_VIO_ATTR                      = 357;
    ERROR_VIO_ROW                       = 358;
    ERROR_VIO_COL                       = 359;
    ERROR_VIO_TOPROW                    = 360;
    ERROR_VIO_BOTROW                    = 361;
    ERROR_VIO_RIGHTCOL                  = 362;
    ERROR_VIO_LEFTCOL                   = 363;
    ERROR_SCS_CALL                      = 364;
    ERROR_SCS_VALUE                     = 365;
    ERROR_VIO_WAIT_FLAG                 = 366;
    ERROR_VIO_UNLOCK                    = 367;
    ERROR_SGS_NOT_SESSION_MGR           = 368;
    ERROR_SMG_INVALID_SGID              = 369;
    ERROR_SMG_INVALID_SESSION_ID        = 369;
    ERROR_SMG_NOSG                      = 370;
    ERROR_SMG_NO_SESSIONS               = 370;
    ERROR_SMG_GRP_NOT_FOUND             = 371;
    ERROR_SMG_SESSION_NOT_FOUND         = 371;
    ERROR_SMG_SET_TITLE                 = 372;
    ERROR_KBD_PARAMETER                 = 373;
    ERROR_KBD_NO_DEVICE                 = 374;
    ERROR_KBD_INVALID_IOWAIT            = 375;
    ERROR_KBD_INVALID_LENGTH            = 376;
    ERROR_KBD_INVALID_ECHO_MASK         = 377;
    ERROR_KBD_INVALID_INPUT_MASK        = 378;
    ERROR_MON_INVALID_PARMS             = 379;
    ERROR_MON_INVALID_DEVNAME           = 380;
    ERROR_MON_INVALID_HANDLE            = 381;
    ERROR_MON_BUFFER_TOO_SMALL          = 382;
    ERROR_MON_BUFFER_EMPTY              = 383;
    ERROR_MON_DATA_TOO_LARGE            = 384;
    ERROR_MOUSE_NO_DEVICE               = 385;
    ERROR_MOUSE_INV_HANDLE              = 386;
    ERROR_MOUSE_INV_PARMS               = 387;
    ERROR_MOUSE_CANT_RESET              = 388;
    ERROR_MOUSE_DISPLAY_PARMS           = 389;
    ERROR_MOUSE_INV_MODULE              = 390;
    ERROR_MOUSE_INV_ENTRY_PT            = 391;
    ERROR_MOUSE_INV_MASK                = 392;
    NO_ERROR_MOUSE_NO_DATA              = 393;
    NO_ERROR_MOUSE_PTR_DRAWN            = 394;
    ERROR_INVALID_FREQUENCY             = 395;
    ERROR_NLS_NO_COUNTRY_FILE           = 396;
    ERROR_NLS_OPEN_FAILED               = 397;
    ERROR_NLS_NO_CTRY_CODE              = 398;
    ERROR_NO_COUNTRY_OR_CODEPAGE        = 398;
    ERROR_NLS_TABLE_TRUNCATED           = 399;
    ERROR_NLS_BAD_TYPE                  = 400;
    ERROR_NLS_TYPE_NOT_FOUND            = 401;
    ERROR_VIO_SMG_ONLY                  = 402;
    ERROR_VIO_INVALID_ASCIIZ            = 403;
    ERROR_VIO_DEREGISTER                = 404;
    ERROR_VIO_NO_POPUP                  = 405;
    ERROR_VIO_EXISTING_POPUP            = 406;
    ERROR_KBD_SMG_ONLY                  = 407;
    ERROR_KBD_INVALID_ASCIIZ            = 408;
    ERROR_KBD_INVALID_MASK              = 409;
    ERROR_KBD_REGISTER                  = 410;
    ERROR_KBD_DEREGISTER                = 411;
    ERROR_MOUSE_SMG_ONLY                = 412;
    ERROR_MOUSE_INVALID_ASCIIZ          = 413;
    ERROR_MOUSE_INVALID_MASK            = 414;
    ERROR_MOUSE_REGISTER                = 415;
    ERROR_MOUSE_DEREGISTER              = 416;
    ERROR_SMG_BAD_ACTION                = 417;
    ERROR_SMG_INVALID_CALL              = 418;
    ERROR_SCS_SG_NOTFOUND               = 419;
    ERROR_SCS_NOT_SHELL                 = 420;
    ERROR_VIO_INVALID_PARMS             = 421;
    ERROR_VIO_FUNCTION_OWNED            = 422;
    ERROR_VIO_RETURN                    = 423;
    ERROR_SCS_INVALID_FUNCTION          = 424;
    ERROR_SCS_NOT_SESSION_MGR           = 425;
    ERROR_VIO_REGISTER                  = 426;
    ERROR_VIO_NO_MODE_THREAD            = 427;
    ERROR_VIO_NO_SAVE_RESTORE_THD       = 428;
    ERROR_VIO_IN_BG                     = 429;
    ERROR_VIO_ILLEGAL_DURING_POPUP      = 430;
    ERROR_SMG_NOT_BASESHELL             = 431;
    ERROR_SMG_BAD_STATUSREQ             = 432;
    ERROR_QUE_INVALID_WAIT              = 433;
    ERROR_VIO_LOCK                      = 434;
    ERROR_MOUSE_INVALID_IOWAIT          = 435;
    ERROR_VIO_INVALID_HANDLE            = 436;
    ERROR_VIO_ILLEGAL_DURING_LOCK       = 437;
    ERROR_VIO_INVALID_LENGTH            = 438;
    ERROR_KBD_INVALID_HANDLE            = 439;
    ERROR_KBD_NO_MORE_HANDLE            = 440;
    ERROR_KBD_CANNOT_CREATE_KCB         = 441;
    ERROR_KBD_CODEPAGE_LOAD_INCOMPL     = 442;
    ERROR_KBD_INVALID_CODEPAGE_ID       = 443;
    ERROR_KBD_NO_CODEPAGE_SUPPORT       = 444;
    ERROR_KBD_FOCUS_REQUIRED            = 445;
    ERROR_KBD_FOCUS_ALREADY_ACTIVE      = 446;
    ERROR_KBD_KEYBOARD_BUSY             = 447;
    ERROR_KBD_INVALID_CODEPAGE          = 448;
    ERROR_KBD_UNABLE_TO_FOCUS           = 449;
    ERROR_SMG_SESSION_NON_SELECT        = 450;
    ERROR_SMG_SESSION_NOT_FOREGRND      = 451;
    ERROR_SMG_SESSION_NOT_PARENT        = 452;
    ERROR_SMG_INVALID_START_MODE        = 453;
    ERROR_SMG_INVALID_RELATED_OPT       = 454;
    ERROR_SMG_INVALID_BOND_OPTION       = 455;
    ERROR_SMG_INVALID_SELECT_OPT        = 456;
    ERROR_SMG_START_IN_BACKGROUND       = 457;
    ERROR_SMG_INVALID_STOP_OPTION       = 458;
    ERROR_SMG_BAD_RESERVE               = 459;
    ERROR_SMG_PROCESS_NOT_PARENT        = 460;
    ERROR_SMG_INVALID_DATA_LENGTH       = 461;
    ERROR_SMG_NOT_BOUND                 = 462;
    ERROR_SMG_RETRY_SUB_ALLOC           = 463;
    ERROR_KBD_DETACHED                  = 464;
    ERROR_VIO_DETACHED                  = 465;
    ERROR_MOU_DETACHED                  = 466;
    ERROR_VIO_FONT                      = 467;
    ERROR_VIO_USER_FONT                 = 468;
    ERROR_VIO_BAD_CP                    = 469;
    ERROR_VIO_NO_CP                     = 470;
    ERROR_VIO_NA_CP                     = 471;
    ERROR_INVALID_CODE_PAGE             = 472;
    ERROR_CPLIST_TOO_SMALL              = 473;
    ERROR_CP_NOT_MOVED                  = 474;
    ERROR_MODE_SWITCH_INIT              = 475;
    ERROR_CODE_PAGE_NOT_FOUND           = 476;
    ERROR_UNEXPECTED_SLOT_RETURNED      = 477;
    ERROR_SMG_INVALID_TRACE_OPTION      = 478;
    ERROR_VIO_INTERNAL_RESOURCE         = 479;
    ERROR_VIO_SHELL_INIT                = 480;
    ERROR_SMG_NO_HARD_ERRORS            = 481;
    ERROR_CP_SWITCH_INCOMPLETE          = 482;
    ERROR_VIO_TRANSPARENT_POPUP         = 483;
    ERROR_CRITSEC_OVERFLOW              = 484;
    ERROR_CRITSEC_UNDERFLOW             = 485;
    ERROR_VIO_BAD_RESERVE               = 486;
    ERROR_INVALID_ADDRESS               = 487;
    ERROR_ZERO_SELECTORS_REQUESTED      = 488;
    ERROR_NOT_ENOUGH_SELECTORS_AVA      = 489;
    ERROR_INVALID_SELECTOR              = 490;
    ERROR_SMG_INVALID_PROGRAM_TYPE      = 491;
    ERROR_SMG_INVALID_PGM_CONTROL       = 492;
    ERROR_SMG_INVALID_INHERIT_OPT       = 493;
    ERROR_VIO_EXTENDED_SG               = 494;
    ERROR_VIO_NOT_PRES_MGR_SG           = 495;
    ERROR_VIO_SHIELD_OWNED              = 496;
    ERROR_VIO_NO_MORE_HANDLES           = 497;
    ERROR_VIO_SEE_ERROR_LOG             = 498;
    ERROR_VIO_ASSOCIATED_DC             = 499;
    ERROR_KBD_NO_CONSOLE                = 500;
    ERROR_MOUSE_NO_CONSOLE              = 501;
    ERROR_MOUSE_INVALID_HANDLE          = 502;
    ERROR_SMG_INVALID_DEBUG_PARMS       = 503;
    ERROR_KBD_EXTENDED_SG               = 504;
    ERROR_MOU_EXTENDED_SG               = 505;
    ERROR_SMG_INVALID_ICON_FILE         = 506;

    ERROR_USER_DEFINED_BASE             =  $FF00;

    ERROR_I24_WRITE_PROTECT             = 0;
    ERROR_I24_BAD_UNIT                  = 1;
    ERROR_I24_NOT_READY                 = 2;
    ERROR_I24_BAD_COMMAND               = 3;
    ERROR_I24_CRC                       = 4;
    ERROR_I24_BAD_LENGTH                = 5;
    ERROR_I24_SEEK                      = 6;
    ERROR_I24_NOT_DOS_DISK              = 7;
    ERROR_I24_SECTOR_NOT_FOUND          = 8;
    ERROR_I24_OUT_OF_PAPER              = 9;
    ERROR_I24_WRITE_FAULT               = 10;
    ERROR_I24_READ_FAULT                = 11;
    ERROR_I24_GEN_FAILURE               = 12;
    ERROR_I24_DISK_CHANGE               = 13;
    ERROR_I24_WRONG_DISK                = 15;
    ERROR_I24_UNCERTAIN_MEDIA           = 16;
    ERROR_I24_CHAR_CALL_INTERRUPTED     = 17;
    ERROR_I24_NO_MONITOR_SUPPORT        = 18;
    ERROR_I24_INVALID_PARAMETER         = 19;
    ERROR_I24_DEVICE_IN_USE             = 20;

    ALLOWED_FAIL                        = $0001;
    ALLOWED_ABORT                       = $0002;
    ALLOWED_RETRY                       = $0004;
    ALLOWED_IGNORE                      = $0008;
    ALLOWED_ACKNOWLEDGE                 = $0010;
    ALLOWED_DISPATCH                    = $8000;

    I24_OPERATION                       = $01;
    I24_AREA                            = $06;
    I24_CLASS                           = $80;

(* Values for error CLASS *)
    ERRCLASS_OUTRES                     = 1;   (* Out of Resource                     *)
    ERRCLASS_TEMPSIT                    = 2;   (* Temporary Situation         *)
    ERRCLASS_AUTH                       = 3;   (* Permission problem          *)
    ERRCLASS_INTRN                      = 4;   (* Internal System Error       *)
    ERRCLASS_HRDFAIL                    = 5;   (* Hardware Failure            *)
    ERRCLASS_SYSFAIL                    = 6;   (* System Failure                      *)
    ERRCLASS_APPERR                     = 7;   (* Application Error           *)
    ERRCLASS_NOTFND                     = 8;   (* Not Found                   *)
    ERRCLASS_BADFMT                     = 9;   (* Bad Format                  *)
    ERRCLASS_LOCKED                     = 10;  (* Locked                              *)
    ERRCLASS_MEDIA                      = 11;  (* Media Failure               *)
    ERRCLASS_ALREADY                    = 12;  (* Collision with Existing Item   *)
    ERRCLASS_UNK                        = 13;  (* Unknown/other               *)
    ERRCLASS_CANT                       = 14;
    ERRCLASS_TIME                       = 15;

(* Values for error ACTION *)
    ERRACT_RETRY                        = 1;   (* Retry                       *)
    ERRACT_DLYRET                       = 2;   (* Delay Retry, retry after pause *)
    ERRACT_USER                         = 3;   (* Ask user to regive information *)
    ERRACT_ABORT                        = 4;   (* abort with clean up         *)
    ERRACT_PANIC                        = 5;   (* abort immediately           *)
    ERRACT_IGNORE                       = 6;   (* ignore                              *)
    ERRACT_INTRET                       = 7;   (* Retry after User Intervention  *)

(* Values for error LOCUS *)
    ERRLOC_UNK                          = 1;   (* No appropriate value        *)
    ERRLOC_DISK                         = 2;   (* Random Access Mass Storage     *)
    ERRLOC_NET                          = 3;   (* Network                             *)
    ERRLOC_SERDEV                       = 4;   (* Serial Device               *)
    ERRLOC_MEM                          = 5;   (* Memory                              *)

(* Abnormal termination codes *)
    TC_NORMAL                           = 0;
    TC_HARDERR                          = 1;
    TC_GP_TRAP                          = 2;
    TC_SIGNAL                           = 3;

    ERROR_SWAPPER_NOT_ACTIVE            = 32768;
    ERROR_INVALID_SWAPID                = 32769;
    ERROR_IOERR_SWAP_FILE               = 32770;
    ERROR_SWAP_TABLE_FULL               = 32771;
    ERROR_SWAP_FILE_FULL                = 32772;
    ERROR_CANT_INIT_SWAPPER             = 32773;
    ERROR_SWAPPER_ALREADY_INIT          = 32774;
    ERROR_PMM_INSUFFICIENT_MEMORY       = 32775;
    ERROR_PMM_INVALID_FLAGS             = 32776;
    ERROR_PMM_INVALID_ADDRESS           = 32777;
    ERROR_PMM_LOCK_FAILED               = 32778;
    ERROR_PMM_UNLOCK_FAILED             = 32779;
    ERROR_PMM_MOVE_INCOMPLETE           = 32780;
    ERROR_UCOM_DRIVE_RENAMED            = 32781;
    ERROR_UCOM_FILENAME_TRUNCATED       = 32782;
    ERROR_UCOM_BUFFER_LENGTH            = 32783;
    ERROR_MON_CHAIN_HANDLE              = 32784;
    ERROR_MON_NOT_REGISTERED            = 32785;
    ERROR_SMG_ALREADY_TOP               = 32786;
    ERROR_PMM_ARENA_MODIFIED            = 32787;
    ERROR_SMG_PRINTER_OPEN              = 32788;
    ERROR_PMM_SET_FLAGS_FAILED          = 32789;
    ERROR_INVALID_DOS_DD                = 32790;
    ERROR_CPSIO_CODE_PAGE_INVALID       = 65026;
    ERROR_CPSIO_NO_SPOOLER              = 65027;
    ERROR_CPSIO_FONT_ID_INVALID         = 65028;
    ERROR_CPSIO_INTERNAL_ERROR          = 65033;
    ERROR_CPSIO_INVALID_PTR_NAME        = 65034;
    ERROR_CPSIO_NOT_ACTIVE              = 65037;
    ERROR_CPSIO_PID_FULL                = 65039;
    ERROR_CPSIO_PID_NOT_FOUND           = 65040;
    ERROR_CPSIO_READ_CTL_SEQ            = 65043;
    ERROR_CPSIO_READ_FNT_DEF            = 65045;
    ERROR_CPSIO_WRITE_ERROR             = 65047;
    ERROR_CPSIO_WRITE_FULL_ERROR        = 65048;
    ERROR_CPSIO_WRITE_HANDLE_BAD        = 65049;
    ERROR_CPSIO_SWIT_LOAD               = 65074;
    ERROR_CPSIO_INV_COMMAND             = 65077;
    ERROR_CPSIO_NO_FONT_SWIT            = 65078;

IMPLEMENTATION

END.
(* ====================================================== *)
(*                  Ende von OS2ERROR.PAS                 *)
