(* ====================================================== *)
(*                        OS2DEF.PAS                      *)
(*  Declaration of types and constants for OS/2 (16-Bit)  *)
(*           Translation to Pascal by jb/toolbox mag      *)
(* ====================================================== *)
{$IFNDEF OS2}
  Error: Wrong Target!/Compiler not patched
{$ENDIF}

UNIT Os2Def;

INTERFACE

CONST
  NULL = 0;

TYPE
  HFile     = INTEGER; (* <-------  That's definitely wrong! *)

(* A semphore is defined as the address of a LONGINT.  *)
(* System semaphores are shared by multiple processes  *)
(* and must be gotten by DosCreateSem or DosOpenSem.   *)
(* Ram sempahores are simply the address of a longint  *)
(* in the in memory.  The longint must be initialized  *)
(* to 0 before it is used.  When calling semphore      *)
(* functions with a Ram semphore, be sure to use       *)
(* Addr(li) if li is the longint, since the semphore   *)
(* calls need the addres of the longword rather than   *)
(* the value                                           *)
  SemaPhore = ^LongInt;

  LHandle   = ^LongInt;
  HAB       =  LHandle;

{ SHandle   = INTEGER;          }
{ USHORT    = WORD;             }
  BOOL      = INTEGER;
{ ULONG     = LongInt;          }
  hPs       =  LHandle;
  pHPS      = ^hPs;
  hDC       =  LHandle;
  pHDC      = ^hDC;
  HRGN      = LHandle;
  pHRGN     = ^HRGN;
{ UChar     = BYTE;             }
{ UInt      = WORD;             }

{ pSZ     = Pointer;            }
  PPSZ    = ^pChar;
  pCh     = Pointer;

  pFN     = FUNCTION : INTEGER;  (* ptr to fun *)
  pPFN    = ^pFN;

  pBYTE   = ^BYTE;   (* short ptr *)
  nPByte  = ^BYTE;
  pShort  = ^INTEGER;
  pLong   = ^LongInt;
  pInt    = ^INTEGER;

  pUChar  = ^BYTE;
  pUShort = ^WORD;
  pULong  = ^LongInt;
  pUInt   = ^INTEGER;
  pVoid   = Pointer;

  pBool   = ^BOOL;

  Sel     = INTEGER;
  pHAB    = ^HAB;

  pSel    = ^Sel;

  ErrorId  = LongInt;
  pErrorId = ^ErrorId;


(* Severity codes *)
CONST
  SEVERITY_NOERROR       = $00000;
  SEVERITY_WARNING       = $00004;
  SEVERITY_ERROR         = $00008;
  SEVERITY_SEVERE        = $0000C;
  SEVERITY_UNRECOVERABLE = $00010;

(* Base component error values *)

  WINERR_BASE            = $01000;  (* Window Manager                  *)
  GPIERR_BASE            = $02000;  (* Graphics Presentation Interface *)
  DEVERR_BASE            = $03000;  (* Device Manager                  *)
  SPLERR_BASE            = $04000;  (* Spooler                         *)

TYPE
  hModule  = WORD;
  pHModule = ^hModule;

  pID      = WORD;
  pPID     = ^pID;
  tId      = WORD;
  pTID     = ^tId;

  hSEM     = Pointer;
  pHSEM    = ^hSEM;

(*** Common SUP types *)

(*** Common GPI/DEV types *)
  hBitmap  = LHandle;  (* hbm  *)
  pHBitmap = ^hBitmap;

  hMF      = LHandle;
  pHMF     = ^hMF;

  Color    = LongInt;
  pColor   = ^Color;

  PointL   = RECORD     (* ptl  *)
    x : LongInt;
    y : LongInt;
  END;
  pPointL  = ^PointL;
  npPointL = ^PointL;    (* short ptr *)

  Points   = RECORD  (* pts *)
    x : INTEGER;
    y : INTEGER;
  END;
  pPoints  = ^Points;

  RectL    = RECORD       (* rcl *)
    xLeft   : LongInt;
    yBottom : LongInt;
    xRight  : LongInt;
    yTop    : LongInt;
  END;
  pRectl   = ^RectL;

  npRectl  = ^RectL;   (* short ptr *)
  Str8     = ARRAY [0..7] OF CHAR;

(***
typedef CHAR STR8[8];       { str8 }
typedef STR8 FAR *PSTR8;
***)

(* common DOS/SHL types *)

(* File time and date types *)

  fTime    = RECORD         (* ftime *)
    Data: WORD;
      (**
       unsigned twosecs : 5;
       unsigned minutes : 6;
       unsigned hours   : 5;
      **)
  END;
  pFTime   = ^fTime;

  fDate    = RECORD
    Data : WORD;        (* fdate *)
      (**
       unsigned day     : 5;
       unsigned month   : 4;
       unsigned year    : 7;
      **)
  END;
  pFDate = ^fDate;

  FileFindBuf = RECORD
    fDateCreation   : fDate;
    fTimeCreation   : fTime;
    fDateLastAccess : fDate;
    fTimeLastAccess : fTime;
    fDateLastWrite  : fDate;
    fTimeLastWrite  : fTime;
    cbFile          : LongInt;
    cbFileAlloc     : LongInt;
    attrFile        : WORD;
    cchName         : BYTE;
    achName         : ARRAY [0..12] OF CHAR;
  END;
  pFileFindBuf = ^FileFindBuf;

(*** common DEV/SPL types *)

(* structure for Device Driver data *)
  DrivData = RECORD
    cb            : LongInt;
    lVersion      : LongInt;
    szDeviceName  : ARRAY [0..31] OF CHAR;
    abGeneralData : CHAR;
  END;
  pDrivData = ^DrivData;

(* array indices for array parameter for
   DevOpenDC, SplQmOpen or SplQpOpen    *)

CONST
  Address        = 0;
  Driver_Name    = 1;
  Driver_Data    = 2;
  DATA_TYPE      = 3;
  Comment        = 4;
  Proc_Name      = 5;
  Proc_Params    = 6;
  SPL_Params     = 7;
  Network_Params = 8;

(* structure definition as an alternative
   of the array parameter                 *)

TYPE
  DevOpenStruc = RECORD     (* dop *)
    pszLogAddress      : pChar;
    pszDriverName      : pChar;
    pdriv              : pDrivData;
    pszDataType        : pChar;
    pszComment         : pChar;
    pszQueueProcName   : pChar;
    pszQueueProcParams : pChar;
    pszSpoolerParams   : pChar;
    pszNetworkParams   : pChar;
  END;
  pDevOpenStruc = ^DevOpenStruc;

(*** common AVIO/GPI types *)

(* values of fsSelection field of FATTRS structure *)
CONST
  FATTR_SEL_ITALIC     = $00001;
  FATTR_SEL_UNDERSCORE = $00002;
  FATTR_SEL_STRIKEOUT  = $00010;
  FATTR_SEL_BOLD       = $00020;

(* values of fsType field of FATTRS structure *)

  FATTR_TYPE_FIXED     = $00002;
  FATTR_TYPE_KERNING   = $00004;

(* values of fsFontUse field of FATTRS structure *)

  FATTR_FONTUSE_NOMIX         = $00002;
  FATTR_FONTUSE_OUTLINE       = $00004;
  FATTR_FONTUSE_TRANSFORMABLE = $00008;

(* size for fields in the font structures *)

  FACESIZE = 32;

(* font struct for Vio/GpiCreateLogFont *)

TYPE
  fAttrs = RECORD          (* fat *)
    usRecordLength         : WORD;
    fsSelection            : WORD;
    lMatch                 : LongInt;
    szFacename             : ARRAY[0..FACESIZE-1] OF CHAR;
    idRegistry             : WORD;
    usCodePage             : WORD;
    lMaxBaselineExt        : LongInt;
    lAveCharWidth          : LongInt;
    fsType                 : WORD;
    fsFontUse              : WORD;
  END;
  pFAttrs = ^fAttrs;

(* font metrics returned by GpiQueryFonts and others *)
TYPE
  FontMetrics = RECORD    (* fm *)
    szFamilyname       : ARRAY[0..FACESIZE-1] OF CHAR;
    szFacename         : ARRAY[0..FACESIZE-1] OF CHAR;
    idRegistry         : WORD;
    usCodePage         : WORD;
    lEmHeight          : LongInt;
    lXHeight           : LongInt;
    lMaxAscender       : LongInt;
    lMaxDescender      : LongInt;
    lLowerCaseAscent   : LongInt;
    lLowerCaseDescent  : LongInt;
    lInternalLeading   : LongInt;
    lExternalLeading   : LongInt;
    lAveCharWidth      : LongInt;
    lMaxCharInc        : LongInt;
    lEmInc             : LongInt;
    lMaxBaselineExt    : LongInt;
    sCharSlope         : INTEGER;
    sInlineDir         : INTEGER;
    sCharRot           : INTEGER;
    usWeightClass      : WORD;
    usWidthClass       : WORD;
    sXDeviceRes        : INTEGER;
    sYDeviceRes        : INTEGER;
    sFirstChar         : INTEGER;
    sLastChar          : INTEGER;
    sDefaultChar       : INTEGER;
    sBreakChar         : INTEGER;
    sNominalPointSize  : INTEGER;
    sMinimumPointSize  : INTEGER;
    sMaximumPointSize  : INTEGER;
    fsType             : WORD;
    fsDefn             : WORD;
    fsSelection        : WORD;
    fsCapabilities     : WORD;
    lSubscriptXSize    : LongInt;
    lSubscriptYSize    : LongInt;
    lSubscriptXOffset  : LongInt;
    lSubscriptYOffset  : LongInt;
    lSuperscriptXSize  : LongInt;
    lSuperscriptYSize  : LongInt;
    lSuperscriptXOffset: LongInt;
    lSuperscriptYOffset: LongInt;
    lUnderscoreSize    : LongInt;
    lUnderscorePosition: LongInt;
    lStrikeoutSize     : LongInt;
    lStrikeoutPosition : LongInt;
    sKerningPairs      : INTEGER;
    sReserved          : INTEGER;
    lMatch             : LongInt;
  END;
  pFontMetrics = ^FontMetrics;

(*** Common WIN types *)
TYPE
  hWnd  = LHandle;      (* hwnd *)
  pHWnd = ^hWnd;

TYPE
  WRect = RECORD     (* wrc *)
    xLeft  : INTEGER;
    dummy1 : INTEGER;
    yBottom: INTEGER;
    dummy2 : INTEGER;
    xRight : INTEGER;
    dummy3 : INTEGER;
    yTop   : INTEGER;
    dummy4 : INTEGER;
  END;
  pWRect  = ^WRect;
  npWRect = ^WRect;   (* short ptr *)

TYPE
  wPoint = RECORD    (* wpt *)
    x      : INTEGER;
    dummy1 : INTEGER;
    y      : INTEGER;
    dummy2 : INTEGER;
  END;
  pWPoint = ^wPoint;
  npWPoint = ^wPoint;  (* short ptr *)


TYPE
   mParam = RECORD
     CASE INTEGER OF
       1: (b1, b2, b3, b4 : BYTE);
       2: (w1, w2         : WORD);
       4: (l              : LongInt);
     END;
   pMParam  = ^mParam;
   mResult  = Pointer;
   pMResult = ^mResult;

FUNCTION MakeLong(LowWord, HiWord : WORD) : LongInt;
FUNCTION LoWord(l: LongInt): WORD;
FUNCTION HiWord(l: LongInt): WORD;

IMPLEMENTATION

  FUNCTION MakeLong(LowWord, HiWord: WORD) : LongInt;
  BEGIN
    MakeLong := LongInt(HiWord SHL 16) + LowWord;
  END;

  FUNCTION LoWord(l: LongInt): WORD;
  VAR
    lR : RECORD
           Lo, Hi : WORD;
         END ABSOLUTE l;
  BEGIN
    LoWord := lR.Lo;
  END;

  FUNCTION HiWord(l: LongInt): WORD;
  VAR
    lR : RECORD
           Lo, Hi : WORD;
         END ABSOLUTE l;
  BEGIN
    HiWord := lR.Hi;
  END;

END.

(* ====================================================== *)
