(* ====================================================== *)
(*                          NLS.PAS                       *)
(*       Implementation of the functions of NLS.DLL       *)
(*               National Language Support              *)
(*        Translation to Pascal by jb/toolbox mag         *)
(* ====================================================== *)
{$IFNDEF OS2}
  Error: Wrong target/Compiler not patched
{$ENDIF}

UNIT Nls;

INTERFACE

USES
  Os2Def;

(* A collating sequence table is essentially a table mapping characters *)
(* in the order they should be collated. *)

TYPE
  CollateTable = ARRAY [#0..#255] OF CHAR;

(* Get a table specifying the collating sequence for a country *)
(* casemap (?) a string *)
TYPE
  CountryCode = RECORD
    Country    : WORD;     (* the country *)
    codepage   : WORD;     (* code page for the country *)
  END;

(* The record returned by DosGetCountryInfo *)

  CountryInfo = RECORD
    Country             : WORD;     (* the country code *)
    codepage            : WORD;     (* must be zero *)
    fsDateFmt           : WORD;     (* 0 -> mm/dd/yy *)
                                        (* 1 -> dd/mm/yy *)
                                        (* 2 -> yy/mm/dd *)
    szCurrency          : ARRAY [0..4] OF CHAR; (* ASCIIZ currency sign *)
    szThousandsSeparator: ARRAY [0..1] OF CHAR; (* ASCIIZ thousands separator *)
    szDecimalSeparator  : ARRAY [0..1] OF CHAR; (* ASCIIZ decimal separator  *)
    szDateSeparator     : ARRAY [0..1] OF CHAR; (* ASCIIZ date separator *)
    szTimeSeparator     : ARRAY [0..1] OF CHAR; (* ASCIIZ time separator *)
    fsCurrencyFmt       : BYTE;         (* bit 0 -> currency indicator follows*)
                                        (* bit 1 -> space between *)
                                        (* bit 2 -> replaces decimal point *)
    cDecimalPlace       : BYTE;         (* decimal places used in currency *)
    fsTimeFmt           : BYTE;         (* bit 0:  0 -> 12 hour with a or p *)
                                        (*         1 -> 24 hour format *)
    abReserved1         : ARRAY [0..1] OF WORD; (* must be zero *)
    szDataSeparator     : ARRAY [0..1] OF CHAR; (* null terminated *)
    abReserved2         : ARRAY [0..4] OF WORD; (* must be zero *)
  END;

FUNCTION DosCaseMap(    Length  : WORD;        (* length of the string *)
                    VAR Country : CountryCode; (* pointer to a country code *)
                    VAR pChStr  : CHAR
                              ) : WORD;
FUNCTION Dos16CaseMap(    Length  : WORD;        (* length of the string *)
                      VAR Country : CountryCode; (* pointer to a country code *)
                      VAR pChStr  : CHAR
                                ) : WORD;

FUNCTION DosGetCollate(    Length       : WORD;         (* length of data area *)
                       VAR Country      : CountryCode;  (* the country and code page *)
                       VAR MemoryBuffer : CollateTable; (* returned collating table *)
                       VAR  DataLength  : WORD          (* length of table returned *)
                                      ) : WORD;
FUNCTION Dos16GetCollate(    Length       : WORD;         (* length of data area *)
                         VAR Country      : CountryCode;  (* the country and code page *)
                         VAR MemoryBuffer : CollateTable; (* returned collating table *)
                         VAR  DataLength  : WORD          (* length of table returned *)
                                        ) : WORD;

(* Get list of code pages available in the system *)
FUNCTION DosGetCtryInfo(    Length       : WORD;         (* length of the buffer *)
                        VAR CountryCode  : CountryCode;  (* the country code to return info *)
                        VAR MemoryBuffer : CountryInfo;  (* address of buffer to return info *)
                        VAR DataLength   : WORD          (* length of returned info *)
                                       ) : WORD;
FUNCTION Dos16GetCtryInfo(    Length       : WORD;         (* length of the buffer *)
                          VAR CountryCode  : CountryCode;  (* the country code to return info *)
                          VAR MemoryBuffer : CountryInfo;  (* address of buffer to return info *)
                          VAR DataLength   : WORD          (* length of returned info *)
                                         ) : WORD;

(* Get the DBCS environmental vector for a specified country code *)
(* Returns a list of pairs of words:  StartValue, EndValue with two *)
(* zeros terminating *)

FUNCTION DosGetDBCSEv(Length       : WORD;         (* length of buffer passed *)
                      Country      : CountryCode;  (* the country code to get Ev for *)
                      MemoryBuffer : Pointer       (* address of buffer *)
                                 ) : WORD;
FUNCTION Dos16GetDBCSEv(Length       : WORD;         (* length of buffer passed *)
                        Country      : CountryCode;  (* the country code to get Ev for *)
                        MemoryBuffer : Pointer       (* address of buffer *)
                                   ) : WORD;

IMPLEMENTATION

  FUNCTION DosCaseMap;       EXTERNAL 'NLS' INDEX 1;
  FUNCTION Dos16CaseMap;     EXTERNAL 'NLS' INDEX 1;

  FUNCTION DosGetCollate;    EXTERNAL 'NLS' INDEX 2;
  FUNCTION Dos16GetCollate;  EXTERNAL 'NLS' INDEX 2;

  FUNCTION DosGetCtryInfo;   EXTERNAL 'NLS' INDEX 3;
  FUNCTION Dos16GetCtryInfo; EXTERNAL 'NLS' INDEX 3;

  FUNCTION DosGetDBCSEv;     EXTERNAL 'NLS' INDEX 4;
  FUNCTION Dos16GetDBCSEv;   EXTERNAL 'NLS' INDEX 4;

(* ====================================================== *)
(*                        32 Bit                          *)
{
  FUNCTION Dos32QueryCtryInfo;  External 'NLS' INDEX 5;
  FUNCTION Dos32QueryDBCSEnv;   External 'NLS' INDEX 6;
  FUNCTION Dos32MapCase;        External 'NLS' INDEX 7;
  FUNCTION Dos32QueryCollate;   External 'NLS' INDEX 8;
}
END.

(* ====================================================== *)
