(* ====================================================== *)
(*                         BUILDPM.PAS                    *)
(*     Program to compile all toolbox-BP-OS/2-libraries   *)
(*                  (C) 1994 toolbox                      *)
(* ====================================================== *)
(* 1. compile this program                                *)
(* 2. makepm the program                                  *)
(* 3. call the resource compiler: rc buildpm.rc           *)
(* ... and ready                                          *)
(* associated files:                                      *)
(* buildpm.pas, buildpm.rc buildpm.rc and the units below *)
{$A+,B-,D-,F+,G+,I-,K+,N-,P-,Q-,R-,S-,T-,V-,W-,X+,Y+}
PROGRAM BuildPM;

USES
  BDCalls, DevIOCtl, DosCalls, HelpMgr,  KbdCalls, MonCalls,
  MouCalls, Msg, NamPipes, Nls, Os2Def, Os2Error, PMErr,
  PMGpi, PmMle, PMPic, PMSPL, PMVioP, PMWin, QueCalls,
  SesMgr, Strings (* by Borland *), VioCalls;

VAR
  Frame, client : hWnd;
  ahab          : HAB;
  aMq           : hMQ;
  aMsg          : QMsg;

CONST
  FrameFlags   : LongInt = FCF_TITLEBAR      +
                           FCF_SYSMENU       +
                           FCF_MENU          +
                           FCF_SIZEBORDER    +
                           FCF_MINBUTTON     +
                           FCF_MAXBUTTON     +
                           FCF_SHELLPOSITION +
                           FCF_TASKLIST      +
                           FCF_ICON;

  FUNCTION ClientWndProc(Window : hWnd;
                         Msg    : WORD;
                         Mp1,
                         Mp2    : mParam) : mResult; EXPORT;

  VAR
    ps   : hPs;
    rcl  : RectL;
    Text : ARRAY[0..100] OF CHAR;

  BEGIN
     ClientWndProc := NIL;
     CASE Msg OF
       WM_CREATE: Dos16Beep(200, 10);
       WM_PAINT :
         BEGIN
           ps := WinBeginPaint(Window, NIL, NIL);
           WinQueryWindowRect(Window, @rcl);
           rcl.yBottom := rcl.yTop + 10;
           StrCopy(Text, 'Alle OS/2-Bibliotheken wurden erzeugt!');
           WinDrawText(ps, -1, Text, @rcl,
                       PMGpi.CLR_BLUE,
                       PMGpi.CLR_PALEGRAY,
                       $8500);
           StrCopy(Text, 'Um OS/2-Programme sinnvoll zu programmieren');
           Inc(rcl.yBottom, 10);
           Inc(rcl.yTop, 10);
           WinDrawText(ps, -1, Text, @rcl,
                       PMGpi.CLR_BLUE,
                       PMGpi.CLR_PALEGRAY,
                       $8500);
           WinEndPaint(ps);
         END;
       WM_COMMAND :
         CASE Mp1.l OF { fr varianten Record Tag setzen ! }
           101: Dos16Beep(4500, 40);
           109: WinPostMsg(NIL, WM_QUIT, NIL, NIL);
           201: WinMessageBox(Frame,
                              Window,
                              'Build-PM der toolbox ''94',
                              'ber...',
                              0,
                              MB_ICONEXCLAMATION +
                              MB_MOVEABLE);
         END;
       WM_DESTROY : Dos16Beep(500, 10);
     ELSE
       ClientWndProc := WinDefWindowProc(Window, Msg,
                                         Mp1, Mp2);
     END;
  END;

BEGIN
  ahab := WinInitialize(0);
  aMq := WinCreateMsgQueue(ahab,0);
  WinRegisterClass(ahab,'Build PM',@ClientWndProc,4,0);
  Frame := WinCreateStdWindow(hWnd(1),
                              WS_VISIBLE,
                              FrameFlags,
                              'Build PM',
                              NIL, 0, 0, 1, client);
  WHILE (WinGetMsg(ahab, aMsg, NIL, 0, 0)) DO
    WinDispatchMsg(ahab, aMsg);
  WinDestroyWindow(Frame);
  WinDestroyMsgQueue(aMq);
  WinTerminate(ahab);
END.

(* ====================================================== *)
(*                 Ende von BUILDPM.PAS                   *)
