(*========================================================*)
(*                 PREP.PAS (Version 2.10)                *)
(*       Copyright (C) 1991-95 J. Braun & DMV-Verlag      *)
(*                Compiler: Turbo Pascal ab 6.0           *)
(*========================================================*)

{$A+,B-,E-,F-,I+,N-,O-,V-,X-,G-,M 4096,0,0}
{.$DEFINE debug}
{$IFDEF DEBUG}{$D+,L+,S+,R+}{$ELSE}{$D-,L-,S-,R-}{$ENDIF}

PROGRAM PrepareHarddisk;

USES
  Crt,
  Dos,
  DOSCountry,
  Absolute;

TYPE
  tXtens = (SYS, BAT);

CONST
  BS          = CHR(8);
  LF          = CHR(10);
  CRLF        = CHR(13) + LF;
  Germany     = 49;
  Switzerland = 41;
  Austria     = 43;

  DrDos5   : BOOLEAN = FALSE;
  german   : BOOLEAN = FALSE;
  Lw       : STRING[2]                   = 'C:';
  StdExt   : ARRAY[tXtens] OF STRING[3]  = ('SYS', 'BAT');
  StartFile: ARRAY[tXtens] OF STRING[10] = ('\CONFIG.',
                                            '\AUTOEXEC.');
  Error    : ARRAY[1..2] OF BOOLEAN      = (FALSE, FALSE);
  Copyright: STRING[50] = 'PrepareSwitch 2.10, (C) '
                        + '1991-95 DMV-Verlag, Poing';

VAR
  CommandLine      : ComStr;
  BootFileName,
  PartFileName,
  Name             : PathStr;
  f1, f2           : FILE OF BYTE;
  i, Attr          : WORD;
  FileExists       : BOOLEAN;
  OldDir           : PathStr;
  sr               : SearchRec;
  OldSystem        : tSystems;
  Line             : STRING;
  txt1, txt2       : TEXT;
  FTime            : LONGINT;
  BootSectorBuffer : ARRAY[0..MaxBufSize] OF BYTE;
  PartSectorBuffer : ARRAY[0..MaxBufSize] OF BYTE;

(*--------------------------------------------------------*)
(*    berprfung, welches System gerade bootfhig ist    *)
FUNCTION CheckOldSystem: tSystems;
VAR
  i      : WORD; 
  j      : BYTE;
  k      : tSystems;
  BufStr : STRING;

BEGIN
  BufStr := '';
  j := 0;
  ReadBootSector(C, BootSectorBuffer);

  FOR i := 20 TO MaxBufSize - 2 DO
    IF Chr(BootSectorBuffer[i]) IN
       ['A' .. 'Z', 'a' .. 'z', '2', '$'] THEN
      BufStr := BufStr + CHR(BootSectorBuffer[i]);

  FOR k := IBM TO SysCount DO
    IF Pos(SysIDs[k], BufStr) > 0 THEN j := BYTE(k);

  IF (j = 1) AND ((Pos('Laden', BufStr) > 0) OR
     (Pos('Loading', BufStr) > 0)) THEN DRDos5 := TRUE;
     (* Die Meldung gibt's bei PC-DOS einfach nicht *)
  IF (tSystems(j) = MsDos) AND (Lo(DosVersion) = 7) THEN
    j := BYTE(tSystems(Win95));
  CheckOldSystem := tSystems(j);
END;


(*--------------------------------------------------------*)
(*               Vorbereitung der Dateien                 *)
PROCEDURE PrepareOrgFile;
BEGIN
  GetFTime(txt1, FTime);
  Close(txt1);
  GetFAttr(txt1, Attr);
  SetFAttr(txt1, Archive);
  {$I-}
  Reset(txt1);
  {$I+}
END;

(*--------------------------------------------------------*)
(*                Schlieen aller Dateien                 *)
PROCEDURE CloseAll;
BEGIN
  Close(txt1);
  SetFAttr(txt1, Attr);
  Close(txt2);
  SetFAttr(txt2, Archive + ReadOnly);
  SetFTime(txt2, FTime);
END;

(*--------------------------------------------------------*)
(*                Hilfe bei Parameter /?|/h               *)
PROCEDURE Help;
CONST
  Tab = Chr(9);
  LF  = Chr(10);
VAR
  t: TEXT;
BEGIN
  Assign(t, '');             (* Standardausgabe trotz Crt *)
  {$I-}
  ReWrite(t);
  {$I+}
  IF german THEN BEGIN
    WriteLn(t, CRLF + 'Vorbereitung eines Betriebssystems ' +
             'fr den Bootswitcher. Es wird automatisch');
    WriteLn(t, 'erkannt,  welches System gerade bootfhig' +
             ' ist.  Hiernach wird die Endung der');
    WriteLn(t, 'Dateien gewhlt. Prep schreibt  den ' +
             'Bootsektor,  die Partitionstabelle sowie');
    WriteLn(t, 'CONFIG.SYS und AUTOEXEC.BAT in das ' +
             'Verzeichnis ' + SysDir + '.');
    WriteLn(t, 'Ist das Verzeichnis nicht vorhanden, ' +
             'wird es angelegt.');
    WriteLn(t, 'Achtung: Es wird nicht berprft,  ' +
             'ob gengend Platz auf der Festplatte ist,');
    WriteLn(t, 'um die Dateien zu schreiben!' + LF);
    WriteLn(t, 'Folgende Betriebssysteme werden' +
             ' untersttzt:');
    WriteLn(t, Tab + 'MS-DOS 3.x/4.0x/5.x/6.x' + Tab
           + Tab + '(.DOS-Dateien)');
    WriteLn(t, Tab + 'PC-DOS / DR-DOS 5/6/7' + Tab
           + Tab + '(.IBM-Dateien)'^J^M+TAB+TAB+TAB+
                  ' (Novell DOS nicht getestet)');
    WriteLn(t, Tab + 'DR-DOS 3.41        ' + Tab
           + Tab + '(.DRS-Dateien)');
    WriteLn(t, Tab + 'MS-OS/2 1.1        ' + Tab
           + Tab + '(.OS1-Dateien)');
    WriteLn(t, Tab + 'MS-OS/2 1.2/1.21/1.3'+ Tab
           + Tab + '(.OS2-Dateien)');
    WriteLn(t, Tab + 'PC-MOS/386 4.0     ' + Tab
           + Tab + '(.MOS-Dateien)');
    WriteLn(t, Tab + 'DOS-Plus V. 1.2    ' + Tab
           + Tab + '(.PLS-Dateien)');
    WriteLn(t, Tab + 'Windows ''95 (MS-DOS 7)' + Tab
           + Tab + '(.WIN-Dateien)');

    Write(t, 'Die Bootsektor- und Partitionsdateien werden');
    WriteLn(t, ' automatisch hidden gesetzt.');
  END ELSE BEGIN
    WriteLn(t, CRLF +
             'The program prepares an operating system for'
           + '  bootswitch. It automatically');
    WriteLn(t, 'recogizes the actual bootsystem. Correspondi'
           + 'g to the  type  of bootsystem,');
    WriteLn(t, 'the file extensions will be set. The bootsec'
           + 'tor file,  the CONFIG.SYS, and');
    WriteLn(t, 'the AUTOEXEC.BAT will be placed in the Direc'
           + 'tory ' + SysDir + '.');
    WriteLn(t, 'Is the directory not yet on the harddisk, it'
           + ' will be created.');
    WriteLn(t, 'Warning: The program does not check, if '
           + 'there is not enough free space for');
    WriteLn(t, 'for the files on the hard disk!' + LF);
    WriteLn(t, 'The following operating systems are ' +
             'supported:');
    WriteLn(t, Tab + 'MS DOS 3.x/4.0 - 6.x' + Tab +
             Tab + '(.DOS files)');
    WriteLn(t, Tab + 'PC DOS / DR-DOS 5 - 7' + Tab +
             Tab + '(.IBM files)'+ ^M^J + TAB+TAB+TAB+
             '(Novell DOS not tested!)');
    WriteLn(t, Tab + 'DOS-Plus V. 1.2    ' + Tab +
             Tab + '(.PLS files)');
    WriteLn(t, Tab + 'DR DOS 3.41        ' + Tab +
             Tab + '(.DRS files)');
    WriteLn(t, Tab + 'MS OS/2 1.1        ' + Tab +
             Tab + '(.OS1 files)');
    WriteLn(t, Tab + 'MS OS/2 1.2/1.21/1.3' + Tab +
             Tab +'(.OS2 files)');
    WriteLn(t, Tab + 'PC MOS/386 4.0     ' + Tab +
             Tab + '(.MOS files)');
    WriteLn(t, Tab + 'Windows ''95 (MS-DOS 7)' + Tab
           + Tab + '(.WIN files)');

    WriteLn(t, 'The bootsector and partition table files ' +
             'will be set "hidden".');
  END;
  Close(t);
END;

BEGIN
  IF fGetCountry IN [Switzerland, Austria, Germany] THEN
    german := TRUE;
  ReadPartition(C, PartSectorBuffer);
  i := WORD(CheckOldSystem);
  GetDir(0, OldDir);
  HighVideo;
  WriteLn(Copyright);          (* Meldung nicht umleitbar *)
  NormVideo;
  CheckBreak := TRUE;
  IF ParamCount > 0 THEN
    CommandLine := ParamStr(1)
  ELSE
    CommandLine := ' ';
  IF (Pos('H', CommandLine) > 0) OR
     (Pos('h', CommandLine) > 0) OR
     (Pos('?', CommandLine) > 0) THEN Help
  ELSE BEGIN
    OldSystem := CheckOldSystem;
    IF german THEN BEGIN
      WriteLn('Bootswitch fr ' + Names[OldSystem] +
              ' wird vorbereitet:' + LF);
      WriteLn('[Enter] um zu beginnen, ^[Break] um abzubrechen');
      ReadLn;
    END ELSE BEGIN
      WriteLn('Preparing bootswitch for '
            + Names[OldSystem] + ':' +  LF);
      WriteLn('[Enter] to start, ^[Break] for cancel');
      ReadLn;
    END;
    CheckBreak := FALSE;
    IF OldSystem > none THEN BEGIN
      {$I-}
      ChDir(SysDir);
      {$I+}
      IF IOResult <> 0 THEN BEGIN
        IF german THEN
          WriteLn('Verzeichnis ' + SysDir +
                  ' wird neu angelegt')
        ELSE
          WriteLn('Creating Directory ' + SysDir );
        {$I-}
        MkDir(SysDir);
        ChDir(SysDir);
        {$I+}
      END;

      BootFileName := SysDir + '\' + BootFile
                    + Systems[OldSystem];
      Assign(f1, BootFileName);
      FindFirst(BootFileName, AnyFile, sr);
      FileExists := Pos(sr.Name, BootFileName) > 0;
      IF FileExists THEN SetFAttr(f1, Archive);
      {$I-}
      ReWrite(f1);
      {$I+}
      IF IOResult <> 0 THEN BEGIN
      IF german THEN
        WriteLn('Bootsektordatei kann nicht geschrieben '
              + 'werden!')
      ELSE
        WriteLn('Access on bootsector file denied!');
        Halt;
      END;
      FOR i := 0 TO MaxBufSize DO
         Write(f1, BootSectorBuffer[i]);
      Close(f1);
      SetFAttr(f1, Archive + Hidden);

      PartFileName := SysDir + '\' + PartFile
                    + Systems[OldSystem];
      Assign(f2, PartFileName);
      FindFirst(PartFileName, AnyFile, sr);
      FileExists := Pos(sr.Name, PartFileName) > 0;
      IF FileExists THEN SetFAttr(f2, Archive);
      {$I-}
      ReWrite(f2);
      {$I+}
      IF IOResult <> 0 THEN
      IF german THEN
        WriteLn('Partitionsdatei kann ' +
                'nicht geschrieben werden!')
      ELSE
        WriteLn('Access on partition file denied!');
      FOR i := 0 TO MaxBufSize DO
        Write(f2, PartSectorBuffer[i]);
      Close(f2);
      SetFAttr(f2, Archive + Hidden);

      IF german THEN
        WriteLn('Die Dateien ' + BootFile
               + Systems[OldSystem] + ' und '
               + PartFile + Systems[OldSystem]
               + ' wurden geschrieben.')
      ELSE
         WriteLn('The files ' + BootFile
                + Systems[OldSystem] + ' and '
                + PartFile + Systems[OldSystem]
                + ' are backed up.');

      Assign(txt1, Lw + StartFile[BAT] + StdExt[BAT]);
      {$I-}
      Reset(txt1);
      {$I+}
      Error[1] := IOResult <> 0;
      IF NOT Error[1] THEN BEGIN
        PrepareOrgFile;
        BootFileName := SysDir + StartFile[BAT]
                      + Systems[OldSystem];
        FindFirst(BootFileName, AnyFile, sr);
        FileExists := (Pos(sr.Name, BootFileName) > 0);
        Assign(txt2, BootFileName);
        IF FileExists THEN SetFAttr(txt2, Archive);
        {$I-}
        ReWrite(txt2);
        {$I+}
        WHILE NOT EoF(txt1) DO BEGIN
          Line := '';
          ReadLn(txt1, Line);
          IF Line <> '' THEN
             WriteLn(txt2, Line);
        END;
        CloseAll;
        Assign(txt1, Lw + StartFile[SYS] + StdExt[SYS]);
        {$I-}
        Reset(txt1);
        {$I+}
        Error[2] := IOResult <> 0;
        IF NOT Error[2] THEN BEGIN
          PrepareOrgFile;
          BootFileName := SysDir + StartFile[SYS]
                        + Systems[OldSystem];
          FindFirst(BootFileName, AnyFile, sr);
          FileExists := Pos(sr.Name, BootFileName) > 0;
          Assign(txt2, BootFileName);
          IF FileExists THEN SetFAttr(txt2, Archive);
          {$I-}
          ReWrite(txt2);
          {$I+}
          WHILE NOT EoF(txt1) DO BEGIN
            ReadLn(txt1, Line);
            IF Line <> '' THEN WriteLn(txt2, Line);
          END;
          CloseAll;
        END;
        IF NOT Error[1] THEN BEGIN
           FOR i := 2 TO Length(StartFile[SYS]) DO
             Write(StartFile[SYS][i]);
           Write(Systems[OldSystem]);
        END;
        IF NOT (Error[1] AND Error[2]) THEN BEGIN
          IF german THEN
             Write(' und ')
          ELSE
             Write(' and ');
        END;
        IF NOT Error[2] THEN BEGIN
          FOR i := 2 TO Length(StartFile[BAT]) DO
            Write(StartFile[BAT][i]);
          Write(Systems[OldSystem] + ' ');
        END;
        IF NOT (Error[1] OR Error[2]) THEN BEGIN
          IF german THEN Write('wurde')
                    ELSE Write('was');
        END;
        IF NOT (Error[1] AND Error[2]) THEN BEGIN
          IF german THEN Write('n')
                    ELSE Write(BS + BS +'ere');
        END;
        IF NOT (Error[1] AND Error[2]) THEN BEGIN
          IF german THEN Write(' gesichert.')
                    ELSE Write(' backed up.');
        END;
        IF Error[1] THEN
           WriteLn(Lw + StartFile[SYS] + ParamMsg[none]);
        IF Error[2] THEN
           WriteLn(Lw + StartFile[BAT] + ParamMsg[none]);
        WriteLn;
      END;
    END ELSE BEGIN
      IF german THEN
        WriteLn('Leider habe ich das System nicht erkannt,'
         + CRLF + 'deshalb wurde keine Datei geschrieben.')
      ELSE
        WriteLn('Actual boot system not detected.' + CRLF +
                'No backup files written.');
    END;
  END;
  ChDir(OldDir);       (* Zurck ins Ursprungsverzeichnis *)
END.

(*========================================================*)
(*                  Ende von PREP.PAS                     *)
