(*--------------------------------------------------------*)
(*                      BOOTSEC.PAS                       *)
(*           (C) 1991 J. Braun & DMV-Verlag               *)
(*--------------------------------------------------------*)
{$A+,B-,D-,E-,F-,G-,I-,L-,N-,O-,R-,S-,V-,X-}
{$M 4096,0,1024}

PROGRAM BootSecInfo;

USES
  Dos, Absolute;

TYPE
  tBootBlock = RECORD
    Jump              : ARRAY[01.. 03] OF BYTE;
    OEM               : ARRAY[01.. 08] OF CHAR;
    Data              : tBPB;
    (* Ab hier kein Standard mehr. Kompatible Systeme     *)
    (* knnen einen anderen Aufbau besitzen               *)
    DiskLabel         : ARRAY[01.. 11] OF CHAR;  (* DOS 4 *)
    FATTypeText       : ARRAY[01.. 08] OF CHAR;  (* DOS 4 *)
    DosLoader         : ARRAY[00..351] OF BYTE;
    Messages          : ARRAY[00.. 64] OF CHAR;
    FileLoader        : ARRAY[00.. 30] OF CHAR;
    (* Ab hier wieder Standard                            *)
    EndMarker         : ARRAY[00.. 01] OF CHAR;
  END;

VAR
  vBuffer    : ARRAY[0..$200] OF BYTE;
  vBootBlock : tBootBlock ABSOLUTE vBuffer;
  i          : WORD;
  vPString   : ComStr;
  vDrvChar   : CHAR;

CONST
  vDrive     : tDrives = C;
  cCRLF      = CHR(13) + CHR(10);

BEGIN
  WriteLn(cCRLF + 'Bootsektor-Information Version 1.01, ' +
        '(C) 1991 J. Braun & DMV-Verlag.');

  IF ParamCount > 0 THEN BEGIN
    vPString := ParamStr(1);
    IF vPString[1] IN ['-', '/'] THEN
      Delete(vPString, 1, 1);
    vDrvChar := UpCase(vPString[1]);
    IF vDrvChar IN ['A'..'Z'] THEN
      vDrive := tDrives(ORD(vDrvChar) - 64)
    ELSE IF vDrvChar = '?' THEN BEGIN
      WriteLn(cCRLF + 'Aufruf:');
      WriteLn(' BOOTSEC [-][Laufwerk|?]');
      WriteLn(' ''?'' zeigt diese Information');
      WriteLn(' Es reicht, wenn der Laufwerksbuchstabe ' +
              'angegeben');
      WriteLn(' wird. Wird kein Laufwerk angegeben, wird ' +
              'Laufwerk');
      WriteLn(' C: angezeigt.' + cCRLF);
      Halt(0);
    END;
  END;

  ReadBootSector(vDrive, vBuffer);

  WriteLn(cCRLF + 'Daten im Bootsektor von Laufwerk ' +
          CHR(ORD(vDrive) + 64) + ':');
  WriteLn('');
  WITH vBootBlock DO BEGIN
    Write  ('OEM              : ');
    FOR i := 1 TO 8 DO Write(OEM[i]);  WriteLn;
    WriteLn('Bytes/Sektor     : ', Data.BytesPerSector);
    WriteLn('Sektoren/Cluster : ', Data.SectorsPerCluster);
    WriteLn('Reservierte Sekt.: ', Data.ReservedSectors);
    WriteLn('Anzahl FATs      : ', Data.NumberOfFATs);
    WriteLn('Anzahl Rooteintr.: ', Data.RootEntries);

    IF Data.TotalSectors <> 0 THEN
      WriteLn('Sektoren (12 Bit): ', Data.TotalSectors)
    ELSE
    WriteLn('Sektoren (16 Bit): ', Data.BigTotalSectors);

    WriteLn('Media-Beschreiber: ', Data.MediaDescriptor);
    WriteLn('Sektoren/FAT     : ', Data.SectorsPerFAT);
    WriteLn('Sektoren/Spur    : ', Data.SectorsPerTrack);
    WriteLn('Kpfe            : ', Data.Heads);
    WriteLn('Versteckte Sekt. : ', Data.HiddenSectors);

    Write(cCRLF + 'Disk-Label (DOS4): ');
    FOR i := 1 TO 11 DO BEGIN
      IF DiskLabel[i] IN ['A'..'Z', '0'..'9'] THEN
        Write(Disklabel[i]);
    END;
    WriteLn;

    Write  ('FAT-ID     (DOS4): ');
    FOR i := 1 TO 8 DO BEGIN
      IF FatTypeText[i] IN ['A'..'Z', '0'..'9']
        THEN Write(FatTypeText[i]);
    END;
    IF Lo(DosVersion) < 4 THEN
      WriteLn('Hier kann bei Ihrem DOS auch etwas anderes stehen');

    WriteLn;

  END;
END.