(*========================================================*)
(*                  BOOT.PAS  (Version 2.10)              *)
(*      Copyright (C) 1991-95 J. Braun & DMV-Verlag       *)
(*  published in toolbox Magazine (GER) Issue 1(1991)     *)
(*            Compiler:  Turbo Pascal 6.0-7.0             *)
(* ------------------------------------------------------ *)
(* Changes (update) 07/16/95: Check on Win'95 (MS-DOS 7)  *)
(* You can switch with this program from Win'95 to PC-DOS *)
(* 7.0 and vice versa. This is a great help if you want   *)
(* to use Win'95 as a second OS with PC DOS 7 on the hard *)
(* disk without booting PC DOS from floppy disk           *)
(* ------------------------------------------------------ *)
(* THIS PROGRAM AND THE RELATED ONES ARE COPYRIGHTED. YOU *)
(* MAY USE THEM WITHOUT PAYING ANY LICENSE FEE FOR        *)
(* PRIVATE AND COMMERICAL USE. COMMERCIAL DISTRIBUTION IS *)
(* GENERALLY PROHIBITED (FREE DISTRIBUTION IS ALLOWED!)   *)
(* IF YOU DISTRIBUTE THE PROGRAMS YOU MUST DISTRIBUTE THE *)
(* SOURCES TOO.                                           *)
(*========================================================*)
(* IF you use Turbo/BP 7 set VER60 in the IDE. Recompile  *)
(* the programs only in Real mode. They will crash in     *)
(* DPMI mode (They are originally written in TP6)         *)
{.$DEFINE debug}            (* Debugging-Informationen on *)
{$A+,B-,E-,F-,I+,N-,O-,V-,X-,G-,M 9216,0,0}   (* Standard *)
{$IFDEF debug} {$D+,L+,S+,R+} {$ELSE} {$D-,L-,S-,R-}{$ENDIF}

PROGRAM BootSwitch;

USES
  Dos,
  Absolute,
  DOSCountry,
  Reboot;

TYPE
  Str255    = STRING[255];
  tError    = (NoSystem,         NoBootSave,
               WrongParam,       NoDir,
               NoConfig,         NoAutoexec,
               ConfigNotWritten, AutoexecNotWritten,
               NoHardDrive,      UserBreak,
               NoPartSave,       NotInstalled);
  tXtens    = (SYS, BAT);                (* Systemdateien *)
  tYesNo    = (Y, N);

CONST
  ErrStr: ARRAY[tError] OF STRING[51] =
   ('Kein oder unbekanntes Betriebssystem auf der Platte',
    'Bootsektor-Sicherungsdatei fehlt',
    'Falscher oder unbekannter Kommandozeilenparameter',
    'Das Verzeichnis mit den Sicherungsdateien fehlt',
    'CONFIG.SYS fehlt',
    'AUTOEXEC.BAT fehlt',
    'CONFIG.SYS kann nicht geschrieben werden',
    'Ich kann die neue AUTOEXEC.BAT nicht schreiben',
    'Ich habe kein Plattenlaufwerk C gefunden',
    'Boot durch Benutzer beendet',
    'Partitions-Sicherungsdatei fehlt',
    'System ist nicht auf der Platte');

  OnlyFile    : BYTE    = AnyFile - VolumeID - Directory;

  internalFlag: BOOLEAN = FALSE; (* load same system again! *)
  drdos56Flag : BOOLEAN = FALSE; (* DR-DOS 5/6?             *)
  dopartFlag  : BOOLEAN = FALSE; (* write partition table?  *)
  germanFlag  : BOOLEAN = FALSE; (* Msg. German/english     *)

  IoError    : ARRAY[1..2]   OF BOOLEAN    = (FALSE, FALSE);
  StdExt     : ARRAY[tXtens] OF STRING[ 3] = ('SYS', 'BAT');
  StartFiles : ARRAY[tXtens] OF STRING[10] = ('\CONFIG.',
                                              '\AUTOEXEC.');
  YesNo     : ARRAY[tYesNo] OF CHAR       = ('J', 'N');

  AbortMsg  : STRING[26] = 'Programm wird abgebrochen!';
  BootDriv  : STRING[ 2] = 'C:';          (* Boot drive *)

  OldSysType: tSystems   = none;          (* act. System  *)
  NewSysType: tSystems   = none;          (* new  System  *)

  Copyright : STRING[48] = 'BootSwitch v2.00b, (C) 1991-95 ' +
                           'DMV-Verlag, Poing';

  BS        = CHR( 8);    (* Backspace               (^H) *)
  TAB       = CHR( 9);    (* Tabulator               (^I) *)
  LF        = CHR(10);    (* LineFeed                (^J) *)
  CR        = CHR(13);    (* Carridge Return = Enter (^M) *)
  CRLF      = CR + LF;    (* DOS-Line feed         (^M^J) *)

VAR
  OrgDir    : PathStr;   (* Start directory when loading  *)
  CheckPart : ComStr;    (* write partition table?        *)

  (* the buffers for the hard disk parameter informations *)
  BootSectorBuffer: tSectBuffer;     (* Boot sector       *)
  PartSectorBuffer: tSectBuffer;     (* part. table       *)

  YesOrNo         : CHAR;     (* fr user input           *)
  CommLine        : ComStr;   (* command line parameters  *)
  i               : BYTE;     (* counter variable         *)

FUNCTION CheckOldSystem: tSystems;
(* Check which system is active when program is envoked   *)
VAR
  w         : WORD;
  j, s      : tSystems;
  BufString : Str255;
BEGIN
  BufString := '';
  j         := none;

  ReadBootSector(C, BootSectorBuffer);

  FOR w := 20 TO MaxBufSize DO
    IF Chr(BootSectorBuffer[w]) IN
      ['A' .. 'Z', 'a' .. 'z', '2', '$'] THEN
      BufString := BufString + CHR(BootSectorBuffer[w]);

  FOR s := IBM TO SysCount DO
    IF Pos(SysIDs[s], BufString) > 0 THEN j := s;

  IF Pos('MSWIN4.0', BufString) > 0 THEN BEGIN
    j              := Win95;
    CheckOldSystem := j;
    Exit;
  END;

  IF (j = IBM) AND ((Pos('Laden', BufString) > 0) OR
     (Pos('Loading', BufString) > 0)) THEN
       drdos56Flag := TRUE;
    (* This message does'nt exist in the bootsector of  *)
    (* IBM DOS so it is DR DOS                          *)

  CheckOldSystem := j;
END;

FUNCTION Ask (Message: Str255) : CHAR;
(* Conversion of the ReadLn string into a character.      *)
(* 'J' instead of 'Y' is accepted                         *)
VAR
  s : STRING[1];
  c : CHAR;
BEGIN
  REPEAT
    c := Chr(0);
    Write(Message);
    ReadLn(s);
    IF s <> '' THEN BEGIN
      IF (Pos('Y', s) > 0) OR (Pos('y', s) > 0) OR
         (Pos('J', s) > 0) OR (Pos('j', s) > 0) THEN
        c := YesNo[Y]
      ELSE IF (Pos('N', s) > 0) OR (Pos('n', s) > 0) THEN
        c := YesNo[N];
    END;
  UNTIL c IN [YesNo[Y], YesNo[N]];
  Ask := c;
END;

PROCEDURE HelpInfo;
(*   Help display on parameters /? and /H                 *)
VAR
  i : tSystems;
BEGIN
  IF germanFlag THEN
    WriteLn(CRLF + 'Aufruf mit:')
  ELSE BEGIN
    WriteLn(CRLF + 'Parameters:');
    ParamMsg[MSDOS][3] := ' '; ParamMsg[DRS][3]   := ' ';
    ParamMsg[MOS][3]   := ' '; ParamMsg[PLS][4]   := ' ';
    ParamMsg[IBM]      := 'PC DOS and DR DOS 5.0';
  END;

  FOR i := IBM TO SysCount DO BEGIN
    Write(TAB + 'BOOT /' + Systems[i] + ' f');
    IF germanFlag THEN Write('') ELSE Write('o');
    Write('r ' + ParamMsg[i]);
    IF i = OS2 THEN Write('/1.21/1.3');
    WriteLn;
  END;

  WriteLn;

  IF germanFlag THEN BEGIN
    WriteLn(TAB + 'BOOT /H | /?  dieser Hilfebildschirm');
    WriteLn(TAB + 'BOOT          '
          + 'aktuelle Systeminformationen.');
    WriteLn(TAB + '              '
          + 'Das Prfix ''/'' ist optional.' + LF);
    WriteLn('Die Bootsektor-Dateien sowie die AUTOEXEC.XXX '
          + 'und CONFIG.XXX mssen mit der');
    WriteLn('entsprechenden Dateiendung im Verzeichnis '
          + SysDir + ' sein.');
    WriteLn('Verwenden Sie hierzu das Programm PREP.'+LF);
    WriteLn('Wird als zweiter Parameter /P angegeben, '
          + 'wird die Partitionstabelle');
    WriteLn('ebenfalls gesichert und (falls vorhanden) '
          + 'geschrieben.');

  END ELSE BEGIN

    WriteLn(TAB + 'BOOT /H | /?  this help screen');
    WriteLn(TAB + 'BOOT          system informations');
    WriteLn(TAB + '              '
          + 'the prefix ''/'' is optional.' + LF);
    WriteLn('The files with the '
          + 'stored bootsectors plus AUTOEXEC.XXX');
    WriteLn('and CONFIG.XXX must'
          + ' be in the Directory '+ SysDir + '.');
    WriteLn('The files must '
          + 'have the correct file extension.');
    WriteLn('This extension must'
          + ' be identical with the commandline');
    WriteLn('parameter for the specified system.' + LF);
    WriteLn('For the correct installation of the systems '
          + 'use PREP' + LF);
    WriteLn('To save and write (if the file exists) the '
          + 'partition');
    WriteLn('table, use /p as second command line '
          + 'parameter.');
  END;
END;

PROCEDURE Error(Message: tError);
(*  Errormessage, exit                                    *)
BEGIN
  ChDir(OrgDir);
  IF Message = UserBreak THEN BEGIN
    WriteLn(ErrStr[Message] + '!');
  END ELSE IF Message = WrongParam THEN BEGIN
    IF germanFlag THEN Write('Fehler: ')
                  ELSE Write('Error: ');
    Write(ErrStr[Message] + '!'+ LF);
    HelpInfo;
  END ELSE BEGIN
    Write(CRLF + 'fatal');
    IF germanFlag THEN Write('er Fehler Nr. ')
                ELSE Write(' Error No. ');
    Write(BYTE(Message));
    Write(': '+ ErrStr[Message]+'!' + CRLF + AbortMsg + LF);
  END;
  Halt(1)
END;


FUNCTION FileExistFunc(FileName: PathStr;
                           Attr: BYTE): BOOLEAN;
(*  Does the file/directory 'FileName' exist?  *)
VAR
  sr: SearchRec;
BEGIN
  FileExistFunc := FALSE;
  sr.Name := '';
  FindFirst(FileName, Attr, sr);
  IF (Pos(FileName, sr.Name) > 0) AND
     (Length(sr.Name) > 0) THEN BEGIN
    FileExistFunc := TRUE;
    Exit;
  END;
  IF (Pos(sr.Name, FileName) > 0) AND
     (Length(sr.Name) > 0) THEN
    FileExistFunc := TRUE;
END;

PROCEDURE ChangeDir;
(*   Test, if the backup directory exists. If not, the    *)
(*   directory will be made.                              *)
BEGIN
{$I-}
  IF NOT FileExistFunc(SysDir, Directory) THEN
    MkDir(SysDir);
  ChDir(SysDir);
  IF IOResult <> 0 THEN Error(NoDir); (* Does'nt work *)
{$I+}
END;

PROCEDURE BootInfo;
(* Informationens to the boot systems if Boot is envoked  *)
(* without command line parameters                        *)
VAR
  i, j : tSystems;
BEGIN
  ChDir(SysDir);

  IF IOResult = 0 THEN BEGIN
    IF germanFlag THEN
      WriteLn('Folgende Betriebssysteme sind im '
            + 'Bootswitcher installiert:')
    ELSE
      WriteLn('The following operating systems '
            + 'are installed:');
    WriteLn;

    FOR i := IBM TO SysCount DO BEGIN
      IF (i = MsDos) AND (Lo(DosVersion) = 7) THEN
          i := Win95;

      IF FileExistFunc(BootFile +
                       Systems[i], OnlyFile) THEN BEGIN
        Write(' ': 5, Names[i]);


        IF i = IBM THEN BEGIN
          IF germanFlag THEN Write(' oder DR-DOS 5/6')
                    ELSE Write(' or DR DOS 5/6');
        END;


        IF i = DRS THEN Write(' 3.41' + TAB)
                   ELSE Write(TAB + TAB);

        IF i <> IBM THEN BEGIN
          IF (Length(Names[i]) < 16) THEN Write(TAB);
          IF (Length(Names[i]) < 11) THEN Write(TAB);
        END;

        IF germanFlag THEN Write('Systemdateien ')
                  ELSE Write('System files ');

        IF NOT FileExistFunc(BootDriv + '\' +
               SysIDNames[i], OnlyFile) THEN
          WriteLn(SysIDNames[i] + ParamMsg[none])
        ELSE BEGIN
          IF germanFlag THEN WriteLn('vorhanden.')
                    ELSE WriteLn('found.');
        END;

      END;
    END;

    IF NOT FileExistFunc(BootFile + Systems[OS1],
                          OnlyFile) THEN BEGIN
      IF FileExistFunc(BootDriv + '\' + SysIDNames[OS1],
                          OnlyFile) THEN BEGIN
        IF germanFlag THEN
          WriteLn(' ':5, 'OS2 1.1 nicht im Bootswitcher '
                       + 'aber auf der Platte vorhanden!')
        ELSE
          WriteLn(' ':5, 'OS2 1.1 not in the bootswitch '
                 + 'system but on the harddisk available!');
      END;
    END;

    (* Is the bootsystem used or does boot.com of OS/2    *)
    (* exist. Warning: this program does'nt work with     *)
    (* 32-Bit OS/2 2.x/3.x                                *)
    IF NOT FileExistFunc(BootFile + Systems[OS2],
                          OnlyFile) THEN BEGIN
      IF FileExistFunc(BootDriv + '\' +
               SysIDNames[OS2], OnlyFile) THEN BEGIN
        IF germanFlag THEN
          WriteLn(' ':5, 'OS2 1.2/1.3 nicht im Bootswitcher'
                + ' aber auf der Platte vorhanden!')
        ELSE
          WriteLn(' ':5, 'OS2 1.2/1.3 not in the bootswitch'
                + ' system but on the harddisk available!');
      END;
    END;

    WriteLn;

  END ELSE BEGIN
    IF germanFlag THEN Write('Verzeichnis ') (* Fehler *)
              ELSE Write('Directory ');
    WriteLn(SysDir + ParamMsg[none]);
  END;

  i := OldSysType;
  IF (i = MsDos) AND (Lo(DosVersion) = 7) THEN i := Win95;

  IF (i = Win95) THEN BEGIN
    IF germanFlag THEN BEGIN
      Write('Der aktuelle Bootsektor auf der Festplatte'
          + ' ldt ' + Names[i] + '.');
    END ELSE BEGIN
      Write('The actual bootsector on the hard '+
           'disk belongs to '+ Names[i] + '.');
    END;
  END;

  IF (i = IBM) AND (drdos56Flag = TRUE) THEN BEGIN
    Names[i] := 'DR-DOS 5/6';
    IF germanFlag THEN BEGIN
      Write('Der aktuelle Bootsektor auf der Festplatte'
          + ' ldt ' + Names[i] + '.');
      IF drdos56Flag THEN
        Write(CR+LF+'Die Bootsektor-Kennung ist "PC-DOS".')
    END ELSE BEGIN
      Write('The actual bootsector on the hard '+
           'disk belongs to '+ Names[i] + '.');
      IF drdos56Flag THEN
        Write(CR + LF + 'The bootsector ID is "PC DOS".')
    END;
  END ELSE WriteLn;
END;

FUNCTION CheckParams(Get: Str255): tSystems;
(*             Commandline check                          *)
VAR
  i: tSystems;
  j: BYTE;
BEGIN
  FOR i := IBM TO SysCount DO BEGIN
    j := Pos(Systems[i], Get);
    IF j > 0 THEN BEGIN
      CheckParams := i;
      Exit;
    END;
  END;
  Error(WrongParam)
END;

PROCEDURE PrepareDisk(FileType: tSystems);
(* Bootsector, config.sys and autoexec.bat are to be      *)
(* written                                                *)

  PROCEDURE pReCopy(FType: tXtens);
  VAR
    f1, f2    : TEXT;
    Line      : Str255;
    SaveName,
    StartName : PathStr;
    i         : BYTE;
  BEGIN
    IF germanFlag THEN Write('Schreibe ')
                  ELSE Write('Writing ');
    FOR i := 2 TO Length(StartFiles[FType]) DO
      Write(StartFiles[FType][i]);
    WriteLn(StdExt[FType] + ' ...');
    StartName := Concat(BootDriv, StartFiles[FType],
                         StdExt[FType]);
    Assign(f1, StartName);
    IF FileExistFunc(StartName, OnlyFile) THEN
      SetFAttr(f1, Archive);
    {$I-}
    ReWrite(f1);
    {$I+}
    IF IOResult <> 0 THEN BEGIN
      IF FType = SYS THEN Error(NoConfig);
      IF FType = BAT THEN Error(NoAutoexec);
    END;
    SaveName := Concat(SysDir, StartFiles[FType],
                        Systems[FileType]);
    Assign(f2, SaveName);
    IF FileExistFunc(SaveName, OnlyFile) THEN
       SetFAttr(f2, Archive);
    {$I-}
    Reset(f2);
    {$I+}
    IF IOResult <> 0 THEN BEGIN
      IF FType = SYS THEN Error(ConfigNotWritten);
      IF FType = BAT THEN Error(AutoexecNotWritten);
    END;
    Line := '';
    WHILE NOT EoF(f2) DO BEGIN
      ReadLn(f2, Line);
      IF Line <> '' THEN WriteLn(f1, Line);
    END;
    Close(f1);
    Close(f2);
  END;

  PROCEDURE BootSecFile;
  TYPE
    tBootBlock = RECORD (* DOS bootblock  *)
                   Jump       : ARRAY[01.. 03] OF BYTE;
                   OEM        : ARRAY[01.. 08] OF CHAR;
                   DiskData   : Absolute.tBPB;
                   DiskLabel  : ARRAY[01.. 11] OF CHAR;
                   FATTypeText: ARRAY[01.. 08] OF CHAR;
                   DosLoader  : ARRAY[00..351] OF BYTE;
                   Messages   : ARRAY[00.. 64] OF CHAR;
                   FileLoader : ARRAY[00.. 30] OF CHAR;
                   EndMarker  : ARRAY[00.. 01] OF CHAR;
                 END;
  VAR
    TempSectorBuffer: tSectBuffer;   (* temporrer Puffer *)
    ABBlock         : tBootBlock ABSOLUTE TempSectorBuffer;
    SBBlock         : tBootBlock ABSOLUTE BootSectorBuffer;
    f               : FILE OF BYTE;
    i               : WORD;
    vName           : PathStr;
    YesOrNo         : CHAR;
  BEGIN
    vName := SysDir + '\' + BootFile + Systems[FileType];
    Assign(f, vName);
    IF FileExistFunc(vName, OnlyFile) THEN
      SetFAttr(f, Archive);
    {$I-}
    Reset(f);
    {$I+}
    IF IOResult <> 0 THEN Error(NoBootSave);

    FOR i := 0 TO MaxBufSize DO
      Read(f, BootSectorBuffer[i]);
    Close(f);
    SetFAttr(f, Archive + Hidden);

    ReadBootSector(C, TempSectorBuffer);

    IF (SBBlock.DiskData.SectorsPerTrack <>
        ABBlock.DiskData.SectorsPerTrack)
    OR (SBBlock.DiskData.Heads <>
        ABBlock.DiskData.Heads)
    OR (SBBlock.DiskData.ReservedSectors <>
        ABBlock.DiskData.ReservedSectors) THEN BEGIN

      IF germanFlag THEN BEGIN
        WriteLn('Aktuelle Plattenparameter unterscheiden ' +
                'sich von den gesicherten!');
        WriteLn('Gesicherte Werte:');
        WITH SBBlock DO BEGIN
          Write(  'Kpfe: ', DiskData.Heads,
                  ' Sektoren gesamt: ');
          IF DiskData.TotalSectors <> 0 THEN
            Write(DiskData.TotalSectors)
          ELSE
            Write(DiskData.BigTotalSectors);
          WriteLn(' Sektoren/Spur: ',
                  DiskData.SectorsPerTrack,
                  ' reserv. Sekt.: ',
                  DiskData.ReservedSectors);
        END;
        WriteLn('Aktuelle Werte:');
        WITH ABBlock DO BEGIN
          Write('Kpfe: ', DiskData.Heads,
                ' Sektoren gesamt: ');
          IF DiskData.TotalSectors <> 0 THEN
            Write(DiskData.TotalSectors)
          ELSE
            Write(DiskData.BigTotalSectors);
          WriteLn(' Sektoren/Spur: ',
                  DiskData.SectorsPerTrack,
                  ' reserv. Sekt.: ',
                  DiskData.ReservedSectors);
        END;
        YesOrNo := Ask('Soll der Bootsektor wirklich ' +
                       'berschrieben werden? (J/N) ')
      END ELSE BEGIN
        WriteLn('Actual disk parameters differ from the ' +
                 'stored!');
        WriteLn('Stored parameters:');
        WITH SBBlock DO BEGIN
          Write('heads: ', DiskData.Heads,
                ' total sectors: ');
          IF DiskData.TotalSectors <> 0 THEN
            Write(DiskData.TotalSectors)
          ELSE
            Write(DiskData.BigTotalSectors);
          WriteLn(' sectors/track: ',
                  DiskData.SectorsPerTrack,
                  ' reserv. sect.: ',
                  DiskData.ReservedSectors);
        END;
        WriteLn('Actual parameters:');
        WITH ABBlock DO BEGIN
          Write('heads: ', DiskData.heads,
                ' total sectors: ');
          IF DiskData.TotalSectors <> 0 THEN
            Write(DiskData.TotalSectors)
          ELSE
            Write(DiskData.BigTotalSectors);
          WriteLn(' sectors/track: ',
                  DiskData.SectorsPerTrack,
                  ' reserv. sect.: ',
                  DiskData.ReservedSectors);
        END;
        YesOrNo := Ask('Shall I overwrite the ' +
                       'bootsector? (Y/N) ');
      END;

      IF YesOrNo = 'N' THEN BEGIN
        IF germanFlag THEN
           WriteLn('Bootswitch wurde abgebrochen !')
         ELSE
           WriteLn('Bootswitch aborted !');
        Halt(1);
      END ELSE BEGIN
        IF germanFlag THEN
          WriteLn('Weiter auf eigene Gefahr ...')
        ELSE
          WriteLn('Continued on your own risk ...');
        FOR i := 0 TO MaxInt DO ;        (* Warteschleife *)
      END;
    END;

    IF germanFlag THEN
      Write('Schreibe Bootsektor ...')
    ELSE
      Write('Updating bootsector information ...');

    WITH SBBlock.DiskData DO BEGIN
    (* The reserved area of the bootsector is different    *)
    (* in several operating system. This looks crude but   *)
    (* in worst case the hard disk data will be saved.     *)
    (* DR-DOS uses the area of "BigTotalSectors" in        *)
    (* different manner (as IBM DOS ands MS DOS. It may    *)
    (* not be copied!                                      *)
     BytesPerSector   := ABBlock.DiskData.BytesPerSector;
     SectorsPerCluster:= ABBlock.DiskData.SectorsPerCluster;
     ReservedSectors  := ABBlock.DiskData.ReservedSectors;
     NumberOfFATs     := ABBlock.DiskData.NumberOfFATs;
     RootEntries      := ABBlock.DiskData.RootEntries;
     TotalSectors     := ABBlock.DiskData.TotalSectors;
     MediaDescriptor  := ABBlock.DiskData.MediaDescriptor;
     SectorsPerFAT    := ABBlock.DiskData.SectorsPerFAT;
     SectorsPerTrack  := ABBlock.DiskData.SectorsPerTrack;
     Heads            := ABBlock.DiskData.Heads;
     HiddenSectors    := ABBlock.DiskData.HiddenSectors;
    END;
    WriteBootSector(C, BootSectorBuffer);
    WriteLn;
  END;

  PROCEDURE PartTableFile;
  VAR
     f    : FILE OF BYTE;
     i    : WORD;
     fName: PathStr;
  BEGIN
   (* While the bootsector hat to be written in any case. *)
   (* the partition table needs not to be written any     *)
   (* time, with the exception if a virus has infected    *)
   (* the hard disk (for example "Stoned" or a new        *)
   (* Partition switcher (for example for Coherent Unix   *)
   (* was installed.                                      *)
    fName := Concat(SysDir, '\', PartFile,
             Systems[FileType]);
    IF FileExistFunc(fName, OnlyFile) THEN BEGIN
      Assign(f, fName);
      SetFAttr(f, Archive);
      {$I-}
      Reset(f);
      {$I+}
      IF IOResult = 0 THEN BEGIN
        FOR i := 0 TO MaxBufSize DO
          Read(f, PartSectorBuffer[i]);
        Close(f);
        SetFAttr(f, Archive + Hidden);
        IF germanFlag THEN
          WriteLn('Schreibe Partitionstabelle ...')
        ELSE
          WriteLn('Writing partition table...');
        WritePartition(C, PartSectorBuffer);
      END;
    END;
  END;

BEGIN
  {$I-}
  ChDir(BootDriv + '\');
  IF IOResult <> 0 THEN Error(NoHardDrive);
  {$I+}
  ChangeDir;
  WriteLn;
  pReCopy(SYS);
  pReCopy(BAT);

  IF NOT internalFlag THEN BEGIN
    BootSecFile;
    IF dopartFlag THEN PartTableFile;
  END

END;

PROCEDURE SaveOldSystem;
(* Save the old data. config.sys and autoxec.bat are      *)
(* backed up and will be written into the backup directory*)
(* with the correct extension. The bootsector will be     *)
(* saved, too.                                            *)
VAR
  BootFileName,
  PartFileName,
  FileName,
  Name         : PathStr;
  f1, f2       : FILE OF BYTE;
  i, Attr      : WORD;
  FileExists   : BOOLEAN;
  FTime        : LONGINT;

  PROCEDURE CopyCfgFile(FType: tXtens);
  VAR
   txt1, txt2 : Text;
   Line       : Str255;
   Name       : PathStr;
  BEGIN
    Name := Concat(BootDriv, StartFiles[FType],
                   StdExt[FType]);
    Assign(txt1, Name);
    {$I-}
    Reset(txt1);
    {$I+}
    IoError[1] := IOResult <> 0;

    IF NOT IoError[1] THEN BEGIN
      GetFTime(txt1, FTime);
      Close(txt1);
      GetFAttr(txt1, Attr);
      SetFAttr(txt1, Archive);
      {$I-}
      Reset(txt1);
      {$I+}
      FileName := Concat(SysDir, StartFiles[FType],
                         Systems[OldSysType]);
      Assign(txt2, FileName);
      IF FileExistFunc(FileName, OnlyFile) THEN
         SetFAttr(txt2, Archive);
      {$I-}
      ReWrite(txt2);
      {$I+}
      WHILE NOT EoF(txt1) DO BEGIN
        Line := '';
        ReadLn(txt1, Line);
        IF Line <> '' THEN WriteLn(txt2, Line);
      END;
      Close(txt1);
      Close(txt2);
      SetFAttr(txt1, Attr);
      SetFAttr(txt2, Archive + ReadOnly);
      SetFTime(txt2, FTime);
    END;
  END;

BEGIN
  IF germanFlag THEN Write('Sichere ')
                ELSE Write('Saving ');
  WriteLn(Names[OldSysType] + ':');

  IF OldSysType > none THEN BEGIN
    ChangeDir;
    IF NOT internalFlag THEN BEGIN
      BootFileName := Concat(BootFile, Systems[OldSysType]);
      Assign(f1, BootFileName);
      IF FileExistFunc(BootFileName, OnlyFile) THEN
        SetFAttr(f1, Archive);
      {$I-}
      Reset(f1);
      {$I+}
      IF IOResult <> 0 THEN BEGIN      (* dann eben nicht *)
        Write(BootFileName);
        IF germanFlag THEN
          WriteLn(' kann nicht geschrieben werden!')
        ELSE
          WriteLn(': access denied!');
        WriteLn(AbortMsg);
        Halt;
      END ELSE BEGIN
        FOR i := 0 TO MaxBufSize DO
          Write(f1, BootSectorBuffer[i]);
        Close(f1);
        SetFAttr(f1, Archive + Hidden);
        IF germanFlag THEN
          WriteLn('Die Datei ' + BootFileName +
                  ' wurde gesichert.')
        ELSE
          WriteLn('The file ' + BootFileName +
                  ' is backed up.');
      END;
    END;

    IF dopartFlag THEN BEGIN
      IF NOT internalFlag THEN BEGIN
        ReadPartition(C, PartSectorBuffer);
        PartFileName := Concat(PartFile,
                               Systems[OldSysType]);
        Assign(f2, PartFileName);
        IF FileExistFunc(PartFileName, OnlyFile) THEN
          SetFAttr(f2, Archive);
        {$I-}
        Reset(f2);
        {$I+}
        IF IOResult <> 0 THEN BEGIN    (* dann eben nicht *)
          IF germanFlag THEN
            WriteLn(PartFileName +
                    ' kann nicht geschrieben werden!')
          ELSE
            WriteLn(PartFileName + ': access denied!');
          FOR i := 0 TO MaxBufSize DO
            Write(f2, PartSectorBuffer[i]);
          Close(f2);
          SetFAttr(f2, Archive + Hidden);
          IF germanFlag THEN
            WriteLn('Die Datei ' + PartFileName +
                    ' wurde gesichert.')
          ELSE
            WriteLn('The file ' + PartFileName +
                    ' is backed up.');
        END;
      END;
    END;

    CopyCfgFile(BAT);
    CopyCfgFile(SYS);

    IF NOT IoError[1] THEN BEGIN
      FOR i := 2 TO Length(StartFiles[SYS]) DO
        Write(StartFiles[SYS][i]);
      Write(Systems[OldSysType]);
    END;

    IF NOT (IoError[1] AND IoError[2]) THEN BEGIN
      IF germanFlag THEN Write(' und ') ELSE Write(' and ');
    END;

    IF NOT IoError[2] THEN BEGIN
      FOR i := 2 TO Length(StartFiles[BAT]) DO
        Write(StartFiles[BAT][i]);
      Write(Systems[OldSysType] + ' ');
    END;

    IF NOT (IoError[1] OR IoError[2]) THEN BEGIN
      IF germanFlag THEN Write('wurde') ELSE Write('was');
    END;

    IF NOT (IoError[1] AND IoError[2]) THEN BEGIN
      IF germanFlag THEN Write('n')
                    ELSE Write(BS + BS + 'ere');
    END;

    IF NOT (IoError[1] AND IoError[2]) THEN BEGIN
      IF germanFlag THEN Write(' gesichert.')
                ELSE Write(' backed up.');
    END;

    IF germanFlag THEN BEGIN
      IF IoError[1] THEN
        WriteLn(BootDriv + StartFiles[SYS] + StdExt[SYS]
              + ' fehlte!');
      IF IoError[2] THEN
        WriteLn(BootDriv + StartFiles[BAT] + StdExt[BAT]
              + ' fehlte!');
    END ELSE BEGIN
      IF IoError[1] THEN
        WriteLn(BootDriv + StartFiles[SYS] + StdExt[SYS]
              + ' not found!');
      IF IoError[2] THEN
        WriteLn(BootDriv + StartFiles[BAT] + StdExt[BAT]
              + ' not found!');
    END
  END ELSE Error(NoSystem);
END;

PROCEDURE PatchMessages;
BEGIN
  AbortMsg       := 'Program aborted!';
  ParamMsg[none] := ' not found!';

  ErrStr[NoSystem]    := 'No or unknown operating system ' +
                       'on the harddisk';
  ErrStr[NoBootSave]  := 'Bootsector backup is missing';
  ErrStr[WrongParam]  :=  'Wrong or unknown commandline ' +
                          'parameter';
  ErrStr[NoDir] := 'Directory with backup files not found';
  ErrStr[NoConfig]    := 'CONFIG backup file is missing';
  ErrStr[NoAutoexec]  := 'AUTOEXEC backup file is missing';
  ErrStr[ConfigNotWritten]   := 'Cannot write CONFIG.SYS';
  ErrStr[AutoexecNotWritten] := 'Cannot write AUTOEXEC.BAT';
  ErrStr[NoHardDrive] := 'No harddisk C: available';
  ErrStr[UserBreak]   := 'Program interrupted by user';
  ErrStr[NoPartSave]  := 'Partition backup file not found';
  ErrStr[NotInstalled]
                 := 'System not on the harddisk available';
END;

BEGIN
  IF fGetCountry IN [Austria, Switzerland, Germany] THEN
    germanFlag := TRUE
  ELSE
    PatchMessages;

  OldSysType := CheckOldSystem;

  IF NOT germanFlag THEN BEGIN
    Names[IBM][7]   := ' '; (* minus are to be           *)
    Names[MSDOS][3] := ' '; (* erased from the           *)
    Names[DRS][3]   := ' '; (* names                     *)
    Names[MOS][3]   := ' '; (* Sorry, but I'm German :-) *)
    Names[PLS][4]   := ' ';
  END;

  GetDir(0, OrgDir);
  WriteLn(Copyright);
  IF ParamCount = 0 THEN BEGIN
    WriteLn;
    BootInfo;
    ChDir(OrgDir);
    Halt(0);
  END ELSE BEGIN
    CommLine := ParamStr(1);
    IF ParamCount > 1 THEN BEGIN
      CheckPart := ParamStr(2);
      FOR i := 1 TO Length(CheckPart) DO
        CheckPart[i] := UpCase(CheckPart[i]);
      IF Pos('P', CheckPart) > 0 THEN dopartFlag := TRUE;
    END;
    FOR i := 1 TO Length(CommLine) DO
      CommLine[i] := UpCase(CommLine[i]);
    IF (Pos('?', CommLine) > 0) OR
       (Pos('H', CommLine) > 0) THEN HelpInfo
    ELSE BEGIN
      IF OldSysType = none THEN Error(NoSystem);
      NewSysType := CheckParams(CommLine);
      IF OldSysType = NewSysType THEN BEGIN
        IF germanFlag THEN BEGIN
          YesOrNo := Ask(Names[OldSysType]
                + ' wird bereits gestartet. '
                + 'Trotzdem nochmals installieren? (J/N) ');
        END ELSE BEGIN
          YesOrNo := Ask(Names[OldSysType] + ' is active.' +
                + ' Nevertheless install it again? (Y/N) ');
        END;
        internalFlag := TRUE;
        IF YesOrNo = YesNo[Y] THEN BEGIN
          IF dopartFlag THEN BEGIN
          (* Boot sector and partition table must not be *)
          (* written again. They are already active.     *)
            IF germanFlag THEN
               WriteLn('Parameter /p wird ignoriert.')
            ELSE
               WriteLn('Parameter /p will be ignored.');
          END;
        END ELSE Error(UserBreak);
      END ELSE BEGIN
       (* Test: are the system files of the requested OS *)
       (* on the hard disk!!??                           *)
        IF NOT FileExistFunc(BootDriv + '\' +
               SysIDNames[NewSysType], OnlyFile) THEN
          Error(NotInstalled);
       (* If yes, is the system installed in the boot manager *)
        IF NOT FileExistFunc(SysDir + '\' + BootFile +
           Systems[NewSysType], OnlyFile) THEN
          Error(NoBootSave);

        IF germanFlag THEN
          YesOrNo := Ask('Bootsystem wird nach '
                        + Names[NewSysType]
                        + ' gendert. Durchfhren? (J/N) ')
        ELSE
          YesOrNo := Ask('Bootsystem will be changed to '
                   + Names[NewSysType] + '. Okay? (Y/N) ');
        IF YesOrNo = YesNo[Y] THEN SaveOldSystem
                              ELSE Error(UserBreak);
      END;

      IF YesOrNo = YesNo[Y] THEN BEGIN
        PrepareDisk(NewSysType);
        IF germanFlag THEN
          Write('System wird neu gestartet, bitte warten')
        ELSE
          Write('System reboot recommended, please wait');
        WriteLn(' ...');
        WarmBoot;
      END;
    END;
  END;
END.

(*========================================================*)
(*                   Ende von BOOT.PAS                    *)
