#include <stdlib.h>
#include <string.h>
#include <dos.h>


/*
This a standard autodetect function as outlines in the Turbo C Manual.
If the card is detected, the highest available mode number is returned.
Otherwise a negative number indicating an error is returned.


copyright(c) 1990 by Peter F. Jones. ALL RIGHTS RESERVED.
This software may be used and included in other programs as
outlined in your software license.
*/

char   copyright1[] = "copyright(c) 1990 by Peter F. Jones. ALL RIGHTS RESERVED.";


unsigned char test_bios_mode(unsigned char bios_mode)
  {
	_AL = bios_mode;
				   /* al has desired mode on input           */
				   /* on return ax = 0xffff if not supported */
	asm       push      bp
	asm       mov       bp,sp
        asm       push      es
        asm       mov       ah,12h
        asm       mov       bx,5506h
        asm       mov       bp,0ffffh
        asm       int       10h
        asm       mov       ax,bp
        asm       pop       es
	asm       pop       bp
	if (_AX==0xffff)
	       return(0);
	     else
	       return(1);

  };




unsigned char test_512K_memory(void)
	{
	asm      push es         /* save registers es and bx                   */
	asm      push bx
	asm      mov  ax,0c000h  /*define storage location of EXTENDED_REG     */
        asm      mov  es,ax
        asm      mov  bx,010h
        asm      mov  dx,es:[bx] /*get the value of EXTENDED_REG from contents */
				 /*;of the storage location C000:0010h         */
        asm      pop  bx         /*;restore registers es and bx                */
        asm      pop  es

        asm       cli
				 /*  dx has EXTENDED_REG */
        asm       mov       al,0bbh
        asm       out       dx,al
        asm       inc       dx
        asm       in        al,dx
        asm       sti
	asm       and       al,020h


			      /*     al = 0  ; 256K display memory installed   */
			      /*        = 20h; 512K display memory installed   */

	if (_AL==0x20)
	       return(1);
	     else
	       return(0);


};






int huge detect_ATI_VGA_Wonder()
    {
     int   counter;
     char  manufacturer_id[] = "761295520";
     char  chip_set_id[] =     "31";
     char far  *manufacturer;
     char far  *chip_set;
     unsigned char  found;

	found = 1;
	manufacturer = MK_FP(0xC000,0x0031);
	chip_set     = MK_FP(0xC000,0x0040);

	for(counter=0;counter<9;counter++)
	  if (manufacturer[counter]!=manufacturer_id[counter]) found = 0;

	if (found)
	for(counter=0;counter<2;counter++)
	  if (chip_set[counter]!=chip_set_id[counter]) found = 0;

      if (!found) return(-11);    /* graphics error - no ATI Wonder */


      if (test_512K_memory())   /*if 512k then try hires modes*/
	 {
	     if (test_bios_mode(0x63))  /*check 800x600*/
		  {
		     return(3);
		  };

	     if (test_bios_mode(0x62))  /*check 640x480*/
		 {
		     return(2);
		  };
	 };

	     if (test_bios_mode(0x61))  /*check 640x400*/
		  {
		     return(1);
		  };

	     if (test_bios_mode(0x13))   /*check 320x200*/
		  {
		     return(0);
		  };
       };


