{WFPLUS - Function Extensions to ObjectWindows Copyright (C) Doug Overmyer 7/1/91}
unit WFPlus;


{******************************************************************}
{ I N T E R F A C E                                                        }
{******************************************************************}
interface
uses WinTypes, WinProcs, WinDos, Strings, WObjects,StdDlgs;
function Max(I,J:Integer):Integer;
function Min(I,J:Integer):Integer;
function GetDateTime(szDateTime:PChar):Boolean;
function ExpandTabs(InStr,OutStr:PChar;Tabsize:Integer):Boolean;
function CheckCC(InStr,OutStr:PChar):Boolean;
{********************************************************************}
{I M P L E M E N T A T I O N                                                     }
{********************************************************************}
implementation

{***********************************************************************}
function Max(I,J:Integer):Integer;
begin
	if I > J then
		Max := I
	else
		Max := J;
end;
{***********************************************************************}
function Min(I,J:Integer):Integer;
begin
	if I < J then
   	Min := I
  else
   	Min := J;
end;

function  GetDateTime(szDateTime:PChar):Boolean;
var
  m,d,y,dw: Word;
  temp,tag: string[4];
  tStr: String;
Begin
  tStr := '';
  GetTime(y,m,d,dw);
  if (y > 12) then begin
    y := (y - 12);
    tag := 'pm';
  End else
    tag := 'am';
  str(y,temp);
  if (y < 10) then
    temp := '0' + Temp;
  tStr := tStr + temp + ':';
  str(m,Temp);
  tStr := tStr + temp + ':';
  str(d,temp);
  tStr := tStr + temp + tag + '     ';
  GetDate(y,m,d,dw);
  str(m,Temp);
  if (m < 10) then
    temp := '0' + temp;
  tStr := tStr + temp + '/';
  str(d,Temp);
  if (d < 10) then
    Temp := '0' + temp;
  tStr := tStr + Temp + '/';
  str(y,temp);
  tStr := tStr + temp;
  strPcopy(szDateTime,tStr);
  GetDateTime := True;
End;

function ExpandTabs(InStr,OutStr:PChar;Tabsize:Integer):Boolean;
var
	IndxIn,IndxOut,IndxTab:Integer;
   NextTab:Integer;
begin
	IndxIn := 0;IndxOut:= 0;IndxTab:= 0;
  For IndxIn := 0 to (StrLen(InStr) -1) do
    case InStr[IndxIn] of
    	#9:
      	begin
      	NextTab := ((IndxOut div TabSize) +1) * TabSize;
        for IndxTab := 1 to (NextTab - IndxOut) do
        	begin
          OutStr[IndxOut] := #32;
          Inc(IndxOut);
          end;
        end;
      #0..#31:
      	begin
        OutStr[IndxOut] := #32;
        Inc(IndxOut);
        end;
      else
      	begin
        OutStr[IndxOut] := InStr[IndxIn];
        Inc(IndxOut);
        end;
    end;
  OutStr[IndxOut] := #0;
  ExpandTabs := TRUE;
end;

function CheckCC(InStr,OutStr:PChar):Boolean;
var
	IndxIn,IndxOut:Integer;
begin
	IndxIn := 0;IndxOut:= 0;
  For IndxIn := 0 to (StrLen(InStr) -1) do
    case InStr[IndxIn] of
    	#9:                             {retain tabs}
        begin
        OutStr[IndxOut] := #9;
        Inc(IndxOut);
        end;
      #0..#31:
      	begin
        OutStr[IndxOut] := #32;
        Inc(IndxOut);
        end;
      else
      	begin
        OutStr[IndxOut] := InStr[IndxIn];
        Inc(IndxOut);
        end;
    end;
  OutStr[IndxOut] := #0;
  CheckCC := TRUE;
end;


end.
