{************************************************}
{   ArtShow 2.1                                  }
{   Copyright 1991 Doug Overmyer                 }
{************************************************}

program ArtShow;

{$R ARTSHoW.RES}

uses OGL1,OGL2,OGL3,WinTypes, WinProcs, WObjects, StdDlgs,
	Strings,WOPlus,StdWnds;

const
  AS_Name =  'ArtShow';
  cm_FileOpen =   101;
  cm_FileWin  =   199;
  cm_Start    =   201;
  cm_Stop	  =     301;
  cm_Back   =     351;
  cm_Help	  =     401;
  cm_ZoomOn  =    501;
  cm_ZoomOff =    502;
  cm_BPSolid =    601;
  cm_BP10  =      603;
  cm_BP15  =      604;
  cm_BP30 =       605;
  cm_BP50 =       606;
  cm_BP70   =     607;
  cm_BPHorizontal=609;
  cm_BPVertical=  611;
  cm_BPDiagonal=  613;
  cm_BPHatch=     615;
  cm_BPPebble=    617;
  cm_BPBrick=     619;

  cm_BCBlack =    700;
  cm_BCWhite =    701;
  cm_BCRed  =     702;
  cm_BCGreen =    703;
  cm_BCBlue =     704;
  cm_BCCyan =     705;
  cm_BCMagenta =  706;
  cm_BCYellow  =  707;
  cm_FullScreen = 801;
  id_BN1 =        901;
  id_BN2 =        902;
  id_BN3 =        903;
  id_BN4 =        904;
  id_BN5 =        905;
  id_BN6 =        906;
  cm_BPPSolid =    1001;
  cm_BPP10  =      1003;
  cm_BPP15  =      1004;
  cm_BPP30 =       1005;
  cm_BPP50 =       1006;
  cm_BPP70   =     1007;
  cm_BPPHorizontal=1009;
  cm_BPPVertical=  1011;
  cm_BPPDiagonal=  1013;
  cm_BPPHatch=     1015;
  cm_BPPPebble=    1017;
  cm_BPPBrick=     1019;

  cm_BCPBlack =    1100;
  cm_BCPWhite =    1101;
  cm_BCPRed  =     1102;
  cm_BCPGreen =    1103;
  cm_BCPBlue =     1104;
  cm_BCPCyan =     1105;
  cm_BCPMagenta =  1106;
  cm_BCPYellow  =  1107;
  idm_RunCP   =    1201;
  idm_About =      1202;
  idm_IconBar =    1203;
  idm_MenuBar =    1204;
  cm_FileBye  =    1301;

  fsPathName =    79;
{*****************************************************************}
{T Y P E S }
{*****************************************************************}
type
  TASApp = object(TApplication)
  procedure InitMainWindow; virtual;
end;

PASFileWin = ^TASFileWin;
TASFileWin = object(TFileWindow)
	constructor Init(AParent:PWindowsObject;ATitle,AFileName:PChar);
	procedure CMFileBye(var Msg:TMessage);virtual cm_First+cm_FileBye;
  destructor Done;virtual;
end;

PASIconBar = ^TASIconBar;
TASIconBar = object(TGWindow)
	BN1,BN2,BN3,BN4,BN5,BN6:PODButton;
  HFloatMenu:hMenu;
  HPopUpMenu:hMenu;
  constructor Init(AParent:PWindowsObject;ATitle:PChar);
  destructor Done;virtual;
  procedure SetupWindow;virtual;
  procedure WMDrawItem(var Msg:TMessage);virtual wm_First+wm_DrawItem;
	procedure WMSize(var Msg: TMessage); virtual wm_First + wm_Size;
  procedure WMMove(var Msg:TMessage); virtual wm_First+wm_Move;
  procedure WMNCLButtonDown(var Msg:TMessage);virtual wm_First+wm_NCLButtonDown;
  procedure DefChildProc(var Msg: TMessage); virtual;
	procedure IDBN1(Var Msg:TMessage);virtual id_First+id_BN1;
  procedure IDBN2(Var Msg:TMessage);virtual id_First+id_BN2;
  procedure IDBN3(Var Msg:TMessage);virtual id_First+id_BN3;
  procedure IDBN4(Var Msg:TMessage);virtual id_First+id_BN4;
  procedure IDBN5(Var Msg:TMessage);virtual id_First+id_BN5;
  procedure IDBN6(Var Msg:TMessage);virtual id_First+id_BN6;
  procedure WMCommand(Var Msg:TMessage);virtual wm_First+wm_Command;
end;

PASWindow = ^TASWindow;
TASWindow = object(TGWindow)
		IconBar:PASIconBar;
  	FileWin:PASFileWin;
    FileName: array[0..fsPathName] of Char;
    Bitmap:PGBitmap;
    Timer_Set :Boolean;
    Is_Running :Boolean;
    Slide_Ptr :Integer;
    Slides :PCollection;
    TheIcon : HIcon;
    hPal:HPalette;
    IsFullScreen:Boolean;
    constructor Init(ATitle: PChar);
    destructor Done; virtual;
    procedure SetupWindow;virtual;
    procedure CMFileOpen(var Msg: TMessage); virtual cm_First + cm_FileOpen;
    procedure WMSize(var Msg: TMessage); virtual wm_First + wm_Size;
		function  OpenFile(Name:Pchar):Boolean;virtual;
    function  DrawToWindow:Boolean;virtual;
    procedure ShowNext;virtual;
    procedure WMTimer(var Msg:TMessage);virtual wm_First+wm_Timer;
    procedure CMStart(var Msg:TMessage);virtual cm_First+cm_Start;
    procedure CMStop(var Msg:TMessage);virtual cm_First+cm_Stop;
    procedure CMBack(var Msg:TMessage);virtual cm_first+cm_Back;
    procedure WMRButtonDown(var Msg:TMessage);virtual wm_First+wm_RButtonDown;
    procedure WMLButtonDown(var Msg:TMessage);virtual wm_First+wm_LButtonDown;
    procedure WMMButtonDown(var Msg:TMessage);virtual wm_First+wm_MButtonDown;
    procedure CMHelp(var Msg:TMessage);virtual cm_First + cm_Help;
    procedure CMBPSolid(var Msg:TMessage);virtual cm_First+cm_BPSolid;
  	procedure CMBP10(var Msg:TMessage);virtual cm_First+cm_BP10;
	  procedure CMBP15(var Msg:TMessage);virtual cm_First+cm_BP15;
	  procedure CMBP30(var Msg:TMessage);virtual cm_First+cm_BP30;
	  procedure CMBP50(var Msg:TMessage);virtual cm_First+cm_BP50;
	  procedure CMBP70(var Msg:TMessage);virtual cm_First+cm_BP70;
	  procedure CMBPHorizontal(var Msg:TMessage);virtual cm_First+cm_BPHorizontal;
	  procedure CMBPVertical(var Msg:TMessage);virtual cm_First+cm_BPVertical;
	  procedure CMBPDiagonal(var Msg:TMessage);virtual cm_First+cm_BPDiagonal;
	  procedure CMBPHatch(var Msg:TMessage);virtual cm_First+cm_BPHatch;
	  procedure CMBPPebble(var Msg:TMessage);virtual cm_First+cm_BPPebble;
	  procedure CMBPBrick(var Msg:TMessage);virtual cm_First+cm_BPBrick;
    procedure CMBCBlack(var Msg:TMessage);virtual cm_First+cm_BCBlack;
    procedure CMBCWhite(var Msg:TMessage);virtual cm_First+cm_BCWhite;
    procedure CMBCRed(var Msg:TMessage);virtual cm_First+cm_BCRed;
    procedure CMBCGreen(var Msg:TMessage);virtual cm_First+cm_BCGreen;
    procedure CMBCBlue(var Msg:TMessage);virtual cm_First+cm_BCBlue;
    procedure CMBCCyan(var Msg:TMessage);virtual cm_First+cm_BCCyan;
    procedure CMBCMagenta(var Msg:TMessage);virtual cm_First+cm_BCMagenta;
    procedure CMBCYellow(var Msg:TMessage);virtual cm_First+cm_BCYellow;
    procedure CMFullScreen(var Msg:TMessage);virtual cm_First+cm_FullScreen;
    procedure CMFileWin(var Msg:TMessage);virtual cm_First + cm_FileWin;
    procedure WMChar(Var Msg:TMessage);virtual wm_First+wm_Char;
  	procedure WMSysCommand(var Msg:TMessage);virtual wm_First+wm_SysCommand;
end;

type
PSlideRec = ^TSlideRec;
TSlideRec = object(TObject)
	FileName : PChar;
  Duration: Integer;
	constructor Init(NewFileName:PChar;NewDuration:Integer);
	destructor  Done;virtual;
end;
{*****************************************************************}
{G L O B A L S }
{*****************************************************************}
var
	MainWin:PASWindow;
{*****************************************************************}
{M E T H O D S }
{*****************************************************************}

{ Construct the TASApp's MainWindow of type TASWindow }
{InitMainWindow}
procedure TASApp.InitMainWindow;
begin
	CmdShow := sw_Maximize;
  MainWindow := New(PASWindow, Init(AS_Name));
  MainWin := PASWindow(MainWindow);
end;

{*****************************************************************}
{Init}
constructor TASWindow.Init(ATitle: PChar);
var
	ARect:TMathRect;
  BackColor:TSystemColor;
  aPalette:TPalette ;
begin
  TGWindow.Init(nil, ATitle);
  Attr.Style := Attr.Style or ws_DlgFrame  ;
  BackColor.Init(sc_Window);
  Brush := New(PBrush,Init(@BackColor));
  Brush^.Pattern := bp_Nil;
  BackColor.Done;
  Bitmap := New(PGBitmap,Init(0,0,0,0,tc_NoTools));
  Picture^.Add(Bitmap);
  Timer_Set := False;
  Slide_Ptr := 0;
  Is_Running := False;
  IsFullScreen := False;
  Slides := New(PCollection,Init(100,100));
  BitMap^.LoadBmpResource('AS_LOGO',Space);
	DrawToWindow;
  IconBar := New(PASIconBar,Init(@Self,'Control Bar'));
  FileWin := nil;
end;

{Done}
destructor TASWindow.Done;
var
	Msg:TMessage;
begin
  Dispose(Slides,Done);
	If (FileWin <> nil) and (FileWin^.HWindow <> 0) then
  	FileWin^.CMFileBye(Msg);
  if Timer_Set then
  	begin
   	KillTimer(HWindow,1);
   	Timer_Set := False;
  	end;
  TGWindow.Done;
end;

procedure TASWindow.SetupWindow;
var
	SysMenu:HMenu;
begin
	TGWindow.SetupWindow;
  SetClassWord(HWindow,GCW_HIcon,LoadIcon(HInstance,'AS_Icon'));
  Sysmenu := GetSystemMenu(hWindow,false);
  AppendMenu(SysMenu,MF_Separator,0,nil);
  AppendMenu(SysMenu,0,idm_IconBar,'Control Bar');
  AppendMenu(SysMenu,0,idm_MenuBar,'Menu Bar');
  AppendMenu(SysMenu,0,idm_RunCP,'Control Panel');
  AppendMenu(SysMenu,MF_Separator,0,nil);
  AppendMenu(Sysmenu,0,idm_About,'About...');
end;

{CMFileOpen}
procedure TASWindow.CMFileOpen(var Msg: TMessage);
var
  TempName: array[0..fsPathName] of Char;
  CaptionBuffer: array [0..fsPathName+12{AS_Name} +2{': '} +1{#0}] of Char;
  TheFile :PTextStream;
  BPtr : PChar;
  NewFileName:Array[0..50] of Char;
  NewDuration:Integer;
  Err1:Integer ;
begin
	SetWindowText(HWindow, AS_Name);
  Is_Running := False;
  If Slides^.Count > 0 then
   	begin
    Dispose(Slides,Done);
    Slides := New(PCollection,Init(100,100));
    Slide_Ptr := 0;
    end;
  if Application^.ExecDialog(New(PFileDialog,
    		Init(@Self, PChar(sd_FileOpen), StrCopy(TempName, '*.shw'))))
        	= id_Ok then
    begin
    StrCopy(FileName, TempName);
    StrCopy(CaptionBuffer, 'Art Show:');
    StrCat(CaptionBuffer, ': ');
    StrCat(CaptionBuffer, AnsiLower(FileName));
    SetWindowText(HWindow, CaptionBuffer);

    TheFile := New(PTextStream,Init(FileName,stOpen,1024));
    While TheFile^.IsEOF = False  do
			begin
      StrCopy(NewFileName,TheFile^.GetNext);
      BPtr := TheFile^.GetNext;
      If BPtr <> nil then
      	Val(BPtr,NewDuration,Err1)
      else
      	Err1 := 1;
      if Err1 = 0 then
        	Slides^.Insert(New(PSlideRec,Init(NewFileName,NewDuration)));
      end;
    Dispose(TheFile,Done);
    end;
end;

function TASWindow.OpenFile(Name: PChar): Boolean;
var
  aPoint:TGPoint;
begin
 	Bitmap^.LoadBMPFile(Name, Space) ;
  aPoint.InitDefault;
  BitMap^.PositionAt(@aPoint);
  aPoint.Done;
  OpenFile := True;
	DrawtoWindow;
end;

function TASWindow.DrawToWindow: Boolean;
var
  OutRect,ClipRect,MapRect: TMathRect;
  SMCYSCREEN,SMCXSCREEN:Integer;
  CenterPt:TGPoint;
  APalette:TPalette;
begin
  APalette.Init(256,10);
  Bitmap^.GetPalette(APalette);
  Port^.SetPalette(@APalette);
  APalette.Done;
  SMCYSCREEN  := GetSystemMetrics(sm_CYScreen);
  SMCXSCREEN := GetSystemMetrics(sm_CXScreen);

  OutRect.InitDefault;ClipRect.InitDefault;MapRect.InitDefault;CenterPt.InitDefault;
  if IsFullScreen then
    OutRect.Build(0,0,SMCXSCREEN,SMCYSCREEN)    {set output to screen size}
  else
  	GetDisplayRect(OutRect);       {set output size to window client size}

  Space^.SetWorldRect(@OutRect);
  OutRect.GetCenter(CenterPt);
  Bitmap^.CenterAt(@CenterPt);       {alter bm's orign,corner so centered}
  MapRect.CopyFrom(@OutRect);        {set mapR to output size, }
  Space^.SetMappingRect(@MapRect);   
  Space^.FitToRectangle(@OutRect);   {adjust zoom}
	CenterPt.Done;OutRect.Done;ClipRect.Done;MapRect.Done;

 	Invalidate;
  UpdateWindow(HWindow);
  DrawToWindow := True;
end;

{ Reset mapping rectangle }
{WMSize}
procedure TASWindow.WMSize(var Msg: TMessage);
var
	DispRect:TMathRect;
  MapRect:TMathRect;
  CenterPt:TGPoint;
  Palette:TPalette;
begin
  TWindow.WMSize(Msg);
  {if IsFullScreen then Exit;}
  DrawToWindow;
  if IconBar <> nil then
		SendMessage(IconBar^.HWindow,wm_Size,0,0);
end;

{ShowNext}
procedure TASWindow.ShowNext;
var
	Slide:PSlideRec;
  Msg:TMessage;
  Dur:Word;
begin
if Timer_Set then
	begin
  	KillTimer(HWindow,1);
  	Timer_Set := False;
	end;
if Slide_Ptr < (Slides^.Count ) then
	begin
  Slide := Slides^.At(Slide_Ptr);
  if StrIComp(Slide^.FileName,'loop') = 0 then
  	begin
   	Slide_Ptr := 0 ;
    CMStart(Msg) ;
  	end
	else
		begin
		Dur := Slide^.Duration ;
  	if Dur < 62 then
  		Dur := Dur * 1000
  	else
  		Dur := 60000;
  	OpenFile(Slide^.FileName);
  	SetTimer(HWindow,1,Dur,nil);
  	Timer_Set := True;
  	Inc(Slide_Ptr);
  	end;
	end;
end;

{WMTimer}
procedure TASWindow.WMTimer(var Msg:TMessage);
begin
	KillTimer(HWindow,1);
  Timer_Set := False;
  ShowNext;
end;

{CMStart}
procedure TASWindow.CMStart(var Msg:TMessage);
begin
  Is_Running := True;
	ShowNext;
end;

{CMStop}
procedure TASWindow.CMStop(var Msg:TMessage);
begin
	if Timer_Set = True then
   	begin
   	KillTimer(HWindow,1);
    Timer_Set := False;
    end;
  Is_Running := False;
end;

{CMBack} {Previous Slide}
procedure TASWindow.CMBack(var Msg:TMessage);
begin
		Slide_Ptr :=Max( Slide_Ptr - 2,0);
    Is_Running := True;
    ShowNext;
end;

{WMRButtonDown} {Previous Slide}
procedure TASWindow.WMRButtonDown(var Msg:TMessage);
begin
	SendMessage(HWindow,wm_command,cm_Back,0);
end;

{WMLButtonDown} {Next Slide, pls!}
procedure TASWindow.WMLButtonDown(var Msg:TMessage);
begin
	If not Is_Running then
   	CMStart(Msg)
  else
   	ShowNext;
end;

{WMMButtonDown} {Stop Show, pls!}
procedure TASWindow.WMMButtonDown(var Msg:TMessage);
begin
  CMStop(Msg);
end;

{CMHelp}
procedure TASWindow.CMHelp(var Msg:TMessage);
var
	HelpDlg : PDialog;
begin
	HelpDlg := New(PDialog,Init(@Self,'AS_ABOUTBOX'));
   Application^.ExecDialog(HelpDlg);
end;

procedure TASWindow.CMBPSolid(var Msg:TMessage);
begin
  Brush^.Pattern := bp_Solid;
end;

procedure TASWindow.CMBP10(var Msg:TMessage);
begin
  Brush^.Pattern := bp_Ten;
end;

procedure TASWindow.CMBP15(var Msg:TMessage);
begin
  Brush^.Pattern := bp_Fifteen;
end;

procedure TASWindow.CMBP30(var Msg:TMessage);
begin
  Brush^.Pattern := bp_Thirty;
end;

procedure TASWindow.CMBP50(var Msg:TMessage);
begin
  Brush^.Pattern := bp_Fifty
end;

procedure TASWindow.CMBP70(var Msg:TMessage);
begin
  Brush^.Pattern := bp_Seventy;
end;

procedure TASWindow.CMBPHorizontal(var Msg:TMessage);
begin
  Brush^.Pattern := bp_Horizontal;
end;

procedure TASWindow.CMBPVertical(var Msg:TMessage);
begin
  Brush^.Pattern := bp_Vertical;
end;

procedure TASWindow.CMBPDiagonal(var Msg:TMessage);
begin
  Brush^.Pattern := bp_Diagonal;
end;

procedure TASWindow.CMBPHatch(var Msg:TMessage);
begin
  Brush^.Pattern := bp_Hatch;
end;

procedure TASWindow.CMBPPebble(var Msg:TMessage);
begin
  Brush^.Pattern := bp_Pebble;
end;

procedure TASWindow.CMBPBrick(var Msg:TMessage);
begin
  Brush^.Pattern := bp_Brick;
end;

procedure TASWindow.CMBCBlack(var Msg:TMessage);
var
NewColor:TColor;
begin
	NewColor.Init(ps_Black);
  Brush^.SetColor(@NewColor);
  NewColor.Done;
end;

procedure TASWindow.CMBCWhite(var Msg:TMessage);
var
NewColor:TColor;
begin
	NewColor.Init(ps_White);
  Brush^.SetColor(@NewColor);
  NewColor.Done;
end;

procedure TASWindow.CMBCRed(var Msg:TMessage);
var
NewColor:TColor;
begin
	NewColor.Init(ps_Red);
  Brush^.SetColor(@NewColor);
  NewColor.Done;
end;

procedure TASWindow.CMBCGreen(var Msg:TMessage);
var
NewColor:TColor;
begin
	NewColor.Init(ps_Green);
  Brush^.SetColor(@NewColor);
  NewColor.Done;
end;

procedure TASWindow.CMBCBlue(var Msg:TMessage);
var
NewColor:TColor;
begin
	NewColor.Init(ps_Blue);
  Brush^.SetColor(@NewColor);
  NewColor.Done;
end;

procedure TASWindow.CMBCCyan(var Msg:TMessage);
var
NewColor:TColor;
begin
	NewColor.Init(ps_Cyan);
  Brush^.SetColor(@NewColor);
  NewColor.Done;
end;

procedure TASWindow.CMBCMagenta(var Msg:TMessage);
var
NewColor:TColor;
begin
	NewColor.Init(ps_Magenta);
  Brush^.SetColor(@NewColor);
  NewColor.Done;
end;

procedure TASWindow.CMBCYellow(var Msg:TMessage);
var
NewColor:TColor;
begin
	NewColor.Init(ps_Yellow);
  Brush^.SetColor(@NewColor);
  NewColor.Done;
end;

procedure TASWindow.CMFullScreen(var Msg:TMessage);
var
	Style:LongInt;
begin
	If IsFullScreen then
  	begin
    Style := GetWindowLong(HWindow,gwl_Style);
    Style := Style or ws_Caption;
    SetWindowLong(HWindow,gwl_Style,Style);
    ShowWindow(HWindow,sw_ShowNormal);
 		ShowWindow(hWindow,sw_ShowMaximized);
  	IsFullScreen := False;
		end
  else
  	begin
    if Attr.Menu > 0 then
    	begin
      Setmenu(HWindow,0);
      DestroyMenu(Attr.Menu);
      Attr.Menu := 0;
      end;
    Style := GetWindowLong(HWindow,gwl_Style);
    Style := Style and not ws_Caption;
    SetWindowLong(HWindow,gwl_Style,Style);
  	ShowWindow(HWindow,sw_ShowNormal);
 		ShowWindow(hWindow,sw_ShowMaximized);
  	IsFullScreen := True;
		end;
end;

procedure TASWindow.WMChar(var Msg:TMessage);
begin
 	case Msg.wParamlo of
  	$1B:
    	begin
      SendMessage(HWindow,wm_Command,cm_FullScreen,0);
	    end;
    67,99:
    	begin
      if IconBar = nil then
      	begin
      	IconBar := New(PASIconBar,Init(@Self,'Control Bar'));
        Application^.MakeWindow(IconBar);
        SetFocus(HWindow);
        end
      else
      	begin
        SendMessage(IconBar^.HWindow,wm_Close,0,0);
        IconBar := nil;
        end;
      end;
    end;
end;

{WMSysCommand}
procedure	TASWindow.WMSysCommand(var Msg:TMessage);
begin
	case Msg.Wparam of
		idm_About:
			Application^.ExecDialog(New(PDialog,Init(@Self,'AS_About')));
    idm_RunCP:
			begin
    	WinExec('Control',1);
    	end;
    idm_IconBar:
    	begin
      if IconBar = nil then
      	begin
      	IconBar := New(PASIconBar,Init(@Self,'Control Bar'));
        Application^.MakeWindow(IconBar);
        SetFocus(HWindow);
        end
      else
      	begin
        SendMessage(IconBar^.HWindow,wm_Close,0,0);
        IconBar := nil;
        end;
      end;
    idm_MenuBar:
    	begin
      if Attr.Menu =  0 then
      	begin
    		Attr.Menu := loadMenu(HInstance,'AS_Menu');
        SetMenu(HWindow,Attr.Menu);
        end
      else
      	begin
        Setmenu(HWindow,0);
      	DestroyMenu(Attr.Menu);
        Attr.Menu := 0;
        end;
      end;
   	else
   		DefWndProc(Msg);
   	end;
end;

procedure TASWindow.CMFileWin(var Msg:TMessage);
begin
	if (FileWin <> nil) and (FileWin^.HWindow > 0) then
  	FileWin^.CMFileBye(Msg);
	FileWin := New(PASFileWin,Init(MainWin,'ArtShow Editor',nil));
  Application^.MakeWindow(FileWin);
end;

{*****************************************************************}
{TSlideRec Methods}
constructor TSlideRec.Init(NewFileName:PChar;NewDuration:Integer);
begin
	FileName := StrNew(NewFileName);
  Duration := NewDuration;
end;

destructor TSlideRec.Done;
begin
	StrDispose(FileName);
end;

{*****************************************************************}
{TASIconBar Methods}

constructor TASIconBar.Init(AParent:PWindowsObject;ATitle:PChar);
begin
	TGWindow.Init(AParent,Atitle);
  Attr.Style :=  ws_PopUpWindow or ws_Visible or ws_Caption;
  Bn1 := New(PODButton,Init(@Self,id_Bn1,'Start',0,0,32,20,false,'AS_Bn1'));
  Bn2 := New(PODButton,Init(@Self,id_Bn2,'Stop',32,0,32,20,false,'AS_Bn2'));
  Bn3 := New(PODButton,Init(@Self,id_Bn3,'Back',64,0,32,20,false,'AS_Bn3'));
  Bn4 := New(PODButton,Init(@Self,id_Bn4,'Full Screen',96,0,32,20,false,'AS_Bn4'));
  Bn5 := New(PODButton,Init(@Self,id_Bn5,'Color/Pattern',128,0,32,20,false,'AS_BN5'));
  Bn6 := New(PODButton,Init(@Self,id_Bn6,'FileEdit',160,0,32,20,false,'AS_BN6'));
  HFloatMenu := LoadMenu(HInstance,'AS_FloatMenu');
  HPopUpMenu := GetSubMenu(HFloatMenu,0);
end;

destructor TASIconBar.Done;
begin
 	Dispose(Bn1,Done);
  Dispose(Bn2,Done);
  Dispose(Bn3,Done);
  Dispose(Bn4,Done);
  Dispose(Bn5,Done);
  Dispose(Bn6,Done);
  DestroyMenu(HFloatMenu);
 	TGWindow.Done;
  MainWin^.IconBar := nil;
end;

procedure TASIconBar.SetupWindow;
var
  WR,CR:TRect;
begin
  GetClientRect(Parent^.HWindow,CR);
	TGWindow.SetupWindow;
end;

procedure TASIconBar.WMSize(var Msg:TMessage);
var
  WR,CR:TRect;
  aPt:TPoint;
begin
  GetClientRect(Parent^.HWindow,CR);
  aPt.X := CR.Right;aPt.Y := CR.Top;
  ClientToScreen(Parent^.HWindow,aPt);
  SetWindowPos(HWindow,0,aPt.X-194,aPt.Y,194,GetSystemMetrics(sm_CYSize)+23,swp_NoZOrder);
  SetFocus(Parent^.HWindow);
end;

procedure TASIconBar.WMMove(var Msg:TMessage);
begin
	InvalidateRect(HWindow,nil,True);
  DefWndProc(Msg);
end;

procedure TASIconBar.WMNCLButtonDown(var Msg:TMessage);
begin
	DefWndProc(Msg);
  SetFocus(Parent^.HWindow);
end;

procedure TASIconBar.WMDrawItem(var Msg:TMessage);
var
	PDIS : ^TDrawItemStruct;
begin
	PDIS := Pointer(Msg.lParam);
	case PDIS^.CtlType of
		odt_Button:
		case PDIS^.CtlID of
			id_Bn1 :Bn1^.DrawItem(Msg);
			id_Bn2 :Bn2^.DrawItem(Msg);
			id_Bn3 :Bn3^.DrawItem(Msg);
 			id_Bn4 :Bn4^.DrawItem(Msg);
		 	id_Bn5 :Bn5^.DrawItem(Msg);
		 	id_Bn6 :Bn6^.DrawItem(Msg);
		end;
	end;
end;

procedure TASIconBar.DefChildProc(var Msg: TMessage);
begin
  TGWindow.DefChildProc(Msg);
end;

procedure TASIconBar.WMCommand(var Msg:TMessage);
begin
	case Msg.WParam of
  	id_Bn1:IDBN1(Msg);
    id_Bn2:IDBN2(Msg);
    id_Bn3:IDBN3(Msg);
    id_Bn4:IDBn4(Msg);
    id_Bn5:IDBn5(Msg);
    id_Bn6:IDBN6(Msg);
    cm_BPPSolid..cm_BCPYellow:SendMessage(Parent^.HWindow,
    		wm_Command,Msg.WParam-400,0);
  end;
end;


procedure TASIconBar.IDBN1(var Msg:TMessage);
begin
   SetFocus(Parent^.HWindow);  
  if MainWin^.Slides^.Count > 0 then
		SendMessage(Parent^.HWindow,wm_command,cm_Start,0)
  else
  	SendMessage(Parent^.HWindow,wm_Command,cm_FileOpen,0);
end;

procedure TASIconBar.IDBN2(var Msg:TMessage);
begin
  SetFocus(Parent^.HWindow);
	SendMessage(Parent^.HWindow,wm_command,cm_Stop,0);
end; 

procedure TASIconBar.IDBN3(var Msg:TMessage);
begin
  SetFocus(Parent^.HWindow);
	SendMessage(Parent^.HWindow,wm_RButtonDown,0,0);
end;

procedure TASIconBar.IDBN4(var Msg:TMessage);
begin
  SetFocus(Parent^.HWindow);
	SendMessage(Parent^.HWindow,wm_command,cm_FullScreen,0);
end;

procedure TASIconBar.IDBN5(var Msg:TMessage);
var
	aPoint:TPoint;
  aRect:TRect;
begin
  SetFocus(Parent^.HWindow);
	aPoint.X := 0;
  aPoint.Y := 25;
  ClientToScreen(HWindow,aPoint);
  TrackPopupMenu(HPopUpMenu,0,aPoint.x,aPoint.Y,0,HWindow,nil);
end;

procedure TASIconBar.IDBN6(var Msg:TMessage);
begin
	SendMessage(Parent^.HWindow,wm_Command,cm_FileWin,0);
end;


{*****************************************************************}
constructor TASFileWin.Init(AParent:PWindowsObject;Atitle,AFileName:Pchar);
begin
	TFileWindow.Init(AParent,ATitle,AFileName);
  Attr.X := 100;Attr.Y := 100;
  Attr.W := 500;Attr.H := 300;
  Attr.Style :=  Attr.Style or ws_TiledWindow;
  Attr.Menu := loadMenu(HInstance,'AS_FileCmds');
end;

procedure TASFileWin.CMFileBye(var Msg:TMessage);
begin
	SendMessage(HWindow,wm_Close,0,0);
end;

destructor TASFileWin.Done;
var
	Msg:TMessage;
begin
	SetFocus(Parent^.HWindow);
  TFileWindow.Done;
  MainWin^.FileWin := nil;
	MainWin^.Slides^.FreeAll;
end;

{*****************************************************************}
{M A I N    L I N E }
{*****************************************************************}
var
  ASApp: TASApp;
begin
  ASApp.Init(AS_Name);
  ASApp.Run;
  ASApp.Done;
end.
