/****************************************************************
*
*  Name:          FRUIT
*
*  Function:      display a pop-up menu and report selections
*
*  Shows how to:  1. create a new window and associated keyboard.
*                 2. define the contents and fields for a menu.
*                 3. move and display a window.
*                 4. take input from a menu.
*
****************************************************************/

#include <stdio.h>
#include "dvapi.h"

/* minimum API version required and actual API version */
#define required 0x201
int  version;

/* object handles */
ulong win,kbd;

/* variables used when reading the menu keyboard */
char *kbuf,field;
int   klng;

/* this string defines the contents of the menu */
char menu1[] = "\
 apples   A \
 bananas  B \
 oranges  O \
 pears    P ";

/* this string defines the field table for the menu.  Note that the 
   ftab macro is used to define the field table header.  This macro,
   defined in dvapi.h, automatically prefixes the field table with a 
   window stream so that the resulting string can be sent via a
   win_stream call.  Following the header is a field table entry for
   each field in the menu.
*/
char ftab1[] = {ftab(5,FTH_KEYSELECT+FTH_MODIFIED,0,0,9,1),
                     0,0,0,11,FTE_SELECT,'A',1,0,
                     1,0,1,11,FTE_SELECT,'B',1,0,
                     2,0,2,11,FTE_SELECT,'O',1,0,
                     3,0,3,11,FTE_SELECT,'P',1,0,
                     1,0,0,0,FTE_SELECT,27,1,0, /* Esc - invisible field */
                     };


/**********************************************************************
*  main  -  check for DESQview present and enable required extensions.
***********************************************************************/

main () {
  /* initialize C interfaces and get API version number */
  version = api_init();

  /* if DESQview is not running or version is too low, display a message */ 
  if (version < required) {
    printf ("This program requires DESQview version %d.02%d or later.\n",
             required/256,required%256);
    }

  /* tell DESQview what extensions to enable and start application */
  else {
    api_level (required);
    program_body();
    }

  /* disable C interfaces and return from program */
  api_exit();
  }


/**********************************************************************
*  program_body  -  build menu and display message when item is selected.
***********************************************************************/

program_body () {

  /* create the menu window and set it to use logical attributes */
  win = win_new ("fruit",5,4,12);
  win_logattr (win,1);
  win_attr (win,1);

  /* create a keyboard object for the menu and open it in field mode */
  kbd = key_new();
  key_open  (kbd,win);
  key_addto (kbd,KBF_FIELD);

  /* write the contents and field table to the menu window */
  win_swrite (win,menu1);
  win_stream (win,ftab1);

  /* reposition and display the menu */
  win_move (win,9,33);
  win_unhide (win);
  win_top (win);

  /* loop until field 5 is selected */
  field = 0;
  while (field != 5) {

    /* wait for a field to be selected, reset it, and display a message */
    key_read (kbd,&kbuf,&klng);
    field = *kbuf;
    fld_reset (win);
    win_printf (win_me(),"field %d selected\n",field);
    }

  /* free created objects */
  key_free (kbd);
  win_free (win);
  }

















